Array.prototype.average = function () {
    var sum = 0, j = 0; 
   for (var i = 0; i < this.length, isFinite(this[i]); i++) { 
          sum += parseFloat(this[i]); ++j; 
    } 
   return j ? sum / j : 0; 
};

function appClass() {
	instance = this;
	this.appName = 'lux-meter';
	this.totalSamples = 100,
	this.settings = {
		lux: 0,
		max : 0,
		min : 0,
		avr : 0,
		values : new Array()
	}
	
	this.load = function() {
		function isEmpty(obj) {for(var prop in obj) {if(obj.hasOwnProperty(prop))return false;	}return true;}
		var value = localStorage.getItem(this.appName);
		if (!isEmpty(JSON.parse(value))) {
			this.settings = value && JSON.parse(value); 
			return true;
		} else return false;
	}
	
	this.save = function() {
		localStorage.setItem(this.appName, JSON.stringify(this.settings));
	}
	
	this.clear = function(clearAll=false) { 
		//console.log('clear localStorage name:' + this.appName);
		localStorage.clear(this.appName);
		if (clearAll) this.settings = null;
	}	
	this.getSettings = function() {
		return this.settings;
	}
	this.setSetting = function(option,value) {
		this.settings.option = value;
	}
}

appClass.prototype.animateValue = function(id, start, end, duration) {
    // assumes integer values for start and end

    var obj = document.getElementById(id);
    var range = end - start;
    // no timer shorter than 50ms (not really visible any way)
    var minTimer = 50;
    // calc step time to show all interediate values
    var stepTime = Math.abs(Math.floor(duration / range));

    // never go below minTimer
    stepTime = Math.max(stepTime, minTimer);

    // get current time and calculate desired end time
    var startTime = new Date().getTime();
    var endTime = startTime + duration;
    var timer;

    function run() {
        var now = new Date().getTime();
        var remaining = Math.max((endTime - now) / duration, 0);
        var value = Math.round(end - (remaining * range));
        obj.innerHTML = value;
        if (value == end) {
            clearInterval(timer);
        }
    }

    var timer = setInterval(run, stepTime);
    run();
}

var app = new appClass();

$(document).ready(function() {
	$('#viewPort').css({ scale: '1.2', opacity: 0});
	//initiate app
	
	var trans = new translateObj({
		'defaultLang':'en',
		'autoDetect': true,
		'onTranslateEnd' : function() {
			$('#viewPort').transition({ scale: '1.2', opacity: 0}).transition({ scale: '1', opacity: 1});
		}
	});
	trans.initTranslate();

	$('#btnReset').click(function(e) {
		e.preventDefault();
		alert(trans.echo('reset data'));
		app.settings.min = app.settings.lux;
		app.settings.avr = app.settings.lux;
		app.settings.max = app.settings.lux;
		app.settings.values = new Array();

		app.animateValue("maxValue", 0, app.settings.max, 300);
		app.animateValue("averageValue", 0, app.settings.avr, 300);
		app.animateValue("minValue", 0, app.settings.min, 300);		
		
	});
	
	
	
/*App Menu options*/
	$('#btnHelp').click(function(e) {
		e.preventDefault();
		$('#viewPort').transition({ scale: '0.75', opacity: 0}).delay(30).queue(function(){
			location.href = 'help.html';
		});
	});
	
	$('#btnAbout').click(function(e) {
		e.preventDefault();
		$('#viewPort').transition({ scale: '0.75', opacity: 0}).delay(30).queue(function(){
			location.href = 'about.html';
		});
	});

	$('#btnExit').click(function(e) {
		e.preventDefault();
		window.close();
	});


	
});

(function($) {
	$(document).ready(function() {
		$.slidebars();
	});
}) (jQuery);


window.addEventListener('devicelight', function(event) {
	var lux = event.value; // Read out the lux value
	if (app.settings.lux != lux) {
		app.animateValue("luxValue", app.settings.lux, lux, 1000);
		
		 total = app.settings.values.length;
		if (total <= app.totalSamples) {
			app.settings.values.push(lux);
			var maxValue = Math.max.apply(Math, app.settings.values);
			var minValue = Math.min.apply(Math, app.settings.values);
			//alert(minValue);
			var averageValue = app.settings.values.average().toFixed(0);
			
			app.animateValue("maxValue", app.settings.max, maxValue, 1000);
			app.animateValue("averageValue", app.settings.avr, averageValue, 1000);
			app.animateValue("minValue", app.settings.min, minValue, 1000);
			
			app.settings.lux = lux;
			app.settings.max = maxValue;
			app.settings.min = minValue;
			app.settings.avr = averageValue;
			app.save();
		} //excess sample limit
	}
});