var accentMap = {
	"š": "s",
	"ć": "c",
	"č": "c",
	"ž": "z",
	"đ": "dj",
	"Š": "S",
	"Ć": "C",
	"Č": "C",
	"Ž": "Z",
	"Đ": "Dj"
};

var normalize = function( term ) {
	var ret = "";

	for ( var i = 0; i < term.length; i++ ) {
		ret += accentMap[ term.charAt(i) ] || term.charAt(i);
	}
	
	return ret;
};

$("#search_query").autocomplete({
	source: function( request, response ) {
		var matcher = new RegExp( "\\b" + $.ui.autocomplete.escapeRegex( request.term ), "i" );
		response( $.grep( autocomplete_array, function( value ) {
			value = value.label || value.value || value;
			return matcher.test( value ) || matcher.test( normalize( value ) );
		}));
	},
	minLength: 2,
	select: function(event, ui) {
        if(ui.item){
            $('#search_query').val(ui.item.value);
        }
		
		var e = jQuery.Event("keypress");
		e.which = 13;
        $('#search_query').trigger(e);
    }
});