var citiesDB = (function() {
	var returnDB = {};
	var datastore = null;
	
	returnDB.open = function(callback) {
		var version = 26;
		var request = indexedDB.open('cities', version);
		console.log("open");
		
		request.onupgradeneeded = function(event) {
			console.log("upgrade");
			var db = request.result;

			if (db.objectStoreNames.contains('cities')) {
				db.deleteObjectStore('cities');
			}

			var store = db.createObjectStore('cities', {keyPath: 'id'});
			var nameIndex = store.createIndex("by_name", "name", {unique: true});
			var latitudeIndex = store.createIndex("by_lat", "lat");
			var longitudeIndex = store.createIndex("by_long", "long");
			var descIndex = store.createIndex("by_desc", "desc");
			var distrIndex = store.createIndex("by_district", "district");

			/* requires jQuery */
			$.ajax({
				type: 'GET',
				url: 'data/cities.json',
				dataType: 'json',
				success: function(data) {
							var i = 0;
							while (data[i]) {
								store.put({id: i, name: data[i]['name'], desc: data[i]['desc'], latitude: data[i]['latitude'], longitude: data[i]['longitude'], district: data[i]['district']});
								i++;
							}
						},
				data: {},
				async: false
			});
		};

		request.onsuccess = function(event) {
			console.log("success");
			datastore = request.result;
			callback();
		};

		request.onerror = function () {
			report(request.error);
			console.log("error");
		}
	};
	
	returnDB.getAll = function(callback) {
		returnDB.get(null, callback);
	};
	
	returnDB.get = function(query, callback) {
		var tx = datastore.transaction("cities", "readonly");
		var store = tx.objectStore("cities");
		var index = store.index("by_name");
		var cities = [];
		var request;
		
		if (query) {
			query = query.toLowerCase().trim();
		}
		
		request = index.openCursor();

		request.onsuccess = function() {
			var cursor = request.result;
				if (cursor) {
					console.log("getAll: " + cursor.value.desc);
					if (query) {
						if (cursor.value.name.toLowerCase().indexOf(query) != -1) {
							cities.push(cursor.value);
						}
					} else {
						cities.push(cursor.value);
					}
					
					cursor.continue();
				} else {
					callback(cities);
				}
		};
	};
	
	returnDB.getByID = function(id, callback) {
		var tx = datastore.transaction("cities", "readonly");
		var store = tx.objectStore("cities");
		var request;
		
		var request = store.get(id);
		
		request.onsuccess = function() {
			callback(request.result);
		};
	};
	
	return returnDB;
}());