var diaryDB = (function() {
	var returnDB = {};
	var datastore = null;
	
	returnDB.open = function(callback) {
		var version = 29;
		var request = indexedDB.open('diary', version);
		console.log("Diary: open");
		
		request.onupgradeneeded = function(event) {
			console.log("Diary: upgrade");
			var db = request.result;

			if (db.objectStoreNames.contains('diary')) {
				db.deleteObjectStore('diary');
			}

			var store = db.createObjectStore('diary', {keyPath: 'id', autoIncrement: true});
			var titleIndex = store.createIndex("by_title", "title", {unique: true});
			var subtitleIndex = store.createIndex("by_subtitle", "subtitle");
			var latitudeIndex = store.createIndex("by_lat", "latitude");
			var longitudeIndex = store.createIndex("by_long", "longitude");
			var linkIndex = store.createIndex("by_link", "link");
			var typeIndex = store.createIndex("by_type", "type");
			var realIDIndex = store.createIndex("by_real_id", "real_id");
		};

		request.onsuccess = function(event) {
			console.log("Diary: success");
			datastore = request.result;
			callback();
		};

		request.onerror = function () {
			report(request.error);
			console.log("Diary: error");
		}
	};
	
	returnDB.getAll = function(callback) {
		returnDB.get(null, callback);
	};
	
	returnDB.get = function(query, callback) {
		var tx = datastore.transaction("diary", "readonly");
		var store = tx.objectStore("diary");
		var index = store.index("by_title");
		var entries = [];
		var request;
		
		if (query) {
			query = query.toLowerCase().trim();
		}
		
		request = index.openCursor();

		request.onsuccess = function() {
			var cursor = request.result;
				if (cursor) {
					if (query) {
						if (cursor.value.title.toLowerCase().indexOf(query) != -1) {
							entries.push(cursor.value);
						}
					} else {
						entries.push(cursor.value);
					}
					
					cursor.continue();
				} else {
					callback(entries);
				}
		};
	};
	
	returnDB.addEntry = function(entry, original, callback) {
		var tx = datastore.transaction("diary", "readwrite");
		var store = tx.objectStore("diary");
		var request = store.put(entry);
		
		request.onsuccess = function(e) {
			callback(e.target.result, original);
		};
	};
	
	returnDB.removeEntry = function(original, callback) {
		var tx = datastore.transaction("diary", "readwrite");
		var store = tx.objectStore("diary");
		var request = store.delete(original.inDiary);
		request.onsuccess = function(e) {
			console.log("Deleted!");
			callback(original);
		};
		request.onerror = function(e) {
			console.log("Failed to delete!");
		};
		
	};
	
	return returnDB;
}());