var naturesDB = (function() {
	var returnDB = {};
	var datastore = null;
	
	returnDB.open = function(callback) {
		var version = 41;
		var request = indexedDB.open('natures', version);
		console.log("open");
		
		request.onupgradeneeded = function(event) {
			console.log("upgrade");
			var db = request.result;

			if (db.objectStoreNames.contains('natures')) {
				db.deleteObjectStore('natures');
			}

			var store = db.createObjectStore('natures', {keyPath: 'id'});
			var nameIndex = store.createIndex("by_name", "name", {unique: true});
			var latitudeIndex = store.createIndex("by_lat", "lat");
			var longitudeIndex = store.createIndex("by_long", "long");
			var descIndex = store.createIndex("by_desc", "desc");
			var cityIndex = store.createIndex("by_city", "city");
			var subtitleIndex = store.createIndex("by_subtitle", "subtitle");
			var inDiaryIndex = store.createIndex("by_inDiary", "inDiary");
			var address = store.createIndex("by_address", "address");
			var cityName = store.createIndex("by_city_name", "city_name");

			/* requires jQuery */
			$.ajax({
				type: 'GET',
				url: 'data/natures.json',
				dataType: 'json',
				success: function(data) {
							var i = 0;
							while (data[i]) {
								store.put({id: i, name: data[i]['name'], desc: data[i]['desc'], latitude: data[i]['latitude'],
									longitude: data[i]['longitude'], city: data[i]['city'], subtitle: data[i]['subtitle'], inDiary: 0,
									address: data[i]['address'], city_name: data[i]['city_name']});
								i++;
							}
						},
				data: {},
				async: false
			});
		};

		request.onsuccess = function(event) {
			console.log("success");
			datastore = request.result;
			callback();
		};

		request.onerror = function () {
			report(request.error);
			console.log("error");
		}
	};
	
	returnDB.getAll = function(callback) {
		returnDB.get(null, callback);
	};
	
	returnDB.get = function(query, callback) {
		var tx = datastore.transaction("natures", "readonly");
		var store = tx.objectStore("natures");
		var index = store.index("by_name");
		var natures = [];
		var request;
		
		if (query) {
			query = query.toLowerCase().trim();
		}
		
		request = index.openCursor();

		request.onsuccess = function() {
			var cursor = request.result;
				if (cursor) {
					if (query) {
						if (cursor.value.name.toLowerCase().indexOf(query) != -1) {
							natures.push(cursor.value);
						}
					} else {
						natures.push(cursor.value);
					}
					
					cursor.continue();
				} else {
					callback(natures);
				}
		};
	};
	
	returnDB.getByID = function(id, callback) {
		var tx = datastore.transaction("natures", "readonly");
		var store = tx.objectStore("natures");
		var request;
		
		var request = store.get(id);
		
		request.onsuccess = function() {
			callback(request.result, "natures");
		};
	};
	
	returnDB.getAllByCity = function(id, callback) {
		var tx = datastore.transaction("natures", "readonly");
		var store = tx.objectStore("natures");
		var index = store.index("by_city");
		var request = index.openCursor(IDBKeyRange.only(id));
		var natures = [];
		
		console.log('AllByCity: ' + id);
		
		request.onsuccess = function() {
			var cursor = request.result;
				if (cursor) {
					natures.push(cursor.value);
					cursor.continue();
				} else {
					callback(natures);
				}
		};
	};
	
	returnDB.getByCity = function(id, query, callback) {
		var tx = datastore.transaction("natures", "readonly");
		var store = tx.objectStore("natures");
		var index = store.index("by_city");
		var request = index.openCursor(IDBKeyRange.only(id));
		var natures = [];
		query = query.toLowerCase().trim();
		
		console.log('ByCity: ' + id);
		
		request.onsuccess = function() {
			var cursor = request.result;
				if (cursor) {
					if (cursor.value.name.toLowerCase().indexOf(query) != -1) {
						natures.push(cursor.value);
					}				
					cursor.continue();
				} else {
					callback(natures);
				}
		};
	};
	
	returnDB.addToDiary = function(id, nature) {
	console.log("Added: " + nature.name + "; id = " + id);
		var tx = datastore.transaction("natures", "readwrite");
		var store = tx.objectStore("natures");
		nature.inDiary = id;
		store.put(nature);
	}
	
	returnDB.removeFromDiary = function(nature) {
	console.log("Removed: " + nature.name + "; id = " + nature.id);
		var tx = datastore.transaction("natures", "readwrite");
		var store = tx.objectStore("natures");
		nature.inDiary = 0;
		store.put(nature);
	}
	
	return returnDB;
}());