var i = 0;

function delayedSetup(loops) {
	setTimeout(function() {
		var container = $('#entries');
		
		if (allEntries[0] == undefined) {
			$("#no_results").show();
		} else {
			$("#no_results").hide();
		}
		
		if (allEntries[i]) {
			autocomplete_array.push(allEntries[i].name);
			var item = $(document.createElement('div'));
			var title = $(document.createElement('span'));
			var subtitle = $(document.createElement('span'));
			var image = $(document.createElement('img'));
			var wrapper = $(document.createElement('div'));
			var sign = $(document.createElement('span'));
			
			sign.toggleClass("cheatsheet list sign");
			sign.attr('id', i);
			
			if (allEntries[i].inDiary == 0) {
				sign.text("\uf055");
				sign.css("color", "#a4ce46");
			} else {
				sign.text("\uf056");
				sign.css("color", "#df3030");
			}
			
			image.attr("src", "images/" + type + "s/" + allEntries[i].id + "_64.png");
			image.toggleClass("list image");

			title.toggleClass("list title");
			title.text(allEntries[i].name);
			
			subtitle.toggleClass("list subtitle");
			subtitle.text(allEntries[i].subtitle);
							
			wrapper.toggleClass("titles_wrapper");
			wrapper.append(title);
			wrapper.append(subtitle);
			
			item.toggleClass("list item");
			item.attr('id', allEntries[i].id);
			
			item.click(function() {
				window.location = type + ".html?id=" + $(this).attr('id');
			});
			
			sign.click(function() {
				var text = "";
				var i = $(this).attr('id');
				
				var self = $(this);
				if (self.css("color") == "rgb(164, 206, 70)") {
					self.text("\uf056");
					self.css("color", "#df3030");
					text = "Added to diary.";
					
					var entry = {
						"title" : allEntries[i].name,
						"subtitle" : allEntries[i].subtitle,
						"latitude" : allEntries[i].latitude,
						"longitude" : allEntries[i].longitude,
						"link" : type + ".html?diary=1&id=" + allEntries[i].id,
						"type" : type,
						"real_id" : allEntries[i].id
					};
					
					diaryDB.addEntry(entry, allEntries[i], addedToDiaryCallback);
				} else {
					self.text("\uf055");
					self.css("color", "#a4ce46");
					text = "Removed from diary.";
					diaryDB.removeEntry(allEntries[i], removedFromDiaryCallback);
				}
				
				$().toastmessage({
					text     	: text,
					position 	: 'bottom-center',
					type     	: 'success',
					stayTime	: 2000					
				});
				
				$().toastmessage('showNoticeToast', text);
				
				return false;
			});
			
			item.append(image);
			item.append(wrapper);
			item.append(sign);
			
			container.append(item);

			i++;
		}
		
		if (--loops) delayedSetup(loops);
	}, 20);
}

var setup = function(entries) {
	allEntries = entries.slice();
	if (sort) {
		allEntries.sort(function(a, b) {
			var a_v = Math.abs(a.longitude - longitude) + Math.abs(a.latitude - latitude);
			var b_v = Math.abs(b.longitude - longitude) + Math.abs(b.latitude - latitude);
			
			return a_v - b_v;
		});
	}
	delayedSetup(allEntries.length);
}
