var setup = function(item, type) {
	var image = $("#top_image");
	var name = $("#entry_title");
	var subtitle = $("#entry_subtitle");
	var desc = $("#entry_desc");
	var text = $("#entry_desc_text");
	var location = $("#entry_location");
	var address = $("#entry_address");
	var pin = $("#add_to_diary");
	
	entry = item;
	
	image.css("background-image", "url(images/" + type + "/" + item.id + ".jpg)");
	$("#image_fs").css("background-image", "url(images/" + type + "/" + item.id + ".jpg)");
	name.text(item.name);
	subtitle.text(item.subtitle);
	text.html(item.desc);
	address.text(item.address);
	location.text(item.city_name);
	
	if (item.inDiary == 0) {
		$("#add_to_diary_text").text("Pin to diary");
		pin.css("background-color", "#7db10a");
	} else {
		$("#add_to_diary_text").text("Unpin");
		pin.css("background-color", "#d01010");
	}
	
	pin.click(function() {
		var text = "";
		var i = $(this).attr('id');
		
		var self = $(this);

		if (entry.inDiary == 0) {
			$("#add_to_diary_text").text("Unpin");
			self.css("background-color", "#d01010");
			text = "Added to diary.";
			
			var diaryEntry = {
				"title" : entry.name,
				"subtitle" : entry.subtitle,
				"latitude" : entry.latitude,
				"longitude" : entry.longitude,
				"link" : entryType + ".html?diary=1&id=" + entry.id,
				"type" : entryType,
				"real_id" : entry.id
			};
			
			diaryDB.addEntry(diaryEntry, entry, addedToDiaryCallback);
		} else {
			$("#add_to_diary_text").text("Pin to diary");
			self.css("background-color", "#7db10a");
			text = "Removed from diary.";
			diaryDB.removeEntry(entry, removedFromDiaryCallback);
		}
		
		$().toastmessage({
			text     	: text,
			position 	: 'bottom-center',
			type     	: 'success',
			stayTime	: 2000						
		});
		
		$().toastmessage('showNoticeToast', text);
		
		return false;
	});
	
	desc.readmore({
		moreLink: '<a class="button readmore" href="#">Read more</a>',
		lessLink: '<a class="button readmore" href="#">Less</a>'
	});

	if (name.width() + 8 > $(window).width()) {					
		name.marquee("scroll_div");
		$(".scroll_div").css("margin-left", "-8px");
	}	
}