var close = false;
var geoService = {};
var resetLocation = true;

var spin_opts = {
			lines: 10, // The number of lines to draw
			length: 16, // The length of each line
			width: 6, // The line thickness
			radius: 24, // The radius of the inner circle
			corners: 1, // Corner roundness (0..1)
			rotate: 9, // The rotation offset
			color: '#FFF', // #rgb or #rrggbb
			speed: 1, // Rounds per second
			trail: 50, // Afterglow percentage
			shadow: true, // Whether to render a shadow
			hwaccel: false, // Whether to use hardware acceleration
			className: 'spinner', // The CSS class to assign to the spinner
			zIndex: 2e9, // The z-index (defaults to 2000000000)
			top: 'auto', // Top position relative to parent in px
			left: 'auto' // Left position relative to parent in px
		};

$.fn.spin = function(opts) {
	opts = spin_opts;

    this.each(function() {
        var $this = $(this),
        data = $this.data();

        if (data.spinner) {
            data.spinner.stop();
            delete data.spinner;
            $("#spin_modal_overlay").remove();
            return this;
        }

        var spinElem = this;
        $('body').append('<div id="spin_modal_overlay" style="background-color: rgba(0, 0, 0, 0.6); width:100%; height:100%; position:fixed; top:0px; left:0px; z-index:' + (opts.zIndex - 1) + '"/>');
        spinElem = $("#spin_modal_overlay")[0];
        data.spinner = new Spinner($.extend({color: $this.css('color')}, opts)).spin(spinElem);
		
		$(".spinner").append('<div id="spinner_text"></div>');
		
		var text = $("#spinner_text");
		
		text.text("Getting accurate position.");
		
		text.css("top", Math.max(0, (($(window).height() - text.outerHeight()) / 2) + 
                                                $(window).scrollTop() + 75) + "px");
		text.css("left", Math.max(0, (($(window).width() - text.outerWidth()) / 2) + 
                                                $(window).scrollLeft()) + "px");
		
		$("#spin_modal_overlay").click(function() {
			resetLocation = false;
			$("body").spin();
		});
    });
	
    return this;
};

function closeMenu() {
	$.sidr('close', 'sidr-main');
	$("#ribbon").animate({"left": "-8px"}, 200);
	close = false;
}

function openMenu() {
	$.sidr('open', 'sidr-main');
	$("#ribbon").animate({"left": "80%"}, 200);
	close = true;
}

$('#simple-menu').sidr({name: 'sidr-main'});

 $(window).touchwipe({
	wipeLeft: function() {
		closeMenu();
	},
	wipeRight: function() {
		openMenu();
	},
	preventDefaultEvents: true
});

$("#ribbon").click(function() {
	if (close) {
		closeMenu();
	} else {
		openMenu();
	}
});

$("#back_button").click(function() {
	setCookie("backedUp", 1, 365);
	history.back();
	
	return false;
});

$("#show_on_map").click(function() {
	if (checkNetPermission()) {
		document.location = "map.html?title=" + encodeURIComponent(entry.name) + "&lat=" + entry.latitude + "&long=" + entry.longitude;
	}
});

$("#address_link").click(function() {
	if (checkNetPermission()) {
		document.location = "map.html?title=" + encodeURIComponent(entry.name) + "&lat=" + entry.latitude + "&long=" + entry.longitude;
	}
});

$("#location_link").click(function() {
	document.location = "city.html?id=" + entry.city;
});

$("#search_button").click(function() {
	$("#search_button").hide();
	$("#title").hide();
	$("#search_query").show();
	$("#search_query").focus();
	
	return false;
});

$("#search_query").blur(function() {
	$("#search_button").show();
	$("#title").show();
	$("#search_query").hide();
});

function showCurrentLocation(position) {
	if (resetLocation) {
		if (type != "diary") {
			document.location = type + "s.html?latitude=" + position.coords.latitude + "&longitude=" + position.coords.longitude;
		} else {
			document.location = "diary.html?latitude=" + position.coords.latitude + "&longitude=" + position.coords.longitude;
		}
	}
}


function errorHandlerLowAccuracy(error){
	$('body').spin();
	var text = "Couldn't get location.";
	$().toastmessage({
		text     	: text,
		position 	: 'bottom-center',
		type     	: 'success',
		stayTime	: 2000						
	});
	$().toastmessage('showNoticeToast', text);
}

function errorHandlerHighAccuracy(error){
	if (error.code == error.TIMEOUT) {
		$("#spinner_text").text("Approximating position.");
		$("#spinner_text").css("left", Math.max(0, (($(window).width() - $("#spinner_text").outerWidth()) / 2) + 
                                                $(window).scrollLeft()) + "px");
		getLocation(5000, false, errorHandlerLowAccuracy);
	} else {
		$('body').spin();
		var text = "Couldn't get location.";
		$().toastmessage({
			text     	: text,
			position 	: 'bottom-center',
			type     	: 'success',
			stayTime	: 2000						
		});
		$().toastmessage('showNoticeToast', text);
	}
}

$("#closest").click(function() {
		$('body').spin();
		resetLocation = true;
		var geoService = navigator.geolocation;
		
		getLocation(10000, true, errorHandlerHighAccuracy);
		
		return false;
});

$("#image_fs").click(function() {
	$("#image_fs").hide();
});

$("#top_image").click(function() {
	$("#image_fs").show();
});

function getLocation(timeoutVal, highAccuracy, errorCallback) {
	if (geoService) {
		navigator.geolocation.getCurrentPosition(showCurrentLocation, errorCallback, {enableHighAccuracy: highAccuracy, timeout: timeoutVal});
	} else {
		$('body').spin();
		var text = "GeoLocation is not supported by your device.";
		$().toastmessage({
			text     	: text,
			position 	: 'bottom-center',
			type     	: 'success',
			stayTime	: 2000						
		});
		$().toastmessage('showNoticeToast', text);
	}
}