var sightsDB = (function() {
	var returnDB = {};
	var datastore = null;
	
	returnDB.open = function(callback) {
		var version = 42;
		var request = indexedDB.open('sights', version);
		console.log("open");
		
		request.onupgradeneeded = function(event) {
			console.log("upgrade");
			var db = request.result;

			if (db.objectStoreNames.contains('sights')) {
				db.deleteObjectStore('sights');
			}

			var store = db.createObjectStore('sights', {keyPath: 'id'});
			var nameIndex = store.createIndex("by_name", "name", {unique: true});
			var latitudeIndex = store.createIndex("by_lat", "lat");
			var longitudeIndex = store.createIndex("by_long", "long");
			var descIndex = store.createIndex("by_desc", "desc");
			var cityIndex = store.createIndex("by_city", "city");
			var subtitleIndex = store.createIndex("by_subtitle", "subtitle");
			var inDiaryIndex = store.createIndex("by_inDiary", "inDiary");
			var address = store.createIndex("by_address", "address");
			var cityName = store.createIndex("by_city_name", "city_name");

			/* requires jQuery */
			$.ajax({
				type: 'GET',
				url: 'data/sights.json',
				dataType: 'json',
				success: function(data) {
							var i = 0;
							while (data[i]) {
								store.put({id: i, name: data[i]['name'], desc: data[i]['desc'], latitude: data[i]['latitude'],
									longitude: data[i]['longitude'], city: data[i]['city'], subtitle: data[i]['subtitle'], inDiary: 0,
									address: data[i]['address'], city_name: data[i]['city_name']});
								i++;
							}
						},
				data: {},
				async: false
			});
		};

		request.onsuccess = function(event) {
			console.log("success");
			datastore = request.result;
			callback();
		};

		request.onerror = function () {
			report(request.error);
			console.log("error");
		}
	};
	
	returnDB.getAll = function(callback) {
		returnDB.get(null, callback);
	};
	
	returnDB.get = function(query, callback) {
		var tx = datastore.transaction("sights", "readonly");
		var store = tx.objectStore("sights");
		var index = store.index("by_name");
		var sights = [];
		var request;
		
		if (query) {
			query = query.toLowerCase().trim();
		}
		
		request = index.openCursor();

		request.onsuccess = function() {
			var cursor = request.result;
				if (cursor) {
					if (query) {
						if (cursor.value.name.toLowerCase().indexOf(query) != -1) {
							sights.push(cursor.value);
						}
					} else {
						sights.push(cursor.value);
					}
					
					cursor.continue();
				} else {
					callback(sights);
				}
		};
	};
	
	returnDB.getByID = function(id, callback) {
		var tx = datastore.transaction("sights", "readonly");
		var store = tx.objectStore("sights");
		var request;
		
		var request = store.get(id);
		
		request.onsuccess = function() {
			callback(request.result, "sights");
		};
	};
	
	returnDB.getAllByCity = function(id, callback) {
		var tx = datastore.transaction("sights", "readonly");
		var store = tx.objectStore("sights");
		var index = store.index("by_city");
		var request = index.openCursor(IDBKeyRange.only(id));
		var sights = [];
		
		console.log('AllByCity: ' + id);
		
		request.onsuccess = function() {
			var cursor = request.result;
				if (cursor) {
					sights.push(cursor.value);
					cursor.continue();
				} else {
					callback(sights);
				}
		};
	};
	
	returnDB.getByCity = function(id, query, callback) {
		var tx = datastore.transaction("sights", "readonly");
		var store = tx.objectStore("sights");
		var index = store.index("by_city");
		var request = index.openCursor(IDBKeyRange.only(id));
		var sights = [];
		query = query.toLowerCase().trim();
		
		console.log('ByCity: ' + id);
		
		request.onsuccess = function() {
			var cursor = request.result;
				if (cursor) {
					if (cursor.value.name.toLowerCase().indexOf(query) != -1) {
						sights.push(cursor.value);
					}				
					cursor.continue();
				} else {
					callback(sights);
				}
		};
	};
	
	returnDB.addToDiary = function(id, sight) {
	console.log("Added: " + sight.name + "; id = " + id);
		var tx = datastore.transaction("sights", "readwrite");
		var store = tx.objectStore("sights");
		sight.inDiary = id;
		store.put(sight);
	}
	
	returnDB.removeFromDiary = function(sight) {
	console.log("Removed: " + sight.name + "; id = " + sight.id);
		var tx = datastore.transaction("sights", "readwrite");
		var store = tx.objectStore("sights");
		sight.inDiary = 0;
		store.put(sight);
	}
	
	return returnDB;
}());