$('#newgame').click(function() {
	game.newgame();
});	
// === Init Game ====
function memorygame(){
	var images,width,height,evengame;
	//-- initialise --
	// default level = 18 images
	this.images = 8;
	this.width  = 72;
	this.height = 72;
	$('#container').css({"width":"313","padding-left":"7px"});			
	$('#gl').html("<em>level: low</em>");
	// Even en on-even spel zorgt voor de wisseling van plaatjse
	// en background
	this.evengame = true;		
	
	//==== New Game =====	
	this.newgame = function(){
		// Opnieuw de array opzetten.
		var grid = new Array();
		// Positie van de gedraaide kaartjes.
		var iPosTurned = new Array(2);
		var iPosThis   = new Array(2);
		var iClickCount = 0;
		var iTurned = 0;
		var iStukkenOver = this.images;		
		var iImages = this.images * 2;		
		iPosTurned[0] = iPosTurned[1] = iPosThis[0] = iPosThis[1] = 0;

		// clean up het bord
		 $(".card").remove();
		 // dummy's ook weg
		 $(".dummy").remove();
		var iTmp = this.images * 2;
		// Het grid waarin de images komen op 0 zetten
		// Zie de do lus. Alleen 0 wordt vervangen door
		// een random getal.
		for(var i=0;i<iTmp;i++)      	 
			grid[i] = 0;
		// Random de tabel vullen
		// Twee keer, omdat ieder plaatje twee keer
		// in het spel voorkomt.
		for (var j=0; j<2; j++){
			for(var i=0;i<this.images;i++){
				// Image 1 t/m 32 wordt random verspreidt
				// waarna de reeks nog eens verspreid wordt
				do{
					var rand_no = Math.ceil(iTmp* Math.random()) - 1;
				} while (grid[rand_no] != 0)
				grid[rand_no] = i; 
			}	
		}
		// Plaats de images in het bord
		for (i = 0; i < grid.length; i++){
			var strTmp = "<li style='width:"+this.width+"px;height:"+this.height+"px' class='card' id='card"+ i +"'>";
			if(this.evengame)
				strTmp += "<figure class='back'><img src='images/cardbacka.png' 'width="+this.width+"px height="+this.height+"px'></figure>";
			else
				strTmp += "<figure class='back'><img src='images/cardbackb.png' 'width="+this.width+"px height="+this.height+"px'></figure>";
			strTmp += "<figure class='front'><img src='images/" + grid[i] + "e.png' 'width="+this.width+"px height="+this.height+"px'></figure></li>";
			$('#container').append(strTmp);
		}
		this.evengame = !this.evengame;
		var iWidth  = this.width;
		var iHeight = this.height;
		// Nu ervoor zorgen dat de click functie werkt
		// Terug draaien gaat na twee twee open kaarten
		// en nogmaals klikken op een kaart.
		$('.card').click(function() {
			iClickCount++;
			if(!$(this).hasClass("flipped")){
				if(iTurned >= 2){
					// Terug draaien open liggende kaartjes
					// of verwijderen indien openliggende kaartjes
					// gelijk.
					iTurned = 0;
					if (iPosTurned[0] == iPosTurned[1]){
						// Er moet een lege dummy <li> worden geplaatst
						$(iPosThis[0]).replaceWith("<li class='dummy' style='width:"+iWidth+"px;height:"+iHeight+"px'></li>");
						$(iPosThis[1]).replaceWith("<li class='dummy' style='width:"+iWidth+"px;height:"+iHeight+"px'></li>");
						iStukkenOver--;
					}
					$('#container li').removeClass("flipped");
					iPosTurned[0] = iPosTurned[1] = iPosThis[0] = iPosThis[1] = 0;
				}
				if(iTurned <= 1){
					$(this).addClass("flipped");
					// id = bijvoorbeeld card32
					iTmp = this.id;
					iTmp = iTmp.substring(4);
					iPosThis[iTurned] = this;
					iPosTurned[iTurned] = grid[iTmp];
					iTurned++;
				}
				// ------ Game over ------
				if(iStukkenOver < 2 && iTurned >= 2){
					var pTitle = "Game over";
					var pText;
					var iAverageClick = iClickCount  / iImages;
					var strAverage = "Average clicks per image:<br>" + iAverageClick.toFixed(2);
					if(iClickCount <= (iImages * 2))
						pText = "You deserve your place in the hall of fame, you have a very good memory !!<br>" + strAverage;
					else if(iClickCount > (iImages * 2) && iClickCount <= (iImages * 3))
						pText = "Your short-term memory is good..! " + strAverage;
					else if(iClickCount > (iImages * 3) && iClickCount <= (iImages * 4))
						pText = "I think you have to train your short-term memory a little bit more with this game.<br>" + strAverage;
					else if(iClickCount > (iImages * 4))
						pText = "Oops... thats not much. Train your brain or go to sleep ;-)<br>" + strAverage;
					$('#gameover').html(pText);
					document.querySelector('#confirm').className = 'fade-in';
				}
			}
		});
	}

	//==== Gamelevel and help =====
	this.gamelevel = function(level){
		switch(level){
		case 1:
			this.images = 8; // 16/2 bord 4x4
			this.width  = this.height = 72;
			$('#container').css({"width":"313","padding-left":"7px"});			
			$('#gl').html("<em>level: low</em>");
		break;
		case 2:
			this.images = 12; // 24/2 bord 4x6
			this.width  = this.height = 48;
			$('#container').css({"width":"317","padding-left":"2px"});			
			$('#gl').html("<em>level: medium</em>");
		break;		
		case 3:
			this.images = 18; // 36/2 bord 6x6
			this.width  = this.height = 48;
			$('#container').css({"width":"317","padding-left":"2px"});
			$('#gl').html("<em>level: high</em>");			
		break;
		}
	} 
}
// Initialise the game
var game = new memorygame();
// Reageer op de click van de levels
$('#bdkLow').click(function() {
	game.gamelevel(1);
	game.newgame();
	});
$('#bdkMedium').click(function() {
	game.gamelevel(2);
	game.newgame();		
	});
$('#bdkHigh').click(function() {
	game.gamelevel(3);
	game.newgame();		
});	

