var myapp = angular.module('myApp',[]);

myapp.controller('mainCtrl',function($scope,$http,$timeout,$window){
	$scope.initObj = {
		w : 9,
		h : 5
	}
	$scope.init = function(){

		$scope.scene = [];
		$scope.startTime = new Date();

		var total = $scope.initObj.h * $scope.initObj.w;
		var remain = total;
		var colorArray = ['red','blue'
			,'green','yellow','orange'
		]
		var totalArray = [0,0
			,0,0,0
		]

		for(i=0;i<colorArray.length;i++){		
			if(i<colorArray.length -1){
				var n = Math.floor((Math.random() * total/colorArray.length) + 1);
				while(n%2!=0){
					n = Math.floor((Math.random() * total/colorArray.length) + 1);
				}
				totalArray[i]=n;
				remain -= n
			}else{
				totalArray[i] = remain
			}
		}
	
		for(i=0;i<=$scope.initObj.w-1;i++){
			$scope.newRow = [];
			for(n=0;n<=$scope.initObj.h-1;n++){
				var col = Math.floor(Math.random() * colorArray.length)
				if(totalArray[col]<0){
					var tile = {
						color : colorArray[col],
						hide : 0
					}
					totalArray[col]--
					}else{
						while(totalArray[col]==0){
							if(col==colorArray.length-1){
								col=0;
							}	else{
								col++
							}	
						}
						
						
						var tile = {
						color : colorArray[col],
						hide : 0
					}	
						totalArray[col]--
					}

				$scope.newRow.push(tile);
			}
			$scope.scene.push($scope.newRow);
		}
	$scope.hide = 0;
	$timeout(function(){
		$scope.hide=1
	},1000,true);


	}



	$scope.init()

	$scope.checkVal1 = '';
	$scope.checkVal2 = '';

	$scope.hideAll = function(){
		angular.forEach($scope.scene,function(val){
			angular.forEach(val,function(val1){
				val1.hide=1;
			})
		})
	}
	
	$scope.checkWin = function(){
		var win =true;
		angular.forEach($scope.scene,function(val){
			angular.forEach(val,function(val1){
				if(val1.checked!=1){
					win=false;
				}
			})
		})
		return win;
	}
	

	$scope.removeItem = function(item){
		angular.forEach($scope.scene,function(val){
			angular.forEach(val,function(val1,key){
				if(item==val1){
					val1.color="white";
					val1.checked=1;
				}
			})
		})
		if($scope.checkWin()==true){
			var endTime = new Date();
			var gTime = msToTime(endTime-$scope.startTime)
			alert('You won in:\n' + gTime + '!!!')
			$scope.init();
		}
	}

	$scope.addItem = function(scene,item){
		var inserted = false
		angular.forEach(scene,function(val){
			angular.forEach(val,function(val1,key){
				if(val1.checked==1){
					val1=item;
					inserted = true;
				}
			})
		})
		if(inserted==false){
			if(scene[scene.length].length < $scope.initObj.h){
				scene[scene.length].push(item)
			}else{
				var newRow = [item];
				scene.push(newRow);
			}
		}
	}

	$scope.changeState = function(item){
		if($scope.checkVal1!='' && $scope.checkVal2) return
		if($scope.checkVal1==item){

		}else{
			item.hide=0
			if($scope.checkVal1!=''){
				$scope.checkVal2=item;
				$timeout(function(){
					if($scope.checkVal1!=''){
						$scope.checkVal1 = '';
						$scope.checkVal2 = '';
					}
					$scope.hideAll();

				}, 1000, true);
			}else{
				$scope.checkVal1=item;
			}
		}
	}

	$scope.$watch('hide',function(newval,oldval){
		angular.forEach($scope.scene,function(val){
			angular.forEach(val,function(val1){
				val1.hide=newval;
			})
		})
	});


	$scope.$watch('checkVal2',function(newval,oldval){
		if(newval){
			if(newval.color==$scope.checkVal1.color){
				$scope.removeItem(newval);
				$scope.removeItem($scope.checkVal1);
			}
		}
	});

	$scope.setClass = function(item){
		if(item.checked==1){
			return item.color
		}else{
			if(item.hide==0){
				return item.color
			}else{
				return 'hide'
			}
		}

	}


	function msToTime(duration) {
	    var milliseconds = parseInt((duration%1000)/100)
	        , seconds = parseInt((duration/1000)%60)
	        , minutes = parseInt((duration/(1000*60))%60)
	        , hours = parseInt((duration/(1000*60*60))%24);

	    hours = (hours < 10) ? "0" + hours : hours;
	    minutes = (minutes < 10) ? "0" + minutes : minutes;
	    seconds = (seconds < 10) ? "0" + seconds : seconds;

	    return hours + ":" + minutes + ":" + seconds + "." + milliseconds;
	}

})
