﻿$(function () {
    document.webL10n.ready(function () {
        //init field

        var $gameField = $('#mgField');
        var cards = [];
        var activeCards = [];

        var mins = 2;
        var secs = mins * 60;
        var currentSeconds = 0;
        var currentMinutes = 0;
        var c = 0;
        var minutes = 0;
        var t;
        var timer_is_on = 0;
        var cardsonfield = 0;
        var timerMode = false;
        var timer1, timer2;

        var $overlay = $('.overlay');

        if (window.innerHeight > window.innerWidth) {
            $('section').addClass('portrait');
        }
        else {
            $('section').addClass('landscape');
        }


        var figures = ['panda', 'darthvader', 'batman', 'muffin', 'mushroom', 'ghost', 'americanfootball', 'vendetta', 'punisher', 'spaceinvaders', 'pokemon', 'ninja', 'deathstar', 'ewingoil', 'kiwi', 'ironman', 'spiderman', 'eightball', 'cherry', 'duck'];

        var newGameOverlay = '<div><img src="../icon_128.png" /><br /></div><div><div class="start-button" id="threeMinutes"><h2>' + document.webL10n.get("twoMinutesGame") + '</h2><p>' + document.webL10n.get("twoMinutesGameDesc") + '</p></div><div class="start-button" id="regularGame"><h2>' + document.webL10n.get("regular-game") + '</h2><p>' + document.webL10n.get("regular-gameDesc") + '</p></div><label>' + document.webL10n.get("30-cards") + '</label><input type="radio" value="30" name="cardnum" checked /><label>' + document.webL10n.get("40-cards") + '</label><input type="radio" value="40" name="cardnum" /></div>';

        displayOverlay(newGameOverlay);

        function initField(timer, num) {
            cards = [];
            $('section').attr('data-cardnum', num);

            var width = (window.innerWidth / 5) - 15;

            Card.prototype.draw = function () {
                $gameField.find('div#row' + this.x).append('<div class="card card' + this.y + '"><div class="front"></div><div class="back"></div></div>');
                $('.card' + this.y).height(width).css('font-size', width * 0.8);
            }


            $gameField.height(window.innerHeight - 30);

            var cardIndex = Number(1);
            cardsonfield = num;
            var max = num;
            if (num === 30) {
                if ($('section').hasClass('portrait')) {
                    maxi = 7;
                    minj = 6;
                }
                else {
                    maxi = 6;
                    minj = 7;
                }
            }
            else if (num === 40) {
                if ($('section').hasClass('portrait')) {
                    maxi = 9;
                    minj = 6;
                }
                else {
                    maxi = 6;
                    minj = 9;
                }
            }

            for (var i = 1; i < maxi; i++) {
                var row = $('<div id="row' + i + '" class="row"></tr>');
                $gameField.append(row);
                for (var j = 1; j < minj; j++) {
                    createCard(i, j, cardIndex)
                    cardIndex += 1;
                }
            }

            setFigures(cards, max);
            dealCards(cards);

            if (timer) {
                currentSeconds = 0;
                currentMinutes = 0;
                c = 0;
                minutes = 0;
                timer_is_on = 0;
                timerMode = true;
                secs = 2 * 60;
                clearTimeout(timer1);
                countingBackward();
            }
            else {
                c = 0;
                minutes = 0;
                timer_is_on = 0;
                currentSeconds = 0;
                currentMinutes = 0;
                secs = 2 * 60;
                timerMode = false;
                clearTimeout(timer2);
                countingForward();
            }

            //tap,click card

            $('.card').on('tap click', function () {
                var that = $(this);
                if (activeCards.length < 2 && !that.hasClass('active') && !dissappearing) {
                    activeCards.push(that);
                    flipUpCard(that);
                    if (activeCards.length === 2) {
                        setTimeout(function () {
                            matchCards(activeCards);
                        }, 1000);
                    }
                }

            });
        }

        //create cards

        function createCard(x, y) {

            Card.prototype.add = function () {
                cards.push(card);
            }

            var card = new Card(x, y, '');
            card.add();
            card.draw();
        }

        function setFigures(a, m) {

            var i = 0;
            var j = 0.
            while (i < m) {
                a[i].figure = figures[j];
                i += 1;
                if ((i % 2) === 0 && i != 0) {
                    j += 1;
                }
            }
            shuffleCards(a);
        }

        //shuffle cards

        function shuffleCards(a) {
            var tmp, current, top = a.length;

            if (top) while (--top) {
                current = Math.floor(Math.random() * (top + 1));
                tmp = a[current];
                a[current] = a[top];
                a[top] = tmp;
            }
        }

        //deal cards

        function dealCards(a) {
            $('.card').each(function (i) {
                var that = $(this);
                that.attr('data-figure', a[i].figure);
            });
        }

        function Card(x, y, figure, index) {
            this.x = x;
            this.y = y;
            this.figure = figure;
        }

        //flipup cards

        function flipUpCard(t) {
            t.addClass('active');
        }

        //flipdown cards

        function flipDownCards(a) {
            $.each(a, function (i, item) {
                item.removeClass('active');
            });
        }

        //match cards

        function matchCards(t) {
            if (t[0].attr('data-figure') === t[1].attr('data-figure')) {
                dissappearing = true;
                removePair(t);
            }
            else {
                flipDownCards(t);
                activeCards = [];
            }
        }

        //remove pair

        var dissappearing = false;

        function removePair(t) {
            $.each(t, function (i, item) {
                item.addClass('magictime vanishOut');
            });

            setTimeout(function () {
                dissappearing = false;
            }, 300);
            activeCards = [];
            cardsonfield -= 2;
            if (cardsonfield === 0) {
                displayOverlay('<div><img src="../icon_128.png" /><br /><h1>' + document.webL10n.get("you-won-the game") + '</h1><div>' + $('.timer').text() + '</div><div class="new_game start-button"><h2>' + document.webL10n.get("choose-new-game") + '</h2></div></div>');
                $('.new_game').on('tap click', function () {
                    displayOverlay(newGameOverlay);
                    destroyField();
                });
            }
        }

        //counting forward

        function countingForward() {

            $(".timer").html('<span>' + document.webL10n.get("your-time") + '</span><span class="time">' + minutes + ':' + c + '</span>');
            c = c + 1;
            if (c % 60 == 0) {
                minutes += 1;
                c = 0;
            }
            if (!timerMode) {
                timer1 = setTimeout(function () {
                    countingForward()
                }, 1000);
            }
        }

        //counting backward

        function countingBackward() {
            currentMinutes = Math.floor(secs / 60);
            currentSeconds = secs % 60;
            if (currentSeconds <= 9) currentSeconds = "0" + currentSeconds;
            secs--;
            $('.timer span:first-of-type').html('<span>' + document.webL10n.get("remaining-time") + '</span>');
            $(".time").html(currentMinutes + ":" + currentSeconds);
            if (secs > -1) timer2 = setTimeout(function () {
                countingBackward();
            }, 1000);
            else {
                loosing();
            }
        }

        //destroy field

        function destroyField() {
            $('#mgField').html('');
        }

        //close game
        //about
        //menu

        $('.back').on('tap click', function () {
            if ($('.overlay').html() === '') {
                window.close();
            }
            else {
                closeOverlay();
            }
        });

        $('.menu').on('tap click', function () {
            if (!$(this).hasClass('active')) {
                $("nav").show();
                $("nav").height($(document).height() - 30);
                $("nav").animate({
                    right: "0"
                }, 1000);
                $(this).addClass('active');
            }
            else {
                menuClose();
                $(this).removeClass('active');
            }
        });

        function menuClose() {
            $("nav").animate({
                right: "-150"
            }, 1000);
            $('.menu').removeClass('active');
        }

        //new game

        $('.newgame').on('tap click', function () {
            menuClose();
            displayOverlay(newGameOverlay);

        });

        $('.about').on('tap click', function () {
            menuClose();
            displayOverlay('<div><img src="../icon_128.png" /><br /><h2>' + document.webL10n.get("about-memory-game") + '</h2><p>' + document.webL10n.get("version") + '</p>' + document.webL10n.get("made-by") + ' <strong>Aniko Litvanyi</strong><p>Firefox OS Course, Óbuda University</p><div class="start-button" id="closeButton"><h2>' + document.webL10n.get("close") + '</h2></div><small>' + document.webL10n.get("icons-were-made") + ' <a target="_blank" href="http://www.webhostinghub.com/glyphs/">WebHostingHub Glyphs</a></small></div>');
            $('#closeButton').on('tap click', function () { closeOverlay(); });
        });

        //landscape mode

        //loose
        function loosing() {
            displayOverlay('<div><h1><img src="../icon_128.png" /><br /><div>' + document.webL10n.get("you-lost") + ' :(</div></h1><div class="new_game start-button"><h2>' + document.webL10n.get("choose-new-game") + '</h2></div></div>');
            $('.new_game').on('tap click', function () {
                displayOverlay(newGameOverlay);
                destroyField();
            });
        }

        //overlay

        function displayOverlay(h) {
            $overlay.html(h).hide();
            $overlay.fadeIn(500);

            $('#threeMinutes').on('tap click', function () {
                var cardNum = parseInt($('input[name=cardnum]:checked').val());
                closeOverlay();
                destroyField();
                initField(true, cardNum);
            });
            $('#regularGame').on('tap click', function () {

                var cardNum = parseInt($('input[name=cardnum]:checked').val());
                closeOverlay();
                destroyField();
                initField(false, cardNum);
            });
        }

        function closeOverlay() {
            $overlay.fadeOut(function () {
                $overlay.html('');
            });
        }

        //window resize

        function onResized(e) {
            $('.card').height($('.card').first().width());
        }
        $(window).on("resize", onResized);
        $(window).on("orientationchange", onResized);

        function oChanged() {

        }

        //templates
        var aboutTemplate = '';
        var highscoreTemplate = '';
    });
});