(function () {

  // create game object
  var game = {

    state: 'off',
    width: 5, 
    height: 5,
    level: 1,
    timer: undefined,
    map: [],
    found: 0,
    total: 0,

    dificulty: function () {
      return this.level / 10;
    },

    start: function () {
      if (this.state === 'on') return;
      this.timer = new Timer();
      this.flipAll();
      this.state = 'on';
    },

    flipAll: function () {
      var map = this.map;
      if (map[0]===undefined) return;
      for (var h=0;h<map.length;h++) {
        var row = map[h];
        for (var w=0;w<row.length;w++) {
          row[w].flip();
        }
      }
    },

    newLevel: function () {
      this.found = 0;
      this.total = 0;
      this.state = 'off';
      if (this.timer) this.timer.stopClock();
      this.map = new Map();
      this.flipAll();
    },

    isWin: function () {
      if (this.found !== this.total) return false;
      this.level++;
      this.width++;
      this.height++;
      this.newLevel();
      alert("You win... this time. Welcome to round " + this.level);
      return true;
    },

    fail: function () {
      alert("You have failed like so many before you. Start over noob....");
      this.reset();
    },

    init: function () {
      this.level = 1;
      this.width = 5;
      this.height = 5;
      this.newLevel();
      return this;
    },

    reset: function () {
      return this.init();
    }
  }

  // timer module
  var Timer = function () {
    var d = new Date();
    d.el = document.getElementById('clock');

    d.clock = function () {
      var stopWatch = new Date().getTime() - this.getTime();
      return Math.floor( parseInt( stopWatch ) / 1000 );
    };

    var id = timer = setInterval(function () {
      d.el.innerHTML = d.clock();
    }, 200);

    d.stopClock = function () {
      clearInterval(id);
      d.el.innerHTML = '0';
    }

    return d;
  }

  // tile module
  var Tile = function () {
    var tile = this;
    var rand = Math.random();

    tile.flipped = false;
    tile.type = (rand<=game.dificulty()) ? 'special' : 'regular';
    tile.el = document.createElement('div');
    tile.el.className = 'tile';
    if (tile.type === 'special') game.total++;

    tile.flip = function () {
      if (tile.el.className.indexOf('flip') < 0 || tile.isClicked) {
        tile.el.className += ' flip ' + tile.type;
      } else {
        tile.el.className = 'tile';
      }
    }

    function elClicked (e) {
      if (game.state !== 'on') return;
      tile.isClicked = true;
      tile.flip();
      if (tile.type === 'regular') game.fail();
      if (tile.type === 'special') game.found++;
      game.isWin();
      console.log()
      tile.flip = function (){};
      tile.el.removeEventListener('click', elClicked);
    }

    tile.el.addEventListener('click', elClicked);
    return tile;
  }

  // map collection
  var Map = function () {

    var map = new Array();
    map.el = document.getElementById('map');
    map.el.innerHTML = '';

    // generate and paint map;
    var wid = game.width;
    var hei = game.height;
    for (var w=0;w<wid; w++) {
      var row = []
      var elRow = document.createElement('div');
      for(var h=0;h<hei; h++) {
        var tile = new Tile();
        row.push(tile)
        elRow.appendChild(tile.el);
      }
      map.push(row);
      map.el.appendChild(elRow);
    }

    return map;
  }

  window.addEventListener("load", function () {
    window.memory = game.init();
  });

})()

/*

function shuffle () {
  // thank you fischer yates
  var originalList = [1,2,3,4,5,6,7,8,9];
  var shuffeledList = [];

  while (originalList[0]) {
    var rand1 = Math.floor( Math.random()*  originalList.length);
    var rand2 = Math.floor( Math.random()*  shuffeledList.length );

    shuffeledList.splice(rand2, 0, originalList.splice(rand1, 1)[0])
  }

  return shuffeledList
}

*/
