/*global $, Game, Application, Configuration, States, TileSet, console, setTimeout*/
/*jslint plusplus: true*/
$(function () {
    'use strict';
    TileSet.init();
    Application.init();
    Game.init();
    
    function hideToolbar() {
        $('#toolbar').removeClass('showToolbar').addClass('hideToolbar');
    }
    
    function initTileSets() {
        var i, tileSet, tileSets;
        tileSet = TileSet.getName();
        $('#' + tileSet + 'TileSetText').html('<i>This is the current tileset</i>');
        $('#' + tileSet + 'TileSet').parent().css('background-color', '#eeeeee');
        tileSets = TileSet.getAvailableTileSetNames();
        for (i = 0; i < tileSets.length; i++) {
            if (tileSets[i] !== tileSet) {
                $('#' + tileSets[i] + 'TileSetText').html('Select this tileset');
                $('#' + tileSets[i] + 'TileSet').parent().css('background-color', 'white');
            }
        }
    }
    
    // css animations
    $('#optionsButton').bind('click', function () {
        console.log('Showing options.');
        initTileSets();
        $('#optionsPage').attr('class', 'current');
        $('[data-position="current"]').attr('class', 'left');
    });
  
    $("#optionsBackButton").bind('click', function () {
        $('#optionsPage').attr('class', 'right');
        $('[data-position="current"]').attr('class', 'current');
    });
  
    $('#newGameButton').bind('click', function () {
        console.log('New game started!');
        // set up toolbars
        $('#toolbar').hide();
        $('#minimizedToolbar').show();
        $('#gamePage').attr('class', 'current');
        $('[data-position="current"]').attr('class', 'left');
        Application.startGame();
    });
    
    $('#backButton').bind('click', function () {
        $('#gamePage').attr('class', 'right');
        $('[data-position="current"]').attr('class', 'current');
        setTimeout(function () {
            hideToolbar();
            $('#main').empty();
        }, Configuration.TRANSITION_TIMEOUT);
    });
    
    $('#hideButton').bind('click', hideToolbar);
    
    $('#toolbar').bind('transitionend', function () {
        var toolbarState = States.UNDEFINED;
        if ($('#toolbar').hasClass('hideToolbar')) {
            toolbarState = States.MINIMIZED;
        } else if ($('#toolbar').hasClass('showToolbar')) {
            toolbarState = States.MAXIMIZED;
        }

        if (toolbarState === States.MINIMIZED) {
            $('#toolbar').hide();
            $('#minimizedToolbar').show();
        } else if (toolbarState === States.MAXIMIZED) {
            $('#hideButton').bind('click', hideToolbar);
        } else {
            console.warn('This should not happen!');
        }
    });
    
    $('#showButton').bind('touchstart', function () {
        // remove event handler on hide button
        $('#hideButton').unbind('click');
        $('#minimizedToolbar').hide();
        $('#toolbar').show();
        $('#toolbar').css({marginTop: '-=3rem'});
        $('#toolbar').removeClass('hideToolbar').addClass('showToolbar');
    });
  
    $('#refreshButton').bind('click', function () {
        // create a new game
        console.log('New game started!');
        $('.live-tile').unbind('click');
        Application.startGame();
    });
    
    $('#alphabetsTileSet').bind('click', function () {
        console.log('Changing tileSet to "alphabets"');
        TileSet.changeTileSet('alphabets');
        initTileSets();
    });
    
    $('#numbersTileSet').bind('click', function () {
        console.log('Changing tileSet to "numbers"');
        TileSet.changeTileSet('numbers');
        initTileSets();
    });

});
