/*global console, $, Game, Configuration, setTimeout*/
/*jslint plusplus: true*/
/*jslint vars: true*/
/**
 * The main application class, providing the high level functions of the game.
 */
var Application = (function () {
    "use strict";
    /** Flag for the object initialization */
    var initialized = false;

    /** The class object */
    var app = {};

    /** The class constuctor */
    app.init = function () {
        if (initialized) {
            return;
        } else {
            initialized = true;
        }

        /** Launch a new game */
        app.startGame = function () {
            // reset counters
            Game.resetGame();
            setTimeout(function () {
                // start timer and show tiles
                Game.generateTiles();
                Game.createEventHandler();
                Game.startTimer();
            }, Configuration.TRANSITION_TIMEOUT);
        };

        /** Load the options menu */
        app.showOptions = function () {
        };
        
        console.log("Application object initialized.");
    };

    return app;
}());
