/*global window, console, $, Configuration, setTimeout, setInterval, alert, TileManager, TileSet*/
/*jslint plusplus: true*/
/*jslint vars: true*/

/**
 * The game class, providing the game logic functions.
 */
var Game = (function () {
    "use strict";

    /** The class object */
    var game = {};

    /** Found pairs */
    var pairs = 0;
    
    /** Flips */
    var flips = 0;
    
    /** The time of the game start */
    var startDate;

    /** The class constuctor */
    game.init = function () {
        /** Generate tiles */
        game.generateTiles = function () {
            console.log("Generating tiles");
            var i;
            // if there are existing items
            if ($('#main').children().length > 0) {
                // remove them
                $("#main").empty();
            }
            $('<div class="tiles tile-group blue" id="memoryTiles">').appendTo("#main");
            
            TileManager.reset();
            TileManager.init();
            for (i = 0; i < Configuration.TILE_PAIRS * 2; i++) {
                // generate a color
                $('<div class="live-tile accent" id="tile' + i + '">').appendTo("#memoryTiles");
                $('<div></div>').appendTo("#tile" + i);
                var nextTile = TileManager.getTile(i);
                $('<div><img class="full accent ' + nextTile.color + '" src="' + nextTile.source + '"/></div>').appendTo("#tile" + i);
                $("#tile" + i).liveTile({ repeatCount: 0, delay: 0, startNow: false});
            }
        };
        
        game.createEventHandler = function () {
            $(".live-tile").bind("click", TileManager.tileClickHandler);
        };
      
        game.resetGame = function () {
            pairs = 0;
            flips = 0;
            $("#time").countdown("destroy");
        };
        
        game.startTimer = function () {
            startDate = new Date();
            $("#time").countdown({since: startDate, compact: true, format: 'MS'});
        };

        game.increasePairs = function () {
            pairs++;
        };
        
        game.increaseFlips = function () {
            flips++;
        };
        
        console.log("Game object initialized.");
    };

    return game;
}());
