/*global console, $, Configuration, setTimeout, setInterval, alert, shuffleArray, pad, Tile, TileSet */
/*jslint vars: true */
/*jslint plusplus: true*/

/**
 * The main game logic class
 */
var TileManager = (function () {
    "use strict";

    /** The number of matches found */
    var tileMatches = 0;

    /** The list of flipped up tiles */
    var flippedTiles = [];

    /** The list of tiles */
    var tiles = [];

    /** A map for finding matching elements */
    var matchingTiles = [];
    
    /** return public methods */
    return {
        /** Initialize the class with data */
        init : function () {
            console.log("INIT CALLED");
            var i, j, m, temp, tile, color, colorList, sourceList;
            
            colorList = ["red", "blue", "teal", "yellow", "orange", "violet", "lime",
                "sienna", "steel", "olive", "mauve", "mango"];
            console.log("hi!", TileSet.getName());
            console.log(TileSet.getAvailableTileSets());
            sourceList = TileSet.getTileList();
            console.log(sourceList);
            
            // "repair" sourceList
            for (i = 0; i < sourceList.length; i++) {
                console.log("hey");
                console.log(sourceList);
                console.log(TileSet.getAvailableTileSets());
                sourceList[i] = "images/tilesets/" + TileSet.getName() + "/" + sourceList[i] + ".png";
            }
            
            // randomize input
            colorList = shuffleArray(colorList);
            sourceList = shuffleArray(sourceList);
            
            // create tiles
            for (i = 0; i < Configuration.TILE_PAIRS; i++) {
                tile = new Tile(colorList[i], sourceList[i]);
                tiles[2 * i] = tile;
                tiles[2 * i + 1] = tile;
            }
            
            // randomize tiles
            shuffleArray(tiles);
            
            // find the pairs
            for (i = 0; i < Configuration.TILE_PAIRS * 2; i++) { // for what?
                for (j = 0; j < Configuration.TILE_PAIRS * 2; j++) { // the pair
                    if (i !== j && tiles[j].color === tiles[i].color) {
                        matchingTiles[i] = j;
                    }
                }
            }
            
            //console.log(tiles, matchingTiles);
        },
        
        /** Get the next memory game tile*/
        getTile : function (i) {
            return tiles[i];
        },
        
        /** Reset everything to its initial state */
        reset : function () {
            tileMatches = 0;
            flippedTiles = [];
            matchingTiles = [];
            tiles = [];
        },

        tileClickHandler : function () {
            var tileId, flipped;
            tileId = parseInt($(this).attr("id").replace("tile", ""), 10);

            // if it is currently flipped DO NOTHING!
            if ($.inArray(tileId, flippedTiles) !== -1) {
                console.log("NO-OP");
                return;
            }

            flipped = flippedTiles.length;
            switch (flipped) {
            // zero is only possible in the beginning
            case 0:
                console.log("case 0");
                // just flip it and move on
                $(this).liveTile("play");
                flippedTiles[0] = tileId;
                console.log("Pair is #" + matchingTiles[tileId]);
                break;
            case 1:
                console.log("case 1");
                $(this).liveTile("play");
                flippedTiles[1] = tileId;
                console.log("clicked: #" + tileId);
                // check if the game is won
                if (tileMatches === Configuration.TILE_PAIRS - 1) {
                    // end the game!
                    var timerHTML = $('#time').html();
                    var periods = $('#time').countdown('getTimes');
                    var timerText = periods[5] + ":" + pad(periods[6]);
                    $('#time').countdown('destroy');
                    $('#time').html(timerHTML);
                    setTimeout(function () { alert("You won after " + timerText + "!"); }, 1000);
                }
                break;
            // two tile is already flipped up
            case 2:
                console.log("case 2");
                console.log("clicked: #" + tileId);
                $(this).liveTile({repeatCount: 0, delay: 0});
                $(this).liveTile("play");
                // check if its a pair
                console.log("First item: " + flippedTiles[0] + " second item: " + flippedTiles[1] + " -- expected " + matchingTiles[flippedTiles[0]]);
                if (flippedTiles[1] === matchingTiles[flippedTiles[0]]) {
                    tileMatches++;
                    $.each(flippedTiles, function (index, value) {
                        $("#tile" + value).unbind("click");
                    });
                    console.log("Match found! Current matches: " + tileMatches);
                    flippedTiles = [];
                } else {
                    $.each(flippedTiles, function (index, value) {
                        $("#tile" + value).liveTile({ repeatCount: 0, delay: 0, startNow: false});
                    });
                }
                flippedTiles = [tileId];
                break;
            }
        }
    };
}());
