/*global console*/
/*jslint vars: true*/
/*jslint plusplus: true*/

var TileSet = (function () {
    "use strict";
    
    var name = "";
    
    var tileList = [];
    
    var availableTileSets = [
        { name: "alphabets", tileList: ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L"]},
        { name: "numbers", tileList: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"]}
    ];

    return {
        init : function () {
            console.log("TILESET INIT");
            name = availableTileSets[0].name;
            tileList = availableTileSets[0].tileList;
            console.log(name);
            console.log(tileList);
        },
        
        getName : function () {
            console.log("TILESET GETNAME");
            console.log(name);
            console.log(tileList);
            return name;
        },
        
        getTileList : function () {
            console.log("TILESET GETTILELIST");
            console.log(name);
            console.log(tileList);
            return tileList.slice(0);
        },
        
        changeTileSet : function (tileSet) {
            console.log("TILESET CHANGE");
            console.log(name);
            console.log(tileList);
            var i, valid = false;
            console.log('Setting tileSet to "' + tileSet + '"');
            for (i = 0; i < availableTileSets.length; i++) {
                if (tileSet === availableTileSets[i].name) {
                    valid = true;
                }
            }
            if (!valid) {
                console.error("Invalid tileSet!");
                return;
            }
            name = tileSet;
            // set the tileList
            for (i = 0; i < availableTileSets.length; i++) {
                if (availableTileSets[i].name === name) {
                    tileList = availableTileSets[i].tileList;
                    console.log(tileList);
                }
            }
        },
        
        getAvailableTileSetNames : function () {
            console.log("TILESET GETAVAILNAMES");
            console.log(name);
            console.log(tileList);
            var i, tileSets = [];
            for (i = 0; i < availableTileSets.length; i++) {
                tileSets[i] = availableTileSets[i].name;
            }
            return tileSets;
        },
        
        getAvailableTileSets : function () {
            console.log("TILESET AVAILSETS");
            console.log(name);
            console.log(tileList);
            return availableTileSets;
        }
    };
}());
