function shuffleArray (array) {
    var m, t, i;
    if (typeof array === "undefined") {
        console.error("No input parameter specified.");
        return;
    }
    
    m = array.length;
    // While there remain elements to shuffle…
    while (m) {
        // Pick a remaining element…
        i = Math.floor(Math.random() * m--);

        // And swap it with the current element.
        t = array[m];
        array[m] = array[i];
        array[i] = t;
    }

    return array;
};

function shuffleArrays (arrayA, arrayB) {
        var n, m, t, i;
        
        if (typeof arrayA === "undefined") {
            console.error("Input parameter #1 unspecified.");
            return;
        }
        if (typeof arrayB === "undefined") {
            console.error("Input parameter #2 unspecified.");
            return;
        }
        if (arrayA.length !== arrayB.length) {
            console.error("Array lengths do not match!");
            return;
        }
        
        m = arrayA.length;
        
        while (m) {
            i = Math.floor(Math.random() * m--);
            
            t = arrayA[m];
            arrayA[m] = arrayA[i];
            arrayA[i] = t;
            
            t = arrayB[m];
            arrayB[m] = arrayB[i];
            arrayB[i] = t;
        }
        return {
            arrayA : arrayA,
            arrayB : arrayB
        }
};

function pad (val) {
    return val > 9 ? val : "0" + val;
};
