(function () {
	/*
		TODO LIST:
		
		0A- localStorage helyett vmi HTTP GET-es web-service (toplista) load: sql query last 10 with a designed html-> response-> jquery append div with id -> button "ok" -> jquery remove div
		0B- toplista designolása alert helyett
		1 - többféle kártyatípus és theme választás (localStorage themeType=0,1,2)
		2 - később reszponzívabbá tenni, jelenleg csak 1 felbontásra van optimalizálva és FIXED (későbbi verziók, tablet etc)
		
		FONTOS: default_locale átrakva magyarra, csak magyar egyelőre 
		http://rishida.net/tools/conversion/ + JS escapes ékezet
	*/


	/*
	////////////////////////////////////////////////////////
	** VÁLTOZÓK, KONSTANSOK osztálya
	////////////////////////////////////////////////////////
	*/
	var Globals = {
		TEST_VERSION	: false,
		GAME_TIME		: 180,
		SND_APPLAUSE 	: "/sounds/applause.ogg",
		SND_CARD 		: "/sounds/card.ogg",
		SND_GONG 		: "/sounds/gong.ogg",
		SND_GOOD 		: "/sounds/good.ogg",
		IMG_CARDS_DIR	: "/images/cards/",
		CARD_BACK		: "/images/cards/card_back.png",
		cards_imgs 		: new Array(37)
	};

	//csak portrait-be
	screen.mozLockOrientation("portrait");
	
	/*
	////////////////////////////////////////////////////////
	** Toplista class
	////////////////////////////////////////////////////////
	*/
	var Toplist = {
		SHOW_SCORES_ONLY: -1,

		// TODO LATER WEB-SERVICE
		//http://users.memorygamefc.wbh.hu/loadtoplist.php
		SAVE_URL: "http://users.memorygamefc.wbh.hu/savetoplist.php?user=[USER]&score=[SCORE]",
		LOAD_URL: "http://users.memorygamefc.wbh.hu/loadtoplist.php",
		
		saveToServer: function(user, score) {
            var xhr = new XMLHttpRequest({mozSystem: true});
            xhr.open("GET", Toplist.SAVE_URL.replace("[USER]", user).replace("[SCORE]", score), true);
            xhr.onreadystatechange = function () {
                if (xhr.status === 200 && xhr.readyState === 4) {
                    var response = xhr.response;
					alert("OK, mentve a toplistába!");
                }
            }

            xhr.onerror = function () {
                alert("saveToServer xhr.onerror");
            };
            xhr.send();
		},	
		
		loadFromServer: function() {
            var xhr = new XMLHttpRequest({mozSystem: true});
            xhr.open("GET", Toplist.LOAD_URL, true);
            xhr.onreadystatechange = function () {
                if (xhr.status === 200 && xhr.readyState === 4) {
                    var response = xhr.response;
					alert(response);
				}
            }
            xhr.onerror = function () {
                alert("loadFromServer xhr.onerror");
            };
            xhr.send();
		},

		save: function(user, score) {
			//localStorage.setItem("toplist", s);
			var user="";
			do {
				user = prompt('Írd be a neved! (min 4, max 12 karakter)', 'user').trim();
			} while (user.length<4)
			
			user=encodeURIComponent(user);
			Toplist.saveToServer(user, score);
		},
		load: function() {
			//return localStorage.getItem("toplist");
			return Toplist.loadFromServer();
		},
		show: function(value) {	
		
			if (value!==Toplist.SHOW_SCORES_ONLY) {
				//elmenti a te eredményeid is
				Toplist.save("user", value);
			}
			Toplist.load();
		},
    }; 
	

	/*
	////////////////////////////////////////////////////////
	** Pontok class
	////////////////////////////////////////////////////////
	*/
	var GamePoints = {
		points: 0,
		
		createPointsDiv: function() {
			$("div[id=divPoints]").remove();
			var divPoints = $('<div class="points" id="divPoints">0 pont</div>');
			$("#body").append(divPoints);
			$("#divPoints").css({
						position: "absolute",
						top: "65px",
						left: "240px"
					}).fadeIn('slow');	
		},
		updatePointsDiv: function() {
			GamePoints.points+=1; 
			$("#divPoints").hide().html(GamePoints.points+" pont").fadeIn('slow');			
		}
	};
	
	/*
	////////////////////////////////////////////////////////
	** GAME class
	////////////////////////////////////////////////////////
	*/
	var Game = {
		covered 		: 0,
		cardcovered1	: "",
		cardcovered2	: "",
		cardcoveredID1	: 0,
		cardcoveredID2	: 0,
		blockedgame		: false,
		countTimer		: null,
		counter			: 0,
		imgw 			: 51,
	
		reset: function() {
			Game.blockedgame 	= false;
			Game.cardcoveredID1	= "";
			Game.cardcoveredID2	= "";
			Game.cardcovered	= "";
			Game.covered 		= 0;
		},
	
		//kártyák inicializálása
		initCards: function() {
			GamePoints.points = 0;
			Game.blockedgame  = false;
			var k = 0;
			for (j=1; j<=2; j++) {
				for (i=1; i<=18; i++) {
					k++; Globals.cards_imgs[k]=Globals.IMG_CARDS_DIR+"soccer_"+i+".png";
				}
			}
			//teszt verzióban nincs keverés
			if (!Globals.TEST_VERSION) Globals.cards_imgs = Game.shuffleCards(Globals.cards_imgs);
		},

		//kártyák keverése
		shuffleCards: function(array) {
		   for (var i=1; i<array.length-1; i++) {
			  var j = Math.floor(Math.random()*(array.length-i))+i;
		 
			  var tmp = array[i];
			  array[i] = array[j];
			  array[j] = tmp;
		   }
		   return array;
		},
	
		//counter, sima időzítő
		updateTimer: function() {
			  var divTimer = $("#divTimer");
			  Game.countTimer-=1;
			  if (Game.countTimer < 0) {
				 clearInterval(Game.counter);
				 alert("Lejárt az időd! A játéknak vége.");
				 Toplist.show(Toplist.SHOW_SCORES_ONLY);
				 Game.blockedgame=true;
				 
				 return;
			  } else {
				 divTimer.html("idő: "+((Game.countTimer < 10) ? '0' : '') + Game.countTimer+"");
			  }
		},
	
		createCounterDiv: function() {
			Game.countTimer = Globals.GAME_TIME;
			
			$("div[id=updateTimerDiv]").remove();
			var divPoints = $('<div class="timer" id="divTimer"></div>');
			$("#body").append(divPoints);
			$("#divTimer").html("idő: "+Game.countTimer).css({
						position: "absolute",
						top: "65px",
						left: "164px"
					}).fadeIn('slow');	

			Game.resetCounter();				
		},
		
		resetCounter: function() {
			Game.counter	= window.setInterval(function(){Game.updateTimer()}, 1000)
		},
	
		newGame: function() {
			clearInterval(Game.counter);

			Sound.playSound(Globals.SND_GONG);	
			GamePoints.createPointsDiv();
			Game.initCards();
			Game.createCounterDiv();


			//töröljük az összes cardot ha van
			for (i=1; i<=36; i++) {
				$("img[id=cardimg"+i+"]").remove();
				var img = $('<img style="display:none" alt="'+Globals.cards_imgs[i]+'" id="cardimg'+i+'" src="'+Globals.CARD_BACK+'" />');
				var top = 110+(parseInt((i-1)/6)*Game.imgw);
				var left= 3+(parseInt((i-1)%6)*Game.imgw);
				
				$("#body").append(img);
				$("#cardimg"+i).css({
					position: "absolute",
					top: top + "px",
					left: left + "px"
				}).delay(i*60).fadeIn('slow');

				$("#cardimg"+i).click(function() {
					if (Game.blockedgame || Game.cardcoveredID1==this.id) return;
					
					Game.covered++; if (Game.covered<3) Sound.playSound(Globals.SND_CARD);	
					
					if (Game.covered==1) {
						//1. lap felfordítása
						Game.cardcovered1   = this.alt;
						Game.cardcoveredID1 = this.id;
						$(this).attr('src', Game.cardcovered1).hide().fadeIn('slow');
					}
					else if (Game.covered==2) {
						//2. lap felfordítása
						Game.cardcovered2   = this.alt;
						Game.cardcoveredID2 = this.id;
						$(this).attr('src', Game.cardcovered2).hide().fadeIn('slow');
						
						if (Game.cardcoveredID1!=Game.cardcoveredID2) {
							if (Game.cardcovered1==this.alt) {
								//megegyeznek a kártyák

								window.setTimeout(function(){
									$("#"+Game.cardcoveredID1).attr("src", Globals.CARD_BACK).fadeOut('slow').hide();
									$("#"+Game.cardcoveredID2).attr("src", Globals.CARD_BACK).fadeOut('slow').hide();
									
									//növeljük a pontot
									Sound.playSound(Globals.SND_GOOD);	
									GamePoints.updatePointsDiv();
									
									//utolsó pont, vége a játéknak
									if (GamePoints.points==18) {
										
										clearInterval(Game.counter);
										Sound.playSound(Globals.SND_GONG);
										
										if (Game.countTimer>5 && Game.countTimer<=15) 
											alert("Hát ez épphogy összejött!");
										else if (Game.countTimer>15 && Game.countTimer<=25) 
											alert("Egész jó!");
										else if (Game.countTimer>25 && Game.countTimer<=40) 
											alert("Nagyon jó!");
										else if (Game.countTimer>40 && Game.countTimer<=55) 
											alert("Wow, jó a memóriád!");
										else if (Game.countTimer>55) 
											alert("Fotografikus memória?? Ugyan már..");
										
										Toplist.show(Globals.GAME_TIME-Game.countTimer);
									}
									
									Game.reset();
								}, 1000);	
							}
							else {
								//nem egyeznek meg a kártyák
								window.setTimeout(function(){
									$("#"+Game.cardcoveredID1).attr("src", Globals.CARD_BACK).hide().fadeIn('slow');
									$("#"+Game.cardcoveredID2).attr("src", Globals.CARD_BACK).hide().fadeIn('slow');
								
									Game.reset();
								}, 2000);
							}
						} else {
							Game.blockedgame = true;
						}
					}				
				});
			}
		}
	};

	/*
	////////////////////////////////////////////////////////
	** Hang class
	////////////////////////////////////////////////////////
	*/
	var Sound = {
		playSound : function(f) {
			var snd = new Audio(f); 
			snd.play();
		} 
	};
	
	//új játék gomb
	var newgameButton = document.querySelector("#newgameButton");
	if (newgameButton) {
		newgameButton.onclick = function () {
			Game.newGame();
		};
	}
	
	//toplista gomb
	var toplistButton = document.querySelector("#toplistButton");
	if (toplistButton) {
		toplistButton.onclick = function () {
			Toplist.show(Toplist.SHOW_SCORES_ONLY);
		};
	}
	$("#toplistButton").css({ 	position: "absolute",
								top: "5px",
								width: "50px",
								left: "260px"
							}).fadeIn('slow');
	
	

})();