/**
 * Lista de compras simples para Firefox OS
 */
 
 /**
* IndexedDb
*/

var dbName = "mercado";
var dbVersion = 1;
var db;
var index;
var idItemDel;
var setorDel;
var chamador;
var aDeletar;

var request = indexedDB.open(dbName, dbVersion);

request.onerror = function(event){
	console.error=("Banco de dados não pode ser aberto! ", event);
};

request.onsuccess = function(event){
	console.log("Base de dados ok!");
	db = event.target.result;
	preencheTelaPrincipal();
};

request.onupgradeneeded = function(event) {
		// o banco de dados ainda não existe, cria object stores e indexes
		console.log("Verificando base de dados!");
		db = event.target.result;
		
		if(!db.objectStoreNames.contains("mercado")){
			console.log("Criando base de dados!");
			
			var objectStore = db.createObjectStore("mercado", {
				keyPath: "id",
				autoIncrement: true
			});
			
			objectStore.createIndex("item", "item", {
				unique: true
			});
			
			index = objectStore.createIndex("setor", "setor", {
				unique: false
			});
			
			console.log("Adicionando alguns setores e intens!");
				
			// setores
			var setores = new Array("conservas","bebidas","cereais","laticinios","limpeza","higiene","carnes","matinais","biscoitos","massas","utilidades","frios","vestuario","legumes","verduras","frutas","tempero");
			
			// itens/setor
			var conservas = new Array("Azeitona","Catchup","Ervilha","Extrato tomate","Maioneze","Milho verde","Óleo de soja","Sal");
			var bebidas = new Array("Água mineral","Cerveja","Energético","Refrigerante","Suco","Whisky","Vinho","Run");
			var cereais = new Array("Arroz","Feijão","Açúcar","Far. trigo","Farofa","Fubá","Far. mandioca","Far. rosca");
			var laticinios = new Array("Iogurte","Coalhada","Manteiga","Margarina","Petit suisse","Requeijão","Queijo ralado");
			var limpeza = new Array("Água sanitária","Alvejante","Amaciante","Detergente","Desinfetante","Sabão pastoso","Sabão em pó","Pedra sanitária");
			var higiene = new Array("Absorvente","Condicionador","Creme pentear","Creme dental","Desodorante","Papel hig.","Shampoo","Sabonete");
			var carnes = new Array("Alcatra","Contra filé","Filé mignon","Filé peixe","Hambúrguer","Linguiça","Moída","Peito frango");
			var matinais = new Array("Adoçante","Pó de café","Leite","Achocolatado","Sucrilhos","Pão de forma","Pão francês","Bolo");
			var biscoitos = new Array("Cream cracker","Wafer","Recheado","Rosquinha","Salgadinho","Bol. mel","Maizena","c. social");
			var massas = new Array("Batata palha","Macar. lámen","Mac. parafuso","Mac. ninho","Espaguete","Mas. lasanha","Gravatinha","Talharim");
			var utilidades = new Array("Fósforos","Lâmpada","Esponja (pia)","Papel toalha","Vassoura","Rodo","Escova roupa","Escova dental");
			var frios = new Array("Massa pastel","Mortadela","Prezunto","Queijo m.","Queijo p.","Mussarela","Salame","Peito de peru");
			var vestuario = new Array("Calça jeans","short","Camiseta","Meias","Bermuda","C. polo","Tênis","Sandália");
			var legumes = new Array("Abóbora","Batata","Beterraba","Chuchu","Pepino","Pimentão","Tomate","Mandioca");
			var verduras = new Array("Agrião","Alface","Chicória","Couve flor","Couve mant.","Repolho","Espinafre","Rúcula");
			var frutas = new Array("Abacaxi","Banana","Laranja","Maçã","Mamão","Melancia","Melão","Uva");
			var tempero = new Array("Alecrim","Alho","Cebola","Cebolinha","Cheiro-verde","Salsa","Orégano","Pimenta");

			// popular DB com dados iniciais a partir dos arrays acima
			// setores
			var setor1 = new Item();
			for(var x = 0; x < 8; x++){ setor1.setor = "conservas"; setor1.item = conservas[x]; objectStore.add(setor1); }
			var setor2 = new Item();
			for(var x = 0; x < 8; x++){ setor2.setor = "bebidas"; setor2.item = bebidas[x]; objectStore.add(setor2); }
			var setor3 = new Item();
			for(var x = 0; x < 8; x++){ setor3.setor = "cereais"; setor3.item = cereais[x]; objectStore.add(setor3); }
			var setor4 = new Item();
			for(var x = 0; x < 8; x++){ setor4.setor = "laticinios"; setor4.item = laticinios[x]; objectStore.add(setor4); }
			var setor5 = new Item();
			for(var x = 0; x < 8; x++){ setor5.setor = "limpeza"; setor5.item = limpeza[x]; objectStore.add(setor5); }
			var setor6 = new Item();
			for(var x = 0; x < 8; x++){ setor6.setor = "higiene"; setor6.item = higiene[x]; objectStore.add(setor6); }
			var setor7 = new Item();
			for(var x = 0; x < 8; x++){ setor7.setor = "carnes"; setor7.item = carnes[x]; objectStore.add(setor7); }
			var setor8 = new Item();
			for(var x = 0; x < 8; x++){ setor8.setor = "matinais"; setor8.item = matinais[x]; objectStore.add(setor8); }
			var setor9 = new Item();
			for(var x = 0; x < 8; x++){ setor9.setor = "biscoitos"; setor9.item = biscoitos[x]; objectStore.add(setor9); }
			var setor10 = new Item();
			for(var x = 0; x < 8; x++){ setor10.setor = "massas"; setor10.item = massas[x]; objectStore.add(setor10); }
			var setor11 = new Item();
			for(var x = 0; x < 8; x++){ setor11.setor = "utilidades"; setor11.item = utilidades[x]; objectStore.add(setor11); }
			var setor12 = new Item();
			for(var x = 0; x < 8; x++){ setor12.setor = "frios"; setor12.item = frios[x]; objectStore.add(setor12); }
			var setor13 = new Item();
			for(var x = 0; x < 8; x++){ setor13.setor = "vestuario"; setor13.item = vestuario[x]; objectStore.add(setor13); }
			var setor14 = new Item();
			for(var x = 0; x < 8; x++){ setor14.setor = "legumes"; setor14.item = legumes[x]; objectStore.add(setor14); }
			var setor15 = new Item();
			for(var x = 0; x < 8; x++){ setor15.setor = "verduras"; setor15.item = verduras[x]; objectStore.add(setor15); }
			var setor16 = new Item();
			for(var x = 0; x < 8; x++){ setor16.setor = "frutas"; setor16.item = frutas[x]; objectStore.add(setor16); }
			var setor17 = new Item();
			for(var x = 0; x < 8; x++){ setor17.setor = "tempero"; setor17.item = tempero[x]; objectStore.add(setor17); }
	};
}

/**
* inicializando
*/	
var totalGeral = 0;
var total = 0;

function Item(){
	this.setor = "";
	this.item = "";
}

/**
* preenche tela principal com os botões para os setores
*/
function preencheTelaPrincipal(){
	
	document.getElementById("principalBotoes").innerHTML = ""; 	// limpar tela de botões
	document.getElementById("escolheSetorMenu").innerHTML = "";	// limpar escolheSetores
	
	var listaSetor = [];
	var setorAtual = "";
	var objectStore = db.transaction("mercado").objectStore("mercado");
	var index = objectStore.index("setor");
	
	console.log("Listando setores...");
	
	index.openCursor().onsuccess = function(event) {
		var cursor = event.target.result;
		
		if(cursor){
			var txt = cursor.value.setor;
			if(setorAtual != txt){
				document.getElementById("principalBotoes").innerHTML += '&nbsp;<button id="btn' + txt + '" class="btn" onclick="mostraSetor(\''+txt+'\')">' + txt + '</button>';
				document.getElementById("escolheSetorMenu").innerHTML += '<li id="' + txt + '"><a onclick="setValor(\'setorItem\',\''+txt+'\',\'\')" href="#"><p>' + txt + '</p></a></li>';
				document.getElementById("setores").innerHTML += '<section role="region" id="'+txt+'" class="hidden"><input id="show'+txt+'" type="hidden" value="0"/></section>';		
				setorAtual = txt;
			}
			cursor.continue();
		}
	};
	
}

function setValor(item, valor, id){
	
	var setorToClose;
	
	if(chamador == "cadastra"){
		document.getElementById(item).value=valor;
		setorToClose = "escolheSetor";
	}
	
	if(chamador == "excluir"){
		if(item == "item"){
			idItemDel = id;
			document.getElementById(setorDel).innerHTML='<section role="region" id="'+setorDel+'" class="hidden"><input id="show'+setorDel+'" type="hidden" value="0"/></section>';
			setorToClose = "escolheItem";
		} else {
			setorDel = valor;
			idItemDel = "";
			setorToClose = "escolheSetor";
		}
	}
	
	exibeSetorSimples(chamador, setorToClose);
}

/**
* esconde tela aberta para exibir a principal
*/
function goPrincipal(toHide){
	document.getElementById('statusbar').style.display="block";
	document.getElementById(toHide).style.display="none";
	document.getElementById('principal').style.display="block";
} 

/**
* calcula o valor multiplicando o preço unitário pela quantidade comprada.
* Faz chamada para a função que atualiza o valor total das compras passando o valor a ser somado.
*/
function calcula(tipo){
	
	//verifica se já existia valor em total
	var teste = document.getElementById('total'+tipo).value;
	teste = teste * 1;
	
	if(teste > 0){
		// neste caso, já existe valor em total. Então vou subtrair o valor existente do total geral
		// e adicionar o novo valor.
		totalGeral = totalGeral - teste;
	}
	
	// Aqui calculo o total do item e adiciono ao total geral
	var qte = document.getElementById('qte'+tipo).value;
	var preco = document.getElementById('valor'+tipo).value;
	
	preco = preco * 1;
	
	//verifico se o valor já foi preenchido antes para poder formatar
	if(preco > 0){
		preco = intToFloat(preco, 2);
		document.getElementById('valor'+tipo).value=preco;
	}
	
	total = qte * preco;
	
	total2 = intToFloat(total, 2);
		
	document.getElementById('total'+tipo).value=total2;
	
	atualizaTotalGeral(total);
}

function intToFloat(num, decPlaces) {
	return num.toFixed(decPlaces);
}

function roundNumber (rnum) {

   return Math.round(rnum*Math.pow(10,2))/Math.pow(10,2);

}

/**
* Atualiza o total gasto com as compras
*/
function atualizaTotalGeral(valor){
	
	totalGeral = roundNumber(totalGeral + valor);
	
	document.getElementById('totalgeral1').innerHTML=totalGeral;
}

/**
* Mostra o sertor selecionado na principal
*/
function mostraSetor(setor){
	
	document.getElementById("escolheItemMenu").innerHTML="";
	
	if(document.getElementById('show'+setor).value == 0){
		
		var trecho = "<header><a href=\"#\" onclick=\"goPrincipal('" + setor + "')\"><span class=\"icon icon-back\">back</span></a>";
		
		trecho = trecho + "<h1>Mercado/" + setor + "</h1></header><input id=\"show" + setor + "\" type=\"hidden\" value=\"1\"/><br/>";
		
		var objectStore = db.transaction("mercado").objectStore("mercado");
		console.log("Listando itens...");
	
		var index = objectStore.index("setor");
		var request = index.openCursor(IDBKeyRange.only(setor));
		request.onsuccess = function(event){
		var cursor = event.target.result;
		if(cursor){
			var txtId = cursor.value.id;	
			// var txtSetor = cursor.value.setor;
			var txt = cursor.value.item;
			// if(txtSetor == setor){
				document.getElementById(setor).innerHTML += "<div id=\"item\">" + txt + "<input class=\"input\" type=\"number\" id=\"total" + txt + "\" disabled=\"disabled\" placeholder=\"total\"><input class=\"input\" type=\"number\" id=\"valor" + txt + "\" placeholder=\"preço\" onchange=\"calcula('" + txt +"')\" formnovalidate/> <input class=\"input\" type=\"number\" id=\"qte" + txt + "\" placeholder=\"qte\" onchange=\"calcula('" + txt +"')\"/></div>";
				document.getElementById("escolheItemMenu").innerHTML += '<li id="' + txt + '"><a onclick="setValor(\'item\',\''+txt+'\',\''+txtId+'\')" href="#"><p>' + txt + '</p></a></li>';
			// }
			cursor.continue();
		}
	};
		
		trecho = trecho + "<br/>";
		
		document.getElementById(setor).innerHTML=trecho;
		trecho = "";
	}
	document.getElementById('principal').style.display="none";
	document.getElementById(setor).style.display="block";
}

function exibeSetorSimples(setor,setorclose){

	// mostra setor desejado com a statusbar
	document.getElementById(setorclose).style.display="none";
	document.getElementById(setor).style.display="block";
}

function cadItem(item, setor){

	var itemAdd = document.getElementById(item).value;
	document.getElementById(item).value = "";
	var setorAdd = document.getElementById(setor).value;
	document.getElementById(setor).value="";
	
	if(itemAdd != "" && setorAdd != ""){
		var transaction = db.transaction(["mercado"], "readwrite");
	
		transaction.oncomplete = function(event) {
			alert("Item adicionado com sucesso!");
		};

		transaction.onerror = function(event) {
			console.log("erro ao adicionar item: ", event);
		};

		var objectStore = transaction.objectStore("mercado");
		var mercItem = new Item();
		mercItem.setor = setorAdd; mercItem.item = itemAdd;
		var request = objectStore.add(mercItem);
		request.onsuccess = function(event){
			
			exibeSetorSimples("principal", "cadastrar");
			preencheTelaPrincipal();									// listar botões novamente, incluindo o novo...
		};
	}else{
		alert("Os dois campos devem ser preenchidos!");
	}
	
}

function deleta(){
	
	// deleta item
	if(idItemDel != ""){
		
		idItemDel = parseInt(idItemDel);
	
		var transaction = db.transaction(["mercado"], "readwrite");
		
		transaction.oncomplete = function(event) {
			exibeSetorSimples("principal","excluir");
			preencheTelaPrincipal();
		};

		transaction.onerror = function(event) {
			console.log("Erro ao deletar");
		};
		
		var request = db.transaction(["mercado"], "readwrite").objectStore("mercado").delete(idItemDel);
		
		request.onsuccess = function(event) {
			console.log("Escluído com sucesso... "+ idItemDel + ' - ' + event);
		};
		request.onerror = function(event){
			console.log("erro ao deletar: " + event);
		};
	}
	else {
	// deleta setor inteiro
		var setorList = [];
		var setorAtual = "";
		
		var transaction = db.transaction(["mercado"], "readwrite");
		
		transaction.oncomplete = function(event) {
			console.log("Setor encontrado e excluído...");
			exibeSetorSimples("principal","excluir");
			preencheTelaPrincipal();
		};

		transaction.onerror = function(event) {
			console.log("Erro ao listar setor para deletar - concomplete");
		};
		
		// selecionar todos os setores iguais ao selecionado para pegar os ids e excluir
		var objectStore = db.transaction("mercado").objectStore("mercado");
		var index = objectStore.index("setor");
		var request = index.openCursor(IDBKeyRange.only(setorDel));
		request.onsuccess = function(event){
			var cursor = event.target.result;
			if(cursor){
				var req = db.transaction(["mercado"], "readwrite").objectStore("mercado").delete(cursor.value.id);
				cursor.continue();
			}
		};
		
		request.onerror = function(event){
			console.log("Erro ao selecionar setor para deletar: " + event);
		};
	}
}

function resetaValores(){
	var resp = confirm('Quer mesmo resetar todos os valores para 0?');
	if(resp){
		for(var x = 0; x < setores.length; x++){
			document.getElementById(setores[x]).innerHTML="<input id=\"show" + setores[x] + "\" type=\"hidden\" value=\"0\"/>";
		}
		totalGeral = 0;
		document.getElementById('totalgeral1').innerHTML=totalGeral;
	}
}
function exibe(tipo){
	document.getElementById(tipo).style.display="block";
}
function esconde(tipo){
	document.getElementById(tipo).style.display="none";
}
function mostramsg(tipo){
	document.getElementById(tipo).style.display="block";
}

 /**
 * Event listeners
 */
window.onload = function(){
	
	// document.getElementById('btncereais').addEventListener('click', function(){ mostraSetor('cereais');});

	
	document.getElementById('radItem').addEventListener('click', function(){ exibe('btnEscolheItemDel'); esconde("delAviso"); aDeletar = "item";});
	document.getElementById('radSetor').addEventListener('click', function(){ esconde('btnEscolheItemDel'); mostramsg("delAviso"); aDeletar = "setor";});
	document.getElementById('btnEscolheSetorDel').addEventListener('click', function(){ exibeSetorSimples('escolheSetor','excluir'); chamador = "excluir";});
	document.getElementById('btnEscolheItemDel').addEventListener('click', function(){ mostraSetor(setorDel); exibeSetorSimples('escolheItem','excluir'); chamador = "excluir";});
	document.getElementById('btnExcluir').addEventListener('click', function(){ deleta(); esconde(setorDel);});
	
	document.getElementById('exibeConfig').addEventListener('click', function(){ exibeSetorSimples('config','principal');});
	document.getElementById('exibeConfig2').addEventListener('click', function(){ exibeSetorSimples('config','cadastrar');});
	document.getElementById('exibeConfig3').addEventListener('click', function(){ exibeSetorSimples('config','excluir');});
	document.getElementById('ressetaValores').addEventListener('click', function(){ resetaValores();});
	document.getElementById('exibeSobre').addEventListener('click', function(){ exibeSetorSimples('sobre','config');});
	document.getElementById('exibeAjuda').addEventListener('click', function(){ exibeSetorSimples('ajuda','config');});
	document.getElementById('exibePrincipal1').addEventListener('click', function(){ exibeSetorSimples('principal','config');});
	document.getElementById('exibePrincipal2').addEventListener('click', function(){ exibeSetorSimples('principal','sobre');});
	document.getElementById('exibePrincipal3').addEventListener('click', function(){ exibeSetorSimples('principal','ajuda');});
	document.getElementById('exibePrincipal4').addEventListener('click', function(){ exibeSetorSimples('principal','cadastrar');});
	document.getElementById('exibePrincipal5').addEventListener('click', function(){ exibeSetorSimples('principal','excluir');});
	document.getElementById('cadastra').addEventListener('click', function(){ exibeSetorSimples('cadastrar','config');});
	document.getElementById('btnEscolheSetor').addEventListener('click', function(){ exibeSetorSimples('escolheSetor','cadastrar'); chamador = "cadastrar";});
	document.getElementById('exclui').addEventListener('click', function(){ exibeSetorSimples('excluir','config');});
	document.getElementById('btnCadItem').addEventListener('click', function(){ cadItem('itemCadastrar','setorItem');});
	document.getElementById("statusbar").hidden = false;
};