$(document).ready(function() {
		findMyCurrentLocation();
		
});



$( window ).resize(function() {
	adjustMapMeasures();
	
});


var map = null;


function addStationMarkers() {
	
	var lineas = new Array(Linea1,Linea2,Linea3,Linea4N,Linea4S,Linea5);

	for (var i = 0; i < lineas.length; i++) {
		for(j=0; j< lineas[i].estaciones.length; j++) {
			
			var currentSt = lineas[i].estaciones[j];
			
			var latlng2 = new google.maps.LatLng (currentSt.lt , currentSt.ll);
			
			//Create the Marker and Drop It
			new google.maps.Marker ({ 
				map : map, 
				animation : google.maps.Animation.DROP,
				position : latlng2,
				icon: './miniImages' + currentSt.image
			}); 
			
			
		}
	}
	
}


function findMyCurrentLocation(){
	var geoService = navigator.geolocation;
	if (geoService) {

		navigator.geolocation.getCurrentPosition(showCurrentLocation,errorHandler,{enableHighAccuracy:true, timeout:10000});
	} else {
		alert("Your Browser does not support GeoLocation.");
	}
	
}

function adjustMapMeasures() {
	var mapcanvas = document.getElementById('mapacanvas');
	mapcanvas.style.height = (window.innerHeight - document.getElementById('maptitle').clientHeight) + "px";

	mapcanvas.style.width = screen.width + "px";
}

function showCurrentLocation(position) {

	//console.log(position.coords.latitude + "," + position.coords.longitude);  
	//Create the latlng object based on the GPS Position retrieved
	var latlng = new google.maps.LatLng (position.coords.latitude, position.coords.longitude);

	//Set Google Map options

	var options = { 
		zoom : 15, 
		center : latlng, 
		mapTypeControl: true,
		mapTypeControlOptions: {
			style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
		},
		zoomControl: true,
		zoomControlOptions: {
			style: google.maps.ZoomControlStyle.SMALL
		}
	};

	var mapcanvas = document.getElementById('mapacanvas');
	adjustMapMeasures();
	map = new google.maps.Map (mapcanvas, options);
	//Create the Marker and Drop It

	new google.maps.Marker ({ 
		map : map, 
		animation : google.maps.Animation.DROP,
		position : latlng,
		//icon: '.' + imagen
	}); 
	addStationMarkers();
}


function errorHandler(error){
	var errormsg = document.getElementById('gpserror').innerHTML;
	var mapcanvas = document.getElementById('mapacanvas');
	mapcanvas.innerHTML = "<div class=\"geoerror\">"+errormsg+"</div>";
	document.webL10n.get("gps-error");
	//alert("Error mientras intentaba obtener posición. Código de error: " + error.code + ", Mensaje: " + error.message);
	//location.href='estacionMetro.html?nombre='+nombre+'&imagen='+imagen+'&lt='+lt+'&ll='+ll+'&descripcion='+descripcion+'&ln='+lineNumber
	
	
}

