$(document).ready(function() {

	var ln = getParameterByName('ln');
	var lineNeeded = null;
	
	document.getElementById('aback').href = "estacionesMetrobus.html?ln="+ln;
	
	switch(ln) {
			case '1':
				lineNeeded = Linea1;
				break;
			case '2':
				lineNeeded = Linea2;
				break;
			case '3':
				lineNeeded = Linea3;
				break;
			case '4N':
				lineNeeded = Linea4N;
				break;
			case '4S':
				lineNeeded = Linea4S;
				break;
			case '5':
				lineNeeded = Linea5;
				break;
			
		}
		
		function adjustMapMeasures() {
			var mapcanvas = document.getElementById('mapacanvas');
			mapcanvas.style.height = (window.innerHeight - document.getElementById('maptitle').clientHeight) + "px"
			mapcanvas.style.width = screen.width + "px";
		}
		$( window ).resize(function() {
			adjustMapMeasures();
		});
		
		var map = null;
		
		findMyCurrentLocation();
		
		function addStationMarkers() {
			
		}
		
		function findMyCurrentLocation(){
			showCurrentLocation();
		}
		
		
		function showCurrentLocation(results) {
		
			//Create the latlng object based on the GPS Position retrieved
			//var latlng = new google.maps.LatLng (ltend,llend);	
			
			//Set Google Map options
			var options = { 
				zoom : 12, 
				mapTypeControl: true,
				mapTypeControlOptions: {
				style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
				},
				zoomControl: true,
				zoomControlOptions: {
				style: google.maps.ZoomControlStyle.SMALL
				}
			};
			
			var mapcanvas = document.getElementById('mapacanvas');
			adjustMapMeasures();
			
			map = new google.maps.Map (mapcanvas, options);
			
			var bounds = new google.maps.LatLngBounds();
			
			var currentLine = "";
			var ruta = [];
			
			for (var i = 0; i < lineNeeded.estaciones.length; i++) {
				var cur = lineNeeded.estaciones[i];
				/*
				//var latlng = new google.maps.LatLng (cur.lt,cur.ll);	
				console.log("Dibujando: " + cur.nombre);
				*/
				//Create the Marker and Drop It
				var marker = new google.maps.Marker ({ 
					map : map, 
					position : new google.maps.LatLng (cur.lt,cur.ll),
					icon: './miniImages' + cur.image
				}); 
				
				bounds.extend(marker.position);
				
				ruta.push(new google.maps.LatLng(cur.lt, cur.ll));
				
				currentLine = cur.linea;
			}
			
			map.fitBounds(bounds);
			
			new google.maps.Polyline({
				path: ruta,
				map: map,
				strokeColor: '#8A3C0B',
				strokeWeight: 4,
				strokeOpacity: 0.6,
				clickable: false
			});
			
			
			
			
		}
		
		function errorHandler(error){
		/*
			alert("Error mientras intentaba obtener posición. Código de error: " + error.code + ", Mensaje: " + error.message);
			location.href='estacionMetro.html?nombre='+nombre+'&imagen='+imagen+'&lt='+lt+'&ll='+ll+'&descripcion='+descripcion+'&ln='+lineNumber
		*/
		}
	
});
