function AppController(){}AppController.prototype.onCreate=function(){this._fixNames();this._audioContext=new AudioContext();this._createMetronome();this._tempoSeekBar=document.querySelector("#tempoSeekBar");this._tempoSeekBar.addEventListener("change",this._onTempoChanged.bind(this));this._speedText=document.querySelector("#speedText");this._speedText.innerHTML="999";this._speedText.parentNode.style.width=(this._speedText.parentNode.offsetWidth+10)+"px";this._setTempo(this.metronome.tempo);this._tempoSeekBar.slider.setSliderValue(this.metronome.tempo);this._initPlusMinusButtons();this._beatsPerBarView=document.querySelector("#beatsPerBar");this._populateSelect(this._beatsPerBarView);this._beatsPerBarView.addEventListener("change",this._onBeatsChanged.bind(this));this._beatsPerBarView.selectedIndex=this.metronome.beatsPerBar-1;this._clicksPerBeatView=document.querySelector("#clicksPerBeat");this._populateSelect(this._clicksPerBeatView);this._clicksPerBeatView.addEventListener("change",this._onBeatsChanged.bind(this));this._clicksPerBeatView.selectedIndex=this.metronome.clicksPerBeat-1;this._accentFirstBeatView=document.querySelector("#accentFirstBeat");this._accentFirstBeatView.checked=this.metronome.accentFirstBeat;this._accentFirstBeatView.addEventListener("change",this._onAccentFirstBeatChanged.bind(this));this._btnStart=document.querySelector("#btnStart");this._btnStart.addEventListener("click",this._playClicked.bind(this));this._btnTapTempo=document.querySelector("#btnTapTempo");this._btnTapTempo.addEventListener("click",this._onTapTempoClicked.bind(this));this._tapTempoClicks=[];initHackyPixel()};AppController.prototype._createMetronome=function(){this.metronome=new Metronome(this._audioContext);this.metronome.tempo=Prefs.getInt(PREF_TEMPO,120);this.metronome.beatsPerBar=Prefs.getInt(PREF_BEATS_PER_BAR,4);this.metronome.clicksPerBeat=Prefs.getInt(PREF_CLICKS_PER_BEAT,1);this.metronome.accentFirstBeat=Prefs.getBoolean(PREF_ACCENT_FIRST_BEAT)};AppController.prototype._populateSelect=function(a){for(var b=1;b<=16;b++){var c=document.createElement("option");c.value=b;c.innerHTML=b;a.appendChild(c)}};AppController.prototype._onTapTempoClicked=function(){var a=50;var c=this._audioContext.currentTime;if(this._tapTempoClicks.length>0){var b=c-this._tapTempoClicks[this._tapTempoClicks.length-1];if(b>2){this._tapTempoClicks=[]}}this._tapTempoClicks.push(c);if(this._tapTempoClicks.length>1){if(this._tapTempoClicks.length>a){this._tapTempoClicks.shift()}var b=(c-this._tapTempoClicks[0])/this._tapTempoClicks.length;if(b>0){this._setTempo(Math.round(60/b))}}};AppController.prototype._initPlusMinusButtons=function(){var i=function(m){this._setTempo(this.metronome.tempo+m.target.tempoDelta);this._tempoSeekBar.slider.setSliderValue(this.metronome.tempo)}.bind(this);var d="ontouchstart" in window;var c=d?"touchstart":"mousedown";var l=d?"touchend":"mouseup";var e;var b;var h=35;var j=function(){this._setTempo(this.metronome.tempo+b);this._tempoSeekBar.slider.setSliderValue(this.metronome.tempo);e=window.setTimeout(j,h)}.bind(this);var f=600;var a=function(m){switch(m.type){case c:b=m.target.tempoDelta;e=window.setTimeout(j,f);break;case l:window.clearTimeout(e);break}}.bind(this);var g=document.querySelector("#btnDecreaseSpeed");g.tempoDelta=-1;g.addEventListener("click",i);g.addEventListener(c,a);g.addEventListener(l,a);var k=document.querySelector("#btnIncreaseSpeed");k.tempoDelta=1;k.addEventListener("click",i);k.addEventListener(c,a);k.addEventListener(l,a)};AppController.prototype._onBeatsChanged=function(){this.metronome.beatsPerBar=this._beatsPerBarView.options[this._beatsPerBarView.selectedIndex].value;this.metronome.clicksPerBeat=this._clicksPerBeatView.options[this._clicksPerBeatView.selectedIndex].value;localStorage.setItem(PREF_BEATS_PER_BAR,this.metronome.beatsPerBar);localStorage.setItem(PREF_CLICKS_PER_BEAT,this.metronome.clicksPerBeat)};AppController.prototype._onAccentFirstBeatChanged=function(){this.metronome.accentFirstBeat=this._accentFirstBeatView.checked;localStorage.setItem(PREF_ACCENT_FIRST_BEAT,this.metronome.accentFirstBeat)};AppController.prototype._onTempoChanged=function(){tempo=Math.round(parseFloat(this._tempoSeekBar.getAttribute("aria-valuenow")));this._setTempo(tempo)};AppController.prototype._setTempo=function(a){a=NumberUtils.putInsideInterval(a,Metronome.MIN_TEMPO,Metronome.MAX_TEMPO);localStorage.setItem(PREF_TEMPO,a);this.metronome.tempo=a;this._speedText.innerHTML=a};AppController.prototype._playClicked=function(){this.metronome.toggle();this._btnStart.innerHTML=this.metronome.isPlaying()?"Stop metronome":"Start metronome"};AppController.prototype._fixNames=function(){window.AudioContext=window.AudioContext||window.webkitAudioContext;if(!navigator.getUserMedia){navigator.getUserMedia=navigator.webkitGetUserMedia||navigator.mozGetUserMedia}if(!navigator.cancelAnimationFrame){navigator.cancelAnimationFrame=navigator.webkitCancelAnimationFrame||navigator.mozCancelAnimationFrame}if(!navigator.requestAnimationFrame){navigator.requestAnimationFrame=navigator.webkitRequestAnimationFrame||navigator.mozRequestAnimationFrame}};function initHackyPixel(){var b=document.querySelector("#hackyPixel");var a=function(){b.style.opacity=0};document.addEventListener("visibilitychange",function(){if(!document.hidden){b.style.opacity=0.05;window.setTimeout(a,100)}})}var appController=new AppController();window.onload=appController.onCreate.bind(appController);