$(document).ready(function() {

    var audio = new Audio();

    ﻿document.querySelector('#btn-show-about-from-index').addEventListener('click', function () {
        document.querySelector('#about-view').className = 'current';
        document.querySelector('[data-position="current"]').className = 'left';
    });

    ﻿document.querySelector('#btn-show-about-from-animal').addEventListener('click', function () {
        document.querySelector('#about-view').className = 'current';
        document.querySelector('#animal-view').className = 'left';
    });

    document.querySelector('#btn-back-from-about').addEventListener('click', function () {
        document.querySelector('#about-view').className = 'right';
        document.querySelector('[data-position="current"]').className = 'current';
    });

    document.querySelector('#btn-back-from-animal').addEventListener('click', function () {
        document.querySelector('#animal-view').className = 'right';
        document.querySelector('[data-position="current"]').className = 'current';
    });

    $('#animals li a').bind('click', function() {
        var animal = $(this).attr('href').substring(1).replace("?","").replace("/","");
        if (animal == "") {
            animal = "cow";
        }
        preloadAnimalImage(animal);
        preloadAnimalImage(animal + '-bubble');

        document.querySelector('#animal-view').className = 'current';
        document.querySelector('[data-position="current"]').className = 'left';

        init(animal, audio);
    });
});

function init(animal, audio) {
    var dataContainerMotion = document.getElementById('js-data-motion-values');
    var dataContainerMotionAbout = document.getElementById('js-data-motion-values-2');

    audio.src = "sounds/" + animal + ".ogg";
    audio.addEventListener("ended",function() {
        updateAnimalImage(animal);
    });

    document.querySelector('#js-animal-image').addEventListener('click', function () {
        playAnimal(animal, audio);
//        document.querySelector('#animal-view').className = 'right';
//        document.querySelector('[data-position="current"]').className = 'current';
    });

    updateAnimalImage(animal);

    if (window.DeviceMotionEvent) {
        window.addEventListener('devicemotion', function(event) {
            var x;
            var y;
            var z;
            if(event.accelerationIncludingGravity) {
                x = event.accelerationIncludingGravity.x;
                y = event.accelerationIncludingGravity.y;
                z = event.accelerationIncludingGravity.z;
            }
            else if(event.acceleration) {
                x = event.acceleration.x;
                y = event.acceleration.y;
                z = event.acceleration.z;
            }
            var r = event.rotationRate;
            var html = '<p>x: ' + x + '</p>';
            html += '<p>y: ' + y + '</p>';
            html += '<p>z: ' + z + '</p>';
            dataContainerMotion.innerHTML = html;
            dataContainerMotionAbout.innerHTML = html;

            if ( y < 0) {
                playAnimal(animal, audio);
            }
        });

    }
}

function updateAnimalImage(animalName) {
    document.getElementById('js-animal-image').innerHTML = '<img src="images/' + animalName + '.svg" />';
}

function preloadAnimalImage(animalName) {
    var img = new Image();
    img.src = 'images/' + animalName + '.svg';
}

function playAnimal(animalName, audio) {
    updateAnimalImage(animalName + '-bubble');
    if (audio.paused == true) { // Avoids playing the sound several times
        audio.play();
        window.navigator.vibrate([1500]);
    }
}
