/* CORE */

function imc(massa , altura) {
  if( isNaN(massa) || isNaN(altura) ) {
    return false;
  } else {
    return massa / (altura * altura);
  }
}

function salvar(massa , altura , imc) {
  if( (isNaN(massa) || isNaN(altura) || isNaN(imc)) || (massa == "" || altura == "" || imc == "") ) {
    alert("Faça o cálculo do IMC antes de tentar anotar.");
  } else {
    if( confirm("Deseja anotar esses números?\n\nmassa = " + massa + "\naltura = " + altura + "\nIMC = " + imc + "\n") ) {
      /* Salvando massa */
      if( localStorage.getItem("meuimc_massa") == null || localStorage.getItem("meuimc_massa") == "null" ) {
        localStorage.setItem("meuimc_massa", massa)
      } else {
        localStorage.setItem("meuimc_massa", localStorage.getItem("meuimc_massa") + "|" + massa)
      }
      /* Salvando altura */
      if( localStorage.getItem("meuimc_altura") == null || localStorage.getItem("meuimc_altura") == "null" ) {
        localStorage.setItem("meuimc_altura", altura)
      } else {
        localStorage.setItem("meuimc_altura", localStorage.getItem("meuimc_altura") + "|" + altura)
      }
      /* Salvando IMC */
      if( localStorage.getItem("meuimc_imc") == null || localStorage.getItem("meuimc_imc") == "null" ) {
        localStorage.setItem("meuimc_imc", imc)
      } else {
        localStorage.setItem("meuimc_imc", localStorage.getItem("meuimc_imc") + "|" + imc)
      }
      /* Salvando data e hora */
      if( localStorage.getItem("meuimc_data") == null || localStorage.getItem("meuimc_data") == "null" ) {
        localStorage.setItem("meuimc_data", data_hora())
      } else {
        localStorage.setItem("meuimc_data", localStorage.getItem("meuimc_data") + "|" + data_hora())
      }
    }
  }
}

function relatorio() {
  if( (localStorage.getItem("meuimc_massa") == null || localStorage.getItem("meuimc_altura") == null || localStorage.getItem("meuimc_imc") == null) || (localStorage.getItem("meuimc_massa") == "null" || localStorage.getItem("meuimc_altura") == "null" || localStorage.getItem("meuimc_imc") == "null") ) {
    alert("Você ainda não anotou nenhum número. Toque sobre o ícone do lápis para anotar cada IMC calculado.");
  } else {
    mostrar_relatorio();
  }
}

function apagar() {
  if( (localStorage.getItem("meuimc_massa") == null || localStorage.getItem("meuimc_altura") == null || localStorage.getItem("meuimc_imc") == null) || (localStorage.getItem("meuimc_massa") == "null" || localStorage.getItem("meuimc_altura") == "null" || localStorage.getItem("meuimc_imc") == "null") ) {
    alert("Você ainda não anotou nenhum número. Toque sobre o ícone do lápis para anotar cada IMC calculado.");
  } else {
    if( confirm("Deseja apagar os números anotados e recomeçar?") ) {
      localStorage.setItem("meuimc_massa", null);
      localStorage.setItem("meuimc_altura", null);
      localStorage.setItem("meuimc_imc", null);
      localStorage.setItem("meuimc_data", null);
      $("#massa").val("");
      $("#altura").val("");
      $("#indice").html("");
      mostrar_controles();
    }
  }
}



/* Utilidades */

function data_hora() {
  var agora = new Date().toLocaleString();
  var res = agora.substring(0 , 16);
  return res;
}

function number_format(number, decimals, dec_point, thousands_sep) {
  /*
    discuss at: http://phpjs.org/functions/number_format/
   original by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
   improved by: davook
   improved by: Brett Zamir (http://brett-zamir.me)
   improved by: Brett Zamir (http://brett-zamir.me)
   improved by: Theriault
   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
   bugfixed by: Michael White (http://getsprink.com)
   bugfixed by: Benjamin Lupton
   bugfixed by: Allan Jensen (http://www.winternet.no)
   bugfixed by: Howard Yeend
   bugfixed by: Diogo Resende
   bugfixed by: Rival
   bugfixed by: Brett Zamir (http://brett-zamir.me)
    revised by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
    revised by: Luke Smith (http://lucassmith.name)
      input by: Kheang Hok Chin (http://www.distantia.ca/)
      input by: Jay Klehr
      input by: Amir Habibi (http://www.residence-mixte.com/)
      input by: Amirouche
  */

  number = (number + '')
    .replace(/[^0-9+\-Ee.]/g, '');
  var n = !isFinite(+number) ? 0 : +number,
    prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
    sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
    dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
    s = '',
    toFixedFix = function(n, prec) {
      var k = Math.pow(10, prec);
      return '' + (Math.round(n * k) / k)
        .toFixed(prec);
    };
  // Fix for IE parseFloat(0.55).toFixed(0) = 0;
  s = (prec ? toFixedFix(n, prec) : '' + Math.round(n))
    .split('.');
  if (s[0].length > 3) {
    s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
  }
  if ((s[1] || '')
    .length < prec) {
    s[1] = s[1] || '';
    s[1] += new Array(prec - s[1].length + 1)
      .join('0');
  }
  return s.join(dec);
}
