﻿var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MfTool;
(function (MfTool) {
    var AnimeTitleCard = (function (_super) {
        __extends(AnimeTitleCard, _super);
        function AnimeTitleCard(game, name, x, y, frame) {
            _super.call(this, game, x, y, name, frame);
            this.count = 0;
            this.frame = frame;
            this.anchor.setTo(0.5, 0.5);
            this.physicsEnabled = true;
            this.game.physics.enable(this, Phaser.Physics.ARCADE);

            this.count = game.rnd.angle();
        }
        AnimeTitleCard.prototype.changeFace0 = function () {
            this.frame = this.nextframe;
        };
        AnimeTitleCard.prototype.update = function () {
            if (this.game.animeOn) {
                this.count += 0.08;
                this.scale.x = Math.sin(this.count);
            }
        };
        AnimeTitleCard.width = 136;
        AnimeTitleCard.height = 150;
        return AnimeTitleCard;
    })(Phaser.Sprite);
    MfTool.AnimeTitleCard = AnimeTitleCard;
})(MfTool || (MfTool = {}));
var $basePath;
document.addEventListener("DOMContentLoaded", function () {
    if ($basePath == undefined)
        $basePath = "";
    var game = new MfTool.GameApp(window.innerWidth, window.innerHeight, $basePath);
});
var MfTool;
(function (MfTool) {
    var NaviBaseFormPanel = (function () {
        function NaviBaseFormPanel() {
        }
        NaviBaseFormPanel.prototype.getNaviUtil = function () {
            return this.naviUtil;
        };

        NaviBaseFormPanel.prototype.getApp = function () {
            return this.naviUtil.game;
        };

        NaviBaseFormPanel.prototype.create = function (game, paneldef, navi, args) {
            var _this = this;
            this.naviUtil = new MfTool.NaviBaseFormUtil(game, this, paneldef, args);
            this.naviUtil.setupForPanel(this, navi, new Phaser.Point(0, 0), new Phaser.Point(1, 1));
            this.naviUtil.makeUiLayer();
            var store = this.naviUtil.setBackPanel(paneldef.Id, "titlepage", null, new Phaser.Point(0, 0), new Phaser.Point(0.8, 0.3));
            if (paneldef.Body != null) {
                var textstore = this.naviUtil.setText(paneldef.Id + "_bodytext", this.naviUtil.paneldef.Body, store, new Phaser.Point(-0.5, -0.5), new Phaser.Point(1, 1), new MfTool.TypeWriterSmooth());
            }

            this.naviUtil.addButtons(game, store, new Phaser.Point(-0.45, 0.2), new Phaser.Point(0.5, 0.23), function (b) {
                _this.pushButton(b);
            }, function (k) {
                _this.timedLink(k);
            }, function (m) {
                _this.tapAny(m);
            });
            this.naviUtil.rootPanel.showPlayAll();
            return this;
        };

        NaviBaseFormPanel.prototype.pushButton = function (btn) {
            var link;
            if (btn.name != null) {
                link = this.naviUtil.paneldef.LinkList[btn.name];
            } else {
                link = this.naviUtil.paneldef.LinkList[this.naviUtil.baseTapId];
            }
            this.naviUtil.navi.execLink(link);
        };

        NaviBaseFormPanel.prototype.timedLink = function (link) {
            this.naviUtil.navi.execLink(link);
        };

        NaviBaseFormPanel.prototype.tapAny = function (point) {
            var link = this.naviUtil.paneldef.LinkList[this.naviUtil.baseTapId];
            this.naviUtil.navi.execLink(link);
        };

        NaviBaseFormPanel.prototype.destroy = function () {
            this.naviUtil.rootPanel.destroy();
        };

        NaviBaseFormPanel.prototype.resize = function () {
            this.naviUtil.rootPanel.resizeScreen(this.naviUtil.game);
        };
        return NaviBaseFormPanel;
    })();
    MfTool.NaviBaseFormPanel = NaviBaseFormPanel;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var AskForm = (function (_super) {
        __extends(AskForm, _super);
        function AskForm() {
            _super.apply(this, arguments);
        }
        AskForm.prototype.create = function (game, paneldef, navi, args) {
            var _this = this;
            this.naviUtil = new MfTool.NaviBaseFormUtil(game, this, paneldef, args);
            this.naviUtil.setupForPanel(this, navi, new Phaser.Point(0, 0), new Phaser.Point(1, 1));
            var store = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id, "titlepage", null, new Phaser.Point(0, 0), new Phaser.Point(0.8, 0.3));
            if (paneldef.Body != null) {
                var textstore = this.naviUtil.setText(paneldef.Id + "_bodytext", this.naviUtil.paneldef.Body, store, new Phaser.Point(-0.5, -0.5), new Phaser.Point(1, 1));
            }

            if (this.getApp().smartPhoneMode) {
                MfTool.Button9P.textProp = { "center": "true", "font": "bold10" };
            } else {
                MfTool.Button9P.textProp = { "center": "true", "font": "bold16" };
            }
            this.naviUtil.addButtons(game, store, new Phaser.Point(-0.45, 0.2), new Phaser.Point(0.5, 0.23), function (b) {
                _this.pushButton(b);
            }, function (k) {
                _this.timedLink(k);
            });
            MfTool.Button9P.textProp = { "center": "true" };

            this.naviUtil.rootPanel.showPlayAll();
            return this;
        };
        return AskForm;
    })(MfTool.NaviBaseFormPanel);
    MfTool.AskForm = AskForm;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var Banmen = (function () {
        function Banmen() {
            this.poslist = {};
            this.itemlist = {};
        }
        Banmen.prototype.initSinsuiBanmen = function (game, xnum, ynum, needCardNum) {
            if (needCardNum > xnum * ynum) {
                ynum = Math.floor((needCardNum + xnum - 1) / xnum);
            }
            this.game = game;
            this.xnum = xnum;
            this.ynum = ynum;
            this.poslist = {};
            for (var y = 0; y < ynum; y++) {
                for (var x = 0; x < xnum; x++) {
                    var pos = new MfTool.BanPos(this, x, y);
                    this.poslist[pos.signame] = pos;
                }
            }
        };

        Banmen.prototype.setBanmenSize = function (pixwidth, pixheight) {
            this.pixSize = new Phaser.Point(pixwidth, pixheight);
        };

        Banmen.prototype.calcRealPos = function (pos) {
            return new Phaser.Point((pos.x - (this.xnum - 1) / 2) * this.pixSize.x / this.xnum, (pos.y - (this.ynum - 1) / 2) * this.pixSize.y / this.ynum).add(this.game.world.centerX, this.game.world.centerY);
        };
        return Banmen;
    })();
    MfTool.Banmen = Banmen;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var BanPos = (function () {
        function BanPos(banmen, x, y) {
            this.x = x;
            this.y = y;
            this.baseBanmen = banmen;
            this.signame = 'x' + x.toString() + '_y' + y.toString();
        }
        BanPos.prototype.calcRealPos = function () {
            return this.baseBanmen.calcRealPos(this);
        };
        return BanPos;
    })();
    MfTool.BanPos = BanPos;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var Boot = (function (_super) {
        __extends(Boot, _super);
        function Boot() {
            _super.apply(this, arguments);
        }
        Boot.prototype.preload = function () {
            this.load.removeAll();

            this.load.audio("titlebgm", [$basePath + "assets/titlebgm.mp3", $basePath + "assets/titlebgm.ogg"]);

            this.load.image("preloadBar", $basePath + "assets/loader.png");
        };
        Boot.prototype.create = function () {
            this.game.setTitleBgm();
            this.input.maxPointers = 1;
            this.stage.disableVisibilityChange = true;
            this.scale.scaleMode = Phaser.ScaleManager.RESIZE;
            this.scale.fullScreenScaleMode = Phaser.ScaleManager.RESIZE;

            if (this.game.device.desktop) {
                this.game.smartPhoneMode = false;
            } else {
                this.game.smartPhoneMode = true;
            }
            this.game.state.start("Preloader", true, false);
        };
        return Boot;
    })(Phaser.State);
    MfTool.Boot = Boot;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var PanelGroup = (function () {
        function PanelGroup(game, name, parentInfo, posPct, sizePct, anc, offsetPix, p9Ratio) {
            if (typeof anc === "undefined") { anc = null; }
            if (typeof p9Ratio === "undefined") { p9Ratio = null; }
            this.childPanel = {};
            this.paddingPct = new Phaser.Point(0.05, 0.05);
            this.lefttopRatio = new Phaser.Point(1 / 3, 1 / 3);
            this.rightbottomRatio = new Phaser.Point(1 / 3, 1 / 3);
            this.name = name;
            this.parentPanel = parentInfo;
            this.parentSize = new Phaser.Point(game.width, game.height);
            this.parentCenterPos = new Phaser.Point(0, 0);
            if (parentInfo != null) {
                this.parentSize = parentInfo.panelBound.getAbsSize(game);
                this.parentCenterPos = parentInfo.panelBound.getAbsPos(game);
            }
            if (p9Ratio != null) {
                this.lefttopRatio.set(p9Ratio.x, p9Ratio.y);
                this.rightbottomRatio.set(p9Ratio.x, p9Ratio.y);
            }
            this.panelBound = this.calcBound(game, posPct, sizePct, anc, offsetPix);
            this.drawBound = this.calcInnerBound(game, anc);
            var p = this.panelBound.getPosByParent(game);
            if (parentInfo != null) {
                this.group = new Phaser.Group(game, parentInfo.group);
                this.group.position.set(p.x, p.y);
                if (parentInfo.childPanel[name] != null) {
                    throw new Error("Duplicate Name");
                }
                parentInfo.childPanel[name] = this;
            } else {
                this.group = game.add.group();
                this.group.position.set(game.world.centerX + p.x, game.world.centerY + p.y);
            }
            this.panelBoundOrg = this.panelBound.clone();
            this.drawBoundOrg = this.drawBound.clone();
            this.group.onDestroy.add(this.end, this);
        }
        PanelGroup.prototype.setOrigin = function (game, posPct, sizePct, anc, offsetPix, spriteModeSize) {
            if (typeof anc === "undefined") { anc = null; }
            if (typeof offsetPix === "undefined") { offsetPix = null; }
            if (typeof spriteModeSize === "undefined") { spriteModeSize = null; }
            if (spriteModeSize != null) {
                sizePct = this.recalcPanelSizeRatio(sizePct, spriteModeSize);
            }
            this.panelBoundOrg = this.calcBound(game, posPct, sizePct, anc, offsetPix);
            this.drawBoundOrg = this.calcInnerBound(game, anc);
            var p = this.panelBoundOrg.getPosByParent(game);
            if (this.parentPanel != null) {
                this.group.position.set(p.x, p.y);
            } else {
                this.group.position.set(game.world.centerX + p.x, game.world.centerY + p.y);
            }
        };

        PanelGroup.prototype.recalcPanelSizeRatio = function (sizePct, baseSpriteSize) {
            var size;
            if (this.parentPanel == null) {
                size = new Phaser.Point(this.group.game.width, this.group.game.height);
            } else {
                size = this.parentPanel.panelBound.getAbsSize(this.group.game);
            }
            var nextsizepct = new Phaser.Point(sizePct.x * baseSpriteSize.x / size.x, sizePct.y * baseSpriteSize.y / size.y);
            return nextsizepct;
        };

        PanelGroup.prototype.setTarget = function (game, posPct, sizePct, anc, offsetPix, spriteModeSize) {
            if (typeof anc === "undefined") { anc = null; }
            if (typeof spriteModeSize === "undefined") { spriteModeSize = null; }
            if (spriteModeSize != null) {
                sizePct = this.recalcPanelSizeRatio(sizePct, spriteModeSize);
            }
            this.panelBound = this.calcBound(game, posPct, sizePct, anc, offsetPix);
            this.drawBound = this.calcInnerBound(game, anc);
        };

        PanelGroup.prototype.calcBound = function (game, posPct, sizePct, anc, offsetPix) {
            if (typeof anc === "undefined") { anc = null; }
            var frameBound = new MfTool.PanelBound();
            var offset = new Phaser.Point(0, 0);
            if (offsetPix != null) {
                offset = offsetPix;
            }
            if (anc != null) {
                frameBound.ancPos = new Phaser.Point(anc.x, anc.y);
            }

            frameBound.setByRatio(game, (posPct.x * this.parentSize.x + this.parentCenterPos.x + offset.x) / game.width, (posPct.y * this.parentSize.y + this.parentCenterPos.y + offset.y) / game.height, sizePct.x * this.parentSize.x / game.width, sizePct.y * this.parentSize.y / game.height);
            frameBound.setRatioByParent((posPct.x * this.parentSize.x + offset.x) / game.width, (posPct.y * this.parentSize.y + offset.y) / game.height);
            return frameBound;
        };

        PanelGroup.prototype.calcInnerBound = function (game, anc) {
            if (typeof anc === "undefined") { anc = null; }
            var frameBound = this.panelBound.makeShrinkBound(game, this.parentSize.x / game.width * this.paddingPct.x, this.parentSize.y / game.height * this.paddingPct.y);
            if (anc != null) {
                frameBound.ancPos = new Phaser.Point(anc.x, anc.y);
            }
            return frameBound;
        };

        PanelGroup.prototype.end = function () {
        };

        PanelGroup.prototype.resizeScreen = function (game) {
            var pos = this.panelBound.getPosByParent(game);
            if (this.parentPanel != null) {
                this.group.position.set(pos.x, pos.y);
            } else {
                this.group.position.set(game.world.centerX + pos.x, game.world.centerY + pos.y);
            }
            var childPanel = this.childPanel;
            for (var p in childPanel) {
                if (childPanel.hasOwnProperty(p)) {
                    var ch = childPanel[p];
                    ch.resizeScreen(game);
                }
            }
        };
        PanelGroup.prototype.resize9P = function (game, sprite9PList, size, spriteBaseSize, offset) {
            if (spriteBaseSize == null)
                return;

            var sp;
            var posy = offset.y;
            var posbasey = 0;
            var smallx = spriteBaseSize.x * (this.lefttopRatio.x + this.rightbottomRatio.x) > size.x;
            var smally = spriteBaseSize.y * (this.lefttopRatio.y + this.rightbottomRatio.y) > size.y;

            for (var j = 0; j < 3; j++) {
                var posx = offset.x;
                var posbasex = 0;
                for (var i = 0; i < 3; i++) {
                    var w;
                    var wb;
                    sp = sprite9PList[i + j * 3];
                    switch (i) {
                        case 0:
                            wb = spriteBaseSize.x * this.lefttopRatio.x;
                            if (smallx)
                                w = size.x * (this.lefttopRatio.x + (1 - this.lefttopRatio.x - this.rightbottomRatio.x) / 2);
                            else
                                w = wb;
                            break;
                        case 2:
                            wb = spriteBaseSize.x * this.rightbottomRatio.x;
                            if (smallx)
                                w = size.x * (this.rightbottomRatio.x + (1 - this.lefttopRatio.x - this.rightbottomRatio.x) / 2);
                            else
                                w = wb;
                            break;
                        default:
                            w = size.x - spriteBaseSize.x * (this.lefttopRatio.x + this.rightbottomRatio.x);
                            if (w <= 0)
                                w = 0;
                            wb = spriteBaseSize.x * (1 - this.lefttopRatio.x - this.rightbottomRatio.x);
                            break;
                    }
                    var h;
                    var hb;
                    switch (j) {
                        case 0:
                            hb = spriteBaseSize.y * this.lefttopRatio.y;
                            if (smally)
                                h = size.y * (this.lefttopRatio.y + (1 - this.lefttopRatio.y - this.rightbottomRatio.y) / 2);
                            else
                                h = hb;
                            break;
                        case 2:
                            hb = spriteBaseSize.y * this.rightbottomRatio.y;
                            if (smally)
                                h = size.y * (this.rightbottomRatio.y + (1 - this.lefttopRatio.y - this.rightbottomRatio.y) / 2);
                            else
                                h = hb;
                            break;
                        default:
                            h = size.y - spriteBaseSize.y * (this.lefttopRatio.y + this.rightbottomRatio.y);
                            if (h <= 0)
                                h = 0;
                            hb = spriteBaseSize.y * (1 - this.lefttopRatio.y - this.rightbottomRatio.y);
                            break;
                    }
                    sp.scale.set(w / wb, h / hb);
                    sp.position.set(posx, posy);
                    var r = new Phaser.Rectangle(posbasex, posbasey, wb, hb);
                    sp.crop(r, false);
                    posx += w;
                    posbasex += wb;
                    if (i === 2) {
                        posy += h;
                        posbasey += hb;
                    }
                }
            }
        };

        PanelGroup.prototype.showPlay = function () {
        };
        PanelGroup.prototype.showPlayAll = function () {
            this.showPlay();
            var childPanel = this.childPanel;
            for (var i in childPanel) {
                if (childPanel.hasOwnProperty(i)) {
                    var panel = childPanel[i];
                    panel.showPlayAll();
                }
            }
        };
        return PanelGroup;
    })();
    MfTool.PanelGroup = PanelGroup;

    var PanelSprite = (function (_super) {
        __extends(PanelSprite, _super);
        function PanelSprite(game, name, texname, parentInfo, posPct, sizePct, anc, offsetPix, p9Ratio) {
            if (typeof anc === "undefined") { anc = null; }
            if (typeof p9Ratio === "undefined") { p9Ratio = null; }
            _super.call(this, game, name, parentInfo, posPct, sizePct, anc, offsetPix, p9Ratio);
            this.panel = [];
            this.tweenList = [];
            this.singleSpriteMode = false;
            this.realSizeMode = false;
            var sp;
            if (p9Ratio === MfTool.PanelBound.Zero) {
                sp = new Phaser.Sprite(game, 0, 0, texname);
                sp.inputEnabled = true;
                this.panel.push(sp);
                this.group.add(sp);
                this.baseSpriteSize = new Phaser.Point(this.panel[0].width, this.panel[0].height);
                this.singleSpriteMode = true;
            } else if (texname != null) {
                for (var j = 0; j < 3; j++) {
                    for (var i = 0; i < 3; i++) {
                        sp = new Phaser.Sprite(game, 0, 0, texname);
                        sp.inputEnabled = true;
                        this.panel.push(sp);
                        this.group.add(sp);
                    }
                }
                this.baseSpriteSize = new Phaser.Point(this.panel[0].width, this.panel[0].height);
            }

            this.group.onDestroy.add(this.end, this);

            this.resizeScreen(game);
        }
        PanelSprite.prototype.end = function () {
            for (var i = 0; i < this.panel.length; i++) {
                var sp = this.panel[i];
                sp.destroy();
            }
            this.panel = [];
        };

        PanelSprite.prototype.resizeScreen = function (game) {
            _super.prototype.resizeScreen.call(this, game);
            this.motionSize = this.panelBound.getAbsSize(game);
            if (this.singleSpriteMode) {
                if (this.realSizeMode) {
                    this.panel[0].width = this.realSpriteSizePct.x * this.baseSpriteSize.x;
                    this.panel[0].height = this.realSpriteSizePct.y * this.baseSpriteSize.y;
                } else {
                    this.panel[0].width = this.motionSize.x;
                    this.panel[0].height = this.motionSize.y;
                }
            } else {
                this.resize9P(game, this.panel, this.panelBound.getAbsSize(game), this.baseSpriteSize, new Phaser.Point(-this.motionSize.x / 2, -this.motionSize.y / 2));
            }
        };

        PanelSprite.prototype.setRealSpriteSize = function (realSizePct) {
            this.realSizeMode = true;
            this.realSpriteSizePct = new Phaser.Point(realSizePct.x, realSizePct.y);
        };

        PanelSprite.prototype.setTarget = function (game, posPct, sizePct, anc, offsetPix, spriteModeSize) {
            if (typeof anc === "undefined") { anc = null; }
            if (typeof spriteModeSize === "undefined") { spriteModeSize = null; }
            _super.prototype.setTarget.call(this, game, posPct, sizePct, anc, offsetPix, spriteModeSize);
            this.resizeScreen(game);
        };
        PanelSprite.prototype.setMotion = function (game, during, fact) {
            if (typeof during === "undefined") { during = 1000; }
            if (typeof fact === "undefined") { fact = null; }
            if (fact == null) {
                fact = new MfTool.FadeInPanelFactory();
            }
            fact.assignTween(game, this, during);
            this.tweenList.push(fact);
        };
        PanelSprite.prototype.showPlay = function () {
            for (var i = 0; i < this.tweenList.length; i++) {
                var fact = this.tweenList[i];
                fact.runMotion(this);
            }
        };

        Object.defineProperty(PanelSprite.prototype, "tint", {
            get: function () {
                return this.panel[0].tint;
            },
            set: function (value) {
                for (var i = 0; i < this.panel.length; i++) {
                    this.panel[i].tint = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PanelSprite.prototype, "alpha", {
            get: function () {
                return this.panel[0].alpha;
            },
            set: function (value) {
                for (var i = 0; i < this.panel.length; i++) {
                    this.panel[i].alpha = value;
                }
            },
            enumerable: true,
            configurable: true
        });

        Object.defineProperty(PanelSprite.prototype, "width", {
            get: function () {
                return this.motionSize.x;
            },
            set: function (value) {
                if (this.motionSize.x !== value) {
                    this.motionSize.x = value;
                    if (this.singleSpriteMode) {
                        this.panel[0].width = this.motionSize.x;
                    } else {
                        this.resize9P(this.group.game, this.panel, this.motionSize, this.baseSpriteSize, new Phaser.Point(-this.motionSize.x / 2, -this.motionSize.y / 2));
                    }
                }
            },
            enumerable: true,
            configurable: true
        });

        Object.defineProperty(PanelSprite.prototype, "height", {
            get: function () {
                return this.motionSize.y;
            },
            set: function (value) {
                if (this.motionSize.y !== value) {
                    this.motionSize.y = value;
                    if (this.singleSpriteMode) {
                        this.panel[0].height = this.motionSize.y;
                    } else {
                        this.resize9P(this.group.game, this.panel, this.motionSize, this.baseSpriteSize, new Phaser.Point(-this.motionSize.x / 2, -this.motionSize.y / 2));
                    }
                }
            },
            enumerable: true,
            configurable: true
        });

        Object.defineProperty(PanelSprite.prototype, "enable", {
            get: function () {
                return this.group.visible;
            },
            set: function (value) {
                this.group.visible = value;
            },
            enumerable: true,
            configurable: true
        });

        PanelSprite.prototype.destroy = function () {
            this.group.destroy();
        };

        PanelSprite.prototype.setOriginBySpriteRatio = function (game, posPct, sizePct, anc, offset) {
            if (typeof anc === "undefined") { anc = null; }
            if (typeof offset === "undefined") { offset = null; }
            this.setOrigin(game, posPct, sizePct, anc, offset, this.baseSpriteSize);
        };
        PanelSprite.prototype.setTargetBySpriteRatio = function (game, posPct, sizePct, anc, offset) {
            if (typeof anc === "undefined") { anc = null; }
            if (typeof offset === "undefined") { offset = null; }
            this.setTarget(game, posPct, sizePct, anc, offset, this.baseSpriteSize);
            this.resizeScreen(game);
        };
        return PanelSprite;
    })(PanelGroup);
    MfTool.PanelSprite = PanelSprite;

    

    var PanelText = (function (_super) {
        __extends(PanelText, _super);
        function PanelText(game, drawText, name, parentInfo, posPct, sizePct, anc, fact, prop, offsetPix) {
            if (typeof anc === "undefined") { anc = null; }
            if (typeof fact === "undefined") { fact = null; }
            if (typeof prop === "undefined") { prop = null; }
            if (typeof offsetPix === "undefined") { offsetPix = null; }
            _super.call(this, game, name, parentInfo, posPct, sizePct, anc, offsetPix);
            this.allCharParts = [];
            this.rowBlock = [];
            this.textProp = {};
            this.paddingPct = new Phaser.Point(0.05, 0.05);
            this.mouseDownOnAny = false;
            this.pointerDownPos = new Phaser.Point();
            this.pointerDownScrollOffset = new Phaser.Point();
            this.mapCenterAtDown = new Phaser.Point();
            this.scrollOffset = new Phaser.Point();

            if (prop != null && prop["font"] != null) {
                this.fontInfo = MfTool.FontInfo.getInfo(prop["font"]);
            }
            if (this.fontInfo == null) {
                this.fontInfo = new MfTool.FontInfo();
            }
            this.maxTextSize = new Phaser.Point();
            if (prop != null) {
                this.textProp = prop;
            }
            this.group.mask = game.add.graphics(0, 0);

            this.motionfact = fact;

            this.setText(drawText);

            this.group.onDestroy.add(this.end, this);
            this.resizeScreen(game);
        }
        PanelText.prototype.setUserScroll = function (value) {
            this.enableUserScroll = value;
            if (this.enableUserScroll) {
                var p = this.panelBound.getPosByParent(this.group.game);
                if (this.parentPanel != null) {
                    this.transGroup = new Phaser.Group(this.group.game, this.parentPanel.group);
                    this.transGroup.position.set(p.x, p.y);
                } else {
                    this.transGroup = this.group.game.add.group();
                    this.transGroup.position.set(this.group.game.world.centerX + p.x, this.group.game.world.centerY + p.y);
                }
                this.transSprite = new Phaser.Sprite(this.group.game, 0, 0);

                this.transGroup.add(this.transSprite);

                this.transSprite.inputEnabled = true;
                this.transSprite.events.onInputDown.add(this.onDown, this);
                this.transSprite.events.onInputUp.add(this.onUp, this);
                this.transSprite.events.onInputOut.add(this.onUp, this);
                this.group.game.input.addMoveCallback(this.onHold, this);

                this.scrollUp = new Phaser.Text(this.group.game, 0, 0, "▲", {});
                this.scrollUp.setStyle({ fill: "#ffffff" });
                this.scrollUp.setShadow(4, 4);
                this.scrollUp.scale.set(0.5, 0.5);
                this.scrollUp.anchor.set(1, 0);
                this.scrollDown = new Phaser.Text(this.group.game, 0, 0, "▼", {});
                this.scrollDown.setStyle({ fill: "#ffffff" });
                this.scrollDown.setShadow(4, 4);
                this.scrollDown.scale.set(0.5, 0.5);
                this.scrollDown.anchor.set(1, 1);
                this.scrollUpTween = this.group.game.add.tween(this.scrollUp).to({ alpha: 0 }, 1500, Phaser.Easing.Linear.None, false, 0, -1);
                this.scrollDownTween = this.group.game.add.tween(this.scrollDown).to({ alpha: 0 }, 1500, Phaser.Easing.Linear.None, false, 0, -1);

                this.transGroup.add(this.scrollUp);
                this.transGroup.add(this.scrollDown);

                this.scrollOffset.set(0, 0);
            }
        };

        PanelText.prototype.onDown = function (tex, input) {
            this.pointerDownPos.set(input.x, input.y);
            this.mapCenterAtDown.set(this.group.x, this.group.y);
            this.pointerDownScrollOffset.set(this.scrollOffset.x, this.scrollOffset.y);
            this.mouseDownOnAny = true;
        };
        PanelText.prototype.onUp = function (tex, input) {
            if (this.mouseDownOnAny) {
                this.mouseDownOnAny = false;
                var pt = new Phaser.Point(input.x, input.y).subtract(this.pointerDownPos.x, this.pointerDownPos.y);
                var prevGroupPos = new Phaser.Point(this.group.position.x, this.group.position.y);
                this.group.position.set(this.group.position.x, pt.y + this.mapCenterAtDown.y);
                var prevScOff = new Phaser.Point(this.scrollOffset.x, this.scrollOffset.y);
                this.scrollOffset.set(this.pointerDownScrollOffset.x, this.pointerDownScrollOffset.y + pt.y);
                if (!this.isScrollable(pt.y)) {
                    this.group.position.set(prevGroupPos.x, prevGroupPos.y);
                    this.scrollOffset.set(prevScOff.x, prevScOff.y);
                    if (pt.y > 0)
                        this.offUpMarker();
                    else
                        this.offDownMarker();
                } else {
                    this.updateScrollMark();
                }
            }
        };
        PanelText.prototype.onHold = function (input) {
            if (this.mouseDownOnAny) {
                var pt = new Phaser.Point(input.x, input.y).subtract(this.pointerDownPos.x, this.pointerDownPos.y);
                var prevGroupPos = new Phaser.Point(this.group.position.x, this.group.position.y);
                this.group.position.set(this.group.position.x, pt.y + this.mapCenterAtDown.y);
                var prevScOff = new Phaser.Point(this.scrollOffset.x, this.scrollOffset.y);
                this.scrollOffset.set(this.pointerDownScrollOffset.x, this.pointerDownScrollOffset.y + pt.y);
                if (!this.isScrollable(pt.y)) {
                    this.group.position.set(prevGroupPos.x, prevGroupPos.y);
                    this.scrollOffset.set(prevScOff.x, prevScOff.y);
                    if (pt.y > 0)
                        this.offUpMarker();
                    else
                        this.offDownMarker();
                } else {
                    this.updateScrollMark();
                }
            }
        };

        PanelText.prototype.setText = function (drawText) {
            if (this.motionfact != null) {
                this.motionfact.stop();
                this.group.removeAll(true);
            }
            this.originalText = drawText;
            var text = PanelText.takeLangText(drawText);

            this.allCharParts = this.makeChars(text);

            this.calcTextLineNum(text, this.drawBound.sizePct);
            if (this.motionfact != null) {
                this.applyMotion();
            } else {
                for (var i = 0; i < this.allCharParts.length; i++) {
                    var ch = this.allCharParts[i];
                    ch.panel.position.set(ch.originPos.x, ch.originPos.y);
                }
            }
        };

        PanelText.prototype.setMotion = function (fact) {
            if (typeof fact === "undefined") { fact = null; }
            if (fact == null) {
                fact = new MfTool.TypeWriterSmooth();
            }
            this.motionfact = fact;
            this.applyMotion();
        };

        PanelText.prototype.showPlay = function () {
            if (this.motionfact == null) {
                this.motionfact = new MfTool.StaticText();
                this.applyMotion();
            }
            this.motionfact.runMotion(this);
        };

        PanelText.prototype.resizeScreen = function (game) {
            _super.prototype.resizeScreen.call(this, game);

            var lt = this.calcGroupPos();

            this.group.position.set(lt.x + this.scrollOffset.x, lt.y + this.scrollOffset.y);

            this.group.mask.clear();

            this.group.mask = game.add.graphics(0, 0);
            this.group.mask.beginFill(0xffffff);
            var sz = this.panelBound.getAbsSize(game);
            var lt2 = this.panelBound.getAbsPosFromLeftTop(game);
            if (this.parentPanel == null) {
                lt2 = new Phaser.Point(0, 0);
            } else {
                if (this.textProp["center"] === "true") {
                    lt2.x -= sz.x / 2;
                    lt2.y -= sz.y / 2;
                    lt.x -= sz.x / 2;
                    lt.y -= sz.y / 2;
                }
            }
            this.group.mask.drawRect(lt2.x, lt2.y, sz.x, sz.y);

            if (this.enableUserScroll) {
                var sa = this.drawBound.getAbsSize(game);
                this.transGroup.position.set(lt.x, lt.y);
                this.transSprite.width = sa.x;
                this.transSprite.height = sa.y;

                this.scrollUp.position.set(sa.x, 0);
                this.scrollDown.position.set(sa.x, sa.y);

                this.updateScrollMark();
            }
        };

        PanelText.prototype.calcGroupPos = function () {
            var lt0 = this.panelBound.getPosByParent(this.group.game);

            var lt = new Phaser.Point(lt0.x, lt0.y);
            var sx = this.panelBound.getAbsSize(this.group.game);
            if (this.textProp["center"] === "true") {
                lt.y += sx.y * this.paddingPct.y;
            } else {
                lt.x += sx.x * this.paddingPct.x;
                lt.y += sx.y * this.paddingPct.y;
            }
            return lt;
        };

        PanelText.prototype.updateScrollMark = function () {
            var sz = this.panelBound.getAbsSize(this.group.game);
            var checkposY = 0;
            if (this.textProp["center"] === "true") {
                checkposY = -sz.y / 2 + this.maxTextSize.y / 2;
            } else {
                checkposY = 0;
            }
            if (this.scrollOffset.y >= checkposY) {
                this.offUpMarker();
            } else {
                this.scrollUp.visible = true;
                this.scrollUpTween.start();
            }
            if (this.maxTextSize.y + this.scrollOffset.y < checkposY + sz.y) {
                this.offDownMarker();
            } else {
                this.scrollDown.visible = true;
                this.scrollDownTween.start();
            }
        };

        PanelText.prototype.offUpMarker = function () {
            this.scrollUp.visible = false;
            this.scrollUpTween.stop();
        };
        PanelText.prototype.offDownMarker = function () {
            this.scrollDown.visible = false;
            this.scrollDownTween.stop();
        };

        PanelText.prototype.isScrollable = function (deltay) {
            var sz = this.panelBound.getAbsSize(this.group.game);
            var checkposY = 0;
            if (this.textProp["center"] === "true") {
                checkposY = -sz.y / 2 + this.maxTextSize.y / 2;
            } else {
                checkposY = 0;
            }
            if (deltay > 0) {
                if (this.scrollOffset.y >= checkposY) {
                    return false;
                } else {
                    return true;
                }
            } else {
                if (this.maxTextSize.y + this.fontInfo.lineHeight + this.scrollOffset.y < checkposY + sz.y) {
                    return false;
                } else {
                    return true;
                }
            }
        };

        PanelText.takeLangText = function (drawText) {
            var langText = drawText.split("|");
            if (langText.length <= 1) {
                return drawText;
            } else {
                var toplabel = "";
                var lang = MfTool.NaviPanelDef.useLang;
                for (var p = 0; p < langText.length; p++) {
                    var txt = langText[p];
                    var t = txt.split(":");
                    if (t.length < 2) {
                        toplabel = txt;
                    } else {
                        if (t[0] === lang) {
                            return t[1];
                        }
                    }
                }
                return toplabel;
            }
        };

        PanelText.prototype.end = function () {
            this.group.game.tweens.remove(this.scrollDownTween);
            this.group.game.tweens.remove(this.scrollUpTween);
            this.rowBlock = [];
        };

        PanelText.prototype.makeChars = function (text) {
            var effectTextList = text.split("\n");
            var list = Array();
            for (var spos = 0; spos < effectTextList.length; spos++) {
                var sremain = effectTextList[spos];
                sremain = sremain.concat("\n");
                for (var cpos = 0; cpos < sremain.length; cpos++) {
                    var dchar = new MfTool.DanceChar(this.group, sremain[cpos], 0, 0, this.fontInfo);
                    if (this.textProp["color"] != null) {
                        dchar.rgb = parseInt(this.textProp["color"]);
                    }
                    list.push(dchar);
                }
            }
            return list;
        };

        PanelText.prototype.calcTextLineNum = function (text, boxsize) {
            this.rowBlock = [];
            var allpos = 0;
            var rowno = 0;
            var orgpos = new Phaser.Point(0, 0);
            var effectTextList = text.split("\n");
            for (var spos = 0; spos < effectTextList.length; spos++) {
                var sremain = effectTextList[spos];

                sremain = sremain.concat("\n");
                var linewidth = 0;
                var lineCharList = Array();
                for (var cpos = 0; cpos < sremain.length; cpos++) {
                    var dchar = this.allCharParts[allpos++];
                    dchar.textWidth = dchar.panel.context.measureText(dchar.showText).width;
                    linewidth += dchar.textWidth;
                    if (linewidth > boxsize.x * this.group.game.width) {
                        if (lineCharList.length <= 0) {
                            return;
                        }
                        this.rowBlock.push(new MfTool.DanceLine(lineCharList, rowno++));
                        orgpos.y += this.fontInfo.lineHeight;
                        lineCharList = Array();
                        linewidth = dchar.textWidth;
                    }
                    lineCharList.push(dchar);
                    this.maxTextSize.x = Math.max(this.maxTextSize.x, linewidth);
                }

                if (lineCharList.length > 0) {
                    this.rowBlock.push(new MfTool.DanceLine(lineCharList, rowno++));
                    orgpos.y += this.fontInfo.lineHeight;
                }
            }
            this.maxTextSize.y = this.rowBlock.length * this.fontInfo.lineHeight;

            orgpos = new Phaser.Point(0, 0);
            if (this.textProp["center"] === "true") {
                orgpos = new Phaser.Point(0, -this.maxTextSize.y / 2);
            }
            for (var lpos = 0; lpos < this.rowBlock.length; lpos++) {
                var block = this.rowBlock[lpos];
                block.setCharPos(this.group.game, lpos, orgpos, this.maxTextSize, this.textProp);
                orgpos.y += this.fontInfo.lineHeight;
            }
        };

        PanelText.prototype.applyMotion = function () {
            var count = 0;
            for (var y = 0; y < this.rowBlock.length; y++) {
                var line = this.rowBlock[y];
                for (var x = 0; x < line.columnBlock.length; x++) {
                    var ch = line.columnBlock[x];
                    this.motionfact.assignTween(this.group.game, ch, this, count++);
                }
            }

            count = 0;
            for (var y0 = 0; y0 < this.rowBlock.length; y0++) {
                var line0 = this.rowBlock[y0];
                for (var x0 = 0; x0 < line0.columnBlock.length; x0++) {
                    var ch0 = line0.columnBlock[x0];
                    this.motionfact.linkTween(this.group.game, ch0, this, count++);
                }
            }
        };

        PanelText.prototype.startTopCharTweens = function () {
            if (this.rowBlock != null && this.rowBlock.length > 0 && this.rowBlock[0].columnBlock != null && this.rowBlock[0].columnBlock.length > 0)
                this.rowBlock[0].columnBlock[0].startCharTweens();
        };

        PanelText.prototype.startAllCharTweens = function () {
            for (var i = 0; i < this.allCharParts.length; i++) {
                var ch = this.allCharParts[i];
                ch.startCharTweens();
            }
        };

        Object.defineProperty(PanelText.prototype, "alpha", {
            get: function () {
                return this.group.alpha;
            },
            set: function (value) {
                this.group.alpha = value;
            },
            enumerable: true,
            configurable: true
        });


        PanelText.prototype.getLineBlockByOffset = function (textPosy, lineOffset) {
            var nextpos = textPosy + lineOffset;
            if (nextpos < 0 || nextpos >= this.rowBlock.length)
                return null;
            return this.rowBlock[nextpos];
        };
        return PanelText;
    })(PanelGroup);
    MfTool.PanelText = PanelText;

    

    var ButtonGroup = (function (_super) {
        __extends(ButtonGroup, _super);
        function ButtonGroup(game, name, buttonList, parentInfo, key, posPct, sizePct, pushButton, timedLink, anyTap, buttonAlignList, anc, offsetPix, p9Ratio) {
            if (typeof pushButton === "undefined") { pushButton = null; }
            if (typeof timedLink === "undefined") { timedLink = null; }
            if (typeof anyTap === "undefined") { anyTap = null; }
            if (typeof buttonAlignList === "undefined") { buttonAlignList = null; }
            if (typeof anc === "undefined") { anc = null; }
            if (typeof offsetPix === "undefined") { offsetPix = null; }
            if (typeof p9Ratio === "undefined") { p9Ratio = null; }
            _super.call(this, game, name, parentInfo, posPct, sizePct, anc, offsetPix, p9Ratio);
            this.buttonList = [];

            var blist = new Array();
            var showBtnList = new Array();
            for (var blink in buttonList) {
                if (buttonList.hasOwnProperty(blink)) {
                    var lk = buttonList[blink];
                    blist.push(lk);
                    var bNotBtn = false;
                    if (lk.Property["selfdelay"] != null) {
                        bNotBtn = true;
                    }
                    if (lk.Property["basetap"] != null) {
                        bNotBtn = true;
                    }
                    if (!bNotBtn) {
                        showBtnList.push(lk);
                    }
                }
            }

            showBtnList.sort(function (a, b) {
                var ap = a.Property["pri"];
                var bp = b.Property["pri"];
                if (ap == null && bp == null)
                    return 0;
                if (ap != null && bp == null)
                    return -1;
                if (ap == null && bp != null)
                    return 1;
                return parseInt(ap) - parseInt(bp);
            });
            blist.sort(function (a, b) {
                var ap = a.Property["pri"];
                var bp = b.Property["pri"];
                if (ap == null && bp == null)
                    return 0;
                if (ap != null && bp == null)
                    return -1;
                if (ap == null && bp != null)
                    return 1;
                return parseInt(ap) - parseInt(bp);
            });

            if (buttonAlignList == null) {
                buttonAlignList = new Phaser.Point(0, 1);
            }
            var btnRatioSize = new Phaser.Point(1, 1);
            if (buttonAlignList.x === 0 && buttonAlignList.y === 1) {
                buttonAlignList = new Phaser.Point(showBtnList.length, 1);
            } else if (buttonAlignList.x === 1 && buttonAlignList.y === 0) {
                buttonAlignList = new Phaser.Point(1, showBtnList.length);
            } else if (buttonAlignList.x > 0) {
                if (showBtnList.length <= buttonAlignList.x) {
                    buttonAlignList.set(showBtnList.length, 1);
                } else {
                    buttonAlignList.set(buttonAlignList.x, Math.floor((showBtnList.length + buttonAlignList.x - 1) / buttonAlignList.x));
                }
            } else if (buttonAlignList.y > 0) {
                if (buttonAlignList.x === 0) {
                    buttonAlignList = new Phaser.Point(showBtnList.length, 1);
                } else {
                    buttonAlignList.set(buttonAlignList.x, Math.floor((showBtnList.length + buttonAlignList.x - 1) / buttonAlignList.x));
                }
            }
            btnRatioSize.x /= buttonAlignList.x;
            btnRatioSize.y /= buttonAlignList.y;

            var pos = new Phaser.Point(0, 0);
            var btnname = "button";
            for (var lno = 0; lno < blist.length; lno++) {
                var link = blist[lno];
                var bIsSelfLink = false;
                if (link.Property["selfdelay"] != null && timedLink != null) {
                    game.time.events.add(Phaser.Timer.SECOND * parseFloat(link.Property["selfdelay"]), timedLink, this, link);
                    bIsSelfLink = true;
                }
                if (link.Property["basetap"] != null && anyTap != null) {
                    this.baseTapId = link.Id;
                    game.input.onTap.add(function (a) {
                        anyTap(a);
                    });
                    bIsSelfLink = true;
                }

                if (!bIsSelfLink) {
                    var btn;
                    btn = new MfTool.Button9P(game, link.Id, this, new Phaser.Point(pos.x * btnRatioSize.x, pos.y * btnRatioSize.y), btnRatioSize, key, function (b, k) {
                        if (pushButton != null)
                            pushButton(b, k);
                    }, null, null, 1, 0, 2);
                    btn.text = link.Label;
                    this.buttonList.push(btn);

                    pos.x++;
                    if (pos.x >= buttonAlignList.x) {
                        pos.x = 0;
                        pos.y++;
                    }
                }
            }
        }
        return ButtonGroup;
    })(PanelGroup);
    MfTool.ButtonGroup = ButtonGroup;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var Button9P = (function (_super) {
        __extends(Button9P, _super);
        function Button9P(game, name, parentInfo, posPct, sizePct, key, callback, anc, offset, overFrame, outFrame, downFrame, upFrame) {
            if (typeof callback === "undefined") { callback = null; }
            if (typeof anc === "undefined") { anc = null; }
            if (typeof offset === "undefined") { offset = null; }
            if (typeof overFrame === "undefined") { overFrame = 0; }
            if (typeof outFrame === "undefined") { outFrame = 0; }
            if (typeof downFrame === "undefined") { downFrame = 0; }
            if (typeof upFrame === "undefined") { upFrame = 0; }
            _super.call(this, game, name, parentInfo, posPct, sizePct, anc, offset);
            this.splite = [];
            this.lefttopRatio = new Phaser.Point(1 / 3, 1 / 3);
            this.rightbottomRatio = new Phaser.Point(1 / 3, 1 / 3);
            this.overFrame = overFrame;
            this.outFrame = outFrame;
            this.downFrame = downFrame;
            this.upFrame = upFrame;

            this.buttonCallback = callback;

            var sp;
            for (var j = 0; j < 3; j++) {
                for (var i = 0; i < 3; i++) {
                    sp = new Phaser.Sprite(game, 0, 0, key);
                    this.splite.push(sp);
                    this.group.add(sp);
                }
            }
            this.baseSize = new Phaser.Point(this.splite[0].width, this.splite[0].height);

            this.btn = new Phaser.Button(game, 0, 0, null, null, null);
            this.btn.name = name;

            this.group.add(this.btn);
            this.btn.onInputDown.add(this.btnDown, this);
            this.btn.onInputUp.add(this.btnUp, this);
            this.btn.onInputOver.add(this.btnOver, this);
            this.btn.onInputOut.add(this.btnOut, this);

            this.textLabel = new MfTool.PanelText(game, "", "btnLabel", this, new Phaser.Point(0.5, 0.5), new Phaser.Point(0.95, 0.95), null, null, Button9P.textProp);
            this.textLabel.setMotion(new MfTool.FadeInAll());

            var size = this.panelBound.getAbsSize(game);
            this.width = size.x;
            this.height = size.y;
        }
        Button9P.prototype.btnDown = function (btn, pt) {
            this.setAllFrameNo(this.downFrame);
        };
        Button9P.prototype.btnUp = function (btn, pt) {
            this.setAllFrameNo(this.upFrame);
            if (this.buttonCallback != null) {
                this.buttonCallback(btn, pt);
            }
        };
        Button9P.prototype.btnOver = function (btn, pt) {
            this.setAllFrameNo(this.overFrame);
        };
        Button9P.prototype.btnOut = function (btn, pt) {
            this.setAllFrameNo(this.outFrame);
        };

        Button9P.prototype.setAllFrameNo = function (no) {
            for (var i = 0; i < this.splite.length; i++) {
                this.splite[i].frame = no;
            }
        };

        Object.defineProperty(Button9P.prototype, "width", {
            get: function () {
                return this.btn.width;
            },
            set: function (value) {
                this.btn.width = value;

                this.resize9P(this.group.game, this.splite, new Phaser.Point(this.btn.width, this.btn.height), this.baseSize, new Phaser.Point(0, 0));
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Button9P.prototype, "height", {
            get: function () {
                return this.btn.height;
            },
            set: function (value) {
                this.btn.height = value;
                this.resize9P(this.group.game, this.splite, new Phaser.Point(this.btn.width, this.btn.height), this.baseSize, new Phaser.Point(0, 0));
            },
            enumerable: true,
            configurable: true
        });

        Object.defineProperty(Button9P.prototype, "text", {
            get: function () {
                return this.textLabel.originalText;
            },
            set: function (value) {
                this.textLabel.setText(value);
            },
            enumerable: true,
            configurable: true
        });


        Button9P.prototype.resizeScreen = function (game) {
            _super.prototype.resizeScreen.call(this, game);
            var size = this.panelBound.getAbsSize(game);
            this.btn.width = size.x;
            this.btn.height = size.y;
            this.width = size.x;
            this.height = size.y;
        };
        Button9P.textProp = { "center": "true" };
        return Button9P;
    })(MfTool.PanelGroup);
    MfTool.Button9P = Button9P;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var Card = (function (_super) {
        __extends(Card, _super);
        function Card(game, markindex, index, face, scaleBase) {
            _super.call(this, game, MfTool.CardStack.delPos, MfTool.CardStack.delPos, "card");
            this.deviceScale = 1;
            this.mark = markindex;
            this.no = index;
            this.curface = face;
            this.frame = this.calcFacePos();

            this.anchor.setTo(0.5, 0.5);
            this.deviceScale = scaleBase;

            this.scale.set(this.deviceScale, this.deviceScale);
        }
        Card.prototype.touchCard = function () {
            this.bringToTop();
            Card.logic.touchItem(this);
        };

        Card.prototype.flipCard = function () {
            this.curface = !this.curface;
            this.nextframe = this.calcFacePos();
            if (this.game.animeOn) {
                var tw1 = this.game.add.tween(this.scale).to({ x: 0 }, 100, Phaser.Easing.Linear.None);
                tw1.onComplete.add(this.changeFace0, this);
                return tw1.to({ x: this.deviceScale }, 100, Phaser.Easing.Linear.None).start();
            } else {
                this.changeFace0();
                return this.game.add.tween(this.scale).to({ x: this.deviceScale }, 1).start();
            }
        };

        Card.prototype.changeFace0 = function () {
            this.frame = this.nextframe;
        };

        Card.prototype.calcFacePos = function () {
            var pos = 0;
            if (!this.curface)
                pos = Card.backFacePos;
            else if (this.no > 9) {
                switch (this.mark) {
                    case 0:
                        pos = (this.no - 10) + 40;
                        break;
                    case 1:
                        pos = (this.no - 10) + 40 + 3;
                        break;
                    case 2:
                        pos = (this.no - 10) + 40 + 6;
                        break;
                    case 3:
                        pos = (this.no - 10) + 50;
                        break;
                }
            } else {
                pos = this.no + this.mark * 10;
            }
            return pos;
        };

        Card.prototype.moveBanpos = function (banPos, origin, rotate) {
            if (typeof rotate === "undefined") { rotate = true; }
            this.position = origin;
            var target = banPos.calcRealPos();
            if (this.game.animeOn) {
                if (rotate)
                    this.rotation = Math.PI * 2 + this.game.rnd.realInRange(0, Math.PI);
                this.game.add.tween(this).to({ x: target.x, y: target.y, rotation: 0 }, 500, Phaser.Easing.Cubic.Out, true);
            } else {
                this.x = target.x;
                this.y = target.y;
            }
        };

        Card.prototype.moveBanposForAnime = function (target, origin, freeAngleEnd) {
            if (typeof freeAngleEnd === "undefined") { freeAngleEnd = false; }
            this.position = origin;
            this.angle = 360 * 2 + this.game.rnd.angle();
            var rotend = 0;
            if (freeAngleEnd) {
                rotend = this.game.rnd.angle();
            }
            return this.game.add.tween(this).to({ x: target.x, y: target.y, angle: rotend }, 500, Phaser.Easing.Cubic.Out, true);
        };

        Card.loadContents = function (loader, path) {
            loader.spritesheet('card', path + 'assets/cardbase.png', Card.width, Card.height);
        };
        Card.width = 80;
        Card.height = 120;

        Card.maxMark = 3;
        Card.maxNo = 12;
        Card.backFacePos = 55;
        return Card;
    })(Phaser.Sprite);
    MfTool.Card = Card;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var CardStack = (function () {
        function CardStack(game, face, maxnum, layer, scale) {
            this.game = game;
            this.stack = new Array();
            this.inBoard = new Array();

            for (var i = 12; i >= 0; i--) {
                for (var j = 1; j >= 0; j--) {
                    var q = new MfTool.Card(game, j, i, face, scale);
                    layer.add(q);
                    q.inputEnabled = true;

                    this.stack.push(q);
                    if (--maxnum <= 0)
                        return;
                }
            }

            for (var k = 12; k >= 0; k--) {
                for (var m = 3; m >= 2; m--) {
                    var p = new MfTool.Card(game, m, k, face, scale);
                    layer.add(p);
                    p.inputEnabled = true;

                    this.stack.push(p);
                    if (--maxnum <= 0)
                        return;
                }
            }
        }
        CardStack.prototype.randomPickToBoard = function () {
            if (this.stack.length == 0) {
                return null;
            }
            var c = null;

            c = this.stack[this.game.rnd.integerInRange(0, this.stack.length - 1)];
            this.inBoard.push(c);
            var index = this.stack.indexOf(c, 0);
            if (index != undefined) {
                this.stack.splice(index, 1);
            }
            return c;
        };

        CardStack.prototype.deleteFromBoard = function (c) {
            this.stack.push(c);
            var index = this.inBoard.indexOf(c, 0);
            if (index != undefined) {
                this.inBoard.splice(index, 1);
            }

            c.bringToTop();
            if (this.game.animeOn) {
                var r = this.game.rnd.realInRange(-120, 120);
                var q = this.game.rnd.realInRange(-120, 120);
                var target = new Phaser.Point(c.x + r, this.game.world.height * 1.1);
                this.game.add.tween(c).to({ alpha: 0 }, 50, Phaser.Easing.Linear.None, true);
                this.game.add.tween(c).to({ angle: q }, 500, Phaser.Easing.Back.In, true);
                var tween = this.game.add.tween(c).to({ alpha: 0, x: target.x, y: target.y }, 500, Phaser.Easing.Quartic.In, true);
                tween.onComplete.add(this.delPos, this);
                return tween;
            } else {
                c.alpha = 0;
                this.delPos(c);
                return null;
            }
        };
        CardStack.prototype.delPos = function (c) {
            c.x = CardStack.delPos;
            c.y = CardStack.delPos;
        };
        CardStack.delPos = 10000;
        return CardStack;
    })();
    MfTool.CardStack = CardStack;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var ComboTip = (function (_super) {
        __extends(ComboTip, _super);
        function ComboTip(game, color) {
            _super.call(this, game, 0, 0, "combo", 0);
            this.comboNo = 0;
            this.anchor.set(0.5, 0.5);
            this.tint = color;
            this.visible = false;
            this.comboNo = 0;
            this.game.world.addChild(this);
        }
        ComboTip.prototype.showCombo = function (x, y, no, group) {
            if (typeof group === "undefined") { group = null; }
            this.comboNo = no;
            this.position.set(x - this.width / 4, y - this.height);
            this.frame = no;
            this.visible = true;

            var tw = this.game.add.tween(this).to({ y: y }, 400, Phaser.Easing.Bounce.Out, true).delay(500);
            tw.onComplete.add(this.end, this);
            this.game.add.tween(this).to({ x: x }, 400, Phaser.Easing.Exponential.Out, true);
            this.game.add.tween(this).to({ alpha: 1 }, 400, Phaser.Easing.Exponential.Out, true);
            return tw;
        };

        ComboTip.prototype.end = function () {
            this.visible = false;
        };

        ComboTip.loadContents = function (load, assetpath) {
            load.spritesheet("combo", assetpath + "assets/combo64_64_4.png", ComboTip.panelWidth, ComboTip.panelHeight);
        };
        ComboTip.panelWidth = 64;
        ComboTip.panelHeight = 64;
        return ComboTip;
    })(Phaser.Sprite);
    MfTool.ComboTip = ComboTip;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var ConfigForm = (function (_super) {
        __extends(ConfigForm, _super);
        function ConfigForm() {
            _super.apply(this, arguments);
        }
        ConfigForm.prototype.create = function (game, paneldef, navi, args) {
            var _this = this;
            this.naviUtil = new MfTool.NaviBaseFormUtil(game, this, paneldef, args);
            this.naviUtil.setupForPanel(this, navi, new Phaser.Point(0, 0), new Phaser.Point(1, 1));
            var store = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id, "naviback", null, new Phaser.Point(0, 0), new Phaser.Point(1, 1));
            if (paneldef.Body != null) {
                var textstore = this.naviUtil.setText(paneldef.Id + "_bodytext", this.naviUtil.paneldef.Body, store, new Phaser.Point(0, 0), new Phaser.Point(1, 1));
            }

            this.naviUtil.addButtons(game, store, new Phaser.Point(-0.45, 0.2), new Phaser.Point(0.5, 0.23), function (b) {
                _this.pushButton(b);
            }, function (k) {
                _this.timedLink(k);
            });
            this.naviUtil.rootPanel.showPlayAll();
            return this;
        };

        ConfigForm.prototype.dofull = function () {
            if (this.naviUtil.game.scale.isFullScreen) {
                this.naviUtil.game.scale.stopFullScreen();
            } else {
                this.naviUtil.game.scale.startFullScreen(false);
            }
        };

        ConfigForm.prototype.doBgmBtn = function () {
            this.naviUtil.game.toggleBgm();
        };
        return ConfigForm;
    })(MfTool.NaviBaseFormPanel);
    MfTool.ConfigForm = ConfigForm;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var DanceChar = (function () {
        function DanceChar(group, text, rowno, colno, fontInfo) {
            this.tweenList = [];
            this.showText = text;
            this.textPos = new Phaser.Point(colno, rowno);
            this.originPos = new Phaser.Point(this.textPos.x * fontInfo.fontsize, this.textPos.y * fontInfo.lineHeight);
            this.targetPos = new Phaser.Point(this.textPos.x * fontInfo.fontsize, this.textPos.y * fontInfo.lineHeight);

            this.panel = new Phaser.Text(group.game, this.textPos.x * fontInfo.fontsize, this.textPos.y * fontInfo.lineHeight, text, { "font": fontInfo.fontdef });
            group.add(this.panel);
            this.textColor = 0;
        }
        DanceChar.prototype.startCharTweens = function () {
            for (var i = 0; i < this.tweenList.length; i++) {
                var tw = this.tweenList[i];
                tw.start();
            }
        };

        DanceChar.prototype.getPrevChar = function (block) {
            var x = this.textPos.x - 1;
            var y = this.textPos.y;
            if (x < 0) {
                y--;
                if (y < 0)
                    return null;
                var line = block.rowBlock[y];
                x = line.columnBlock.length - 1;
            }
            var ln = block.rowBlock[y];
            var ch = ln.columnBlock[x];
            return ch;
        };

        DanceChar.prototype.setTextPos = function (colno, rowno, orgpos) {
            this.textPos = new Phaser.Point(colno, rowno);
            this.originPos = new Phaser.Point(orgpos.x, orgpos.y);
            this.targetPos = new Phaser.Point(orgpos.x, orgpos.y);
            return new Phaser.Point(orgpos.x + this.textWidth, orgpos.y);
        };

        Object.defineProperty(DanceChar.prototype, "rgb", {
            get: function () {
                return this.textColor;
            },
            set: function (value) {
                this.textColor = value;
                this.panel.fill = "#" + value.toString(16);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DanceChar.prototype, "colorV", {
            get: function () {
                var rgb = Phaser.Color.getRGB(this.textColor);
                var hsv = Phaser.Color.RGBtoHSV(rgb["r"], rgb["g"], rgb["b"]);
                return hsv["v"];
            },
            set: function (value) {
                var rgb = Phaser.Color.getRGB(this.textColor);
                var hsv = Phaser.Color.RGBtoHSV(rgb["r"], rgb["g"], rgb["b"]);
                hsv["v"] = value;
                var nextrgb = Phaser.Color.HSVtoRGB(hsv["h"], hsv["s"], hsv["v"]);
                var v = Phaser.Color.getColor(nextrgb["r"], nextrgb["g"], nextrgb["b"]);
                this.textColor = v;
                this.panel.fill = "#" + v.toString(16);
            },
            enumerable: true,
            configurable: true
        });
        return DanceChar;
    })();
    MfTool.DanceChar = DanceChar;

    var DanceLine = (function () {
        function DanceLine(charlist, rowno) {
            this.columnBlock = [];
            var pos = new Phaser.Point(0, 0);
            for (var cpos = 0; cpos < charlist.length; cpos++) {
                var ch = charlist[cpos];
                this.columnBlock.push(ch);
                pos = ch.setTextPos(cpos, rowno, pos);
            }
            this.lineWidth = pos.x;
        }
        DanceLine.prototype.setCharPos = function (game, rowno, orgpos, maxBound, textProp) {
            var pos = new Phaser.Point(orgpos.x, orgpos.y);
            if (textProp["center"] === "true") {
                pos = new Phaser.Point(orgpos.x - this.lineWidth / 2, orgpos.y);
            }
            for (var cpos = 0; cpos < this.columnBlock.length; cpos++) {
                var ch = this.columnBlock[cpos];

                pos = ch.setTextPos(cpos, rowno, pos);
            }
        };

        DanceLine.prototype.getCharByOffset = function (textPosx, offsetx) {
            var nextpos = textPosx + offsetx;
            if (nextpos < 0 || nextpos >= this.columnBlock.length) {
                return null;
            }
            return this.columnBlock[nextpos];
        };
        return DanceLine;
    })();
    MfTool.DanceLine = DanceLine;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var FlightFromLeft = (function () {
        function FlightFromLeft(oneCharDuring) {
            if (typeof oneCharDuring === "undefined") { oneCharDuring = 100; }
            this.oneCharDuring = oneCharDuring;
        }
        FlightFromLeft.prototype.assignTween = function (game, baseChar, block, charPosAll) {
            var orgpos = baseChar.originPos;
            orgpos.x += game.world.width + baseChar.textPos.x * block.fontInfo.fontsize;
            baseChar.panel.position.set(orgpos.x, orgpos.y);
            this.tw = game.add.tween(baseChar.panel).to({ x: baseChar.targetPos.x }, this.oneCharDuring, Phaser.Easing.Linear.None);
            baseChar.tweenList.push(this.tw);
        };

        FlightFromLeft.prototype.linkTween = function (game, baseChar, block, charPosAll) {
            var prevPos = baseChar.getPrevChar(block);
            if (prevPos != null && prevPos.tweenList.length > 0) {
                prevPos.tweenList[0].onComplete.add(function () {
                    baseChar.startCharTweens();
                }, this);
            }
        };

        FlightFromLeft.prototype.runMotion = function (naviTextStore) {
            naviTextStore.startTopCharTweens();
        };

        FlightFromLeft.prototype.stop = function () {
            if (this.tw != null) {
                this.tw.stop();
                this.tw = null;
            }
        };
        return FlightFromLeft;
    })();
    MfTool.FlightFromLeft = FlightFromLeft;

    var BreakOutRight = (function () {
        function BreakOutRight() {
            this.twList = [];
        }
        BreakOutRight.prototype.assignTween = function (game, baseChar, block, charPosAll) {
            baseChar.panel.position.set(baseChar.originPos.x, baseChar.originPos.y);

            var targetPos = baseChar.targetPos;
            targetPos.x += game.width / 3;

            var a = game.rnd.angle();

            var tw = game.add.tween(baseChar.panel).to({ angle: a }, 50, Phaser.Easing.Linear.None);
            this.twList.push(tw);
            baseChar.tweenList.push(tw);

            tw = game.add.tween(baseChar.panel).to({ angle: a, alpha: 0, colorV: 1 }, 1000, Phaser.Easing.Linear.None);
            this.twList.push(tw);
            baseChar.tweenList.push(tw);

            tw = game.add.tween(baseChar).to({ colorV: 1 }, 750, Phaser.Easing.Linear.None);
            this.twList.push(tw);
            baseChar.tweenList.push(tw);

            tw = game.add.tween(baseChar.panel).to({ x: targetPos.x, angle: a, alpha: 0 }, 1000, Phaser.Easing.Quartic.In);
            this.twList.push(tw);
            baseChar.tweenList.push(tw);
        };

        BreakOutRight.prototype.linkTween = function (game, baseChar, block, charPosAll) {
            var prevPos = new Phaser.Point(baseChar.textPos.x, baseChar.textPos.y);
            var prevChar = this.findPrevChar(block, prevPos, baseChar);

            if (prevChar != null && prevChar.tweenList.length > 0) {
                prevChar.tweenList[0].onComplete.add(function () {
                    baseChar.startCharTweens();
                }, this);
            }
        };

        BreakOutRight.prototype.findPrevChar = function (block, pos, ch) {
            var currentLine = block.getLineBlockByOffset(pos.y, 0);
            var prevChar = currentLine.getCharByOffset(pos.x, 1);
            if (prevChar != null)
                return prevChar;

            var prevLine = block.getLineBlockByOffset(pos.y, -1);
            if (prevLine == null) {
                this.startChar = ch;
                return null;
            }
            if (prevLine.columnBlock.length > 0) {
                return prevLine.columnBlock[0];
            }

            pos.y--;
            return this.findPrevChar(block, pos, ch);
        };

        BreakOutRight.prototype.runMotion = function (naviTextStore) {
            if (this.startChar != null)
                this.startChar.startCharTweens();
        };

        BreakOutRight.prototype.stop = function () {
            for (var i = 0; i < this.twList.length; i++) {
                this.twList[i].stop();
                this.twList[i] = null;
            }
            this.twList = [];
        };
        return BreakOutRight;
    })();
    MfTool.BreakOutRight = BreakOutRight;

    var RoundToEndGroupCenter = (function () {
        function RoundToEndGroupCenter() {
        }
        RoundToEndGroupCenter.prototype.assignTween = function (game, baseChar, block, charPosAll) {
            var rotate = Math.PI - Math.PI * 2 / block.allCharParts.length * charPosAll;

            var orgpos = new Phaser.Point(game.world.centerX * 1.5 * Math.cos(rotate), -game.world.centerY * 1.5 * Math.sin(rotate));
            baseChar.panel.position.set(orgpos.x, orgpos.y);
            this.tw = game.add.tween(baseChar.panel).to({ x: baseChar.targetPos.x, y: baseChar.targetPos.y }, 2000, Phaser.Easing.Bounce.Out);
            baseChar.tweenList.push(this.tw);
        };

        RoundToEndGroupCenter.prototype.linkTween = function (game, baseChar, block, charPosAll) {
        };

        RoundToEndGroupCenter.prototype.runMotion = function (naviTextStore) {
            naviTextStore.startAllCharTweens();
        };
        RoundToEndGroupCenter.prototype.stop = function () {
            if (this.tw != null) {
                this.tw.stop();
                this.tw = null;
            }
        };
        return RoundToEndGroupCenter;
    })();
    MfTool.RoundToEndGroupCenter = RoundToEndGroupCenter;

    var RoundToEndScreenCenter = (function () {
        function RoundToEndScreenCenter() {
        }
        RoundToEndScreenCenter.prototype.assignTween = function (game, baseChar, block, charPosAll) {
            var rotate = Math.PI - Math.PI * 2 / block.allCharParts.length * charPosAll;

            var orgpos = new Phaser.Point(game.world.centerX * 1.5 * Math.cos(rotate), -game.world.centerY * 1.5 * Math.sin(rotate));
            baseChar.panel.position.set(orgpos.x + game.world.centerX, orgpos.y + game.world.centerY);
            this.tw = game.add.tween(baseChar.panel).to({ x: baseChar.targetPos.x, y: baseChar.targetPos.y }, 2000, Phaser.Easing.Bounce.Out);
            baseChar.tweenList.push(this.tw);
        };

        RoundToEndScreenCenter.prototype.linkTween = function (game, baseChar, block, charPosAll) {
        };

        RoundToEndScreenCenter.prototype.runMotion = function (naviTextStore) {
            naviTextStore.startAllCharTweens();
        };
        RoundToEndScreenCenter.prototype.stop = function () {
            if (this.tw != null) {
                this.tw.stop();
                this.tw = null;
            }
        };
        return RoundToEndScreenCenter;
    })();
    MfTool.RoundToEndScreenCenter = RoundToEndScreenCenter;

    var FadeInAll = (function () {
        function FadeInAll() {
        }
        FadeInAll.prototype.assignTween = function (game, baseChar, block, charPosAll) {
            baseChar.panel.position.set(baseChar.targetPos.x, baseChar.targetPos.y);
            baseChar.panel.alpha = 0;
            this.tw = game.add.tween(baseChar.panel).to({ alpha: 1 }, 300, Phaser.Easing.Linear.None);
            baseChar.tweenList.push(this.tw);
        };

        FadeInAll.prototype.linkTween = function (game, baseChar, block, charPosAll) {
        };

        FadeInAll.prototype.runMotion = function (naviTextStore) {
            naviTextStore.startAllCharTweens();
        };
        FadeInAll.prototype.stop = function () {
            if (this.tw != null) {
                this.tw.stop();
                this.tw = null;
            }
        };
        return FadeInAll;
    })();
    MfTool.FadeInAll = FadeInAll;

    var BlinkAll = (function () {
        function BlinkAll(during) {
            if (typeof during === "undefined") { during = 300; }
            this.during = during;
        }
        BlinkAll.prototype.assignTween = function (game, baseChar, block, charPosAll) {
            baseChar.panel.position.set(baseChar.targetPos.x, baseChar.targetPos.y);
            baseChar.panel.alpha = 0;
            this.tw = game.add.tween(baseChar.panel).to({ alpha: 1 }, this.during, Phaser.Easing.Linear.None, false, 0, -1, true);
            baseChar.tweenList.push(this.tw);
        };

        BlinkAll.prototype.linkTween = function (game, baseChar, block, charPosAll) {
        };

        BlinkAll.prototype.runMotion = function (naviTextStore) {
            naviTextStore.startAllCharTweens();
        };
        BlinkAll.prototype.stop = function () {
            if (this.tw != null) {
                this.tw.stop();
                this.tw = null;
            }
        };
        return BlinkAll;
    })();
    MfTool.BlinkAll = BlinkAll;

    var TypeWriterSmooth = (function () {
        function TypeWriterSmooth(during, delay, callback) {
            if (typeof during === "undefined") { during = null; }
            if (typeof delay === "undefined") { delay = null; }
            if (typeof callback === "undefined") { callback = null; }
            if (during == null) {
                this.duaring = 100;
            } else {
                this.duaring = during;
            }
            if (delay == null) {
                this.delay = 0;
            } else {
                this.delay = delay;
            }
            this.callback = callback;
        }
        TypeWriterSmooth.prototype.assignTween = function (game, baseChar, block, charPosAll) {
            var d = this.duaring;
            if (baseChar.showText === "\n") {
                d += 500;
            }
            baseChar.panel.position.set(baseChar.targetPos.x, baseChar.targetPos.y);
            baseChar.panel.alpha = 0;
            this.tw = game.add.tween(baseChar.panel).to({ alpha: 1 }, d, Phaser.Easing.Linear.None, false);
            baseChar.tweenList.push(this.tw);
        };

        TypeWriterSmooth.prototype.linkTween = function (game, baseChar, block, charPosAll) {
            var _this = this;
            var prevPos = baseChar.getPrevChar(block);
            if (prevPos != null && prevPos.tweenList.length > 0) {
                prevPos.tweenList[0].onComplete.add(function () {
                    baseChar.startCharTweens();
                }, this);
            }
            if (this.callback != null && charPosAll === block.allCharParts.length - 1) {
                baseChar.tweenList[0].onComplete.add(function () {
                    _this.callback();
                }, this);
            }
        };

        TypeWriterSmooth.prototype.runMotion = function (naviTextStore) {
            this.store = naviTextStore;
            if (this.delay !== 0) {
                naviTextStore.group.game.time.events.add(this.delay, this.delayRun, this);
            } else {
                naviTextStore.startTopCharTweens();
            }
        };
        TypeWriterSmooth.prototype.delayRun = function () {
            this.store.startTopCharTweens();
        };
        TypeWriterSmooth.prototype.stop = function () {
            if (this.tw != null) {
                this.tw.stop();
                this.tw = null;
            }
        };
        return TypeWriterSmooth;
    })();
    MfTool.TypeWriterSmooth = TypeWriterSmooth;

    var ScrollText = (function () {
        function ScrollText(during, delay, callback) {
            if (typeof during === "undefined") { during = 100; }
            if (typeof delay === "undefined") { delay = 0; }
            if (typeof callback === "undefined") { callback = null; }
            this.duaring = during;
            this.delay = delay;
            this.callback = callback;
        }
        ScrollText.prototype.assignTween = function (game, baseChar, block, charPosAll) {
            baseChar.panel.position.set(baseChar.targetPos.x, baseChar.targetPos.y);
        };

        ScrollText.prototype.linkTween = function (game, baseChar, block, charPosAll) {
        };

        ScrollText.prototype.runMotion = function (naviTextStore) {
            this.store = naviTextStore;
            if (this.delay !== 0) {
                naviTextStore.group.game.time.events.add(this.delay, this.run, this);
            } else {
                this.run();
            }
        };
        ScrollText.prototype.run = function () {
            var _this = this;
            var y = this.store.group.position.y;

            var f = this.store.panelBound.getAbsSize(this.store.group.game);
            var d = this.store.drawBound.getAbsSize(this.store.group.game);

            this.tw = this.store.group.game.add.tween(this.store.group.position).to({ y: y - this.store.maxTextSize.y - (f.y - d.y) / 2 - this.store.fontInfo.lineHeight }, this.duaring, Phaser.Easing.Linear.None, true);
            if (this.callback != null) {
                this.tw.onComplete.add(function () {
                    _this.callback();
                }, this);
            }
        };
        ScrollText.prototype.stop = function () {
            if (this.tw != null) {
                this.tw.stop();
                this.tw = null;
            }
        };
        return ScrollText;
    })();
    MfTool.ScrollText = ScrollText;

    var StaticText = (function () {
        function StaticText(callback) {
            if (typeof callback === "undefined") { callback = null; }
        }
        StaticText.prototype.assignTween = function (game, baseChar, block, charPosAll) {
            baseChar.panel.position.set(baseChar.targetPos.x, baseChar.targetPos.y);
        };

        StaticText.prototype.linkTween = function (game, baseChar, block, charPosAll) {
        };

        StaticText.prototype.runMotion = function (naviTextStore) {
        };
        StaticText.prototype.stop = function () {
        };
        return StaticText;
    })();
    MfTool.StaticText = StaticText;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var NaviBaseFormState = (function (_super) {
        __extends(NaviBaseFormState, _super);
        function NaviBaseFormState() {
            _super.apply(this, arguments);
        }
        NaviBaseFormState.prototype.getApp = function () {
            return this.naviUtil.game;
        };

        NaviBaseFormState.prototype.init = function (paneldef, args) {
            this.naviUtil = new MfTool.NaviBaseFormUtil(this.game, this, paneldef, args);
            this.naviUtil.navi = this.game.getNaviController();
        };
        NaviBaseFormState.prototype.create = function () {
            var _this = this;
            this.naviUtil.makeUiLayer();
            this.naviUtil.addButtons(this.game, null, new Phaser.Point(-0.45, 0.2), new Phaser.Point(0.5, 0.23), function (b) {
                _this.pushButton(b);
            }, function (k) {
                _this.timedLink(k);
            }, function (m) {
                _this.tapAny(m);
            });
        };

        NaviBaseFormState.prototype.pushButton = function (btn) {
            var link;
            if (btn.name != null) {
                link = this.naviUtil.paneldef.LinkList[btn.name];
            } else {
                link = this.naviUtil.paneldef.LinkList[this.naviUtil.baseTapId];
            }

            this.preNextState(link);
        };

        NaviBaseFormState.prototype.timedLink = function (link) {
            this.preNextState(link);
        };

        NaviBaseFormState.prototype.tapAny = function (point) {
            var link = this.naviUtil.paneldef.LinkList[this.naviUtil.baseTapId];
            this.preNextState(link);
        };

        NaviBaseFormState.prototype.preNextState = function (link) {
            this.naviUtil.navi.execLinkFromState(link);
        };

        NaviBaseFormState.prototype.resize = function () {
            this.naviUtil.resizePanel();
        };

        NaviBaseFormState.prototype.getNaviUtil = function () {
            return this.naviUtil;
        };
        return NaviBaseFormState;
    })(Phaser.State);
    MfTool.NaviBaseFormState = NaviBaseFormState;
    var GameState = (function (_super) {
        __extends(GameState, _super);
        function GameState() {
            _super.apply(this, arguments);
        }
        GameState.prototype.scoreUp = function (point) {
        };
        return GameState;
    })(NaviBaseFormState);
    MfTool.GameState = GameState;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var Demo1Form = (function (_super) {
        __extends(Demo1Form, _super);
        function Demo1Form() {
            _super.apply(this, arguments);
        }
        Demo1Form.prototype.create = function () {
            var _this = this;
            var basepanel = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id, "naviback", null, new Phaser.Point(0, 0), new Phaser.Point(1, 1));

            this.store = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id + "_t", "titlepage", basepanel, new Phaser.Point(0.4, 0.2), new Phaser.Point(0.8, 0.7), new Phaser.Point(1, 1));
            this.store.tint = 0xfff1ca;

            this.ch = this.naviUtil.setBackPanel("cat", "cat", basepanel, new Phaser.Point(0.4, 0.4), new Phaser.Point(0.2, 0.2), new Phaser.Point(0, 1), null, MfTool.PanelBound.Zero);
            this.ch.setRealSpriteSize(new Phaser.Point(1, 1));
            this.ch.panel[0].anchor.set(0.5, 0);
            this.ch.setOriginBySpriteRatio(this.game, new Phaser.Point(0.4, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
            this.ch.setTargetBySpriteRatio(this.game, new Phaser.Point(0.4, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));

            this.store2 = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id + "_t2", "titlepage", basepanel, new Phaser.Point(-0.4, 0.3), new Phaser.Point(0.8, 0.1), new Phaser.Point(-1, 1));
            this.store2.tint = 0xfff1ca;

            this.ch2 = this.naviUtil.setBackPanel("rabit", "rabit", basepanel, new Phaser.Point(-0.4, 0.4), new Phaser.Point(0.2, 0.2), new Phaser.Point(0, 1), null, MfTool.PanelBound.Zero);
            this.ch2.panel[0].anchor.set(0.5, 0);
            this.ch2.setRealSpriteSize(new Phaser.Point(1, 1));

            this.title = this.naviUtil.setText(this.naviUtil.paneldef.Id + "_bodytext0", "ストーリー|en:Story", this.store, new Phaser.Point(0, -0.5), new Phaser.Point(0.95, 1), null, { "center": "true" });
            var font = null;
            if (this.getApp().smartPhoneMode) {
                font = { "font": "bold16" };
            }
            this.txtstore = this.naviUtil.setText(this.naviUtil.paneldef.Id + "_bodytext", this.naviUtil.paneldef.Body, this.store, new Phaser.Point(-0.5, -0.46), new Phaser.Point(0.95, 0.95), null, font);
            this.txtstore2 = this.naviUtil.setText(this.naviUtil.paneldef.Id + "_bodytext2", "なにを言っているのかちょっとわからないです|en:We do not understand that you are saying...", this.store2, new Phaser.Point(-0.5, -0.5), new Phaser.Point(0.95, 0.9), null, font);

            if (this.getApp().animeOn) {
                this.store.setOrigin(this.game, new Phaser.Point(0.4, 0.2), new Phaser.Point(0, 0), new Phaser.Point(1, 1));
                this.store.setMotion(this.game, 300, new MfTool.MoveLinerPanelFactory(function () {
                    _this.panelMoveEnd();
                }));
                this.ch.setMotion(this.game, 1, new MfTool.MoveLinerPanelFactory());
                this.title.alpha = 0;
                var d = 20;
                if (MfTool.NaviPanelDef.useLang === "ja")
                    d = 100;
                this.txtstore.setMotion(new MfTool.TypeWriterSmooth(d, null, function () {
                    _this.rabitMove();
                }));

                this.store2.setTarget(this.game, new Phaser.Point(-0.4, 0.3), new Phaser.Point(0, 0), new Phaser.Point(-1, 1));
                this.ch2.setTargetBySpriteRatio(this.game, new Phaser.Point(-0.6, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
                this.txtstore2.alpha = 0;
            } else {
                this.rabitMove();
            }

            this.store.showPlay();
            this.ch.showPlay();

            _super.prototype.create.call(this);
        };

        Demo1Form.prototype.panelMoveEnd = function () {
            this.title.alpha = 1;
            this.txtstore.showPlay();
        };

        Demo1Form.prototype.rabitMove = function () {
            var _this = this;
            this.store2.setOrigin(this.game, new Phaser.Point(-0.4, 0.3), new Phaser.Point(0, 0), new Phaser.Point(-1, 1));
            this.store2.setTarget(this.game, new Phaser.Point(-0.4, 0.3), new Phaser.Point(0.8, 0.1), new Phaser.Point(-1, 1));

            this.ch2.setOriginBySpriteRatio(this.game, new Phaser.Point(-0.6, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
            this.ch2.setTargetBySpriteRatio(this.game, new Phaser.Point(-0.4, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));

            if (this.getApp().animeOn) {
                this.store2.setMotion(this.game, 300, new MfTool.MoveLinerPanelFactory(function () {
                    _this.rabitTalk();
                }));
                this.ch2.setMotion(this.game, 1, new MfTool.MoveLinerPanelFactory());
            } else {
                this.rabitTalk();
            }
            this.store2.showPlay();
            this.ch2.showPlay();
        };

        Demo1Form.prototype.rabitTalk = function () {
            if (this.getApp().animeOn) {
                var d = 20;
                if (MfTool.NaviPanelDef.useLang === "ja")
                    d = 100;
                this.txtstore2.alpha = 1;
                this.txtstore2.setTarget(this.game, new Phaser.Point(-0.5, -0.5), new Phaser.Point(0.95, 0.9));
                this.txtstore2.setMotion(new MfTool.TypeWriterSmooth(d));
            }
            this.txtstore2.showPlay();
        };

        Demo1Form.prototype.preNextState = function (link) {
            var _this = this;
            this.link = link;

            if (this.getApp().animeOn) {
                this.title.alpha = 0;
                this.txtstore.alpha = 0;
                if (this.txtstore2 != null) {
                    this.txtstore2.alpha = 0;
                }
                this.store.setOrigin(this.game, new Phaser.Point(0.4, 0.2), new Phaser.Point(0.8, 0.7), new Phaser.Point(1, 1));
                this.store.setTarget(this.game, new Phaser.Point(0.4, 0.2), new Phaser.Point(0, 0), new Phaser.Point(1, 1));
                this.store.setMotion(this.game, 300, new MfTool.MoveLinerPanelFactory(function () {
                    _this.end();
                }));

                this.ch.setOriginBySpriteRatio(this.game, new Phaser.Point(0.4, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
                this.ch.setTargetBySpriteRatio(this.game, new Phaser.Point(0.6, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
                this.ch.setMotion(this.game, 300, new MfTool.MoveLinerPanelFactory());

                this.store2.setOrigin(this.game, new Phaser.Point(-0.4, 0.4), new Phaser.Point(0.8, 0.1), new Phaser.Point(-1, 1));
                this.store2.setTarget(this.game, new Phaser.Point(-0.4, 0.4), new Phaser.Point(0, 0), new Phaser.Point(-1, 1));
                this.store2.setMotion(this.game, 300, new MfTool.MoveLinerPanelFactory());

                this.store2.alpha = 0;

                this.ch2.setOriginBySpriteRatio(this.game, new Phaser.Point(-0.4, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
                this.ch2.setTargetBySpriteRatio(this.game, new Phaser.Point(-0.6, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
                this.ch2.setMotion(this.game, 1, new MfTool.MoveLinerPanelFactory());

                this.store.showPlay();

                this.ch.showPlay();
                this.ch2.showPlay();
            } else {
                this.end();
            }
        };

        Demo1Form.prototype.end = function () {
            this.naviUtil.navi.execLinkFromState(this.link);
        };
        Demo1Form.prototype.update = function () {
            this.naviUtil.update();
        };
        return Demo1Form;
    })(MfTool.NaviBaseFormState);
    MfTool.Demo1Form = Demo1Form;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var Demo2Form = (function (_super) {
        __extends(Demo2Form, _super);
        function Demo2Form() {
            _super.apply(this, arguments);
        }
        Demo2Form.prototype.create = function () {
            var _this = this;
            var basepanel = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id, "naviback", null, new Phaser.Point(0, 0), new Phaser.Point(1, 1));

            this.store = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id + "_t", "titlepage", basepanel, new Phaser.Point(-0.4, 0.4), new Phaser.Point(0.8, 0.8), new Phaser.Point(-1, 1));
            this.store.tint = 0xfff1ca;

            this.ch = this.naviUtil.setBackPanel("rabit", "rabit", basepanel, new Phaser.Point(-0.5, 0), new Phaser.Point(0.2, 0.2), new Phaser.Point(0, 1), null, MfTool.PanelBound.Zero);
            this.ch.setRealSpriteSize(new Phaser.Point(1, 1));
            this.ch.panel[0].anchor.set(0.5, 0);
            this.ch.setOriginBySpriteRatio(this.game, new Phaser.Point(-0.4, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
            this.ch.setTargetBySpriteRatio(this.game, new Phaser.Point(-0.4, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
            var font = null;
            if (this.getApp().smartPhoneMode) {
                font = { "font": "bold16" };
            }
            this.txtstore = this.naviUtil.setText(this.naviUtil.paneldef.Id + "_bodytext", this.naviUtil.paneldef.Body, this.store, new Phaser.Point(-0.5, -0.5), new Phaser.Point(0.95, 1), null, font);
            if (this.getApp().animeOn) {
                this.store.setOrigin(this.game, new Phaser.Point(-0.4, 0.4), new Phaser.Point(0, 0), new Phaser.Point(-1, 1));
                this.store.setMotion(this.game, 300, new MfTool.MoveLinerPanelFactory(function () {
                    _this.panelMoveEnd();
                }));
                var d = 20;
                if (MfTool.NaviPanelDef.useLang === "ja")
                    d = 100;
                this.txtstore.setMotion(new MfTool.TypeWriterSmooth(d));
                this.ch.setMotion(this.game, 1, new MfTool.MoveLinerPanelFactory());
            } else {
            }
            this.store.showPlay();
            this.ch.showPlay();

            _super.prototype.create.call(this);
        };

        Demo2Form.prototype.panelMoveEnd = function () {
            this.txtstore.showPlay();
        };

        Demo2Form.prototype.preNextState = function (link) {
            var _this = this;
            this.link = link;
            if (this.getApp().animeOn) {
                this.txtstore.alpha = 0;
                this.store.setOrigin(this.game, new Phaser.Point(-0.6, 0.4), new Phaser.Point(0.8, 0.8), new Phaser.Point(-1, 1));
                this.store.setTarget(this.game, new Phaser.Point(-0.6, 0.4), new Phaser.Point(0, 0), new Phaser.Point(-1, 1));
                this.store.setMotion(this.game, 300, new MfTool.MoveLinerPanelFactory(function () {
                    _this.end();
                }));

                this.ch.setOriginBySpriteRatio(this.game, new Phaser.Point(-0.5, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
                this.ch.setTargetBySpriteRatio(this.game, new Phaser.Point(-0.6, 0.4), new Phaser.Point(1, 1), new Phaser.Point(0, 1));
                this.ch.setMotion(this.game, 300, new MfTool.MoveLinerPanelFactory());

                this.naviUtil.rootPanel.showPlayAll();
            } else {
                this.end();
            }
        };
        Demo2Form.prototype.update = function () {
            this.naviUtil.update();
        };

        Demo2Form.prototype.end = function () {
            this.naviUtil.navi.execLinkFromState(this.link);
        };
        return Demo2Form;
    })(MfTool.NaviBaseFormState);
    MfTool.Demo2Form = Demo2Form;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var EndForm = (function (_super) {
        __extends(EndForm, _super);
        function EndForm() {
            _super.apply(this, arguments);
        }
        EndForm.prototype.create = function (game, paneldef, navi, args) {
            var _this = this;
            this.naviUtil = new MfTool.NaviBaseFormUtil(game, this, paneldef, args);
            this.naviUtil.setupForPanel(this, navi, new Phaser.Point(0, 0), new Phaser.Point(1, 1));
            this.naviUtil.makeUiLayer();

            var textstore = this.naviUtil.setText(paneldef.Id + "_bodytext", this.naviUtil.paneldef.Body, this.naviUtil.rootPanel, new Phaser.Point(0, -0.2), new Phaser.Point(0.9, 0.9), new MfTool.TypeWriterSmooth(), { "center": "true", "color": "0xffffff" });

            this.naviUtil.addButtons(game, this.naviUtil.rootPanel, new Phaser.Point(-0.45, 0.2), new Phaser.Point(0.5, 0.23), function (b) {
                _this.pushButton(b);
            }, function (k) {
                _this.timedLink(k);
            });

            this.naviUtil.showBlind(true);

            this.naviUtil.rootPanel.showPlayAll();

            return this;
        };
        return EndForm;
    })(MfTool.NaviBaseFormPanel);
    MfTool.EndForm = EndForm;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var FontInfo = (function () {
        function FontInfo() {
            this.facename = "";
            this.stylename = "";
            this.fontsize = 20;
            this.lineHeight = 26;
            this.fontdef = "bold 20pt Arial";
        }
        FontInfo.loadFromJson = function (url, compcallback) {
            var request = new XMLHttpRequest();
            if (compcallback) {
                request.onload = (function (ev) {
                    FontInfo.fontInfoList = JSON.parse(ev.target.responseText);

                    if (compcallback)
                        compcallback();
                });
            }
            request.open("get", url, compcallback ? true : false);
            request.send();
            if (!compcallback) {
                FontInfo.fontInfoList = JSON.parse(request.responseText);
            }
        };

        FontInfo.getInfo = function (font) {
            return FontInfo.fontInfoList[font];
        };
        FontInfo.fontInfoList = {};
        return FontInfo;
    })();
    MfTool.FontInfo = FontInfo;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var GameBase = (function (_super) {
        __extends(GameBase, _super);
        function GameBase(winwidth, winheight, assetpath) {
            var _this = this;
            _super.call(this, "100", "100", Phaser.AUTO, "", null);
            this.prefs = {};
            this.reqestBgm = false;
            this.scoreInnerList = {};
            this.winwidth = winwidth;
            this.winheight = winheight;
            this.prefs = {};

            MfTool.FontInfo.loadFromJson(assetpath + "assets/fontinfo.json", function () {
                _this.loadPanel(assetpath);
            });

            var loc = window.navigator.language.toLowerCase();
            if (loc == null) {
                MfTool.NaviPanelDef.setLangage("en");
            } else {
                var lc = loc.split("-");
                MfTool.NaviPanelDef.setLangage(lc[0]);
            }
        }
        GameBase.prototype.loadPanel = function (assetpath) {
            var _this = this;
            this.startBoot();
            MfTool.NaviPanelDef.loadJson(assetpath + "assets/panel.json", function () {
                _this.loadConfig();
            });
        };

        GameBase.prototype.loadConfig = function () {
            var _this = this;
            PrefStub.getPrefs(this.getPrefName(), function (e) {
                return _this.loadComp(e);
            });
        };

        GameBase.prototype.loadComp = function (s) {
            if (s == null) {
                this.prefs = {};
            } else {
                this.prefs = JSON.parse(s);
                if (this.prefs == null)
                    this.prefs = {};
                this.scoreInnerList = MfTool.ScoreData.parse(this.prefs["score"]);
                if (this.scoreInnerList == null) {
                    this.scoreInnerList = {};
                    this.prefs["score"] = this.scoreInnerList;
                }
            }

            this.startBoot();
        };

        GameBase.prototype.savePrefs = function () {
            this.prefs["score"] = this.scoreInnerList;
            PrefStub.savePrefs(this.getPrefName(), JSON.stringify(this.prefs));
        };

        GameBase.prototype.getPrefName = function () {
            throw new Error("Need prefName implement at GameApp");
        };

        GameBase.prototype.startBoot = function () {
            this.navi = new MfTool.NaviController(this, this);

            this.state.start("Boot");
        };

        GameBase.prototype.getNaviController = function () {
            return this.navi;
        };

        GameBase.prototype.startGame = function () {
            this.navi.runNavi("logo");
        };

        GameBase.prototype.setTitleBgm = function () {
            if (this.bgmOn && !this.runTitleBgm) {
                this.sound.play("titlebgm", 1, true);
                this.runTitleBgm = true;
            }
        };
        GameBase.prototype.playTitleBgm = function (play) {
            this.reqestBgm = play;
            if (play) {
                this.setTitleBgm();
            } else {
                this.sound.stopAll();
                this.runTitleBgm = false;
            }
        };

        Object.defineProperty(GameBase.prototype, "scoreList", {
            get: function () {
                return MfTool.ScoreData.sortRank(this.scoreInnerList);
            },
            enumerable: true,
            configurable: true
        });

        GameBase.prototype.addScore = function (score, maxlength) {
            if (typeof maxlength === "undefined") { maxlength = 9; }
            this.scoreInnerList = MfTool.ScoreData.addScore(score, this.scoreList, maxlength);
            this.savePrefs();
        };
        GameBase.prototype.getMaxScore = function () {
            var list = this.scoreList;
            if (list.length > 0)
                return list[0];
            return null;
        };
        GameBase.prototype.getMinScore = function () {
            var list = this.scoreList;
            if (list.length > 0)
                return list[list.length - 1];
            return null;
        };
        Object.defineProperty(GameBase.prototype, "bgmOn", {
            get: function () {
                if (this.prefs["bgmOn"] == null || this.prefs["bgmOn"] === "true")
                    return true;
                return false;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(GameBase.prototype, "animeOn", {
            get: function () {
                if (this.prefs["animeOn"] == null || (this.prefs["animeOn"] === "true")) {
                    return true;
                } else {
                    return false;
                }
            },
            enumerable: true,
            configurable: true
        });

        GameBase.prototype.toggleBgm = function () {
            if (this.bgmOn) {
                this.prefs["bgmOn"] = "false";
                this.sound.stopAll();
            } else {
                this.prefs["bgmOn"] = "true";
                if (this.state.current === "GameForm")
                    this.sound.play("stagebgm", 1, true);
            }
            this.savePrefs();
        };

        GameBase.prototype.toggleAnime = function () {
            if (this.prefs["animeOn"] == null || (this.prefs["animeOn"] === "true")) {
                this.prefs["animeOn"] = "false";
            } else {
                this.prefs["animeOn"] = "true";
            }
            this.savePrefs();
        };
        GameBase.prefName = "";
        return GameBase;
    })(Phaser.Game);
    MfTool.GameBase = GameBase;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var GameApp = (function (_super) {
        __extends(GameApp, _super);
        function GameApp(winwidth, winheight, assetpath) {
            _super.call(this, winwidth, winheight, assetpath);

            this.state.add("Boot", MfTool.Boot, false);
            this.state.add("Preloader", MfTool.Preloader, false);
            this.state.add("LogoForm", MfTool.LogoForm, false);
            this.state.add("Demo1Form", MfTool.Demo1Form, false);
            this.state.add("Demo2Form", MfTool.Demo2Form, false);
            this.state.add("TitleForm", MfTool.TitleForm, false);
            this.state.add("GameForm", SinkeiSuijyaku.GameForm, false);
        }
        GameApp.prototype.execCommand = function (cmd) {
            var currentState;
            switch (cmd) {
                case "initGame":
                     {
                        this.navi.currentPanel = null;
                        currentState = this.state.getCurrentState();
                        currentState.clickStartAndfadeOut();
                    }
                    break;
                case "loadGame":
                     {
                        this.navi.currentPanel = null;
                        currentState = this.state.getCurrentState();
                        currentState.clickStartAndfadeOut();
                    }
                    break;
                default:
                    break;
            }
        };

        GameApp.prototype.execLink = function (naviLinkDef) {
            this.navi.execLinkFromState(naviLinkDef);
        };

        GameApp.prototype.getPrefName = function () {
            return "mfcontpref";
        };
        return GameApp;
    })(MfTool.GameBase);
    MfTool.GameApp = GameApp;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var PanelBound = (function () {
        function PanelBound() {
            this.ancPos = new Phaser.Point(0, 0);
        }
        PanelBound.prototype.setByRatio = function (game, xpct, ypct, wpct, hpct) {
            this.posPct = new Phaser.Point(xpct, ypct);
            this.sizePct = new Phaser.Point(wpct, hpct);
        };

        PanelBound.prototype.setRatioByParent = function (xpct, ypct) {
            this.posPctByParent = new Phaser.Point(xpct, ypct);
        };

        PanelBound.prototype.getAbsPos = function (game) {
            return new Phaser.Point(game.width * this.posPct.x - this.sizePct.x * game.width * this.ancPos.x / 2, game.height * this.posPct.y - this.sizePct.y * game.height * this.ancPos.y / 2);
        };

        PanelBound.prototype.getPosByParent = function (game) {
            return new Phaser.Point(game.width * this.posPctByParent.x - this.sizePct.x * game.width * this.ancPos.x / 2, game.height * this.posPctByParent.y - this.sizePct.y * game.height * this.ancPos.y / 2);
        };

        PanelBound.prototype.getAbsPosFromLeftTop = function (game) {
            return new Phaser.Point(game.world.centerX + game.width * this.posPct.x, game.world.centerY + game.height * this.posPct.y);
        };

        PanelBound.prototype.getAbsSize = function (game) {
            return new Phaser.Point(game.width * this.sizePct.x, game.height * this.sizePct.y);
        };

        PanelBound.prototype.getAbsLeftTop = function (game) {
            return new Phaser.Point(game.width * this.posPct.x - game.width * this.sizePct.x / 2, game.height * this.posPct.y - game.height * this.sizePct.y / 2);
        };

        PanelBound.prototype.getLeftTopByParent = function (game) {
            return new Phaser.Point(game.width * this.posPctByParent.x - game.width * this.sizePct.x / 2, game.height * this.posPctByParent.y - game.height * this.sizePct.y / 2);
        };

        PanelBound.prototype.getAbsLeftTopFromLeftTop = function (game) {
            return new Phaser.Point(game.width * this.posPct.x - game.width * this.sizePct.x / 2 + game.world.centerX, game.height * this.posPct.y - game.height * this.sizePct.y / 2 + game.world.centerY);
        };

        PanelBound.prototype.setAbsLeftTopPosFromLeftTop = function (game, x, y) {
            this.posPct.x = (x - game.world.centerX + game.width * this.sizePct.x / 2) / game.width;
            this.posPct.y = (y - game.world.centerY + game.height * this.sizePct.y / 2) / game.height;
        };

        PanelBound.prototype.setRatioLeftTopPosFromLeftTop = function (game, xpct, ypct) {
            this.posPct.x = (xpct * game.width - game.world.centerX + game.width * this.sizePct.x / 2) / game.width;
            this.posPct.y = (ypct * game.height - game.world.centerY + game.height * this.sizePct.y / 2) / game.height;
        };

        PanelBound.prototype.makeShrinkBound = function (game, wpct, hpct) {
            var bound = new PanelBound();
            bound.setByRatio(game, this.posPct.x, this.posPct.y, this.sizePct.x - wpct, this.sizePct.y - hpct);
            bound.setRatioByParent(this.posPctByParent.x, this.posPctByParent.y);
            return bound;
        };

        PanelBound.prototype.clone = function () {
            var copy = new PanelBound();
            copy.posPct = new Phaser.Point(this.posPct.x, this.posPct.y);
            copy.sizePct = new Phaser.Point(this.sizePct.x, this.sizePct.y);
            copy.ancPos = new Phaser.Point(this.ancPos.x, this.ancPos.y);
            copy.posPctByParent = new Phaser.Point(this.posPctByParent.x, this.posPctByParent.y);
            return copy;
        };
        PanelBound.Zero = new Phaser.Point(0, 0);

        PanelBound.One = new Phaser.Point(1, 1);

        PanelBound.TextLeftTop = new Phaser.Point(-0.5, -0.5);
        return PanelBound;
    })();
    MfTool.PanelBound = PanelBound;
})(MfTool || (MfTool = {}));
var SinkeiSuijyaku;
(function (SinkeiSuijyaku) {
    var GameState = MfTool.GameState;

    var PanelBound = MfTool.PanelBound;

    var RoundToEndGroupCenter = MfTool.RoundToEndGroupCenter;

    var GameForm = (function (_super) {
        __extends(GameForm, _super);
        function GameForm() {
            _super.apply(this, arguments);
            this.boadCardNum = 50;
            this.scaleForDevice = 1;
        }
        GameForm.prototype.create = function () {
            var _this = this;
            this.scaleForDevice = 1;
            var scaleForMenu = 1;
            if (this.gameApp.smartPhoneMode) {
                this.scaleForDevice = 0.7;
                scaleForMenu = 1;
            }
            this.logic = new SinkeiSuijyaku.SinsuiiLogic(this);
            this.banmenPanel = this.naviUtil.setBackPanel("banmen", "stageback", null, PanelBound.Zero, PanelBound.One, null, null, new Phaser.Point(0.4, 0.4));

            this.sound.stopAll();
            if (this.gameApp.bgmOn) {
                this.sound.play("stagebgm", 1, true);
            }
            MfTool.Card.logic = this.logic;

            this.banmen = new MfTool.Banmen();

            this.calcSize();

            var forDebug = false;
            var dif = 1;
            if (forDebug)
                dif = 0;

            var requestboardXYnum = this.logic.calcXyNum(this.gameSize, MfTool.Card.width, MfTool.Card.height, this.scaleForDevice);

            this.boadCardNum = this.logic.calcCardNum(this.gameSize, MfTool.Card.width, MfTool.Card.height, this.scaleForDevice, requestboardXYnum, dif);
            this.banmen.initSinsuiBanmen(this.game, requestboardXYnum.x, requestboardXYnum.y, this.boadCardNum);

            this.cardLayer = new Phaser.Group(this.game);
            this.cardStack = new MfTool.CardStack(this.game, false, this.boadCardNum, this.cardLayer, this.scaleForDevice);

            this.score = new MfTool.ScorePanel(this.game, "numtex", 6);

            this.logic.initUi();

            this.setPosAndSize();

            this.naviPaletteAndDlog = this.naviUtil.navi;
            this.naviUtil.navi.commandTarget = this;

            this.menuButton = this.game.add.button(32 * scaleForMenu, 32 * scaleForMenu, "menuMainBtn", function () {
                return _this.clickMainButton();
            });
            this.menuButton.anchor.set(0.5, 0.5);
            this.menuButton.scale.set(scaleForMenu, scaleForMenu);
            this.menuButton.rotation = Math.PI / 4;

            this.cardStack.stack.forEach(function (c) {
                c.inputEnabled = true;
                c.events.onInputDown.add(c.touchCard, c);
            });
            this.rebuildState();

            this.game.input.onDown.add(this.forDebug, this);

            _super.prototype.create.call(this);
        };

        Object.defineProperty(GameForm.prototype, "gameApp", {
            get: function () {
                return this.game;
            },
            enumerable: true,
            configurable: true
        });

        GameForm.prototype.forDebug = function () {
        };
        GameForm.prototype.calcSize = function () {
            this.banmenPanel.resizeScreen(this.game);

            this.backSize = new Phaser.Point(this.game.width * 0.95, this.game.height * 0.95);
            this.gameSize = this.backSize.multiply(0.95, 0.95);

            this.banmen.setBanmenSize(this.gameSize.x, this.gameSize.y);
        };
        GameForm.prototype.setPosAndSize = function () {
            this.reSpreadCard();
            this.score.groupPanel.position.set(this.game.world.width - this.score.panelwidth * 1 - 80, this.game.world.height - 10);
        };

        GameForm.prototype.resize = function () {
            this.calcSize();
            this.setPosAndSize();
            this.naviPaletteAndDlog.resize();
        };
        GameForm.prototype.getNaviController = function () {
            return this.naviPaletteAndDlog;
        };

        GameForm.prototype.clickMainButton = function () {
            if (this.naviPaletteAndDlog.currentPanel != null && this.naviPaletteAndDlog.currentPanel.Name === "mainPalette") {
                var palette = this.naviPaletteAndDlog.currentForm;
                palette.close(this.naviPaletteAndDlog);
                this.game.add.tween(this.menuButton).to({ rotation: Math.PI / 4 }, 100, Phaser.Easing.Linear.None, true);

                return;
            }
            this.naviPaletteAndDlog.runNavi("mainPalette");
            this.menuButton.bringToTop();
            this.game.add.tween(this.menuButton).to({ rotation: -Math.PI / 4 }, 100, Phaser.Easing.Linear.None, true);
        };

        GameForm.prototype.rebuildState = function () {
            var num = this.boadCardNum;

            var poslist = this.banmen.poslist;
            for (var possig in poslist) {
                if (poslist.hasOwnProperty(possig)) {
                    if (num <= 0)
                        return;
                    var card = this.cardStack.randomPickToBoard();
                    card.moveBanpos(poslist[possig], new Phaser.Point(this.game.world.width / 2, this.game.world.height * 1.1));

                    this.banmen.itemlist[possig] = card;
                    num--;
                }
            }
        };

        GameForm.prototype.reSpreadCard = function () {
            var livecard = Array();
            for (var p = 0; p < this.cardStack.inBoard.length; p++) {
                var c = this.cardStack.inBoard[p];
                if (c != null)
                    livecard.push(c);
            }

            if (livecard.length === 0)
                return;
            var requestboardXYnum = this.logic.calcXyNum(this.gameSize, MfTool.Card.width, MfTool.Card.height, this.scaleForDevice);
            this.banmen.initSinsuiBanmen(this.game, requestboardXYnum.x, requestboardXYnum.y, livecard.length);

            var poslist = this.banmen.poslist;
            for (var possig in poslist) {
                if (poslist.hasOwnProperty(possig)) {
                    if (livecard.length === 0)
                        break;
                    var card = livecard.pop();
                    card.moveBanpos(poslist[possig], card.position, false);
                    this.banmen.itemlist[possig] = card;
                    card.bringToTop();
                }
            }
        };

        GameForm.prototype.scoreUp = function (point) {
            this.score.addScore(point);
        };

        GameForm.prototype.execCommand = function (cmd) {
            switch (cmd) {
                case "toggleBgm":
                    this.game.toggleBgm();
                    break;
                case "openUrl":
                    this.openUrl("http://akibakokoubou.jp/blog/?p=4643");
                    break;
                case "doHelp":
                    this.openUrl("file://assets/help.html");
                    break;
                case "toggleAnime":
                    this.game.toggleAnime();
                    break;
                default:
                    break;
            }
        };

        GameForm.prototype.openUrl = function (url) {
            var newwin = window.open(url, "_blank");
            if (window.focus) {
                newwin.focus();
            }
        };

        GameForm.prototype.clearStage = function () {
            this.game.sound.stopAll();
            if (this.gameApp.bgmOn)
                this.game.sound.play("win");

            this.ringEffect(this.game.world.centerX, this.game.world.centerY, "bring", 3);
            this.ringEffect(this.game.world.centerX, this.game.world.centerY, "rring", 3);

            this.winPanel = this.naviUtil.setText("win", "Clear!", this.banmenPanel, new Phaser.Point(0, -0.1), PanelBound.One, new RoundToEndGroupCenter(), { "center": "true", "font": "bold96", "color": "0xffffff" });
            this.naviUtil.rootPanel.showPlayAll();
            var scoredata = new MfTool.ScoreData("You", this.score.scorePoint);
            this.gameApp.addScore(scoredata);

            this.game.time.events.add(Phaser.Timer.SECOND * 3, this.askNext, this);
        };

        GameForm.prototype.askNext = function () {
            this.winPanel.alpha = 0;
            this.naviUtil.navi.runNavi("ranking");
        };

        GameForm.prototype.ringEffect = function (x, y, splitename, ringnum, startdelay) {
            if (typeof startdelay === "undefined") { startdelay = 0; }
            var emitter = this.game.add.emitter(x, y, ringnum);
            emitter.makeParticles(splitename);
            emitter.gravity = 0;

            emitter.width = 30;
            emitter.height = 30;
            emitter.setRotation(0, Math.PI * 2);
            emitter.setAlpha(1, 0, 1500, Phaser.Easing.Linear.None);
            emitter.setScale(0.5, 2, 0.5, 2, 1500, Phaser.Easing.Exponential.Out);
            emitter.start(true, 1500, null, 10);
        };
        return GameForm;
    })(GameState);
    SinkeiSuijyaku.GameForm = GameForm;
})(SinkeiSuijyaku || (SinkeiSuijyaku = {}));
var MfTool;
(function (MfTool) {
    var LogicBase = (function () {
        function LogicBase(g, ui) {
            this.game = g;
            this.uilogic = ui;
        }
        LogicBase.prototype.touchItem = function (item) {
        };

        LogicBase.prototype.scoreUp = function (point) {
        };

        LogicBase.prototype.initUi = function () {
        };
        return LogicBase;
    })();
    MfTool.LogicBase = LogicBase;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var LogoForm = (function (_super) {
        __extends(LogoForm, _super);
        function LogoForm() {
            _super.apply(this, arguments);
        }
        LogoForm.prototype.create = function () {
            var basepanel = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id, "titlepage", null, new Phaser.Point(0, 0), new Phaser.Point(0.8, 0.8));

            var logo = this.add.sprite(this.game.world.centerX, this.game.world.centerY, "logo");
            logo.anchor.set(0.5, 0.5);
            if (this.getApp().animeOn) {
                logo.scale.set(0.01, 0.01);
                this.game.add.tween(logo.scale).to({ x: 1, y: 1 }, 1000, Phaser.Easing.Elastic.Out, true);
            } else {
                logo.scale.set(1, 1);
            }

            this.naviUtil.rootPanel.showPlay();

            _super.prototype.create.call(this);
        };
        return LogoForm;
    })(MfTool.NaviBaseFormState);
    MfTool.LogoForm = LogoForm;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var NaviBaseFormUtil = (function () {
        function NaviBaseFormUtil(game, targetForm, paneldef, args) {
            this.panelList = {};
            this.textBoxList = {};
            this.game = game;
            this.paneldef = paneldef;
            this.args = args;
            this.targetForm = targetForm;
        }
        NaviBaseFormUtil.prototype.makeUiLayer = function () {
            this.uiLayer = new MfTool.PanelSprite(this.game, "uiLayer", null, this.rootPanel, new Phaser.Point(0, 0), new Phaser.Point(1, 1));

            this.blind = new Phaser.Sprite(this.game, 0, 0, "black");
            this.uiLayer.group.add(this.blind);
            this.blind.width = this.game.world.width;
            this.blind.height = this.game.world.height;
            this.blind.anchor.set(0.5, 0.5);
            this.blind.visible = false;
            this.blind.inputEnabled = false;
        };

        NaviBaseFormUtil.prototype.addButtons = function (game, parentpanel, posPct, sizePct, pushButton, timedLink, anyTap, buttonAlignList, anc) {
            if (typeof pushButton === "undefined") { pushButton = null; }
            if (typeof timedLink === "undefined") { timedLink = null; }
            if (typeof anyTap === "undefined") { anyTap = null; }
            if (typeof buttonAlignList === "undefined") { buttonAlignList = null; }
            if (typeof anc === "undefined") { anc = null; }
            var buttonBlock = new MfTool.ButtonGroup(game, "bl", this.paneldef.LinkList, parentpanel, "navibtn", posPct, sizePct, function (a, b) {
                if (pushButton != null)
                    pushButton(a, b);
            }, function (c) {
                if (timedLink != null)
                    timedLink(c);
            }, function (c) {
                if (anyTap != null)
                    anyTap(c);
            }, buttonAlignList, anc);
            this.baseTapId = buttonBlock.baseTapId;
        };

        NaviBaseFormUtil.prototype.setText = function (name, text, parentname, posPct, sizePct, fact, prop) {
            if (typeof fact === "undefined") { fact = null; }
            if (typeof prop === "undefined") { prop = null; }
            var store = new MfTool.PanelText(this.game, text, name, parentname, posPct, sizePct, null, fact, prop);
            if (this.textBoxList[name] != null) {
                throw new Error("Duplicate name");
            }
            this.textBoxList[name] = store;
            return store;
        };

        NaviBaseFormUtil.prototype.setBackPanel = function (name, bg, parentname, posPct, sizePct, anc, offset, p9Ratio) {
            if (typeof anc === "undefined") { anc = null; }
            if (typeof offset === "undefined") { offset = null; }
            if (typeof p9Ratio === "undefined") { p9Ratio = null; }
            var store = new MfTool.PanelSprite(this.game, name, bg, parentname, posPct, sizePct, anc, offset, p9Ratio);
            if (parentname == null) {
                this.rootPanel = store;
            }
            if (this.panelList[name] != null) {
                throw new Error("Duplicated name");
            }
            this.panelList[name] = store;
            return store;
        };

        NaviBaseFormUtil.prototype.setupForPanel = function (form, navi, posPct, sizePct) {
            this.navi = navi;
            var store = new MfTool.PanelSprite(this.game, "panelorigin", null, null, posPct, sizePct);
            this.panelList["panelorigin"] = store;
            this.rootPanel = store;
        };

        NaviBaseFormUtil.prototype.resizePanel = function () {
            if (this.rootPanel != null)
                this.rootPanel.resizeScreen(this.game);

            this.blind.width = this.game.world.width;
            this.blind.height = this.game.world.height;
        };

        NaviBaseFormUtil.prototype.update = function () {
        };

        NaviBaseFormUtil.prototype.destroy = function () {
            if (this.rootPanel != null) {
                this.rootPanel.destroy();
                this.rootPanel = null;
            }
            if (this.uiLayer != null) {
                this.uiLayer.destroy();
                this.uiLayer = null;
            }
            this.panelList = {};
            this.textBoxList = {};
        };

        NaviBaseFormUtil.prototype.showBlind = function (show) {
            if (show) {
                this.blind.visible = true;
                this.blind.alpha = 0.5;
                this.blind.inputEnabled = true;
            } else {
                this.blind.alpha = 0;
                this.blind.inputEnabled = false;
                this.blind.visible = false;
            }
        };
        return NaviBaseFormUtil;
    })();
    MfTool.NaviBaseFormUtil = NaviBaseFormUtil;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var NaviController = (function () {
        function NaviController(game, target) {
            this.moduleList = [];
            this.game = game;
            this.commandTarget = target;
        }
        NaviController.prototype.runNavi = function (runname, args) {
            this.args = args;

            for (var pid in MfTool.NaviPanelDef.panelList) {
                if (MfTool.NaviPanelDef.panelList.hasOwnProperty(pid)) {
                    if (MfTool.NaviPanelDef.panelList[pid].Name === runname) {
                        return this.makePanel(MfTool.NaviPanelDef.panelList[pid]);
                    }
                }
            }
            return null;
        };
        NaviController.prototype.runNaviById = function (runid) {
            return this.makePanel(MfTool.NaviPanelDef.panelList[runid]);
        };

        NaviController.prototype.makePanel = function (panel) {
            if (this.currentForm != null) {
                this.closeForm();
            }
            this.currentPanel = panel;
            if (this.currentPanel == null)
                return null;

            var q;
            if (this.currentPanel.Template != null) {
                if (this.game.state.checkState(this.currentPanel.Template)) {
                    this.game.state.start(this.currentPanel.Template, true, false, this.currentPanel, this.args);
                    return null;
                }

                for (var i = 0; i < this.moduleList.length; i++) {
                    q = window[this.moduleList[i]][this.currentPanel.Template];
                    if (q != null)
                        break;
                }
                if (q == null) {
                    q = window["MfTool"][this.currentPanel.Template];
                }
                if (q == null) {
                    q = window["MfTool"]["NaviBaseFormPanel"];
                }
            }
            if (q != null) {
                var r = q.prototype;
                var s = Object.create(r);
                this.currentForm = s.create(this.game, this.currentPanel, this, this.args);
                s.naviUtil.rootPanel.group.visible = true;

                return this.currentForm;
            }
            return null;
        };

        NaviController.prototype.addModule = function (name) {
            this.moduleList.push(name);
        };

        NaviController.prototype.closeForm = function () {
            if (this.currentForm != null) {
                this.currentForm.destroy();
            }
            this.currentForm = null;
            this.currentPanel = null;
        };

        NaviController.prototype.resize = function () {
            if (this.currentForm != null) {
                this.currentForm.resize();
            }
        };

        NaviController.prototype.execLink = function (link) {
            if (this.inLinkRunning)
                return;
            this.game.time.events.clearPendingEvents();
            var cmd = link.Property["cmd"];
            if (cmd != null) {
                if (this.commandTarget != null)
                    this.commandTarget.execCommand(cmd);
                else {
                    console.info('NaviController Command:' + cmd);
                }
            }
            if (link.NextPanel != null) {
                if (this.currentPanel != null && link.NextPanel === this.currentPanel.Id) {
                    return;
                }

                if (link.Property["linkdelay"] != null) {
                    this.inLinkRunning = true;
                    this.game.time.events.add(Phaser.Timer.SECOND * parseFloat(link.Property["linkdelay"]), this.delayLink, this, link);
                    return;
                }
                this.closeForm();
                this.runNaviById(link.NextPanel);
            } else {
                this.closeForm();
            }
        };

        NaviController.prototype.delayLink = function (link) {
            this.closeForm();
            this.runNaviById(link.NextPanel);
        };

        NaviController.prototype.execLinkFromState = function (link) {
            if (this.inLinkRunning)
                return;
            this.game.time.events.clearPendingEvents();
            var cmd = link.Property["cmd"];
            if (cmd != null) {
                if (this.commandTarget != null)
                    this.commandTarget.execCommand(cmd);
                else {
                    console.info('NaviController Command:' + cmd);
                }
            }
            if (link.NextPanel != null) {
                if (this.currentPanel != null && link.NextPanel === this.currentPanel.Id) {
                    return;
                }

                if (link.Property["linkdelay"] != null) {
                    this.inLinkRunning = true;
                    this.game.time.events.add(Phaser.Timer.SECOND * parseFloat(link.Property["linkdelay"]), this.delayLinkFromState, this, link);
                    return;
                }
                this.runNaviById(link.NextPanel);
            }
        };

        NaviController.prototype.delayLinkFromState = function (link) {
            this.inLinkRunning = false;
            this.runNaviById(link.NextPanel);
        };
        return NaviController;
    })();
    MfTool.NaviController = NaviController;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var NaviPanelDef = (function () {
        function NaviPanelDef() {
            this.LinkList = {};
        }
        NaviPanelDef.loadJson = function (url, compcallback) {
            if (typeof compcallback === "undefined") { compcallback = null; }
            var request = new XMLHttpRequest();
            if (compcallback != null) {
                request.onload = (function (ev) {
                    NaviPanelDef.panelList = JSON.parse(ev.target.responseText);

                    if (compcallback)
                        compcallback();
                });
            }
            request.open("get", url, (compcallback != null));
            request.send();
            if (compcallback == null) {
                NaviPanelDef.panelList = JSON.parse(request.responseText);
            }
        };

        NaviPanelDef.setLangage = function (locale) {
            NaviPanelDef.useLang = locale;
        };
        NaviPanelDef.panelList = {};

        NaviPanelDef.useLang = "ja";
        return NaviPanelDef;
    })();
    MfTool.NaviPanelDef = NaviPanelDef;

    var NaviLinkDef = (function () {
        function NaviLinkDef() {
            this.Property = {};
        }
        return NaviLinkDef;
    })();
    MfTool.NaviLinkDef = NaviLinkDef;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var NumSplite = (function (_super) {
        __extends(NumSplite, _super);
        function NumSplite(game, x, y) {
            _super.call(this, game, x, y, "numtex", 0);
            this.anchor.set(0, 1);
            this.tint = 0xff9552;
            this.value = 0;
        }
        NumSplite.prototype.setValue = function (val, withMotion) {
            if (typeof withMotion === "undefined") { withMotion = true; }
            if (withMotion && this.value !== val) {
                this.value = val;
                var y0 = this.position.y;
                this.game.add.tween(this).to({ y: -30 }, 50, Phaser.Easing.Cubic.Out, true).onComplete.add(this.bounce, this);
            }
            this.value = val;
            this.frame = val;
        };

        NumSplite.prototype.bounce = function () {
            this.frame = this.value;
            this.game.add.tween(this).to({ y: 0 }, 200, Phaser.Easing.Bounce.Out, true);
        };
        NumSplite.panelWidth = 21;
        NumSplite.panelHeight = 32;
        return NumSplite;
    })(Phaser.Sprite);
    MfTool.NumSplite = NumSplite;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var PaletteForm = (function (_super) {
        __extends(PaletteForm, _super);
        function PaletteForm() {
            _super.apply(this, arguments);
        }
        PaletteForm.prototype.create = function (game, paneldef, navi) {
            var _this = this;
            this.naviUtil = new MfTool.NaviBaseFormUtil(game, this, paneldef, null);
            this.naviUtil.setupForPanel(this, navi, new Phaser.Point(0, 0), new Phaser.Point(1, 1));
            var devscale = game.smartPhoneMode ? 1.5 : 1;

            this.back = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id, "titlepage", null, new Phaser.Point(-0.5, -0.45), new Phaser.Point(0.3, 0.5), new Phaser.Point(-1, -1));
            this.back.setOrigin(game, new Phaser.Point(-0.8, -0.45), new Phaser.Point(0.3, 0.5), new Phaser.Point(-1, -1));
            this.back.setTarget(game, new Phaser.Point(-0.5, -0.45), new Phaser.Point(0.3, 0.5), new Phaser.Point(-1, -1));
            this.back.setMotion(game, 200, new MfTool.MoveLinerPanelFactory());
            var font = null;
            if (this.getApp().smartPhoneMode) {
                MfTool.Button9P.textProp = { "center": "true", "font": "bold10" };
            } else {
                MfTool.Button9P.textProp = { "center": "true", "font": "bold16" };
            }

            this.naviUtil.addButtons(game, this.back, new Phaser.Point(-0.475, -0.475), new Phaser.Point(0.95, 0.95), function (b) {
                _this.pushButton(b);
            }, function (k) {
                _this.timedLink(k);
            }, null, new Phaser.Point(1, 0));
            MfTool.Button9P.textProp = { "center": "true" };

            this.naviUtil.rootPanel.showPlayAll();

            return this;
        };

        PaletteForm.prototype.close = function (navi) {
            var _this = this;
            this.back.setOrigin(this.back.group.game, new Phaser.Point(-0.5, -0.45), new Phaser.Point(0.3, 0.5), new Phaser.Point(-1, -1));
            this.back.setTarget(this.back.group.game, new Phaser.Point(-0.8, -0.45), new Phaser.Point(0.3, 0.5), new Phaser.Point(-1, -1));
            this.back.setMotion(this.back.group.game, 200, new MfTool.MoveLinerPanelFactory(function () {
                _this.closeEnd(navi);
            }));

            this.naviUtil.rootPanel.showPlayAll();
        };

        PaletteForm.prototype.closeEnd = function (navi) {
            navi.closeForm();
        };

        PaletteForm.prototype.destroy = function () {
            _super.prototype.destroy.call(this);
        };

        PaletteForm.loadContents = function (loader, basepath) {
            loader.spritesheet("menuMainBtn", basepath + "assets/menumbtn.png", 64, 64);
            loader.spritesheet("palback", basepath + "assets/bbg6464.png", 64, 64);
        };
        return PaletteForm;
    })(MfTool.NaviBaseFormPanel);
    MfTool.PaletteForm = PaletteForm;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var FadeInPanelFactory = (function () {
        function FadeInPanelFactory() {
        }
        FadeInPanelFactory.prototype.assignTween = function (game, panel, during) {
            panel.alpha = 0;
            this.tween = game.add.tween(panel).to({ alpha: 1 }, during, Phaser.Easing.Linear.None);
        };

        FadeInPanelFactory.prototype.runMotion = function (panel) {
            this.tween.start();
        };
        return FadeInPanelFactory;
    })();
    MfTool.FadeInPanelFactory = FadeInPanelFactory;

    var MoveLinerPanelFactory = (function () {
        function MoveLinerPanelFactory(callback) {
            if (typeof callback === "undefined") { callback = null; }
            this.callback = callback;
        }
        MoveLinerPanelFactory.prototype.assignTween = function (game, panel, during) {
            var _this = this;
            var posOrg = panel.panelBoundOrg.getPosByParent(game);
            var posTarget = panel.panelBound.getPosByParent(game);
            var sizeOrg = panel.panelBoundOrg.getAbsSize(game);
            var sizeTarget = panel.panelBound.getAbsSize(game);
            panel.width = sizeOrg.x;
            panel.height = sizeOrg.y;
            if (panel.parentPanel != null) {
            } else {
                posOrg.set(game.world.centerX + posOrg.x, game.world.centerY + posOrg.y);
                posTarget.set(game.world.centerX + posTarget.x, game.world.centerY + posTarget.y);
            }
            panel.group.position.set(posOrg.x, posOrg.y);

            this.tweensize = game.add.tween(panel).to({ width: sizeTarget.x, height: sizeTarget.y }, during, Phaser.Easing.Linear.None);
            this.tweenpos = game.add.tween(panel.group.position).to({ x: posTarget.x, y: posTarget.y }, during, Phaser.Easing.Linear.None);
            this.posOrg = posOrg;
            this.sizeOrg = sizeOrg;
            if (this.callback != null) {
                this.tweenpos.onComplete.add(function () {
                    _this.callback();
                }, this);
            }
        };

        MoveLinerPanelFactory.prototype.runMotion = function (panel) {
            panel.width = this.sizeOrg.x;
            panel.height = this.sizeOrg.y;
            panel.group.position.set(this.posOrg.x, this.posOrg.y);
            this.tweensize.start();
            this.tweenpos.start();
        };
        return MoveLinerPanelFactory;
    })();
    MfTool.MoveLinerPanelFactory = MoveLinerPanelFactory;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var Preloader = (function (_super) {
        __extends(Preloader, _super);
        function Preloader() {
            _super.apply(this, arguments);
        }
        Preloader.prototype.preload = function () {
            this.preloadBar = this.add.sprite(200, 250, "preloadBar");

            var barscale = 1;
            if (this.preloadBar.width > this.world.width * 0.8) {
                barscale = Math.min(barscale, this.world.width * 0.8 / this.preloadBar.width);
            }
            if (this.preloadBar.height > this.world.height * 0.8) {
                barscale = Math.min(barscale, this.world.height * 0.8 / this.preloadBar.height);
            }
            this.preloadBar.scale.set(barscale, 1);
            this.preloadBar.anchor.set(0, 1);
            this.preloadBar.position.set(this.game.world.width - this.preloadBar.width * 1.1, this.game.world.height * 0.9);
            this.load.setPreloadSprite(this.preloadBar);

            this.load.spritesheet("cardback", $basePath + "assets/bcd136_150_2.png", 136, 150);
            this.load.image("titlepage", $basePath + "assets/rpanel63_63.png");
            this.load.image("brankback", $basePath + "assets/wbg6464.png");
            this.load.image("stageback", $basePath + "assets/ban200_200_80_40_80.png");

            this.load.image("transpanel", $basePath + "assets/trans6464.png");
            this.load.image("white", $basePath + "assets/white64_64.png");
            this.load.image("black", $basePath + "assets/black64_64.png");
            this.load.image("logo", $basePath + "assets/logo256256.png");

            MfTool.ComboTip.loadContents(this.load, $basePath);

            this.load.audio("stagebgm", [$basePath + "assets/stage1bgm.mp3", $basePath + "assets/stage1bgm.ogg"]);

            this.load.audio("startse", [$basePath + "assets/start.mp3", $basePath + "assets/start.ogg"]);
            this.load.audio("clickse", [$basePath + "assets/cursor1.mp3", $basePath + "assets/cursor1.ogg"]);
            this.load.audio("correctse", [$basePath + "assets/correct2.mp3", $basePath + "assets/correct2.ogg"]);
            this.load.audio("tapse", [$basePath + "assets/cursor2.mp3", $basePath + "assets/cursor2.ogg"]);
            this.load.audio("tap2se", [$basePath + "assets/cursor8.mp3", $basePath + "assets/cursor8.ogg"]);
            this.load.audio("win", [$basePath + "assets/decision4.mp3", $basePath + "assets/decision4.ogg"]);
            this.load.audio("buse", [$basePath + "assets/bu.mp3", $basePath + "assets/bu.ogg"]);

            this.load.image("clearmark", $basePath + "assets/win.png");

            this.load.spritesheet("title1", $basePath + "assets/title1.png", 320, 240);
            this.load.spritesheet("title2", $basePath + "assets/title2.png", 320, 240);
            this.load.image("starttxt", $basePath + "assets/start185_41.png");

            this.load.image("bring", $basePath + "assets/bring64_64.png");
            this.load.image("rring", $basePath + "assets/rring64_64.png");

            this.load.image("cat", $basePath + "assets/cat140_216.png");
            this.load.image("rabit", $basePath + "assets/rabit140_220.png");

            MfTool.Card.loadContents(this.load, $basePath);

            MfTool.ScorePanel.loadContents(this.load, $basePath);

            this.load.image("naviback", $basePath + "assets/bbg6464.png");
            this.load.spritesheet("navibtn", $basePath + "assets/rpanel63_63_3.png", 63, 63);

            MfTool.PaletteForm.loadContents(this.load, $basePath);
        };

        Preloader.prototype.create = function () {
            this.add.tween(this.preloadBar).to({ alpha: 0 }, 1000, Phaser.Easing.Linear.None, true).onComplete.add(this.startMainMenu, this);
        };

        Preloader.prototype.startMainMenu = function () {
            var g = this.game;
            g.startGame();
        };
        return Preloader;
    })(Phaser.State);
    MfTool.Preloader = Preloader;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var RankForm = (function (_super) {
        __extends(RankForm, _super);
        function RankForm() {
            _super.apply(this, arguments);
        }
        RankForm.prototype.create = function (game, paneldef, navi, args) {
            var _this = this;
            this.naviUtil = new MfTool.NaviBaseFormUtil(game, this, paneldef, args);
            this.naviUtil.setupForPanel(this, navi, MfTool.PanelBound.Zero, MfTool.PanelBound.One);
            this.naviUtil.makeUiLayer();

            var textstore = this.naviUtil.setText(paneldef.Id + "_bodytext", this.naviUtil.paneldef.Body, this.naviUtil.rootPanel, new Phaser.Point(0, -0.4), MfTool.PanelBound.One, null, { "center": "true", "color": "0xffffff" });

            var list = this.getApp().scoreList;
            var text = "";
            var text2 = "";
            for (var i = 0; i < list.length; i++) {
                var sc = list[i];
                text = text + sc.toShortText() + "\n";
                text2 = text2 + sc.toShortDate() + "\n";
            }

            var textstore2 = this.naviUtil.setText(paneldef.Id + "_bodytext2", text, this.naviUtil.rootPanel, new Phaser.Point(-0.4, -0.3), MfTool.PanelBound.One, null, { "color": "0xffffff" });
            var textstore3 = this.naviUtil.setText(paneldef.Id + "_bodytext4", text2, this.naviUtil.rootPanel, new Phaser.Point(0, -0.3), MfTool.PanelBound.One, null, { "color": "0xffffff" });
            if (this.getApp().animeOn) {
                textstore2.setMotion(new MfTool.FlightFromLeft(50));
                textstore3.setMotion(new MfTool.FlightFromLeft(50));
            }

            this.naviUtil.addButtons(game, this.naviUtil.rootPanel, new Phaser.Point(-0.45, 0.2), new Phaser.Point(0.5, 0.23), function (b) {
                _this.pushButton(b);
            }, function (k) {
                _this.timedLink(k);
            }, function (m) {
                _this.tapAny(m);
            });

            this.naviUtil.showBlind(true);

            this.naviUtil.rootPanel.showPlayAll();
            return this;
        };
        return RankForm;
    })(MfTool.NaviBaseFormPanel);
    MfTool.RankForm = RankForm;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var ScoreData = (function () {
        function ScoreData(name, score) {
            this.rank = 0;
            this.playername = "";
            this.date = "";
            this.time = "";
            this.score = 0;
            this.addition = null;
            this.playername = name;
            this.score = score;

            var time = new Date(Date.now());
            var datestr = time.getFullYear().toString() + "/" + (time.getMonth() + 1).toString() + "/" + time.getDate().toString();
            this.date = datestr;
            var timestr = ("0" + time.getHours()).slice(-2) + ":" + ("0" + time.getMinutes()).slice(-2);
            this.time = timestr;
        }
        ScoreData.prototype.toText = function () {
            return this.rank.toString() + ":" + this.playername + ":" + this.score.toString() + "[" + this.date + " " + this.time + "]";
        };

        ScoreData.prototype.toShortText = function () {
            return this.rank.toString() + ":" + this.playername + ":" + this.score.toString();
        };

        ScoreData.parse = function (d) {
            var list = Array();
            for (var s in d) {
                if (d.hasOwnProperty(s)) {
                    var r = d[s];
                    var q = new ScoreData(r.playername, r.score);
                    q.rank = r.rank;
                    q.date = r.date;
                    q.time = r.time;
                    q.addition = r.addition;
                    list.push(q);
                }
            }
            return list;
        };

        ScoreData.sortRank = function (list) {
            var lt = Array();
            for (var r in list) {
                if (list.hasOwnProperty(r)) {
                    var k = list[r];
                    lt.push(k);
                }
            }
            var sorted = lt.sort(function (a, b) {
                return a.rank - b.rank;
            });
            return sorted;
        };

        ScoreData.toJson = function (list, maxlength) {
            if (typeof maxlength === "undefined") { maxlength = 9; }
            var outlist = {};
            var sorted = list.sort(function (a, b) {
                return a.rank - b.rank;
            });
            var savelen = Math.min(maxlength, sorted.length);
            for (var i = 0; i < savelen; i++) {
                var s = list[i];
                outlist[s.rank] = s;
            }
            return outlist;
        };
        ScoreData.addScore = function (score, list, maxlength) {
            if (typeof maxlength === "undefined") { maxlength = 9; }
            var sorted = list.sort(function (a, b) {
                return a.rank - b.rank;
            });
            var nextlist = [];
            var shift = 0;
            var maxrank = 0;
            for (var i = 0; i < sorted.length; i++) {
                var r = sorted[i];
                if (score.score >= r.score && shift === 0) {
                    score.rank = r.rank;
                    maxrank = Math.max(maxrank, score.rank);
                    nextlist.push(score);
                    shift = 1;
                }
                r.rank = r.rank + shift;
                nextlist.push(r);
                maxrank = Math.max(maxrank, r.rank);
            }
            if (sorted.length < maxlength && shift === 0) {
                score.rank = maxrank + 1;
                nextlist.push(score);
            }
            return ScoreData.toJson(nextlist, maxlength);
        };

        ScoreData.prototype.toShortDate = function () {
            return "[" + this.date + "]";
        };
        return ScoreData;
    })();
    MfTool.ScoreData = ScoreData;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var ScorePanel = (function () {
        function ScorePanel(game, texname, colnum) {
            this.numberPanelList = [];
            this.kColNum = 6;
            this.kColNum = colnum;
            this.groupPanel = game.add.group();

            this.groupPanel.position.set(game.world.centerX - this.kColNum * MfTool.NumSplite.panelWidth / 2, game.world.centerY);
            for (var i = 0; i < this.kColNum; i++) {
                var nsp = new MfTool.NumSplite(game, (i + 1) * MfTool.NumSplite.panelWidth, 0);
                this.groupPanel.add(nsp);
                this.numberPanelList.push(nsp);
            }
            var minussp = new MfTool.NumSplite(game, 0, 0);
            this.groupPanel.add(minussp);
            this.numberPanelList.push(minussp);
            minussp.setValue(10, false);
            minussp.alpha = 0;

            this.setScore(0);

            this.panelwidth = (MfTool.NumSplite.panelWidth + 3) * colnum;
            this.panelHeight = MfTool.NumSplite.panelHeight;
        }
        ScorePanel.loadContents = function (loader, assetpath) {
            loader.spritesheet("numtex", assetpath + "assets/scorenum21_32_13.png", MfTool.NumSplite.panelWidth, MfTool.NumSplite.panelHeight);
        };

        ScorePanel.prototype.addScore = function (point) {
            this.scoreValue += point;
            this.setScore(this.scoreValue);
        };
        ScorePanel.prototype.setScore = function (point) {
            this.scoreValue = point;
            var sub = 0;

            var minussp = this.numberPanelList[this.groupPanel.children.length - 1];
            if (this.scoreValue < 0) {
                minussp.alpha = 1;
                point = -point;
            } else {
                minussp.alpha = 0;
            }

            for (var i = this.groupPanel.children.length - 1 - 1; i >= 0; i--) {
                var pos = Math.pow(10, i);
                var val = ((point - sub) / pos) | 0;
                this.groupPanel.children[this.groupPanel.children.length - 1 - 1 - i].setValue(val);
                point -= val * pos;
            }
        };

        Object.defineProperty(ScorePanel.prototype, "scorePoint", {
            get: function () {
                return this.scoreValue;
            },
            enumerable: true,
            configurable: true
        });
        return ScorePanel;
    })();
    MfTool.ScorePanel = ScorePanel;
})(MfTool || (MfTool = {}));
var MfTool;
(function (MfTool) {
    var ShortCreditForm = (function (_super) {
        __extends(ShortCreditForm, _super);
        function ShortCreditForm() {
            _super.apply(this, arguments);
        }
        ShortCreditForm.prototype.create = function (game, paneldef, navi, args) {
            var _this = this;
            this.naviUtil = new MfTool.NaviBaseFormUtil(game, this, paneldef, args);
            this.naviUtil.setupForPanel(this, navi, new Phaser.Point(0, 0), new Phaser.Point(1, 1));
            this.naviUtil.makeUiLayer();

            var textstore = this.naviUtil.setText(paneldef.Id + "_bodytext", this.naviUtil.paneldef.Body, this.naviUtil.rootPanel, new Phaser.Point(0, -0.2), new Phaser.Point(0.9, 0.9), null, { "center": "true", "color": "0xffffff" });
            if (this.getApp().animeOn) {
                textstore.setMotion(new MfTool.TypeWriterSmooth());
            }

            this.naviUtil.addButtons(game, this.naviUtil.rootPanel, new Phaser.Point(-0.45, 0.2), new Phaser.Point(0.5, 0.23), function (b) {
                _this.pushButton(b);
            }, function (k) {
                _this.timedLink(k);
            }, function (m) {
                _this.tapAny(m);
            });

            this.naviUtil.showBlind(true);

            this.naviUtil.rootPanel.showPlayAll();

            return this;
        };
        return ShortCreditForm;
    })(MfTool.NaviBaseFormPanel);
    MfTool.ShortCreditForm = ShortCreditForm;
})(MfTool || (MfTool = {}));
var SinkeiSuijyaku;
(function (SinkeiSuijyaku) {
    var SinsuiiLogic = (function (_super) {
        __extends(SinsuiiLogic, _super);
        function SinsuiiLogic(uilogic) {
            _super.call(this, uilogic.game, uilogic);

            this.comboCount = 0;
        }
        SinsuiiLogic.prototype.initUi = function () {
            this.combo1 = new MfTool.ComboTip(this.game, 0xfff42c);
            this.combo2 = new MfTool.ComboTip(this.game, 0xfff42c);
        };

        SinsuiiLogic.prototype.getUiLogic = function () {
            return this.uilogic;
        };

        SinsuiiLogic.prototype.touchItem = function (item) {
            if (this.selone == null) {
                if (this.getUiLogic().gameApp.bgmOn)
                    this.uilogic.sound.play("clickse", 1);

                this.game.input.disabled = true;
                this.selone = item;
                this.selone.flipCard().onComplete.add(this.inputEnable, this);
            } else {
                this.seltwo = item;
                if (this.selone === this.seltwo) {
                } else if (this.selone.no === this.seltwo.no) {
                    this.game.input.disabled = true;
                    this.seltwo.flipCard().onComplete.add(this.waitAndTake, this);
                } else {
                    this.comboCount = 0;
                    this.scoreUp(-1);
                    this.game.input.disabled = true;
                    if (this.getUiLogic().gameApp.bgmOn)
                        this.uilogic.sound.play("buse", 1);
                    this.seltwo.flipCard().onComplete.add(this.backCardWait, this);
                }
            }
            _super.prototype.touchItem.call(this, item);
        };

        SinsuiiLogic.prototype.backCardWait = function () {
            var _this = this;
            setTimeout(function () {
                return _this.backCard();
            }, 1000);
        };

        SinsuiiLogic.prototype.backCard = function () {
            if (this.seltwo != null) {
                this.seltwo.flipCard();
            }
            if (this.selone != null) {
                this.selone.flipCard().onComplete.add(this.inputEnable, this);
            }
            this.selone = null;
            this.seltwo = null;
        };

        SinsuiiLogic.prototype.waitAndTake = function () {
            var _this = this;
            setTimeout(function () {
                return _this.takeCards();
            }, 500);
        };

        SinsuiiLogic.prototype.takeCards = function () {
            if (this.getUiLogic().gameApp.bgmOn)
                this.uilogic.sound.play("correctse", 0.5);
            var ui = this.uilogic;
            if (this.comboCount > 0) {
                var cno = this.comboCount - 1;
                if (cno >= 3) {
                    cno = 3;
                }
                this.combo1.showCombo(this.selone.position.x, this.selone.position.y - MfTool.Card.height / 2, cno);
                this.combo2.showCombo(this.seltwo.position.x, this.seltwo.position.y - MfTool.Card.height / 2, cno);
            }

            ui.cardStack.deleteFromBoard(this.selone);
            ui.cardStack.deleteFromBoard(this.seltwo);

            this.selone = null;
            this.seltwo = null;
            var cp = this.comboCount;
            if (cp >= 3)
                cp = 3;
            this.scoreUp(10 * Math.pow(2, cp));
            this.comboCount++;
            this.inputEnable();
            if (ui.cardStack.inBoard.length === 0) {
                this.getUiLogic().clearStage();
            }
        };

        SinsuiiLogic.prototype.inputEnable = function () {
            this.game.input.disabled = false;
            this.game.input.reset();
        };

        SinsuiiLogic.prototype.scoreUp = function (point) {
            this.uilogic.scoreUp(point);
            _super.prototype.scoreUp.call(this, point);
        };

        SinsuiiLogic.prototype.calcCardNum = function (gameBoardSize, cardWidth, cardHeight, deviceScale, cardNumXy, difficult) {
            var maxcardnum = Math.floor(cardNumXy.x * cardNumXy.y / 2) * 2;

            var hnum2 = Math.floor(gameBoardSize.y / (cardWidth * deviceScale * 1.1));
            var vnum2 = Math.floor(gameBoardSize.x / (cardHeight * deviceScale * 1.1));
            var maxcardnum2 = Math.floor(hnum2 * vnum2 / 2) * 2;
            maxcardnum = Math.min(maxcardnum, maxcardnum2);

            if (difficult <= 0)
                return 4;
            maxcardnum = Math.floor(maxcardnum * difficult / 2) * 2;

            if (maxcardnum > 52)
                maxcardnum = 52;
            return maxcardnum;
        };

        SinsuiiLogic.prototype.calcXyNum = function (gameBoardSize, cardWidth, cardHeight, deviceScale) {
            var hnum = Math.floor(gameBoardSize.x / (cardWidth * deviceScale * 1.1));
            var vnum = Math.floor(gameBoardSize.y / (cardHeight * deviceScale * 1.1));
            return new Phaser.Point(hnum, vnum);
        };
        return SinsuiiLogic;
    })(MfTool.LogicBase);
    SinkeiSuijyaku.SinsuiiLogic = SinsuiiLogic;
})(SinkeiSuijyaku || (SinkeiSuijyaku = {}));
var MfTool;
(function (MfTool) {
    var TitleForm = (function (_super) {
        __extends(TitleForm, _super);
        function TitleForm() {
            _super.apply(this, arguments);
        }
        TitleForm.prototype.create = function () {
            var _this = this;
            this.naviUtil.navi.commandTarget = this.game;

            var basepanel = this.naviUtil.setBackPanel(this.naviUtil.paneldef.Id, "naviback", null, new Phaser.Point(0, 0), new Phaser.Point(1, 1));

            this.game.playTitleBgm(true);

            this.game.physics.setBoundsToWorld();
            this.bglayer = this.game.add.group();
            this.bglayer.enableBody = true;
            this.bglayer.physicsBodyType = Phaser.Physics.ARCADE;

            this.makeBackCard();

            this.animeLayer = this.game.add.group();

            this.title1 = this.add.sprite(this.game.world.centerX, this.game.world.centerY, "title1");
            this.title1.anchor.set(0.5, 1);
            this.title1.position.y = this.game.world.centerY - 120 - 45 + 120;

            this.title2 = this.add.sprite(this.game.world.centerX, this.game.world.centerY, "title2");
            this.title2.anchor.set(0.5, 1);
            this.title2.position.y = this.game.world.centerY + 120 - 55 + 120;

            this.logo = this.add.sprite(this.game.world.width, this.game.world.height, "logo");
            this.logo.anchor.set(1, 1);
            this.logo.scale.set(0.5, 0.5);

            var font = null;
            if (this.getApp().smartPhoneMode) {
                font = { "center": "true", "font": "normal" };
            } else {
                font = { "center": "true", "font": "bold48" };
            }

            this.startTxt = this.naviUtil.setText("starttxt", "Tap Start", basepanel, new Phaser.Point(0, 0.3), new Phaser.Point(1, 1), null, font);

            if (this.getApp().animeOn) {
                var cropRect1 = new Phaser.Rectangle(0, 0, this.title1.width, 0);
                var cropRect2 = new Phaser.Rectangle(0, 0, this.title2.width, 0);
                this.add.tween(cropRect1).to({ height: this.title1.height }, 1000, Phaser.Easing.Linear.None, true);
                this.add.tween(cropRect2).to({ height: this.title2.height }, 1000, Phaser.Easing.Linear.None, true, 1000).onComplete.add(function () {
                    _this.ringEffect(_this.title2.position.x - _this.title2.width * 0.3, _this.title2.position.y + _this.title2.height * 0.3, "bring", 3);
                }, this);

                this.title1.crop(cropRect1, false);
                this.title2.crop(cropRect2, false);

                this.game.time.events.add(4000, this.animeCard, this);

                this.startTxt.alpha = 0;

                this.game.time.events.add(Phaser.Timer.SECOND * 3.5, this.brinkText, this);
            }

            this.naviUtil.rootPanel.showPlayAll();

            _super.prototype.create.call(this);
        };

        TitleForm.prototype.brinkText = function () {
            this.startTxt.alpha = 1;
            this.startTxt.setMotion(new MfTool.BlinkAll(1000));
            this.startTxt.showPlay();
        };

        TitleForm.prototype.ringEffect = function (x, y, splitename, ringnum, startdelay) {
            if (typeof startdelay === "undefined") { startdelay = 0; }
            var emitter = this.game.add.emitter(x, y, ringnum);
            emitter.makeParticles(splitename);
            emitter.gravity = 0;

            emitter.width = 30;
            emitter.height = 30;
            emitter.setRotation(0, Math.PI * 2);
            emitter.setAlpha(1, 0, 1500, Phaser.Easing.Linear.None);
            emitter.setScale(0.5, 2, 0.5, 2, 1500, Phaser.Easing.Exponential.Out);
            emitter.start(true, 1500, null, 10);
        };

        TitleForm.prototype.animeCard = function () {
            var _this = this;
            var angle = this.game.rnd.angle();
            var p1 = new Phaser.Point(this.game.world.centerX + this.game.world.width / 2 * Math.cos(Phaser.Math.degToRad(angle)), this.game.world.centerY + this.game.world.width / 2 * Math.sin(Phaser.Math.degToRad(angle)));
            var p2 = new Phaser.Point(this.game.world.centerX + this.game.world.width * 0.4 * Math.cos(Phaser.Math.degToRad(angle + 180)), this.game.world.centerY + this.game.world.height * 0.4 * Math.sin(Phaser.Math.degToRad(angle + 180)));

            var card = new MfTool.Card(this.game, this.rnd.integerInRange(0, MfTool.Card.maxMark), this.rnd.integerInRange(0, MfTool.Card.maxNo), true, 1);
            this.animeLayer.addChild(card);

            card.moveBanposForAnime(p2, p1, true).onComplete.add(function () {
                _this.game.time.events.add(800, _this.animeCard, _this);
            }, this);
        };

        TitleForm.prototype.clickStartAndfadeOut = function () {
            this.game.tweens.removeAll();
            this.game.time.events.clearPendingEvents();

            this.game.world.forEachAlive(this.fadeitem, this);

            this.game.playTitleBgm(false);
        };

        TitleForm.prototype.fadeitem = function (item) {
            this.add.tween(item).to({ alpha: 0 }, 300, Phaser.Easing.Linear.None, true);
        };

        TitleForm.prototype.resize = function () {
            this.naviUtil.resizePanel();

            this.title1.position.set(this.game.world.centerX, this.game.world.centerY - 120 - 40 + 120);
            this.title2.position.set(this.game.world.centerX, this.game.world.centerY + 120 - 40 + 120);
            this.makeBackCard();
            this.logo.position.set(this.game.world.width, this.game.world.height);
        };

        TitleForm.prototype.update = function () {
            if (this.game.animeOn) {
                this.title1.updateCrop();
                this.title2.updateCrop();
            }
        };

        TitleForm.prototype.render = function () {
        };

        TitleForm.prototype.makeBackCard = function () {
            var _this = this;
            this.bglayer.removeAll(true);
            var xnum = Math.ceil(this.game.width / 136);
            var ynum = Math.ceil(this.game.height / 150);

            var tg = 0;
            for (var i = 0; i < xnum; i += 2) {
                var tt = tg;
                for (var j = 0; j < ynum; j += 3) {
                    var bgcard = new MfTool.AnimeTitleCard(this.game, "cardback", i * 136, j * 150, tt % 2);

                    bgcard.checkWorldBounds = true;
                    bgcard.events.onOutOfBounds.add(function (e) {
                        return _this.outrun(e);
                    }, this);
                    if (this.game.animeOn) {
                        bgcard.body.velocity.x = 100;
                    }
                    bgcard.frame = tt % 2;
                    tt++;
                    this.bglayer.add(bgcard);
                }
                tg++;
            }
        };

        TitleForm.prototype.outrun = function (item) {
            item.position.x = 0;
            item.body.velocity.x = 100;
        };
        return TitleForm;
    })(MfTool.NaviBaseFormState);
    MfTool.TitleForm = TitleForm;
})(MfTool || (MfTool = {}));
//# sourceMappingURL=gametoppage.js.map
