var app = angular.module("horario");

app.controller('mainpage', ['$scope', '$rootScope','LxDialogService', 'LxNotificationService', 'Sidebar', 'indexedDBDataSvc', '$location', '$filter', 'colorMeta', '$timeout',function($scope, $rootScope, LxDialogService, LxNotificationService, Sidebar, indexedDBDataSvc, $location, $filter, colorMeta, $timeout){
  var horas_noti = [];
  //ctrlData.activeTab = 0;
	$scope.opendDialog = function(dialogId){
        LxDialogService.open(dialogId);
	};
	$scope.closingDialog = function(){
        LxNotificationService.info('¡Guardar PDF cerrado!');
	};
  var configuracion = [];
  $scope.languages = {
    "en": {
      "mihorario": "My Schedule",
      "add": "Add",
      "average": "GPA",
      "before": "before",
      "btn2Main": "Save",
      "cancel": "Cancel",
      "classroom": "Classroom",
      "color": "Color",
      "create": "Created on",
      "day": "Day",
      "days": ["Sunday","Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
      "daysMin": ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
      "description": "Add a description",
      "details": "Details",
      "edit": "Edit",
      "enableNoti": "Enable notification",
      "enjoy": "Enjoy!",
      "evaluations": "Evaluations",
      "fri": "Fri",
      "from": "From",
      "grade": "Grade",
      "grades": "Grades",
      "help": "Help",
      "helpNoti": "Displays a notification before initiating a subject.",
      "high": "High",
      "homework": "Homework",
      "hour" : "Hour",
      "lang" : "English",
      "language" : "Language:",
      "lastEdition": "Last edition",
      "medium": "Medium",
      "mon": "Mon",
      "months": ["jan","feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"],
      "monthsLarge": ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
      "msg1": "No aggregate hours",
      "msg2": "No subjects, adds",
      "msg3": "No notes, adds",
      "new": "New",
      "next":"Next",
      "normal": "Normal",
      "note": "Note",
      "notes": "Notes",
      "of": "of",
      "ok": "Ok",
      "opc2Main": "Save as PDF",
      "priority": "Priority",
      "posiblePro": "Posible problems",
      "sat": "Sat",
      "save": "Save",
      "settings": "Settings",
      "solutions": "Solutions",
      "step1" : "Step 1",
      "step2" : "Step 2",
      "step3" : "Step 3",
      "subject": "Subject",
      "sun": "Sun",
      "teacher": "Teacher",
      "th2" : "Monday",
      "th3" : "Tuesday",
      "th4" : "Wednesday",
      "th5" : "Thursday",
      "th6" : "Friday",
      "th7" : "Saturday",
      "th8" : "Sunday",
      "theNews": "To begin, choose a language:",
      "titleMain": "My Schedule",
      "titleNote": "Title note",
      "to": "to",
      "todayhave": "Today you have",
      "txtWelcome": "Welcome to",
      "visibleDays": "Visible days",
      "welcome": "Welcome",
      "youupgrading": "If you're upgrading from an older version, your data will be deleted, because now other configuration is handled.",
      "nosub": "The subject is not displayed, a number is shown in the table",
      "nonot": "No notifications displayed",
      "quest": "Questions or contributions",
      "comment": "Leave your comment",
      "click": "Click here",
      "hP1": "If a number with gray background appears, the more likely allas eliminated a matter that was at that time. Upgrade your time, placing the new subjects.",
      "hP2": "Notifications only work if your application runs in the background, so when you close down your app, notifications are desabilitan. If you want to be always active notifications, go for a home but do not remove the app in the background.",
      "notiTitle": "Subject to start",
      "notiSub1": " started in: ",
      "minutes": "minute(s)"
    },
    "es": {
      "mihorario": "Mi Horario",
      "add": "Añadir",
      "average": "Prom. general",
      "before": "antes",
      "btn2Main": "Guardar",
      "cancel": "Cancelar",
      "classroom": "Aula",
      "color": "Color",
      "create": "Creada el",
      "day": "Día",
      "days":  ["Domingo","Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"],
      "daysMin": ["Dom", "Lun", "Mar", "Mie", "Jue", "Vie", "Sab"],
      "description": "Añade una descripción",
      "details": "Detalles",
      "edit": "Editar",
      "enableNoti": "Activar notificación",
      "enjoy": "Disfruta!",
      "evaluations": "Unidades",
      "fri": "Vie",
      "from": "Desde",
      "grade": "Calificación",
      "grades": "Calificaciónes",
      "help": "Ayuda",
      "helpNoti": "Muestra una alerta antes de iniciar una materia.",
      "high": "Alta",
      "homework": "Tarea",
      "hour" : "Hora",
      "lang" : "Español",
      "language" : "Idioma:",
      "lastEdition": "Última edición",
      "medium": "Media",
      "mon": "Lun",
      "months": ["ene","feb", "mar", "abr", "may", "jun", "jul", "ago", "sept", "oct", "nov", "dic"],
      "monthsLarge": ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"],
      "msg1": "No hay horas agregadas",
      "msg2": "No hay materias, agrega una",
      "msg3": "No hay notas, agrega una",
      "new": "Nueva",
      "next": "Siguiente",
      "normal": "Normal",
      "note": "Nota",
      "notes": "Notas",
      "of": "de",
      "ok": "Aceptar",
      "opc2Main": "Exportar como PDF",
      "priority": "Prioridad",
      "posiblePro": "Posibles problemas",
      "sat": "Sáb",
      "save": "Guardar",
      "settings": "Configuración",
      "solutions": "Soluciones",
      "step1" : "Paso 1",
      "step2" : "Paso 2",
      "step3" : "Paso 3",
      "subject": "Materia",
      "sun": "Dom",
      "teacher": "Profesor",
      "th2" : "Lunes",
      "th3" : "Martes",
      "th4" : "Miércoles",
      "th5" : "Jueves",
      "th6" : "Viernes",
      "th7" : "Sábado",
      "th8" : "Domingo",
      "theNews": "Para comenzar, elige un idioma:",
      "titleMain": "Mi Horario",
      "titleNote": "Título de la nota",
      "to": "a",
      "todayhave": "Hoy tienes",
      "txtWelcome": "Bienvenido a",
      "visibleDays": "Días visibles",
      "welcome": "Bienvenido",
      "youupgrading": "Si estas actualizando desde una versión antigua, tus datos seran borrados, debido a que ahora se maneja otra configuración.",
      "nosub": "Aparece un número en lugar de la materia",
      "nonot": "No aparecen notificaciones",
      "quest": "Dudas o aportes",
      "comment": "Deja tu comentario",
      "click": "Click aquí",
      "hP1" : "Si aparece un número con fondo gris, lo mas probable es que allas eliminado una materia que estaba en esa hora. Actualiza tu hora, colocando las nuevas materias.",
      "hP2": "Las notificaciones solo funcionan si tu aplicación corre en segundo plano, asi que al momento de cerrar definitivamente tu app, las notificaciones se desabilitan. Si deseas tener siempre activas las notificaciones, sal a home pero no quites el app de segundo plano.",
      "notiTitle": "Materia por comenzar",
      "notiSub1": " iniciara en: ",
      "minutes": "minuto(s)"
    },
    "pt" : {
      "mihorario": "Mi Horario",
      "add": "Adicionar",
      "average": "Média",
      "before": "antes",
      "btn2Main": "Save",
      "cancel": "Cancelar",
      "classroom": "Sala de aula",
      "color": "Cor",
      "create": "Criado na ",
      "day": "Dia",
      "days":  ["Domingo","Seg-feira", "Terça-Feira", "Qua", "Qui", "Sexta-Feira", "Sábado"],
      "daysMin": ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
      "description": "Adiciona a descrição",
      "details": "Detalhes",
      "edit": "Editar",
      "enableNoti": "Ativar notificação",
      "enjoy": "Desfrutar!",
      "evaluations": "Unidades",
      "fri": "Sex",
      "from": "Desde",
      "grade": "Nota",
      "grades": "Notas",
      "help": "Ajuda",
      "helpNoti": "Exibe uma notificação antes de iniciar um assunto.",
      "high": "Alto",
      "homework": "Homework",
      "hour" : "Hora",
      "lang" : "Português",
      "language" : "Idioma:",
      "lastEdition": "Última edição",
      "medium": "Média",
      "mon": "Seg",
      "months": ["jan","fev", "mar", "abr", "mai", "jun", "jul", "ago", "set", "out", "nov", "dez"],
      "monthsLarge": ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembre", "Dezembro"],
      "msg1": "há horas agregadas",
      "msg2": "Nenhum assunto, adiciona",
      "msg3": "Nenhum notas, adiciona",
      "new": "Novo",
      "next": "Siguiente",
      "normal": "Normal",
      "note": "Nota",
      "notes": "Notes",
      "of": "de",
      "ok": "Ok",
      "opc2Main": "Save as PDF",
      "priority": "Prioridade",
      "posiblePro": "Problemas potenciais",
      "sat": "Sáb",
      "save": "Salvar",
      "settings": "Configurar",
      "solutions": "Soluções",
      "step1" : "Passo 1",
      "step2" : "Passo 2",
      "step3" : "Passo 3",
      "subject": "Assunto",
      "sun": "Dom",
      "teacher": "Professor",
      "th2" : "Seg-feira",
      "th3" : "Terça-Feira",
      "th4" : "Quarta-Feira",
      "th5" : "Quinta-Feira",
      "th6" : "Sexta-Feira",
      "th7" : "Sábado",
      "th8" : "Domingo",
      "theNews": "Para começar, escolha um idioma:",
      "titleMain": "Mi Horario",
      "titleNote": "Nota título",
      "to": "a",
      "todayhave": "Hoje você tem",
      "txtWelcome": "Bem-vindo ao",
      "visibleDays": "Dias visíveis",
      "welcome": "Bem-vindo",
      "youupgrading": "Se você estiver atualizando a partir de uma versão mais antiga, seus dados serão apagados, porque agora outra configuração é tratado.",
      "nosub": "O assunto não é exibido, um número é mostrado na tabela",
      "nonot": "No notifications displayed",
      "quest": "Perguntas ou contribuições",
      "comment": "Deixe o seu comentário",
      "click": "Clique aqui",
      "hP1": "Se um número com fundo cinza aparece, as Allas mais prováveis eliminado um assunto que era naquele tempo. Atualize seu tempo, colocando os novos temas.",
      "hP2" : "Notificações só funcionam se o seu aplicativo é executado em segundo plano, então quando você fechar o aplicativo, notificações são desabilitan. Se você quer ser sempre notificações ativos, ir para uma casa, mas não remover o aplicativo em segundo plano.",
      "notiTitle": "Sujeita a começar",
      "notiSub1": " iniciado em: ",
      "minutes": "minuto(s)"
    }
  };
  $rootScope.idioma = $scope.languages.en;

  $scope.saveLang = function(dato){
    console.log("nuevo dato " + dato);
    indexedDBDataSvc.saveConfig($scope.dayVisible, $scope.alert, $scope.notifi, dato).then(function(){
      $scope.getConfigs();
    }, function(err){
      alert(err);
    });
  };

  $rootScope.cBarraNoti="#009688";
  $scope.tituloExp="";
  $scope.email="";
  $scope.nameDoc = "mihorario";
  $scope.showExp = false;
  $scope.color = "grey-50";
  $scope.horas = [];
  $scope.horasH = [];
  $scope.clockH = 10;
  $scope.clockM = 30;
  $scope.clockT = "am";
  $scope.materias = {};
  $scope.monthname = "";
  $scope.monthnameL = "";
  $scope.classrooms = [];
  $scope.teachers = [];
  $scope.emails = [];
  $scope.notas = [];
  $scope.tareas = [];
  $scope.workslun = [];
  $scope.worksmar = [];
  $scope.worksmie = [];
  $scope.worksjue = [];
  $scope.worksvie = [];
  $scope.workssab = [];
  $scope.worksdom = [];
  $scope.diashome = [];
  $scope.dialogHWV = false;
  $scope.key = "";
  $scope.horaedit = "";
  $scope.matedit = "";
  $scope.keymat = "";
  $scope.Sidebar = Sidebar;
  $scope.barramain = false;
  $scope.notifi = true;
  $scope.alert = "1";
  $scope.dayVisible = "vie";
  $scope.viewDetail = false;
  $scope.getlang = "";
  $scope.showColor = "teal-500";
  $scope.showColorFont = "white-1";
  $scope.title = $scope.idioma.titleMain;
  var timeout;
  console.log($scope.idioma.titleMain);
  $scope.colorN = function(){
    $scope.cBarraNoti = "#2196F3";
  };
  $scope.colores = [
    { id: 0, name: 'Blue',      cod: 'blue', hex: '#2196F3'},
    { id: 1, name: 'Red',      cod: 'red', hex: '#F44336'},
    { id: 2, name: 'Pink',    cod: 'pink', hex: '#E91E63'},
    { id: 3, name: 'Purple',  cod: 'purple', hex: '#9C27B0'},
    { id: 4, name: 'Deep purple',  cod: 'deep-purple', hex: '#673AB7'},
    { id: 5, name: 'Indigo',  cod: 'indigo', hex: '#3F51B5'},
    { id: 6, name: 'Light blue',    cod: 'light-blue', hex: '#00BCD4'},
    { id: 7, name: 'Teal',    cod: 'teal', hex: '#009688'},
    { id: 8, name: 'Green',    cod: 'green', hex: '#4CAF50'},
    { id: 9, name: 'Light Green',    cod: 'light-green', hex: '#8BC34A'},
    { id: 10, name: 'Lime',    cod: 'lime', hex: '#CDDC39'},
    { id: 11, name: 'Yellow',    cod: 'yellow', hex: '#FFEB3B'},
    { id: 12, name: 'Amber',    cod: 'amber', hex: '#FFC107'},
    { id: 13, name: 'Orange',    cod: 'orange', hex: '#FF9800'},
    { id: 14, name: 'Deep orange',    cod: 'deep-orange', hex: '#FF5722'},
    { id: 15, name: 'Brown',    cod: 'brown', hex: '#795548'},
    { id: 16, name: 'Grey',    cod: 'grey', hex: '#9E9E9E'},
    { id: 17, name: 'Blue grey',    cod: 'blue-grey', hex: '#607D8B'}
  ];
  $scope.dayhomeselect = "Martes";
  $scope.animationHome = function(e, titulo){
  $scope.dayhomeselect = "";
  $scope.titumsg = titulo;
    $scope.elementtargethw = $(e.target);
    var id = $(e.target).parents(".homebox");
    var posicion = id.position();
  $scope.posicionTar = posicion.top+10;
    $("#headtitu").css({
      'top': (posicion.top+10)+'px',
      'opacity': '1',
    });
    $("#headtitu").css({
      'transition': 'all 0.4s ease-out',
      'background-color': '#00BCD4',
      'transform': 'translate(0px, -'+(posicion.top+10)+'px)'
    });
    id.css('opacity', '0');
    //id.addClass('animationHome');
    //id.css('transform', 'translate(0px, -'+posicion.top+'px)');
    id.children(".deshomebox").css({
      'display': 'block !important'
    });
    $scope.closeTareas = function(entrada, salida){
      $("#headtitu").css({
        'transform': 'translate(0px, '+$scope.posicionTar+'px)',
        'background-color': '#fff',
        'opacity': '0'
      });
      $("#headtitu").css({
      'top': '0px'
    });
      id.css('opacity', '1');
    };

  };
  $scope.setActive = function(entrada){
      $scope.ctrlData = {
        activeTab : 2,
        activeTab2 : entrada
      };
      $scope.dayListHom = [$scope.idioma.th2,$scope.idioma.th3,$scope.idioma.th4,$scope.idioma.th5,$scope.idioma.th6,$scope.idioma.th7,$scope.idioma.th8];
      $scope.dayHomeTitle = $scope.dayListHom[entrada];
     
  };
  $scope.showExpDialog = function(){
    $scope.showExp = true;
    console.log("jaja" + $scope.showExp);
  };
  $scope.dialogHome = function(entrada, salida){
    $scope.indexHome = entrada;
    $scope.ctrlData = {
        activeTab : 2,
        activeTab2 : entrada
      };
    /*$scope.setActive(entrada);*/
    $("#dialogHW").css({"display": "block"});
  };
  $scope.dialogHomeHide = function(){
    $("#dialogHW").css({"display": "none"});
  };
  $scope.disableNotiH = function(){
    var elemento =  $scope.elementtargethw;
    var padre = elemento.parents(".homebox");
    elemento.css({
      'color': '#006E88',
      'font-size': '1.3rem'
    });
    padre.children(".deshomebox").css({
      'display': 'none'
    });
    elemento.children("a").css({
      'display': 'none'
    });
  };
  $scope.icoMenu = function(){
    if ($('#icoMenu').hasClass('ico-menu-ani')) {
        $('#icoMenu').removeClass("ico-menu-ani");
        $scope.hideBarMain();
    }
    else {
      Sidebar.toggleSidebar();
    }
  };

 /* $.fn.contrastColor = function() {
    return this.each(function() {

        var bg = $(this).css('background-color');
        console.log(bg)
        //use el primer fondo padre opaco si el elemento es transparente
        if(bg == 'transparent' || bg == 'rgba(0, 0, 0, 0)') { 
            $(this).parents().each(function(){
                bg = $(this).css('background-color')
                if(bg != 'transparent' && bg != 'rgba(0, 0, 0, 0)') return false; 
            });
            //salir si todos son trasparentes
            if(bg == 'transparent' || bg == 'rgba(0, 0, 0, 0)') return false;
        }
        //obtiene el r,g,b y decide
        var rgb = bg.replace(/^(rgb|rgba)\(/,'').replace(/\)$/,'').replace(/\s/g,'').split(',');
        var yiq = ((rgb[0]*299)+(rgb[1]*587)+(rgb[2]*114))/1000;
        if(yiq >= 200) {
          $scope.showColorFont = "black-2"; console.log("alto funcion contraste")}
        else {
          $scope.showColorFont = "white-1"; 
          console.log("bajo contraste funcion")}
          console.log(yiq+" contraste funcion")

    });
};*/
$scope.hex2rgb = function(cole) {
  var colour = String(cole);
var r,g,b;
if ( colour.charAt(0) == '#' ) {
colour = colour.substr(1);
}

r = colour.charAt(0) + "" + colour.charAt(1);
g = colour.charAt(2) + "" + colour.charAt(3);
b = colour.charAt(4) + "" + colour.charAt(5);

r = parseInt( r,16 );
g = parseInt( g,16 );
b = parseInt( b ,16);
var hola = ((r*299) + (g*587) + (b*114))/1000;
var colorMenuIco = "";
if(hola >= 125) {
  $scope.showColorFont = "black-2";
 colorMenuIco =  "rgba(0,0,0,.6)";
}
  else {
   $scope.showColorFont = "white-1";
   colorMenuIco =  "#fff";
}
$('.l').css({'background-color': colorMenuIco});

console.log('rgb(' + r + ',' + g + ',' + b + ')');
return 'rgb(' + r + ',' + g + ',' + b + ')';
};
  $scope.showEditBar = function(id, hora, materiabar, color) {
    if (materiabar !== "") {
    $scope.barramain = true;
    $scope.title = hora;
    $scope.horaedit = hora;
    $scope.key = id;
    $scope.showMateria = "S/Materia";
    $scope.showAula = "";
    $scope.showProfe = "";
    $scope.showColor = "grey-300";
    $scope.viewDetail = true;
    //$scope.showColorFont = "black-2";

    $('#icoMenu').addClass('ico-menu-ani');
    var colorMat = "";
    for (i = 0; i<$scope.materias.length; i++){
            var format = $scope.materias[i].titulo;

        if (format == materiabar){
            $scope.showMateria = $scope.materias[i].titulo;
            $scope.showAula = $scope.materias[i].aula;
            $scope.showProfe = $scope.materias[i].profe;
            $scope.showColor = $scope.materias[i].color+"-500";
            colorMat = $scope.materias[i].color;
            //$scope.showColorFont = "white-2";
            if ($scope.materias[i].aula === "" & $scope.materias[i].profe === ""){
              $scope.viewDetail = false;
            }
            break;
        }
        
      }
      $rootScope.cBarraNoti = colorMeta.getColor(colorMat);
      $scope.hex2rgb($rootScope.cBarraNoti);
      console.log("color barra"+$rootScope.cBarraNoti);
    
  console.log("detail "+ $scope.viewDetail);
}
};

  $scope.hideBarMain = function(id){$scope.title = $scope.idioma.titleMain;
    $scope.barramain = false;
    $scope.horaedit = "";
    $scope.key = "";
    $scope.showMateria = "";
    $scope.showAula = "";
    $scope.showProfe = "";
    $scope.showColor = "teal-500";
    $scope.showColorFont = "white-1";
    $rootScope.cBarraNoti = "#009688";
    $('.l').css({'background-color': "#fff"});
    $scope.viewDetail = false;
  };
  $scope.editar = false;
  

  $scope.deleteHora = function(){
    indexedDBDataSvc.deleteHora($scope.key).then(function(){
      $scope.hideBarMain();
      $scope.refreshList();
      
    }, function(err){
      $window.alert(err);
    });
  };
  $scope.deletehw = function(idhw){
    console.log("borrada tarea");
    indexedDBDataSvc.deleteWork(idhw).then(function(){
      $scope.refreshTareas();
      /*$scope.hideBarraEditNote();
      $scope.refreshNotas();*/
      LxNotificationService.info('¡Tarea borrada!');
    }, function(err){
      $window.alert(err);
    });
  };
  $scope.toEditHour = function(hora){
    if(hora !== null){
      $location.url('/edit/hora/'+ hora);
    } else {
      $location.url('/edit/hora/'+$scope.key);
      $scope.hideBarMain();
    }
  };
  $scope.getConfigs = function(){
    indexedDBDataSvc.getConfig("config").then(function(data){
      $scope.getlang=data.multilang;
      switch($scope.getlang) {
        case "en":
            $rootScope.idioma = $scope.languages.en;
            break;
        case "es":
            $rootScope.idioma = $scope.languages.es;
            break;
        case "pt":
            $rootScope.idioma = $scope.languages.pt;
            break;
      }
      $scope.dayVisible=data.day;
      if(data.day == "vie"){
        $scope.tdSab = false;
        $scope.tdDom = false;
      }
      else if(data.day == "sab"){
        $scope.tdSab = true;
        $scope.tdDom = false;
      }
      else if(data.day == "dom"){
        $scope.tdSab = true;
        $scope.tdDom = true;
      }
      $scope.notifi = data.noti;
      $scope.alert = data.alert;
    //console.log(data.day +" data "+ $scope.alert);
    }, function(err){
      alert(err);
    });
  };
	$scope.refreshList = function(){
    indexedDBDataSvc.getHoras().then(function(data){
      $scope.horas=data;
      $scope.horasH = data;
      $scope.listhoras = [];
      for (var i = 0; i<$scope.horas.length; i++){
        if ($scope.horas[i].hora !== ""){
          $scope.listhoras.push(data[i].hora);
        }
        if ($scope.horas[i].lun !== ""){
          var lun = Number(data[i].lun);
          $scope.colorear(lun, "lun", i);
        }
        if (data[i].mar !== ""){
          var mar = Number(data[i].mar);
          $scope.colorear(mar, "mar", i);
        }
        if (data[i].mie !== ""){
          var mie = Number(data[i].mie);
          $scope.colorear(mie, "mie", i);
        }
        if (data[i].jue !== ""){
          var jue = Number(data[i].jue);
          $scope.colorear(jue, "jue", i);
        }
        if (data[i].vie !== ""){
          var vie = Number(data[i].vie);
          $scope.colorear(vie, "vie", i);
        }
        if (data[i].sab !== ""){
          var sab = Number(data[i].sab);
          $scope.colorear(sab, "sab", i);
        }
        if (data[i].dom !== ""){
          var dom = Number(data[i].dom);
          $scope.colorear(dom, "dom", i);
        }
      }
     // window.clearTimeout($scope.timeoutID);
    }, function(err){
      alert(err);
    });
    $scope.getConfigs();
  };
  $scope.colorear = function(mat, dia, key){
    var aula = "";
    indexedDBDataSvc.getSubject(mat).then(function(data){
      if (data.aula !== "") {
        aula = data.aula;
      }
      else{
        aula = "";
      }
      if (dia == "lun"){
        horas_noti.push($scope.horas[key].hora);
        $scope.horas[key].lun = data.titulo;
        $scope.horas[key].clun = data.color + "-500 ma";
        $scope.horas[key].aulal = aula;
      }
      else if (dia == "mar"){
        $scope.horas[key].mar = data.titulo;
        $scope.horas[key].cmar = data.color + "-500 ma";
        $scope.horas[key].aulam = aula;
      }
      else if (dia == "mie"){
        $scope.horas[key].mie = data.titulo;
        $scope.horas[key].cmie = data.color + "-500 ma";
        $scope.horas[key].aulaw = aula;
      }
      else if (dia == "jue"){
        $scope.horas[key].jue = data.titulo;
        $scope.horas[key].cjue = data.color + "-500 ma";
        $scope.horas[key].aulaj = aula;
      }
      else if (dia == "vie"){
        $scope.horas[key].vie = data.titulo;
        $scope.horas[key].cvie = data.color + "-500 ma";
        $scope.horas[key].aulav = aula;
      }
      else if (dia == "sab"){
        $scope.horas[key].sab = data.titulo;
        $scope.horas[key].csab = data.color + "-500 ma";
        $scope.horas[key].aulas = aula;
      }
      else if (dia == "dom"){
        $scope.horas[key].dom = data.titulo;
        $scope.horas[key].cdom = data.color + "-500 ma";
        $scope.horas[key].aulad = aula;
      }
    }, function(err){
      alert(err);
    });
  };
  $scope.refreshMaterias = function(){
    indexedDBDataSvc.getSubjects().then(function(data){
      $scope.materias = data;
      $scope.classrooms.length = 0;
      $scope.teachers.length = 0;
      $scope.emails.length = 0;

      for(var i=0; i<data.length; i++){
        /*if(data[i].aula.length > 1 & data[i].aula != ""){
          $scope.classroom.push(data[i].aula);
        }*/
        if(data[i].profe !== null & data[i].profe !== ""){
          $scope.teachers.push(data[i].profe);
        }
        if(data[i].email !== null & data[i].email !== ""){
          $scope.emails.push(data[i].email);
        }
        if(data[i].aula !== null & data[i].aula !== ""){
          $scope.classrooms.push(data[i].aula);
        }
      }
    }, function(err){
      alert(err);
    });
  };
  $scope.refreshNotas = function(){
    indexedDBDataSvc.getNotes().then(function(data){
      $scope.notas=data;
    }, function(err){
      alert(err);
    });
  };
  $scope.refreshTareas = function(){
    indexedDBDataSvc.getWorks().then(function(data){
      $scope.tareas=data;
      $scope.workslun = [];
      $scope.worksmar = [];
      $scope.worksmie = [];
      $scope.worksjue = [];
      $scope.worksvie = [];
      $scope.workssab = [];
      $scope.worksdom = [];
      $scope.worksprevious = [];
      $scope.workstoday = [];
      $scope.workstomorrow = [];
      $scope.countworks = "";
      $scope.countw = 0;
      var fecha = new Date();
      var fecha2;
      var hoy = new Date(fecha.getFullYear(), fecha.getMonth(), fecha.getDate());
      var tomorrow = new Date(fecha.getFullYear(), fecha.getMonth(), fecha.getDate()+1);
      $scope.today = $scope.idioma.days[hoy.getDay()]+", "+ hoy.getDate() +" "+ $scope.idioma.months[hoy.getMonth()] +". "+ hoy.getFullYear();
      //console.log($scope.tareas);[{id:"",materia:""},{id:"", materia:""}]
      for (var i = 0; i < $scope.tareas.length; i++) {
        fecha2 = new Date($scope.tareas[i].day[2], $scope.tareas[i].day[1], $scope.tareas[i].day[0]);
        if (fecha2 < hoy) {
          $scope.worksprevious.push($scope.tareas[i]);
        }
        else{
          if ($scope.tareas[i].day[0] == fecha.getDate() & $scope.tareas[i].day[1] == fecha.getMonth() & $scope.tareas[i].day[2] == fecha.getFullYear()){
          $scope.countw++;
          $scope.workstoday.push($scope.tareas[i]);
          //$scope.tareas[i].description = null;
          if ($scope.countw > 9) $scope.countworks = "9-plus-box";
          else $scope.countworks = $scope.countw + "-box";
          }
          if ($scope.tareas[i].day[0] == tomorrow.getDate() & $scope.tareas[i].day[1] == tomorrow.getMonth() & $scope.tareas[i].day[2] == tomorrow.getFullYear()){
            $scope.workstomorrow.push($scope.tareas[i]);
          }
          
            switch($scope.tareas[i].day[3])
            {
              case 1:
                $scope.workslun.push($scope.tareas[i]);
                break;
              case 2:
                $scope.worksmar.push($scope.tareas[i]);
                break;
              case 3:
                $scope.worksmie.push($scope.tareas[i]);
                break;
              case 4:
                $scope.worksjue.push($scope.tareas[i]);
                break;
              case 5:
                $scope.worksvie.push($scope.tareas[i]);
                break;
              case 6:
                $scope.workssab.push($scope.tareas[i]);
                break;
              case 0:
                $scope.worksdom.push($scope.tareas[i]);
                break;
            }
          
        }
      }
    }, function(err){
      alert(err);
    });
    
  };
  $scope.homeReady = function(id,id2){
    var sg = document.getElementsByClassName(id+id2);
    var state = "";
    var tarea = [];
    if (sg[0].checked) {
      state = "checked";
      LxNotificationService.success('¡Tarea Realiza!');
    }
    else {
      state = "";
    } 
      for (var i = 0; i < $scope.tareas.length; i++) {
        if($scope.tareas[i].id == id){
          tarea = $scope.tareas[i];
          break;
        }
      }
      var todo  = {"id": tarea.id, "materia": tarea.materia, "day": tarea.day, "hour": tarea.hour, "description": tarea.description, "state": state};
      indexedDBDataSvc.editHW(todo).then(function(){
        $scope.refreshTareas();
      }, function(err){
        alert(err);
      });
  };
  $scope.chequeo = function(a,b,estado){
   /* var inp = document.getElementById(a+b);
   if (estado = "checked") {
      inp.prop("checked", true);
    } else
    {
      inp.prop("checked", false);
    }*/
  };
  $scope.profes = function(fuente){
    $scope.helptea = [];
    for(var i=0; i<$scope.teachers.length; i++){
      var search = $scope.teachers[i];
      var longi = fuente.length;
      var search1 = search.toLowerCase();
      if(search1.slice(0, longi) == fuente.toLowerCase() & fuente !==   ""){
        $scope.helptea.push(search1);
      }
    }
  };
  $scope.init = function(){
    indexedDBDataSvc.open().then(function(){
      $scope.refreshList();
      $scope.refreshMaterias();
      $scope.refreshNotas();
      $scope.refreshTareas();
      /*$timeout(function(){
        alertas();}, 5000);*/
    });
    setInterval(alertas, 1000);
  };
  function alertas(){
    if($scope.notifi == true){
    var myDate  = new Date();
    var hourF = $filter('date')(myDate, 'HH:mm:ss');
    var horaE;
    var day = myDate.getDay();
    var hoy = "";
    switch(day){
      case 0:
        hoy = "dom";
        break;
      case 1:
        hoy = "lun";
        break;
      case 2:
        hoy = "mar";
        break;
      case 3:
        hoy = "mie";
        break;
      case 4:
        hoy = "jue";
        break;
      case 5:
        hoy = "vie";
        break;
      case 6:
        hoy = "sab";
        break;
    }
    for (var i = 0; i < $scope.horas.length; i++) {
      horaE = retraso($scope.horas[i].hora);
      if (horaE == hourF && $scope.horas[i][hoy] != "") $scope.noti($scope.horas[i][hoy]);
    }
  }};
 /* function alerta(data, respuesta){
    var lista = $scope.horas;
    //window.clearTimeout(timeout);
    var date = new Date(); 
    var hora = date.getHours();
    hora = ("0" + hora).slice(-2);
    var min = date.getMinutes();
    min = ("0" + min).slice(-2);
    var aa = date.getSeconds();
    var win, time;
    var ntime;
    console.log("> "+hora+" "+min+" "+aa)
    //lista.sort();
    lista.sort(function (a, b) {
      if (a.hora > b.hora) {
        return 1;
      }
      if (a.hora < b.hora) {
        return -1;
      }
      return 0;
    });
    for (var j = 0; j < lista.length; j++) {
      //console.log(lista[j].hora)
      if(lista[j].hora > (hora+":"+min)){
        win = lista[j];
        console.log(win.hora + " win"); 
        break;
      }
    }
    if(win == undefined){
      win = lista[0];
     }
     time = retraso(win.hora);
     btime = time-date.getTime();

     console.log(date.getDay());
     console.log("hora "+btime/1000)

    $timeout(function(){
        $scope.noti(win.materia);}, btime);
    //timeout = setTimeout($scope.noti(), SecondsTime); 
    
   }*/
   
function retraso(starthour){
    var antes = Number($scope.alert);
    var start = starthour.split(':');
    var new_hour = "";

    var hour = Number(start[0]);
    var hour1 = Number(start[0])-1;
    if (hour1 < 10){
      hour1 = "0"+hour1;
    }
    if (hour < 10){
      hour = "0"+hour;
    }
    var min = Number(start[1]);
    var min_min = min-antes;
    if (min_min < 10){
      min_min = "0"+min_min;
    }
     if(min < antes){
      new_hour = hour1 +":" + min - antes + 60+ ":00";
     }else{
      new_hour= hour+":"+ min_min+":00";
     }
     return new_hour;
  };/*
function retraso(starthour){
    var retrasoMinutes = Number($scope.alert);

    var luego = new Date();
    var hora = starthour.split(':');
    var hour = Number(hora[0]);
    var min = Number(hora[1]);
    if(min < retrasoMinutes){
      min = 60 - retrasoMinutes + min;
      hour = hour -1;
    } else {
      min = min -retrasoMinutes;
    }
    luego.setHours(hour);
    luego.setMinutes(min);
    luego.setSeconds(0);
    //console.log(luego.getTime() + " "+ hour+ ":"+min)
    return luego.getTime();
  }*/



  $scope.noti = function(materia){
    if (Notification) {
        if (Notification.permission !== "granted") {
            Notification.requestPermission();
        }
        var title = $scope.idioma.notiTitle;
        var extra = {
            icon: "images/icon_60.png",
            body: materia +$scope.idioma.notiSub1 +$scope.alert+$scope.idioma.minutes+"."
        };
        var noti = new Notification( title, extra);
        noti.onclick = {
            // Al hacer click
        };
        noti.onclose = {
            // Al cerrar
        };
        //alerta(false);
        LxNotificationService.info(materia +$scope.idioma.notiSub1+ $scope.alert +$scope.idioma.minutes+".");
        
    } 
      
      
      
      /*var navInfo = window.navigator.appVersion.toLowerCase();

      if(navInfo.indexOf('windows') != -1)
      {
      var sound = new Howl({
        urls: ['media/Moto.ogg']
      }).play();
      }*/
      
      
  };
  $scope.exportar = function(){
    var data = [], fontSize = 12, height = 0, doc;
      doc = new jsPDF('p', 'pt', 'letter', true);
      doc.setFont("helvetica", "normal");
      var name_file = document.getElementById('nombreDocument').value;
      var titulo = document.getElementById('tituloDoc').value;
      if (name_file === "") {
        name_file = "mihorario";
      }

      doc.setFontSize(20);
      doc.text(20, 50, titulo);

      doc.setFontSize(fontSize);
      //Aqui se genera el pdf
        data = doc.tableToJson('tablehours2');
        height = doc.drawTable(data, {
          xstart : 15,
          ystart : 10,
          tablestart : 70,
          marginleft : 20
        });
        doc.text(50, height + 20, 'Mi horario V2.3');
        doc.save(name_file+".pdf");
        LxNotificationService.info('Guardando pdf');
        $scope.showExp = false;
      };
      $scope.remove_hom = function(id){
        indexedDBDataSvc.deleteWork(id).then(function(){
          $scope.refreshTareas();
          LxNotificationService.success('Tarea borrada!');
        }, function(err){
          $window.alert(err);
        });
      };
      $scope.edit_hom_url = function(aidi){
        var url = "?id="+aidi.id+"&materia="+aidi.materia+"&hour="+aidi.hour+"&day="+aidi.day+"&description="+aidi.description+"&state="+aidi.state;
        var res = encodeURIComponent(url);
        $location.url('/edit/homework/'+ res+"/"+aidi.materia);
      };
  $scope.init();
}]);

app.controller('listmaterias', ['$scope','$rootScope','LxNotificationService', 'indexedDBDataSvc', '$location', 'colorMeta',function($scope, $rootScope, LxNotificationService, indexedDBDataSvc, $location, colorMeta){
    $scope.barraEditMats = false;
    $scope.matDetails = false;
    $rootScope.cBarraNoti = "#009688";
	$scope.showEditMats = function(id, name, profe, aula, color, email, promedio){
        $scope.barraEditMats = true;
      $scope.matDetails = true;
      $scope.matedit = name;
      $scope.keymat = id;
      $scope.editprof = profe;
      $scope.coloredit = color;
      $scope.aulaedit = aula;
      $scope.emailedit = email;
      $scope.promedit = promedio;
      $scope.color = color + "-800";
      $rootScope.cBarraNoti = colorMeta.getColor($scope.coloredit);
	};     
	$scope.hideBarraEditMats = function(){
        $scope.barraEditMats = false;
        $scope.matDetails = false;
        $scope.matedit = "";
        $scope.keymat = "";
        $scope.color = "grey-50";
        $rootScope.cBarraNoti = "#009688";
	};
	$scope.closingDialog = function(){
        LxNotificationService.info('¡Añadir materia fue cerrado!');
	};

  $scope.deleteSubject = function(){
    indexedDBDataSvc.deleteSubject($scope.keymat).then(function(){
      $scope.hideBarraEditMats();
      $scope.refreshMaterias();
      LxNotificationService.info('¡Materia borrada!');
    }, function(err){
      $window.alert(err);
    });
  };

  $scope.toEditSubject = function(){
    $location.url('/edit/materia/'+$scope.keymat);
    $scope.hideBarMain();
  };
}]);

app.controller('notas', ['$scope','LxNotificationService', 'indexedDBDataSvc', '$location', '$rootScope','colorMeta',function($scope, LxNotificationService, indexedDBDataSvc, $location, $rootScope, colorMeta){
    $scope.barraEditNotes = false;
    $scope.noteDetails = false;
    $rootScope.cBarraNoti = "#009688";
  $scope.showEditNote = function(id, titulo, descripcion, prioridad, fecha){
      $scope.barraEditNotes = true;
      $scope.noteDetails = true;
      $scope.keyNote = id;
      $scope.titulo = titulo;
      $scope.descripcion = descripcion;
      $scope.prioridad = prioridad;
      $scope.fecha = fecha;
      $rootScope.cBarraNoti = colorMeta.getColor($scope.prioridad);
  };     
  $scope.hideBarraEditNote = function(){
      $scope.barraEditNotes = false;
      $scope.noteDetails = false;
      $scope.keyNote = "";
      $scope.titulo = "";
      $scope.descripcion = "";
      $scope.prioridad = "";
      $scope.fecha = "";
      $rootScope.cBarraNoti = "#009688";
  };

  $scope.deleteNote = function(){
    indexedDBDataSvc.deleteNote($scope.keyNote).then(function(){
      $scope.hideBarraEditNote();
      $scope.refreshNotas();
      LxNotificationService.info('¡Nota borrada!');
    }, function(err){
      $window.alert(err);
    });
  };

  $scope.toEditNote = function(){
    $location.url('/edit/note/'+$scope.keyNote);
    $scope.hideBarraEditNote();
  };
}]);

app.controller('add-hora', ['$scope','$filter', 'LxNotificationService', 'indexedDBDataSvc', function($scope, $filter, LxNotificationService, indexedDBDataSvc){
  $scope.title = $scope.idioma.new + " "+$scope.idioma.hour;
	$scope.lun = "";
	$scope.mar = "";
	$scope.mie = "";
	$scope.jue = "";
	$scope.vie = "";
	$scope.sab = "";
	$scope.dom = "";
    $scope.showDelHora = false;
    var tiempo, tiempo2, newtime2;
    $scope.addHora = function(){
      tiempo = $('#hora').text();
      tiempo2 = $('#hora2').text();
      if(tiempo == "00:00"){
        LxNotificationService.alert('Campo vacio', 'No has insertado una hora inicial', 'ok', function(answer){});
      } 
      else {
        
        if(tiempo2 == "00:00") tiempo2 = "";
        else newtime2 = ultimo(tiempo, tiempo2);

        indexedDBDataSvc.addHora(tiempo,tiempo2, $scope.lun, $scope.mar, $scope.mie, $scope.jue, $scope.vie, $scope.sab, $scope.dom).then(function(){
        $scope.refreshList();
        $scope.lun = "";
        $scope.mar = "";
        $scope.mie = "";
        $scope.jue = "";
        $scope.vie = "";
        $scope.sab = "";
        $scope.dom = "";
        if(tiempo2 != ""){
          $('#hora').text(tiempo2);
          $('#hora2').text(newtime2);
        } 
          LxNotificationService.success('¡Hora añadida');
         }, function(err){
          alert(err);
          });
      }//aqui termina el else
  };

  /*function restarHoras(inicio,fin) {
    var fechaInicio = new Date(inicio);
    var fechaFin = new Date(fin);
    var dif= fechaFin - fechaInicio; // diferencia en milisegundos
    var difSeg = Math.floor(dif/1000); //diferencia en segundos
    var segundos = difSeg % 60; //segundos
    var difMin = Math.floor(difSeg/60); //diferencia en minutos
    var minutos = difMin % 60; //minutos
    var difHs = Math.floor(difMin/60); //diferencia en horas
    var horas = difHs % 24; //horas
    return horas+":"+minutos+":"+segundos; //armo el tiempo de diferencia
    }*/
  function ultimo(hour2, hour1){
    var fechaInicio = new Date();
    var fechaFin = new Date();
    var tiempo1 = hour1.split(':');
    var tiempo2 = hour2.split(':');
    var hora = Number(tiempo1[0]);
    var min = Number(tiempo1[1]);
    var hora2 = Number(tiempo2[0]);
    var min2 = Number(tiempo2[1]);
    fechaInicio.setHours(hora);
    fechaInicio.setMinutes(min);
    fechaInicio.setSeconds(0);
    fechaFin.setHours(hora2);
    fechaFin.setMinutes(min2);
    fechaFin.setSeconds(0);
    var dif = fechaInicio - fechaFin;
    var difSeg = Math.floor(dif/1000); //diferencia en segundos
    var segundos = difSeg % 60; //segundos
    var difMin = Math.floor(difSeg/60); //diferencia en minutos
    var minutos = difMin % 60; //minutos
    var difHs = Math.floor(difMin/60); //diferencia en horas
    var horas = difHs % 24; //horas
    hora += horas;
    min += minutos;
    if (min > 60) {min = min-60;hora += 1;}
    if (min == 60) {min = "00"; hora += 1;}
    $('#hora2').text(hora+":"+min);
    if (hora<10) hora = "0"+hora;
    if (min<10 & min > 1) min = "0"+min;
    return hora+":"+min; //armo el tiempo de diferencia
    //console.log(luego.getTime() + " "+ hour+ ":"+min)
  }

}]);

app.controller('edit-hora', ['$scope','$filter', 'LxNotificationService', 'indexedDBDataSvc', '$routeParams', '$location', function($scope, $filter, LxNotificationService, indexedDBDataSvc, $routeParams, $location){
  $scope.title = $scope.idioma.edit;
  $scope.Id = Number($routeParams.horaId);
  $scope.showDelHora = true;
    indexedDBDataSvc.getHora($scope.Id).then(function(data){
      $("#hora").text(data.hora);
      if(data.hora2 === ""){
        $("#hora2").text("00:00");
      } else{
        $("#hora2").text(data.hora2);
      }
      $scope.lun = data.lun;
      $scope.mar = data.mar;
      $scope.mie = data.mie;
      $scope.jue = data.jue;
      $scope.vie = data.vie;
      $scope.sab = data.sab;
      $scope.dom = data.dom;
    }, function(err){
      alert(err);
    });
    $scope.deleteHora = function(){
      indexedDBDataSvc.deleteHora($scope.Id).then(function(){
        $scope.refreshList();
        $location.url('/');
        LxNotificationService.success('Delete success!');
      }, function(err){
        $window.alert(err);
      });
    };
    $scope.addHora = function(){
      var tiempoe = $('#hora').text();
      var tiempoe2 = $('#hora2').text();
      if(tiempoe2 == "00:00"){
        tiempoe2 = "";
      }
      $scope.todo  = {"id": $scope.Id, "hora": tiempoe, "hora2": tiempoe2, "lun": $scope.lun, "clun": "grey-200", "mar": $scope.mar, "cmar": "grey-200", "mie": $scope.mie, "cmie": "grey-200", "jue": $scope.jue, "cjue": "grey-200", "vie": $scope.vie, "cvie": "grey-200", "sab": $scope.sab, "csab": "grey-200", "dom": $scope.dom, "cdom": "grey-200"};
    indexedDBDataSvc.editHora($scope.todo).then(function(){
      $scope.refreshList();
      $('#hora').text("00:00");
      $('#hora2').text("00:00");
      $scope.lun = "";
      $scope.mar = "";
      $scope.mie = "";
      $scope.jue = "";
      $scope.vie = "";
      $scope.sab = "";
      $scope.dom = "";
      $location.url('/');
      LxNotificationService.success('¡Hora Editada');
    }, function(err){
      alert(err);
    });
  };

}]);

app.controller('add-materia', ['$scope','$rootScope','$filter', 'LxNotificationService', 'indexedDBDataSvc','colorMeta', function($scope, $rootScope, $filter, LxNotificationService, indexedDBDataSvc, colorMeta){
  var idcolor = 0;
  var prome;
  $rootScope.cBarraNoti="#2196F3";
  $scope.title = $scope.idioma.new + " " + $scope.idioma.subject;
  $scope.colorsel = "blue";
  $scope.colorselname = "Blue";
  $scope.materias = [];
  $scope.evaluacion = [0,0,0,0,0,0,0,0,0,0];
  $scope.periodo = "1";
  $scope.promedioGral = 0;
  $scope.addMateria = function(){
    if($scope.nameMateria === "" || $scope.nameMateria === undefined){
      LxNotificationService.alert('Campo vacio', 'No has insertado el nombre de la materia.', 'ok', function(){});
      } 
    else {
      console.log("this "+ $scope.nameMateria);
      indexedDBDataSvc.addSubject($scope.nameMateria, $scope.profr, $scope.aula, $scope.colorsel, $scope.email, $scope.evaluacion, $scope.periodo, $scope.promedioGral).then(function(){
      $scope.refreshMaterias();
      $scope.nameMateria = "";
      $scope.profr = "";
      $scope.aula = "";
      $scope.email = "";
      $scope.colorChange(idcolor+1, $scope.colores[idcolor+1].cod);
      LxNotificationService.success('¡Materia añadida!');
      }, function(err){
        alert(err);
      });
    }
  };
  $scope.selectText = function(tipo, dato){
    $scope[tipo] = dato;
  };
  $scope.cambioeval = function(){
    prome = ($scope.evaluacion[0]+$scope.evaluacion[1]+$scope.evaluacion[2]+$scope.evaluacion[3]+$scope.evaluacion[4]+$scope.evaluacion[5]+$scope.evaluacion[6]+$scope.evaluacion[7]+$scope.evaluacion[8]+$scope.evaluacion[9])/$scope.periodo;
    $scope.promedioGral = Math.round(prome*100)/100;
  };
  $scope.removeTab = function(index){
    $scope[tipo] = dato;
  };
  $scope.colorChange = function(id, cod){
    idcolor = id;
    $scope.colorsel = cod;
    //$scope.colorselname = name;
    $rootScope.cBarraNoti = colorMeta.getColor(cod);
  };
}]);

app.controller('edit-materia', ['$scope','$filter', 'LxNotificationService', 'indexedDBDataSvc', '$routeParams', '$location','$rootScope','colorMeta', function($scope, $filter, LxNotificationService, indexedDBDataSvc, $routeParams, $location, $rootScope, colorMeta){
  
  var prom;
  $scope.title = $scope.idioma.edit;
  $scope.Id = Number($routeParams.mateId);
    indexedDBDataSvc.getSubject($scope.Id).then(function(data){
      $scope.nameMateria = data.titulo;
      $scope.profr = data.profe;
      $scope.aula = data.aula;
      $scope.colorselname = data.color;
      $scope.colorsel = data.color;
      $scope.email = data.email;
      console.log(data.evaluacion + " eval")
      if(data.evaluacion === undefined) {
        $scope.evaluacion = [0,0,0,0,0,0,0,0,0,0];
        $scope.periodo = "1";
        $scope.promedioGral = 0;
      } else
      {
        $scope.evaluacion = data.evaluacion;
        $scope.periodo = data.periodo;
        $scope.promedioGral = data.promedio;
      }
      $rootScope.cBarraNoti = colorMeta.getColor($scope.colorsel);
    }, function(err){
      alert(err);
    });
    
    $scope.cambioeval = function(){
    prom = ($scope.evaluacion[0]+$scope.evaluacion[1]+$scope.evaluacion[2]+$scope.evaluacion[3]+$scope.evaluacion[4]+$scope.evaluacion[5]+$scope.evaluacion[6]+$scope.evaluacion[7]+$scope.evaluacion[8]+$scope.evaluacion[9])/$scope.periodo;
    $scope.promedioGral = Math.round(prom*100)/100;
  };
    $scope.colorChange = function(id, cod){
    idcolor = id;
    $scope.colorsel = cod;
    $rootScope.cBarraNoti = colorMeta.getColor(cod);
  };
    $scope.selectText = function(tipo, dato){
      $scope[tipo] = dato;
    };
    $scope.addMateria = function(){
      $scope.todomat  = {"id": $scope.Id, "titulo": $scope.nameMateria, "profe": $scope.profr, "aula": $scope.aula, "color": $scope.colorsel, "email": $scope.email, "evaluacion": $scope.evaluacion, "periodo":$scope.periodo, "promedio": $scope.promedioGral};
      indexedDBDataSvc.editSubject($scope.todomat).then(function(){
      $scope.refreshMaterias();
      $scope.refreshList();
      $location.url('/materias');
      LxNotificationService.success('¡Materia Editada');
    }, function(err){
      alert(err);
    });
  };
}]);
app.controller('add-homework', ['$scope','$rootScope','$filter', 'LxNotificationService', 'indexedDBDataSvc','colorMeta', function($scope, $rootScope, $filter, LxNotificationService, indexedDBDataSvc, colorMeta){
  var idcolor = 0;
  var date  = new Date();
  $rootScope.cBarraNoti="#2196F3";
  $scope.title = $scope.idioma.new + " " + $scope.idioma.homework;
  $scope.colorsel = "blue";
  $scope.colorselname = "Blue";
  $scope.horahome = "";
  $scope.mathome = {titulo : ""};
  $scope.dateHomeValue = [date.getDate(),date.getMonth(), date.getFullYear(), date.getDay()];
  $scope.dateHome = $scope.idioma.days[date.getDay()] + ", " + $scope.idioma.months[date.getMonth()] + ". "+date.getDate()+ ", " + date.getFullYear();
  $scope.horashome = [];
  $scope.desHome = "";
  $scope.def_opt_hour = $scope.idioma.hour;
  $scope.saveHomework = function(){
    console.log("guardo");
    if($scope.mathome === "" || $scope.desHome === ""){
      LxNotificationService.alert('Campo vacio Ø', 'Por favor llena todos los campos.', 'ok', function(){});
      } 
    else {
      indexedDBDataSvc.addWork($scope.mathome.titulo, $scope.dateHomeValue, $scope.horahome, $scope.desHome).then(function(){
      $scope.refreshTareas();
      //$scope.colorChange(idcolor+1, $scope.colores[idcolor+1].cod);
      LxNotificationService.success('Tarea añadida!');
      }, function(err){
        alert(err);
      });
    }
  };
  $scope.selectSub = function(){
    $scope.diashome = [7,7,7,7,7,7,7]; //se inicializa en 7 en simbolodo de off - started in 7 equals off
    $scope.horaslista = [[],[],[],[],[],[],[]];
    for(i=0;i<$scope.horas.length;i++)
    { 
      if($scope.mathome.titulo == $scope.horasH[i].dom) {$scope.diashome[0] = 0; $scope.horaslista[0].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].sab) {$scope.diashome[6] = 6; $scope.horaslista[6].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].vie) {$scope.diashome[5] = 5; $scope.horaslista[5].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].jue) {$scope.diashome[4] = 4; $scope.horaslista[4].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].mie) {$scope.diashome[3] = 3; $scope.horaslista[3].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].mar) {$scope.diashome[2] = 2; $scope.horaslista[2].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].lun) {$scope.diashome[1] = 1; $scope.horaslista[1].push($scope.horas[i].hora);}
    }
    //$scope.dayhome = $scope.diashome;
    $scope.selectDay();
  };
  $scope.selectDay = function(){
    $scope.horashome = ["No hour on that mat and day"];
    var elejido;
   if ($scope.mathome.titulo !== "") {
    for (var d = 0; d < $scope.diashome.length; d++) {
      if($scope.diashome[d] != 7){
        if (d == $scope.dateHomeValue[3]) {
          //console.log("encontro "+$scope.idioma.days[d]);
          $scope.horashome = $scope.horaslista[d];
        }
      }
    }
   }
  };

  $scope.colorChange = function(id, cod){
    idcolor = id;
    $scope.colorsel = cod;
    //$scope.colorselname = name;
    $rootScope.cBarraNoti = colorMeta.getColor(cod);
  };
}]);
app.controller('edit-nota', ['$scope','$filter', 'LxNotificationService', 'indexedDBDataSvc', '$routeParams', '$location', '$rootScope','colorMeta',function($scope, $filter, LxNotificationService, indexedDBDataSvc, $routeParams, $location,$rootScope, colorMeta){
  $scope.title = $scope.idioma.edit;
  $scope.Id = Number($routeParams.noteId);
  var fecha;
    indexedDBDataSvc.getNote($scope.Id).then(function(data){
      fecha = data.fecha;
      $scope.titleNote = data.titulo;
      $scope.desNote = data.descripcion;
      $scope.priori = data.prioridad;
      $rootScope.cBarraNoti = colorMeta.getColor($scope.priori);
      
    }, function(err){
      alert(err);
    });
    $scope.colorBarN = function(){
    console.log("cambio prioridad " + $scope.priori);
    $rootScope.cBarraNoti = colorMeta.getColor($scope.priori);
    };
    $scope.saveNota = function(){
      var todo  = {"id": $scope.Id, "titulo": $scope.titleNote, "descripcion": $scope.desNote, "prioridad": $scope.priori, "fecha": fecha};
      indexedDBDataSvc.editNote(todo).then(function(){
      $scope.refreshNotas();
      $location.url('/notas');
      LxNotificationService.success('¡Nota Editada');
    }, function(err){
      alert(err);
    });
  };
}]);
app.controller('edit-homework', ['$scope','$filter', 'LxNotificationService', 'indexedDBDataSvc', '$routeParams', '$location', '$rootScope','colorMeta',function($scope, $filter, LxNotificationService, indexedDBDataSvc, $routeParams, $location,$rootScope, colorMeta){
  function $_get(param)
{
/* Obtener la url completa */
  url = $routeParams.homeId;
  /* limpiar la cadena quitándole el signo ? */
  url = url.replace("?", "");
  /* Crear un array con parametro=valor */
  url = url.split("&");
  x = 0;
  while (x < url.length)
  {
    p = url[x].split("=");
    if (p[0] == param)
    {
    return decodeURIComponent(p[1]);
    }
    x++;
  }
}
$scope.mathome = {
      titulo: $_get("materia")
    };
var day = $_get("day").split(",");
$scope.def_opt_hour = $_get("hour");
$scope.dateHomeValue = [parseInt(day[0]),parseInt(day[1]), parseInt(day[2]), parseInt(day[3])];
$scope.dateHome = $scope.idioma.days[day[3]] + ", " + $scope.idioma.months[day[1]] + ". "+day[0]+ ", " + day[2];
$scope.desHome = $_get("description");
$scope.selectSub = function(){
    $scope.diashome = [7,7,7,7,7,7,7]; //se inicializa en 7 en simbolodo de off - started in 7 equals off
    $scope.horaslista = [[],[],[],[],[],[],[]];
    for(i=0;i<$scope.horas.length;i++)
    { 
      if($scope.mathome.titulo == $scope.horasH[i].dom) {$scope.diashome[0] = 0; $scope.horaslista[0].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].sab) {$scope.diashome[6] = 6; $scope.horaslista[6].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].vie) {$scope.diashome[5] = 5; $scope.horaslista[5].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].jue) {$scope.diashome[4] = 4; $scope.horaslista[4].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].mie) {$scope.diashome[3] = 3; $scope.horaslista[3].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].mar) {$scope.diashome[2] = 2; $scope.horaslista[2].push($scope.horas[i].hora);}
      if($scope.mathome.titulo == $scope.horasH[i].lun) {$scope.diashome[1] = 1; $scope.horaslista[1].push($scope.horas[i].hora);}
    }
    //$scope.dayhome = $scope.diashome;
    $scope.selectDay();
  };
  $scope.selectDay = function(){
    $scope.horashome = ["No hour on that mat and day"];
    var elejido;
   if ($scope.mathome !== "") {
    for (var d = 0; d < $scope.diashome.length; d++) {
      if($scope.diashome[d] != 7){
        if (d == $scope.dateHomeValue[3]) {
          //console.log("encontro "+$scope.idioma.days[d]);
          $scope.horashome = $scope.horaslista[d];
        }
      }
    }
   }
  };
  $scope.selectSub();
    $scope.saveHomework = function(){
      console.log("edito");
    var todo2  = {"id": parseInt($_get("id")), "materia": $scope.mathome.titulo, "day": $scope.dateHomeValue, "hour":  $scope.horahome, "description": $scope.desHome, "state": $_get("state")};
    if($scope.mathome.titulo === "" || $scope.desHome === ""){
      LxNotificationService.alert('Campo vacio Ø', 'Por favor llena todos los campos.', 'ok', function(){});
      } 
    else {
      indexedDBDataSvc.editHW(todo2).then(function(){
          $scope.refreshTareas();
          LxNotificationService.success('Tarea Editada!');
        }, function(err){
          alert(err);
        });
      }
  };
  }]);
app.controller('add-nota', ['$scope', '$filter', 'LxNotificationService', 'indexedDBDataSvc', '$rootScope','colorMeta',function($scope, $filter, LxNotificationService, indexedDBDataSvc,$rootScope, colorMeta){
  $scope.title = $scope.idioma.new + " "+$scope.idioma.note;
  $scope.titleNote = "";
  $scope.desNote = "";
  $scope.priori = "green";
  $rootScope.cBarraNoti = "#4CAF50";
  $scope.colorBarN = function(){
    console.log("cambio prioridad " + $scope.priori);
    $rootScope.cBarraNoti = colorMeta.getColor($scope.priori);

  };
  $scope.saveNota = function(){
    if($scope.titleNote === "" || $scope.titleNote === undefined){
      LxNotificationService.alert('Campo vacio', 'Por favor inserta un título a la nota.', 'ok', function(){});
      } 
    else {
      var time  = new Date();
      var timeF = $filter('date')(time, 'fullDate');
      indexedDBDataSvc.addNote($scope.titleNote, $scope.desNote, $scope.priori, timeF).then(function(){
        $scope.refreshNotas();
        $scope.titleNote = "";
        $scope.desNote = "";
        $scope.priori = "green";
        $rootScope.cBarraNoti = "#4CAF50";
        LxNotificationService.success('¡Nota añadida!');
        }, function(err){
          alert(err);
        });
    }
  };
}]);

app.controller('config', ['$scope', 'LxNotificationService', 'indexedDBDataSvc', '$rootScope', function($scope, LxNotificationService, indexedDBDataSvc, $rootScope){
  $rootScope.cBarraNoti = "#424242";
  $scope.saveConfig = function(){
    indexedDBDataSvc.saveConfig($scope.dayVisible, $scope.alert, $scope.notifi, $scope.getlang).then(function(){
      LxNotificationService.success('¡Configuración guardada!');
      $scope.refreshList();
    }, function(err){
      alert(err);
    });
  };
  $scope.changeLang = function(){
    $scope.saveLang($scope.getlang);
  };
  $scope.resColor = function(){
    $rootScope.cBarraNoti = "#009688";
  };
}]);
app.controller('welcome', ['$scope', '$rootScope', function($scope, $rootScope){
  $scope.vista = true;
  $rootScope.cBarraNoti = "#212121";
  $scope.Novedades=[
  { 
    icon: 'alarm',
    titulo: 'Notificación',
    content: 'Ahora puedes recibir una notificación a la hora de comenzar una clase. Puedes configurar o desactivar esta opción en configuraciones.',
    color: 'green',
    label: 'New'
  },
  {
    icon: 'palette',
    titulo: 'Colores',
    content: 'Ya cuentas con 18 colores para perzonalizar tus materias y obtienes un ejemplo del color que decees elegir.',
    color: 'red',
    label: 'Update'
  },
  {
    icon: 'cellphone-link',
    titulo: 'Interfaz',
    content: 'Toda la interfaz fue cambiada al estilo material design.',
    color: 'red',
    label: 'Update'
  },
  {
    icon: 'clock',
    titulo: '2 horas',
    content: 'Ahora puedes indicar la hora de inicio y final de una actividad.',
    color: 'green',
    label: 'New'
  }];
  $scope.resColor = function(){
    $rootScope.cBarraNoti = "#009688";
  };
  
}]);
