var dbx = null;
var params = null;
var servidor = "";
var puntos = null;
var ruta = "";
var ancho = 0;
var sucursalLat = "";
var sucursalLon = "";
var sucursalLog = "";
var contenido = 0;
var lat = "";
var lon = "";

$(document).ready(function(){
	popup_close();
	dbx = new modDB();
	params = getUrlVars($('.pantalla').attr('data-url'));
	contenido = 0;
	for(var i in params){
		try{
			var elemento = null;
			elemento = params[i];
			if(elemento != null){
				contenido++;
				break;
			}
		}catch(e){
		}
	}
	if(contenido > 0){	
		sucursalLat = URLDecode(params["latitud"]);
		sucursalLon = URLDecode(params["longitud"]);
		sucursalLog = URLDecode(params["logo"]);
	}
	puntos = null;
	ruta = "";	
	ancho = parseInt($(window).width());
	$( "#slider" ).slider({ 
		orientation: "horizontal",
		max:16, 
		min:5,
		value:14,
		change: valorSlider,
		slide: valorSlider,
		animate: "fast", 
		step: 1
	});
	
	var slider = document.getElementsByClassName("ui-slider-handle")[0];
	new GestureDetector(slider).startDetecting();
	slider.addEventListener('pan',function(event){		
		$('a.ui-slider-handle').css({"left":event.detail.position.clientX + "px"});		
		var pos = parseInt(ancho/11);
		var pox = parseInt(event.detail.position.clientX/pos) + 5;	
		
		$( "#slider" ).slider("value", pox);
	});
		
	dbx.obtenerServidor(0,setServer);		
});

function valorSlider(){
	var zoom = $( "#slider" ).slider("value");
	crearMapa(zoom);
}


function setServer(serv){	
	var servidors = serv;
	var l = ($(servidors).toArray().length==1)?0:$(servidors).toArray().length+1;
	var r = Math.floor((Math.random()*l));
	servidor = servidors[r];
	if(contenido > 0){
		crearMapa(14);		
	} else {
		navigator.geolocation.getCurrentPosition(obtienePosicion);
	}	
}

function obtienePosicion(posicion){	
	lat = posicion.coords.latitude.toString();
	lon = posicion.coords.longitude.toString();
	//<REMOVER>
	/*POR CUESTIONIES DE PRUEBA SE DEJA QUEMADA LA UBICACION DE LAS OFICINAS CENTRALES DE TELEFONICA EN GUATEMALA*/
		lat = "14.588528";
		lon = "-90.4997031";
	//</REMOVER>
	var ubicacion = lat + "/" + lon;
	obtenerPuntos(ubicacion);
}

function obtenerPuntos(ubicacion){	
	$.jsonp({
		url: servidor + "/director/ClubMovistarV2/sucursalesRadio/" + dbx.sesion.cod_pais + "/" + ubicacion + "/3000",		
		callbackParameter:dbx.jsonp_callback,
		timeout: dbx.ajax_timeout,
		error: function(data){
			dbx.log("error");
			dbx.log(data);
		},
		success: function(data){
			dbx.log(data);
			puntos = data['retorno'];
			crearMapa(14);
		}	
	});
}

function crearMapa(zoom){
	if(puntos != null){
		
		var alto = parseInt($(window).width());
		ruta = "http://maps.googleapis.com/maps/api/staticmap?scale=2&size=640x640&sensor=false";
		var url = "";
		ruta += "&markers=color:green|" + lat + "," + lon + "&zoom=" + zoom;
		dbx.log("RUTA >> " + ruta);
		for(var i in puntos){
			var punto = puntos[i];
			var latitud = punto['latitud'];
			var longitud = punto['longitud'];
			var imagen = "";
			if(punto['imagenes'] && punto['imagenes'].length>0)
				imagen = punto['imagenes'][0];
			var puntoMapa = "&markers=";
			
			if(imagen != ""){
				puntoMapa += "icon:" + imagen + "|";
			} else {
				puntoMapa += "color:red|";
			}
			
			puntoMapa += latitud + "," + longitud + "&zoom=" + zoom;
			
			var largo = ruta.length + puntoMapa.length;
			if(largo < 1900){
				ruta += puntoMapa;
			} else {
				break;
			}		
		}
		$('#content').html('<img id="imgMapa">');
		var imagen = new Image();
		imagen.src = ruta;
		imagen.onload = function(){
			$('#imgMapa').attr('src', ruta);
			$('#content').scrollTo('50%', 0);
		};
	}
	if(contenido > 0){
		ruta = "http://maps.googleapis.com/maps/api/staticmap?scale=2&size=640x640&sensor=false&markers=";
		
		if(sucursalLog != ""){
			ruta += "icon:" + sucursalLog + "|";
		} else {
			ruta += "color:red|";
		}
		ruta += sucursalLat + "," + sucursalLon + "&zoom=" + zoom;
		
		$('#content').html('<img id="imgMapa"/>');
		var imagen = new Image();
		imagen.src = ruta;
		imagen.onload = function(){
			$('#imgMapa').attr('src', ruta);
			$('#content').scrollTo('50%', 0);
		};
	}
}