var servers = null;
var server = "";
var mat = {};

function setServer(serv)
{
    if(servers == null)
        servers = serv;
    var l = ($(servers).toArray().length==1)?0:$(servers).toArray().length+1;
    var r = Math.floor((Math.random()*l));
    server = servers[r];
//HACER LLAMADAS A TODOS LOS PAISES


    var pedido = indexedDB.open('movistardb');
    pedido.onsuccess = function(res){
        try{
            var db = res.target.result;
            var trans = db.transaction(["paises"]);

            var paises = trans.objectStore("paises").index("paises_cod_pais").openCursor();

            paises.onsuccess = function (res){
                var obj_cursor = res.target.result;

                if(obj_cursor) {
                    if(obj_cursor.value.activo==1){
                        mat.actualizarParamentrosContrasena(obj_cursor.value.cod_pais);
                    }
                    obj_cursor.continue();
                } else {
                    db.close();
                }
            };

        } catch (e){
            dbm.log(e.message);
        }
    };


}

var modAct = function(){
	var db = null;
	var callback = null;
	var rollback = null;


//<GENERICO>
mat.inicializar = function(catalogo, funcion, json, fallido, codEquipo,pais){
		callback = funcion;
		rollback = fallido;

    var pedido = indexedDB.open('movistardb');
		
		pedido.onerror = function(res){
			dbx.log("ERROR EN APERTURA");
		};
		
		pedido.onsuccess = function(res){
			db = res.target.result;

            if(catalogo == "faq"){
				mat.recorrerRaiz(json);
			} else if(catalogo == "opcionesEtiquetas" ){
				mat.actualizarEtiqueta(json, json[0]['id_dispositivo_pantalla']);
			} else if(catalogo == "paises"){
				mat.actualizarPais(json);
			} else if(catalogo == "producto"){
				mat.actualizarProdcuto(json);
			} else if(catalogo == "serviciosHlr"){
				mat.actualizarHlr(json);
			} else if(catalogo == "servidores"){
				mat.actualizarServidores(json);
			} else if(catalogo == "tipologias"){
				mat.actualizarTipologias(json, true);
			} else if(catalogo == "tipoPaquete"){
				mat.actualizarTipoPaquete(json);
			} else if(catalogo == "tipofaq"){
				mat.actualizarTipoFaq(json);
			} else if(catalogo == "tarjetasValidas"){
				mat.actualizarTarjeta(json);
			} else if(catalogo == "publicidad"){
				mat.actualizarPublicidad(json, codEquipo);
			} else if(catalogo == "paquetes"){
				//mat.actualizarPaquetes(json);
			} else if(catalogo == "monto_recarga"){
				mat.actualizarMonto(json);
			} else if(catalogo == "fecha"){
				mat.actualizarFecha(json);
			} else if(catalogo == "redes"){
				mat.actualizarRedes(json);
			} else if(catalogo == "configuracion"){
                mat.configuracionContrasena(json,pais);
            }  else {
				//dbx.log("ACTUALIZACION NO IMPLEMENTADA " + catalogo);
				callback();
			}
		};		
	};
	
mat.finalizar = function(){
		try{
			db.close();
			//dbx.log("TERMINO DE MATAR!!!!!");
			callback();
		}catch(e){
		}
	};
//</GENERICO>
	
//<FAQ>		
	var nodos = 0;
	var opciones = null;
	var sync = true;
mat.recorrerRaiz = function(raices){
		opciones = raices;
		nodos = raices.length;
		for(var i in raices){
			mat.eliminarArbol(raices[i]['tcamtfaqid']);
		}
};

mat.eliminarArbol = function(raiz){
		var trans_padre = db.transaction("opciones", "readwrite");
		var kill_padre = trans_padre.objectStore("opciones").index("opciones_cod_opcion").openCursor(IDBKeyRange.only(raiz));
		
		kill_padre.onsuccess = function(res){
			var padre_cursor = res.target.result;
			if(padre_cursor){
				nodos--;			
				var eliminacion = padre_cursor.delete();
				eliminacion.onsuccess = function(){
					dbx.log("ELIMINADO EXITOSAMENTE");
				};
			} else {
				nodos--;
			}
		};
		
		//<agregado>
					
		var trans_hijos = db.transaction("opciones");
		var recorre_hijos = trans_hijos.objectStore("opciones").index("opciones_opcion_padre").openCursor(IDBKeyRange.only(raiz));
			
		recorre_hijos.onsuccess = function(res){
			var hijos_cursor = res.target.result;
			if(hijos_cursor){
				nodos++;
				mat.eliminarArbol(hijos_cursor.value.cod_opcion);
				hijos_cursor.continue();
			} else {
				if(nodos == 0 && sync){
					sync = false;
					dbx.log("ENTRO EN ACTUALIZAR FAQ!!!!!!");
					mat.actualizarFaq(opciones, true);
				}
			} 
		};
		//</agregado>		
	};
	
	var contenido_faq = [];
mat.actualizarFaq = function(opciones, flag){
		for(var i in opciones){
			var latitud = "";
			var longitud = "";
			var opcion = opciones[i];
			var pais = opcion['areapais'];
			var raiz = opcion['tcamtfaqtipoid'];
			var id = opcion['tcamtfaqid'];
			var padre = opcion['tcamtfaqid_padre'];
			var nombre = opcion['nombre'];
			var descripcion = opcion['descripcion'];
			var tipo = opcion['tipo_vista'];
			var orden = opcion['orden'];
			latitud = opcion['latitud'];
			longitud = opcion['longitud'];
			var nHijos = opcion['listadoTotalHijos'];			
			descripcion = descripcion.replace(/[\r\n]/g, "<br/>");
			contenido_faq.push({cod_opcion: id, cod_pais: pais, etiqueta: nombre, descripcion: descripcion, tipo: tipo, opcion_padre: padre, raiz: raiz, orden: orden, latitud: latitud, longitud: longitud});
			
			if(nHijos > 0){
				var lHijos = opcion['listadoHijos'];
				mat.actualizarFaq(lHijos, false);
			}
		}

		if(flag){
			var trans = db.transaction("opciones", "readwrite");
			var nuevo = trans.objectStore("opciones");
			for(var j in contenido_faq){
				var father = null;
				var inserto = null;
				father = contenido_faq[j]['opcion_padre'];
				
				if(father == null){
					inserto = {cod_opcion: contenido_faq[j]['cod_opcion'], cod_pais: parseInt(contenido_faq[j]['cod_pais']), etiqueta: contenido_faq[j]['etiqueta'], descripcion: contenido_faq[j]['descripcion'], tipo: contenido_faq[j]['tipo'], opcion_padre: - contenido_faq[j]['raiz'], orden: contenido_faq[j]['orden'], latitud: contenido_faq[j]['latitud'], longitud: contenido_faq[j]['longitud']};
				} else {
					inserto = {cod_opcion: contenido_faq[j]['cod_opcion'], cod_pais: parseInt(contenido_faq[j]['cod_pais']), etiqueta: contenido_faq[j]['etiqueta'], descripcion: contenido_faq[j]['descripcion'], tipo: contenido_faq[j]['tipo'], opcion_padre: father, orden: contenido_faq[j]['orden'], latitud: contenido_faq[j]['latitud'], longitud: contenido_faq[j]['longitud']};
				}
				try{	
					
					var commit = nuevo.put(inserto);
					commit.onerror = function(res){
						rollback(); 
						dbx.log("ERROR AL INGRESO " + res);
						//break;
					};
				} catch(e){
					dbx.log("ERROR RE-INSERCION: " + e.message);
				}
			}
			mat.finalizar();
		}
	};
//</FAQ>		

//<ETIQUETA>	
	var contenido_etq = [];
mat.actualizarEtiqueta = function(opciones, id_pantalla){
		for(var i in opciones){
			var opcion = opciones[i];
			var cod_etiqueta = opcion['id_dispositivo'];
			var cod_pantalla = opcion['id_dispositivo_pantalla'];
			var nombre = opcion['nombre'];
			var cod_pais = opcion['areapais'];
			var listadoProducto = opcion['listadoProducto'];
			
			for(var j in listadoProducto){
				var nodo = listadoProducto[j];
				var cod_equipo = nodo['cod_uso'];
				var valor = nodo['etiqueta'];
				var orden = nodo['orden'];
				
				contenido_etq.push({cod_etiqueta: cod_etiqueta, cod_pantalla: cod_pantalla, nombre: nombre, cod_pais: cod_pais, cod_equipo: cod_equipo, valor: valor, orden: orden});
			}			
		}
		
		var trans = db.transaction("fusion_etiqueta", "readwrite");
		var objeto = trans.objectStore("fusion_etiqueta").index("fusion_etiqueta_cod_pantalla").openCursor(IDBKeyRange.only(id_pantalla));
			
		objeto.onerror = function(res){
			//dbx.log(res);
		};
			
		objeto.onsuccess = function(res){
			try{
				var fila = res.target.result;
				if(fila){
					var etiqueta = contenido_etq[0];
					if(parseInt(etiqueta['cod_pais']) == fila.value.cod_pais){
						var eliminacion = fila.delete();
						eliminacion.onsuccess = function(){
							dbx.log("ELIMINADO EXITOSAMENTE");
						};						
					}
					fila.continue();
					
				} else {
					var trans = db.transaction("fusion_etiqueta", "readwrite");
					var nuevo = trans.objectStore("fusion_etiqueta");
					
					mat.auxInsertoEtiqueta(nuevo, contenido_etq.length, 0);
				}
			} catch(e){
				dbx.log("ERROR FUSION_ETIQUETA: " + e.message);
			}
		};		
	};	
	
	
mat.auxInsertoEtiqueta = function (trans, total, actual){
	if(actual < total){
		var etiqueta = contenido_etq[actual];
		var inserto = {cod_etiqueta: parseInt(etiqueta['cod_etiqueta']), cod_pantalla: parseInt(etiqueta['cod_pantalla']), nombre: etiqueta['nombre'], cod_pais: parseInt(etiqueta['cod_pais']), cod_equipo: parseInt(etiqueta['cod_equipo']), valor: etiqueta['valor'], orden: parseInt(etiqueta['orden'])};
						
		try{							
			var commit = trans.put(inserto);
			commit.onerror = function(res){
				rollback();
				dbx.log("ERROR AL INGRESO ");
				dbx.log(res);
			};
			commit.onsuccess = function(res){
				dbx.log("ETIQUETA INSERTADA CORRECTAMENTE >> " + res.type);
				actual++;
				mat.auxInsertoEtiqueta(trans, total, actual);
			};
		} catch(e){
			dbx.log("ERROR RE-INSERCION: " + e.message);
		}
	} else {
		mat.finalizar();
	}
}
//</ETIQUETA>

//<PAIS>
	var contenido_pais = [];
mat.actualizarPais = function(opciones){
		for(var i in opciones){
			var opcion = opciones[i];
			var cod_pais = opcion['areaPais'];
			var nombre = opcion['nombrePais'];
			var max_numero = opcion['longitud_numero'];		
			var url = opcion['url_condiciones'];
			var cant_vencimiento = opcion['cantVencimiento'];
			var muestra_registro = opcion['registro'];
			var porcentaje_encuesta = opcion['porc_encuesta'];
			
			contenido_pais.push({cod_pais: cod_pais, nombre: nombre, max_numero: max_numero, activo: 1, url: url, codigo_area: cod_pais, cant_vencimiento: cant_vencimiento, muestra_registro: muestra_registro, porcentaje_transacciones: porcentaje_encuesta});
		}
		
		var trans = db.transaction("paises", "readwrite");
		var objeto = trans.objectStore("paises").openCursor();
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			if(fila){
				fila.delete();
				fila.continue();
			} else {
				var trans = db.transaction("paises", "readwrite");
				var nuevo = trans.objectStore("paises");
				
				for(var j in contenido_pais){
					var pais = contenido_pais[j];
					var inserto = {cod_pais: parseInt(pais['cod_pais']), nombre: pais['nombre'], max_numero: parseInt(pais['max_numero']), activo: 1, url: pais['url'], codigo_area: parseInt(pais['codigo_area']), cant_vencimiento: parseInt(pais['cant_vencimiento']), muestra_registro: parseInt(pais['muestra_registro']), porcentaje_transacciones: parseFloat(pais['porcentaje_transacciones'])};
					
					try{
						var commit = nuevo.put(inserto);
						commit.onerror = function(res){
							rollback(); 
							dbx.log("ERROR AL INGRESO " + res);
							//break;
						};
						//dbx.log("Pais incertado");
					} catch(e){
						dbx.log("ERROR RE-INSERCION: " + e.message);
					}
				}
                mat.finalizar();

			}
		};		
	};
//</PAIS>
//<Configuracion>
    mat.configuracionContrasena = function(data,pais){

        var trans = db.transaction("paises", "readwrite");
        var objectStore = trans.objectStore("paises").index("paises_cod_pais").openCursor();
        var codPais = 0;
        var nombrePais = "";
        var maxNumeroPais =  0;
        var activoPais =  1;
        var urlPais =  "";
        var codigoAreaPais =  0;
        var cantVencimientoPais =  0;
        var muestraRegistroPais = 0;
        var porcentajePais = "0.0";
        try{
            objectStore.onsuccess = function (res){
                var obj_cursor = res.target.result;
                var resultado = data;



                if(obj_cursor) {
                    if( obj_cursor.value.cod_pais == pais){
                        codPais = obj_cursor.value.cod_pais;
                        nombrePais = obj_cursor.value.nombre;
                        maxNumeroPais =  obj_cursor.value.max_numero;
                        activoPais =  obj_cursor.value.activo;
                        urlPais =  obj_cursor.value.url;
                        codigoAreaPais =  obj_cursor.value.codigo_area;
                        cantVencimientoPais =  obj_cursor.value.cant_vencimiento;
                        muestraRegistroPais =  obj_cursor.value.muestra_registro;
                        if(obj_cursor.value.porcentaje_transacciones != undefined){
                            porcentajePais =  obj_cursor.value.porcentaje_transacciones;
                        }else{
                            porcentajePais =  "0.0";
                        }
                        //console.log(obj_cursor.value.nombre + " NOMBRE");
                        obj_cursor.delete();
                        //console.log("delete Pais");
                    }
                    obj_cursor.continue();
                }else{
                    if(resultado.estado && resultado.estado=="OK")
                    {

                        if(resultado.retorno){
                            if( codPais == pais) {
                                var nuevo = trans.objectStore("paises");
                                //var inserto = {cod_pais: resultado.retorno.cod_pais, nombre: nombrePais, max_numero: maxNumeroPais, activo: activoPais, url: urlPais, codigo_area: codigoAreaPais, cant_vencimiento: cantVencimientoPais, muestra_registro:muestraRegistroPais, porcentaje_encuesta: porcentajePais, clave_requiere_numero: obj_cursor.value.clave_requiere_numero,clave_requiere_letra: obj_cursor.value.clave_requiere_letra, clave_requiere_mayuscula:  obj_cursor.value.clave_requiere_mayuscula, clave_requiere_minuscula: obj_cursor.value.clave_requiere_minuscula, clave_requiere_especial: obj_cursor.value.clave_requiere_especial, clave_longitud_min:  obj_cursor.value.clave_longitud_min, clave_longitud_max:  obj_cursor.value.clave_longitud_max };
                                var inserto = {cod_pais:codPais, nombre: nombrePais, max_numero: maxNumeroPais, activo: activoPais, url: urlPais, codigo_area: codigoAreaPais, cant_vencimiento: cantVencimientoPais, muestra_registro:muestraRegistroPais, porcentaje_transacciones: parseFloat(porcentajePais), clave_requiere_numero: resultado.retorno.clave_requiere_numero,clave_requiere_letra: resultado.retorno.clave_requiere_letra, clave_requiere_mayuscula:  resultado.retorno.clave_requiere_mayuscula, clave_requiere_minuscula: resultado.retorno.clave_requiere_minuscula, clave_requiere_especial: resultado.retorno.clave_requiere_especial, clave_longitud_min:  resultado.retorno.clave_longitud_min, clave_longitud_max:  resultado.retorno.clave_longitud_max };
                                try{
                                   // console.log("INSERTO CONFIG" );
                                  //  console.log(nombrePais + " NOMBRE2");
                                    var commit = nuevo.put(inserto);
                                    commit.onerror = function(res){
                                        rollback();
                                        dbx.log("ERROR AL INGRESO " + res);
                                       // console.log("ERROR AL INGRESO " + res);

                                        //break;
                                    };
                                    //dbx.log("Pais incertado");
                                } catch(e){
                                    dbx.log("ERROR RE-INSERCION: " + e.message);
                                  //  console.log("ERROR RE-INSERCION: " + e.message);
                                }
                            }
                        }
                    }else{
                        dbx.log("Contrasenas UPDATE NO NECESARIO YA ESTA AL DIA");
                        //console.log("Contrasenas UPDATE NO NECESARIO YA ESTA AL DIA");
                    }
                }
            };

        }catch(e) {
            dbm.log(e.message);
        }
        mat.finalizar();
    };


//</Configuracion>
//<CONTRASENA>
    mat.actualizarParamentrosContrasena = function(pais){
                    var url = "/admon/moduloseguridad/obtenerConfiguracion/"+pais;

                    $.jsonp({
                        url: server+url,
                        callbackParameter:dbx.jsonp_callback,
                        timeout: dbx.ajax_timeout,
                        error: function(xOptions,data){
                            // popup_close();
                            alert(dbx.headerAlerta + dbx.errorDef);

                        },
                        success: function (data, textStatus, xOptions) {
                           /* if(!$("#overlay").is(":visible"))
                            {
                                return;
                            }*/
                            // popup_close();
                            //console.log("ACTUALIZANDO PARAMETROS CONTRASENA 2");

                            mat.configuracionContrasena(data,pais);
                        }
                    });
    };

//</CONTRASENA>

//<PRODUCTO>
	var contenido_producto = [];
mat.actualizarProdcuto = function(opciones){
		for(var i in opciones){
			var opcion = opciones[i];
			var cod_equipo = opcion['coduso'];
			var cod_pais = opcion['areaPais'];
			var nombre = opcion['nombreProducto'];
			var estado = opcion['estado'];
			var sub_estado = 0;
			
			if(estado == "ALTA"){
				sub_estado = 1;
			} 
			
			contenido_producto.push({cod_equipo: cod_equipo, cod_pais: cod_pais, nombre: nombre, estado: sub_estado});			
		}
		
		var trans = db.transaction("equipos", "readwrite");
		var objeto = trans.objectStore("equipos").openCursor();
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			
			if(fila){
				var producto = contenido_producto[0];					
				if(parseInt(producto['cod_pais']) == fila.value.cod_pais){
					fila.delete();
				}				
				fila.continue();
			} else {
				var trans = db.transaction("equipos", "readwrite");
				var nuevo = trans.objectStore("equipos");
				
				for(var j in contenido_producto){
					var producto = contenido_producto[j];
					var inserto = {cod_equipo: parseInt(producto['cod_equipo']), cod_pais: parseInt(producto['cod_pais']), nombre: producto['nombre'], estado: producto['estado']};
					
					try{
						var commit = nuevo.put(inserto);
						commit.onerror = function(res){
							rollback();
							dbx.log("ERROR AL INGRESO " + res);
							//break;
						};
						//dbx.log("Equipo agregado");
					}catch(e){
						dbx.log("ERROR RE-INSERCION: " + e.message);
					}
				}
				mat.finalizar();
			}
		};
	};
//</PRODUCTO>

//<SERVICIOSHLR>
	var contenido_hlr = [];
mat.actualizarHlr = function(opciones){
		for(var i in opciones){
			var opcion = opciones[i];
			var cod_servicio = opcion['tcamtserviciohlrid'];
			var cod_pais = opcion['areaPais'];
			var nombre = opcion['nombreServicio'];
			var descripcion = opcion['descripcionServicio'];
			var accion = opcion['accion'];
			var estado = 0;
			var activo = 1;
			var codigo = opcion['codigoServicio'];
			var visible = 1;
		
			contenido_hlr.push({cod_servicio: cod_servicio, cod_pais: cod_pais, nombre: nombre, descripcion: descripcion, accion: accion, estado: estado, activo: activo, codigo: codigo, visible: visible});
		}
		
		var trans = db.transaction("servicios", "readwrite");
		var objeto = trans.objectStore("servicios").openCursor();
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			
			if(fila){
				var servicio = contenido_hlr[0];
				if(parseInt(servicio['cod_pais']) == fila.value.cod_pais){
					fila.delete();
				}				
				fila.continue();
			} else {
				var trans = db.transaction("servicios", "readwrite");
				var nuevo = trans.objectStore("servicios");
				
				for(var j in contenido_hlr){
					var servicio = contenido_hlr[j];
					var inserto = {cod_servicio: parseInt(servicio['cod_servicio']), cod_pais: parseInt(servicio['cod_pais']), nombre: servicio['nombre'], descripcion: servicio['descripcion'], accion: parseInt(servicio['accion']), estado: servicio['estado'], activo: servicio['activo'], codigo: servicio['codigo'], visible: servicio['visible']};
					
					try{
						var commit = nuevo.put(inserto);
						commit.onerror = function(res){
							rollback();
							dbx.log("ERROR AL INGRESO " + res);
							//break;
						};
						//dbx.log("Servicio incertado");
					} catch(e){
						dbx.log("ERROR RE-INSERCION: " + e.message);
					}
				}
				mat.finalizar();
			}
		};
	};
//</SERVICIOSHLR>

//<SERVIDORES>
	var contenido_servidores = [];
mat.actualizarServidores = function(opciones){
		for(var i in opciones){
			var opcion = opciones[i];
			var server = opcion['ip'];
			var tipo = opcion['tipo'];
			
			contenido_servidores.push({server: server, tipo: tipo});
		}
		
		var trans = db.transaction("servidores", "readwrite");
		var objeto = trans.objectStore("servidores").openCursor();
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			if(fila){
				fila.delete();
				fila.continue();
			} else {
				var trans = db.transaction("servidores", "readwrite");
				var nuevo = trans.objectStore("servidores");
				
				for(var j in contenido_servidores){
					var servidor = contenido_servidores[j];
					var inserto = {server: servidor['server'], tipo: parseInt(servidor['tipo'])};
					
					try{
						var commit = nuevo.put(inserto);
						commit.onerror = function(res){
							rollback(); 
							dbx.log("ERROR AL INGRESO " + res);
							//break;
						};
						//dbx.log("Servidor incertado");
					}catch(e){
						dbx.log("ERROR RE-INSERCION: " + e.message);
					}
				}
				mat.finalizar();
			}			
		};		
	};
//</SERVIDORES>

//<TIPOLOGIAS>
	var contenido_tpg = [];
mat.actualizarTipologias = function(opciones, flag){
		for(var i in opciones){
			var opcion = opciones[i];
			var cod_consulta			= "";
			var cod_equipo				= "";
			var cod_pais				= "";
			var nombre					= "";
			var codigo_padre			= "";
			var orden					= "";
			var opcion_1_habilitado		= "";
			var opcion_1_obligatorio	= "";
			var opcion_1_etiqueta		= "";
			var opcion_1_longitud		= "";
			var opcion_2_habilitado		= "";
			var opcion_2_obligatorio	= "";
			var opcion_2_etiqueta		= "";
			var opcion_2_longitud		= "";
			var tipologiaid				= "";
			
			cod_consulta			= opcion['tcamtnodostipoid'];
			cod_equipo				= opcion['cod_uso']; 
			cod_pais				= opcion['area'];	
			nombre					= opcion['nombreNodo'];
			codigo_padre			= (opcion['tcamtnodospadreid'].trim().length==0)?"0":opcion['tcamtnodospadreid'];
			orden					= opcion['orden'];
			opcion_1_habilitado		= opcion['sn_habilitado'];
			opcion_1_obligatorio	= opcion['sn_obligatorio'];
			opcion_1_etiqueta		= opcion['etiqueta'];
			opcion_1_longitud		= opcion['longitud'];
			opcion_2_habilitado		= opcion['sn_habilitado2'];
			opcion_2_obligatorio	= opcion['sn_obligatorio2'];	
			opcion_2_etiqueta		= opcion['etiqueta2'];
			opcion_2_longitud		= opcion['longitud2'];
			tipologiaid				= (opcion['tcamttipologiaid'].trim().length==0)?"0":opcion['tcamttipologiaid']; 
			
			contenido_tpg.push({cod_consulta: cod_consulta, cod_equipo: cod_equipo, cod_pais: cod_pais, nombre: nombre, codigo_padre: codigo_padre, orden: orden, opcion_1_habilitado: opcion_1_habilitado, opcion_1_obligatorio: opcion_1_obligatorio, opcion_1_etiqueta: opcion_1_etiqueta, opcion_1_longitud: opcion_1_longitud, opcion_2_habilitado: opcion_2_habilitado, opcion_2_obligatorio: opcion_2_obligatorio, opcion_2_etiqueta: opcion_2_etiqueta, opcion_2_longitud: opcion_2_longitud, tipologiaid: tipologiaid});	
			
			if(opcion.nodosHijos){
				mat.actualizarTipologias(opcion['nodosHijos'], false);
			}
		}

		if(flag){
			var trans = db.transaction("consultas", "readwrite");
			var objeto = trans.objectStore("consultas").openCursor();
			
			objeto.onsuccess = function(res){
				var fila = res.target.result;
				
				if(fila){
					var consulta = contenido_tpg[0];
					if(parseInt(consulta['cod_pais']) == fila.value.cod_pais){
						fila.delete();
					}
					fila.continue();
				} else {
					var trans = db.transaction("consultas", "readwrite");
					var nuevo = trans.objectStore("consultas");
					
					for(var j in contenido_tpg){
						var consulta = contenido_tpg[j];
						var inserto = {cod_consulta: parseInt(consulta['cod_consulta']), cod_equipo: parseInt(consulta['cod_equipo']), cod_pais: parseInt(consulta['cod_pais']), nombre: consulta['nombre'], codigo_padre: parseInt(consulta['codigo_padre']), orden: parseInt(consulta['orden']), opcion_1_habilitado : parseInt(consulta['opcion_1_habilitado']), opcion_1_obligatorio: parseInt(consulta['opcion_1_obligatorio']), opcion_1_etiqueta: consulta['opcion_1_etiqueta'], opcion_1_longitud: parseInt(consulta['opcion_1_longitud']), opcion_2_habilitado: parseInt(consulta['opcion_2_habilitado']), opcion_2_obligatorio: parseInt(consulta['opcion_2_obligatorio']), opcion_2_etiqueta: consulta['opcion_2_etiqueta'], opcion_2_longitud: parseInt(consulta['opcion_2_longitud']), tipologiaid: parseInt(consulta['tipologiaid'])};
						
						try{
							var commit = nuevo.put(inserto);
							commit.onerror = function(res){
								rollback(); 
								dbx.log("ERROR AL INGRESO " + res);
								//break;
							};
							//dbx.log("Tipologia insertada");
						}catch(e){
							dbx.log("ERROR RE-INSERCION: " + e.message);
						}
					}
					mat.finalizar();
				}
			};
		} 	
	};
//</TIPOLOGIAS>

//<TIPOPAQUETE>
	var contenido_tp = [];
mat.actualizarTipoPaquete = function(opciones){
		for(var i in opciones){
			var opcion = opciones[i];
			var cod_tipo_paquete = opcion['tcAmtTipoPaqueteId'];
			var cod_pais = opcion['areaPais'];
			var nombre = opcion['nombre'];
			
			contenido_tp.push({cod_tipo_paquete: cod_tipo_paquete, cod_pais: cod_pais, nombre: nombre});			
		}
		
		var trans = db.transaction("tipos_paquete", "readwrite");
		var objeto = trans.objectStore("tipos_paquete").openCursor();
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			
			if(fila){
				var tipo = contenido_tp[0];
				if(parseInt(tipo['cod_pais']) == fila.value.cod_pais){
					fila.delete();
				}
				fila.continue();
			} else {
				var trans = db.transaction("tipos_paquete", "readwrite");
				var nuevo = trans.objectStore("tipos_paquete");
				
				for(var j in contenido_tp){
					var tipo = contenido_tp[j];
					var inserto = {cod_tipo_paquete: parseInt(tipo['cod_tipo_paquete']), cod_pais: parseInt(tipo['cod_pais']), nombre: tipo['nombre']};
					
					try{
						var commit = nuevo.put(inserto);
						commit.onerror = function(res){
							rollback(); 
							dbx.log("ERROR AL INGRESO " + res);
							//break;
						};
						//dbx.log("Tipo Paquete incertado");
					}catch(e){
						dbx.log("ERROR RE-INSERCION: " + e.message);
					}
				}
				mat.finalizar();
			}			
		};
	};
//</TIPOPAQUETE>

//<TIPOFAQ>
	var contenido_tpfq = [];
mat.actualizarTipoFaq = function(opciones){
		for(var i in opciones){
			var opcion = opciones[i];
			var cod_tipo_opcion = opcion['tcamtfaqtipoid'];
			var cod_pais = opcion['areapais'];
			var nombre = opcion['nombretipo'];
			var tipo = opcion['tipo_vista'];
			
			contenido_tpfq.push({cod_tipo_opcion: cod_tipo_opcion, cod_pais: cod_pais, nombre: nombre, tipo: tipo});
		}
		
		var trans = db.transaction("tipo_opciones", "readwrite");
		var objeto = trans.objectStore("tipo_opciones").openCursor();
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			if(fila){
				var tfaq = contenido_tpfq[0];
				if(parseInt(tfaq['cod_pais']) == fila.value.cod_pais){
					fila.delete();
				}
				fila.continue();
			} else {
				var trans = db.transaction("tipo_opciones", "readwrite");
				var nuevo = trans.objectStore("tipo_opciones");
				
				for(var j in contenido_tpfq){
					var tfaq = contenido_tpfq[j];
					var inserto = {cod_tipo_opcion: parseInt(tfaq['cod_tipo_opcion']), cod_pais: parseInt(tfaq['cod_pais']), nombre: tfaq['nombre'], tipo: parseInt(tfaq['tipo'])};
					
					try{
						var commit = nuevo.put(inserto);
						commit.onerror = function(res){
							rollback(); 
							dbx.log("ERROR AL INGRESO " + res);
							//break;
						};
						//dbx.log("Tipo Faq incertado");
					}catch(e){
						dbx.log("ERROR RE-INSERCION: " + e.message);
					}
				}
				mat.finalizar();
			}
		};
	};
//</TIPOFAQ>

//<TARJEAVALIDA>
	var contenido_tvalida = [];
mat.actualizarTarjeta = function(opciones){
		for(var i in opciones){
			var opcion = opciones[i];
			var cod_tarjeta = opcion['tcamttarjetacreditoid'];
			var cod_pais = opcion['areapais'];
			var nombre = opcion['nombre'];
			var max_numero = opcion['longitud_tarjeta'];
			var max_cvv = opcion['longitud_cvv'];
			var estado = opcion['estado'];
			var sub_estado = 0;
			
			if(estado == "ALTA"){
				sub_estado = 1;
			}
			
			contenido_tvalida.push({cod_tarjeta: cod_tarjeta, cod_pais: cod_pais, nombre: nombre, max_numero: max_numero, max_cvv: max_cvv, estado: sub_estado});
		}
		
		var trans = db.transaction("tarjetas", "readwrite");
		var objeto = trans.objectStore("tarjetas").openCursor();
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			if(fila){
				var tarjeta = contenido_tvalida[0];
				if(parseInt(tarjeta['cod_pais']) == fila.value.cod_pais){
					fila.delete();
				}
				fila.continue();
			} else {
				var trans = db.transaction("tarjetas", "readwrite");
				var nuevo = trans.objectStore("tarjetas");
				
				for(var j in contenido_tvalida){
					var tarjeta = contenido_tvalida[j];
					var inserto = {cod_tarjeta: parseInt(tarjeta['cod_tarjeta']), cod_pais: parseInt(tarjeta['cod_pais']), nombre: tarjeta['nombre'], max_numero: parseInt(tarjeta['max_numero']), max_cvv: parseInt(tarjeta['max_cvv']), estado: tarjeta['estado']};
					
					try{
						var commit = nuevo.put(inserto);
						commit.onerror = function(res){
							rollback(); 
							dbx.log("ERROR AL INGRESO " + res);
							//break;
						};
					}catch(e){
						dbx.log("ERROR RE-INSERCION: " + e.message);
					}
				}
				mat.finalizar();
			}
		};		
	};
//</TARJETAVALIDA>

//<PUBLICIDAD>
	
mat.actualizarPublicidad = function(opciones, codEquipo){
	var contenido_pub = [];
		for(var i in opciones){
			
			var opcion = opciones[i];
			dbx.log(opcion);
			var cod_pais = opcion['areaPais'];
			var path = "/imagenes/novedades/";
			var url = opcion['url'];
			var nombre = opcion['nombrePublicidad'];
			var activo = 1;
			var animacion = opcion['animacion'];
			var vence = opcion['fin'];
			var inicio = opcion['inicio'];
			var vinculo = opcion['vinculo'];
			if(opcion.nombreAgrupacion == "firefoxosSmall")
				contenido_pub.push({cod_pais: cod_pais, path: path, url: url, nombre: nombre, activo: activo, animacion: animacion, vence: vence, inicio: inicio, vinculo: vinculo});
		}
		codEquipo = codEquipo + "";
		
		if(codEquipo.trim().length == 0)
			codEquipo = "0";
		var trans = db.transaction("novedades", "readwrite");
		var objeto = trans.objectStore("novedades").openCursor();
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			if(fila && contenido_pub[0] != null){
				var novedad = contenido_pub[0];
				if(parseInt(novedad['cod_pais']) == fila.value.cod_pais){
					if(parseInt(fila.value.cod_equipo) == parseInt(codEquipo))
						fila.delete();
				}
				fila.continue();
			} else {
				var trans = db.transaction("novedades", "readwrite");
				var nuevo = trans.objectStore("novedades");
				
				for(var j in contenido_pub){
					var novedad = contenido_pub[j];
					var inserto = {cod_pais: parseInt(novedad['cod_pais']), path: novedad['path'], url: novedad['url'], nombre: novedad['nombre'], activo: novedad['activo'], animacion: parseInt(novedad['animacion']), vence: parseInt(novedad['vence']), inicio: parseInt(novedad['inicio']), vinculo: novedad['vinculo'], cod_equipo: codEquipo};
					
					try{
						var commit = nuevo.put(inserto);
						commit.onerror = function(res){
							rollback(); 
							dbx.log("ERROR AL INGRESO ");
							dbx.log(res);
							//break;
						};
					}catch(e){
						dbx.log("ERROR RE-INSERCION: " + e.message);
					}
				}
				mat.finalizar();
			}
		};
	};
//</PUBLICIDAD>

//<PAQUETE>
	var contenido_paq = [];
	var contenido_bolsa = [];
/*mat.actualizarPaquetes = function(opciones){
		var pais = parseInt(opciones[0]['areapais']);
		var trans = db.transaction("tipos_paquete");
		var objeto = trans.objectStore("tipos_paquete").index("tipos_paquete_cod_pais").openCursor(IDBKeyRange.only(pais));
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			if(fila){
				for(var i in opciones){
					var opcion = opciones[i];
					if(opcion['tcamttipopaqueteid'] == fila.value.cod_tipo_paquete){
						var cod_paquete = opcion['tcamtpaqueteid'];
						var cod_tipo_paquete = opcion['tcamttipopaqueteid'];
						var nombre = opcion['titulo'];
						var descripcion = opcion['descripcion'];
						var precio =  opcion['precio'];
						var preciof = opcion['preciof'];
						var orden = parseInt(opcion['orden']);
						var bolsa = parseInt(opcion['nivel_bolsa']);
						var cod_pais = parseInt(opcion['areapais']);
						var nombre_paquete = opcion['nombretipopaquete'];
						
						contenido_paq.push({cod_paquete: cod_paquete, cod_tipo_paquete: cod_tipo_paquete, nombre: nombre, descripcion: descripcion, precio: precio, preciof: preciof, orden: orden, bolsa: bolsa, cod_pais: cod_pais, nombre_paquete: nombre_paquete});
						
						if(opcion['listadoTotalBolsa'] > 0){
							var bolsas = opcion['listadoBolsa'];
							for(var j in bolsas){
								var bolsa = bolsas[j];
								var cod_bolsa = bolsa['cod_bolsa'];
								var cod_paquete = bolsa['tcamtpaqueteid'];
								
								contenido_bolsa.push({cod_bolsa: cod_bolsa, cod_paquete: cod_paquete});
							}
						}
					}
				}				
				fila.continue();
			} else {	
				var pais = contenido_paq[0]['cod_pais'];
				var trans1 = db.transaction("fusion_paquetes", "readwrite");
				var objeto1 = trans1.objectStore("fusion_paquetes").index("fusion_paquetes_cod_pais").openCursor(IDBKeyRange.only(pais));
				
				objeto1.onsuccess = function(res){
					var fila = res.target.result;
					if(fila){
						fila.delete();
						fila.continue();
					} else {
						var transf = db.transaction("fusion_paquetes", "readwrite");
						var nuevo = transf.objectStore("fusion_paquetes");
						
						for(var j in contenido_paq){
							var fpaq = contenido_paq[j];
							var inserto = {cod_paquete: fpaq['cod_paquete'], cod_tipo_paquete: fpaq['cod_tipo_paquete'], nombre: fpaq['nombre'], descripcion: fpaq['descripcion'], precio: fpaq['precio'], preciof: fpaq['preciof'], orden: fpaq['orden'], bolsa: fpaq['bolsa'], cod_pais: fpaq['cod_pais'], nombre_paquete: fpaq['nombre_paquete']};
							
							try{
								var commit = nuevo.put(inserto);
								commit.onerror = function(res){
									rollback(); 
									dbx.log("ERROR AL INGRESO " + res);
									//break;
								};
							}catch(e){
								dbx.log("ERROR RE-INSERCION: " + e.message);
							}
						}
						flag1 = true;
						mat.finalizaresp();
					}
				};
				
				var trans2 = db.transaction("paquete_bolsa", "readwrite");
				var objeto2 = trans2.objectStore("paquete_bolsa").openCursor();
				
				objeto2.onsuccess = function(res){
					var fila = res.target.result;
					if(fila){
						fila.delete();
						fila.continue();
					} else {
						var transf = db.transaction("paquete_bolsa", "readwrite");
						var nuevo = transf.objectStore("paquete_bolsa");
						
						for(var j in contenido_bolsa){
							var fbol = contenido_bolsa[j];
							var inserto = {cod_bolsa: fbol['cod_bolsa'], cod_paquete: fbol['cod_paquete']};
							
							try{
								var commit = nuevo.put(inserto);
								commit.onerror = function(res){
									rollback(); 
									dbx.log("ERROR AL INGRESO " + res); 
									//break;
								};
							}catch(e){
								dbx.log("ERROR RE-INSERCION: " + e.message);
							}
						}
						flag2 = true;
						mat.finalizaresp();
					}
				};
			}
		};
	};*/
	var flag1 = false;
	var flag2 = false;
mat.finalizaresp = function(){
		if(flag1 && flag2){
			try{
				db.close();
				//dbx.log("TERMINO DE MATAR etiquetas!!!!!");
				dbx.log("FINALIZO PAQUETES");
				callback();
			}catch(e){
			}
		}
	};
//<PAQUETE>

//<MONTO>
	var contenido_monto = [];
mat.actualizarMonto = function(opciones){
		for(var i in opciones){
			var opcion = opciones[i];
			var cod_monto = parseInt(opcion['tcamtrecargaid']);
			var cod_pais = parseInt(opcion['areaPais']);
			var monto = opcion['montoRecarga'];
			
			contenido_monto.push({cod_monto: cod_monto, cod_pais: cod_pais, monto: monto});
		}
		
		var pais = contenido_monto[0]['cod_pais'];
		var trans = db.transaction("montos_recarga", "readwrite");
		var objeto = trans.objectStore("montos_recarga").index("montos_recarga_cod_pais").openCursor(IDBKeyRange.only(pais));
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			if(fila){
				fila.delete();
				fila.continue();
			} else {
				var trans = db.transaction("montos_recarga", "readwrite");
				var nuevo = trans.objectStore("montos_recarga");
				
				for(var j in contenido_monto){
					var monto = contenido_monto[j];
					var inserto = {cod_monto: monto['cod_monto'], cod_pais: monto['cod_pais'], monto: monto['monto']};
					
					try{
						var commit = nuevo.put(inserto);
						commit.onerror = function(res){
							rollback(); 
							dbx.log("ERROR AL INGRESO " + res);
							//break;
						};
					}catch(e){
						dbx.log("ERROR RE-INSERCION: " + e.message);
					}
				}
				mat.finalizar();
			}
		};
	};
//</MONTO>

//<FECHA>
mat.actualizarFecha = function(pais){
		var trans = db.transaction("fecha_actualizacion", "readwrite");
		var objeto = trans.objectStore("fecha_actualizacion").index("fecha_actualizacion_cod_pais").openCursor(IDBKeyRange.only(pais));
		var cod_pais = 0;
		objeto.onsuccess = function(res){
			var fila = res.target.result;			
			if(fila){
				cod_pais = fila.value.cod_pais;
				fila.delete();
				fila.continue();
			} else {
				var fecha = "";
				var calendario = new Date();
				var anio = calendario.getFullYear();
				var mes = calendario.getMonth() + 1;
				var dia = calendario.getDate();
				var hora = calendario.getHours();
				var minuto = calendario.getMinutes();
				var segundo = calendario.getSeconds();				
				
				if(mes < 10){
					mes = '0' + mes;
				}
				if(dia < 10){
					dia = '0' + dia;
				}
				if(hora < 10){
					hora = '0' + hora;
				}
				if(minuto < 10){
					minuto = '0' + minuto;
				}
				if(segundo < 10){
					segundo = '0' + segundo;
				}
				
				fecha = anio + "" + mes + dia + hora + minuto + segundo;
				
				var trans = db.transaction("fecha_actualizacion", "readwrite");
				var nuevo = trans.objectStore("fecha_actualizacion");

				try{
					var inserto = {fecha: fecha, cod_pais: pais};
					//dbx.log(inserto);
					var commit = nuevo.put(inserto);
					commit.onerror = function(res){
						rollback(); 
						dbx.log("ERROR AL INGRESO " + res);
						//break;
					};
				}catch(e){
					dbx.log("ERROR RE-INSERCION: " + e.message);
				}
				db.close();
			}
		};	
	};
//</FECHA>

//<REDES>
	var contenido_redes = [];
mat.actualizarRedes = function(opciones){
	for(var i in opciones){
		var opcion = opciones[i];
		var id_redes = opcion['tcamtredesid']; 
		var nombre = opcion['nombre_red']; 
		var imagen = opcion['url_imagen'];  
		var link = opcion['url']; 
		var cod_pais = opcion['area'];

		contenido_redes.push({id_redes: id_redes, nombre: nombre, imagen: imagen, link: link, cod_pais: cod_pais});
	}
	var pais = contenido_redes[0]['cod_pais'];
	var trans = db.transaction("redes_sociales", "readwrite");
	var objeto = trans.objectStore("redes_sociales").index("redes_sociales_cod_pais").openCursor(IDBKeyRange.only(pais));
		
	objeto.onsuccess = function(res){
		var fila = res.target.result;
		if(fila){
			fila.delete();
			fila.continue();
		} else {
			var trans = db.transaction("redes_sociales", "readwrite");
			var nuevo = trans.objectStore("redes_sociales");
				
			for(var j in contenido_redes){
				var red = contenido_redes[j];
				var inserto = {id_redes: red['id_redes'], nombre: red['nombre'], imagen: red['imagen'], link: red['link'], cod_pais: red['cod_pais']};
					
				try{
					var commit = nuevo.put(inserto);
					commit.onerror = function(res){
						rollback();
						dbx.log("ERROR AL INGRESO " + res);
						//break;
					};
				}catch(e){
					dbx.log("ERROR RE-INSERCION: " + e.message);
				}
			}
			mat.finalizar();
		}
	};
};
//</REDES>

	return mat;
};