var dbCm = null;
var serversCm = null;
var serverCm = "";
var restCM = false;


function actualizarCM(){
	dbCm = new modDB();
	dbCm.obtenerServidor(0,setServidorActCM);
	var fecha = 20130101000000;
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{			
				var db = res.target.result;		
				var trans = db.transaction("tcn_club_control_versiones");
				var objStore = trans.objectStore("tcn_club_control_versiones").openCursor();			
				objStore.onsuccess = function (res){
				var obj_cursor = res.target.result;
				
				if(obj_cursor){
					if(parseInt(obj_cursor.value.fecha_actualizacion)>=fecha)
						fecha = parseInt(obj_cursor.value.fecha_actualizacion);
					obj_cursor.continue();
				}else{
					db.close();
					obtenerActualizacion(fecha);
				}
			};
		}catch(e){
			dbCm.log(e);
		}
	};
}//actualizar cm

function setServidorActCM(serv)
{
	if(serversCm == null)
		serversCm = serv;
	var l = ($(serversCm).toArray().length==1)?0:$(serversCm).toArray().length+1;
	var r = Math.floor((Math.random()*l));
	serverCm = serversCm[r];
}//setServidorActCM


function obtenerActualizacion(fecha){
	dbx.log("INICIO ACTUALIZACION CM!!!!!!");
	if(dbCm.sesion.cod_pais != "505")
		return;
	if(restCM){
		fecha = "20130101000000";
		restCM = false;
	}
	var url = "/director/ClubMovistarV2/ClubMovistarUpdate/"+dbCm.sesion.cod_pais+"/"+fecha;
	//console.log("SERVIDOOOOOOOOOOOOR >> " + serverCm+url);
	$.jsonp({
		 url: serverCm+url,
		 callbackParameter:dbx.jsonp_callback,
		 timeout: dbx.ajax_timeout,
		 error: function(xOptions,data){
			 	dbCm.log("ERROR AL OBTENER URL");
			 
		 },
		 success: function (data, textStatus, xOptions) {
			 if(data.mensaje && data.mensaje.registros &&  parseInt(data.mensaje.registros)>0)
			 {
			 	var pedido = indexedDB.open('movistardb');	
				pedido.onerror = function(res){
					dbCm.log("Error");
				};
				pedido.onsuccess = function(res){
					try{			
						var db = res.target.result;		
						var trans = db.transaction("tcn_club_cola","readwrite");
						var objStore = trans.objectStore("tcn_club_cola");
						for(var i in data.retorno)
						{
							var nombreCatalogo = "";
							if(data.retorno[i].catalogo=="Afiliados"){
								nombreCatalogo = "tcn_club_afiliados";
							}else if(data.retorno[i].catalogo=="Beneficios"){
								nombreCatalogo = "tcn_club_beneficios";
							}else if(data.retorno[i].catalogo=="Categorias"){
								nombreCatalogo = "tcn_club_categorias";
							}else if(data.retorno[i].catalogo=="Sucursales"){
								nombreCatalogo = "tcn_club_sucursales";
							}else if(data.retorno[i].catalogo=="TiposQuejas"){
								nombreCatalogo = "tcn_club_quejas";
							}else if(data.retorno[i].catalogo=="Promociones"){
								nombreCatalogo = "tcn_club_promociones";
							}else if(data.retorno[i].catalogo=="Imagenes"){
								nombreCatalogo = "tcn_club_imagenes";
							}else if(data.retorno[i].catalogo=="Eventos"){
								nombreCatalogo = "tcn_club_eventos";
							}else if(data.retorno[i].catalogo=="Zonas"){
								nombreCatalogo = "tcn_club_zonas";
							}
							for(var j in data.retorno[i].ids)
							{								
								var cola = {"catalogo":nombreCatalogo,
									    "catalogo_id":data.retorno[i].ids[j].id,
									    "operacion":data.retorno[i].ids[j].operacion};
								objStore.put(cola);
							}
						}
						db.close();
						actualizarFechaActualizacion(data);
					}catch(e){
						dbCm.log("ERROR AL INSERTAR EN LA COLA CM");
						dbCm.log(e);
					}
				};			 
			 }else{
				 dbCm.log("CM UPDATE NO NECESARIO YA ESTA AL DIA");
				 actualizarAfiliados();
			 }
		 }
	});
}//obtenerActualizacion

function actualizarFechaActualizacion(data){
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_control_versiones","readwrite");
			var objStore = trans.objectStore("tcn_club_control_versiones");
			var clear = objStore.clear(); 
			clear.onsuccess = function(){
				for(var i in data.retorno){
					
					var nombreCatalogo = "";
					var index = "";
					if(data.retorno[i].catalogo=="Afiliados"){
						nombreCatalogo = "tcn_club_afiliados";
					}else if(data.retorno[i].catalogo=="Beneficios"){
						nombreCatalogo = "tcn_club_beneficios";
					}else if(data.retorno[i].catalogo=="Categorias"){
						nombreCatalogo = "tcn_club_categorias";
					}else if(data.retorno[i].catalogo=="Sucursales"){
						nombreCatalogo = "tcn_club_sucursales";
					}else if(data.retorno[i].catalogo=="TiposQuejas"){
						nombreCatalogo = "tcn_club_quejas";
					}else if(data.retorno[i].catalogo=="Promociones"){
						nombreCatalogo = "tcn_club_promociones";
					}else if(data.retorno[i].catalogo=="Imagenes"){
						nombreCatalogo = "tcn_club_imagenes";
					}else if(data.retorno[i].catalogo=="Eventos"){
						nombreCatalogo = "tcn_club_eventos";
					}else if(data.retorno[i].catalogo=="Zonas"){
						nombreCatalogo = "tcn_club_zonas";
					}
					
					var obj = {"catalogo":nombreCatalogo,
							   "fecha_actualizacion":data.retorno[i].fechaActualizacion};
					
					objStore.put(obj);
				}
			};
			db.close();	
			
			actualizarAfiliados();
		}catch(e){
			dbCm.log("ERROR DE ACTUALIZAR LA FECHA DE ACTUALIZACION");
			dbCm.log(e);
		}
	};
}//actualizarFechaActualizacion

function actualizarAfiliados(){
	var nombre_catalogo = "tcn_club_afiliados";
	var ids = [];
	//dbCm.log("REVISANDO ACTUALIZACIONES PENDIENTES DE AFILIADOS");
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(nombre_catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					var id = obj_cursor.value.catalogo_id;
					var del = indexedDB.open('movistardb');	
					del.onerror = function(res){
						dbCm.log("Error");
					};
					del.onsuccess = function(res){
						try{
							var delDb = res.target.result;		
							var delTrans = delDb.transaction(nombre_catalogo,"readwrite");
							var delObjStore = delTrans.objectStore(nombre_catalogo)
							.index("tcn_club_afiliados_id_afiliado")
							.openCursor(IDBKeyRange.only(parseInt(id)));
							delObjStore.onsuccess = function(res){
								var obj_cursor = res.target.result;
								if(obj_cursor)
									obj_cursor.delete();
								delDb.close();
							};
						}catch(e){
							dbCm.log("ERROR AL ELIMINAR REGISTRO");
							dbCm.log(e);
						}
					};
					
					if(obj_cursor.value.operacion=="INSERT" || obj_cursor.value.operacion=="UPDATE")
						ids.push(obj_cursor.value.catalogo_id);
					
					obj_cursor.continue();
				}else{
					db.close();
					if(ids.length > 0)
					{
						var json_string = "{\"ids\":[";
						for(var i in ids)
						{
							json_string += "{\"id\":"+ids[i]+"},";
						}
						
						json_string += "]}";
						
						var url = "/director/ClubMovistarV2/afiliados/getAfiliadosByIds/"+dbx.sesion.cod_pais;
						$.ajaxq("mod_sync",{
						    url: serverCm+url,
						    type: 'POST',
						    crossDomain: true,
						    dataType: 'json',
						    data: json_string,
						    cache: false,
						    success: function(data)
						    {
					        	var ins = indexedDB.open('movistardb');	
					        	ins.onerror = function(res){
					        		dbCm.log("Error");
					        	};
					        	ins.onsuccess = function(res)
					        	{
					        		try{
					        			var db = res.target.result;		
					        			var trans = db.transaction(nombre_catalogo,"readwrite");
					        			var objStore = trans.objectStore(nombre_catalogo);
					        			for(var i in data.retorno)
								    	{
								        	var obj = {"id_afiliado":parseInt(data.retorno[i].idAfiliado),
								        			   "nombre":data.retorno[i].nombre,
								        			   "descripcion":data.retorno[i].descripcion,
								        			   "logo":data.retorno[i].logo,
								        			   "estado":parseInt(data.retorno[i].estado),
								        			   "id_categoria":parseInt(data.retorno[i].idCategoria)};
								        	objStore.put(obj);
								    	}
					        			db.close();
					        			vaciarCola(nombre_catalogo);
					        			actualizarBeneficios();
					        		}catch(e){
					        			dbCm.log("ERROR AL INSERTAR OBJETO");
					        			dbCm.log(e);
					        		}
					        	};
					    	}
						});
					}else{
						actualizarBeneficios();
					}
					
				}
			};
		}catch(e){
			dbCm.log("ERROR COLA CM");
			dbCm.log(e);
		}
	};
	
}//actualizarAfiliados

function actualizarBeneficios(){
	var nombre_catalogo = "tcn_club_beneficios";
	var ids = [];
	dbCm.log("REVISANDO ACTUALIZACIONES PENDIENTES DE BENEFICIOS");
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(nombre_catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					var id = obj_cursor.value.catalogo_id;
					var del = indexedDB.open('movistardb');	
					del.onerror = function(res){
						dbCm.log("Error");
					};
					del.onsuccess = function(res){
						try{
							var delDb = res.target.result;		
							var delTrans = delDb.transaction(nombre_catalogo,"readwrite");
							var delObjStore = delTrans.objectStore(nombre_catalogo)
							.index("tcn_club_beneficios_id_beneficio")
							.openCursor(IDBKeyRange.only(parseInt(id)));
							delObjStore.onsuccess = function(res){
								var obj_cursor = res.target.result;
								if(obj_cursor)
									obj_cursor.delete();
								delDb.close();
							};
						}catch(e){
							dbCm.log("ERROR AL ELIMINAR REGISTRO");
							dbCm.log(e);
						}
					};
					
					if(obj_cursor.value.operacion=="INSERT" || obj_cursor.value.operacion=="UPDATE")
						ids.push(obj_cursor.value.catalogo_id);
					
					obj_cursor.continue();
				}else{
					db.close();
					if(ids.length > 0)
					{
						var json_string = "{\"ids\":[";
						for(var i in ids)
						{
							json_string += "{\"id\":"+ids[i]+"},";
						}
						
						json_string += "]}";
						
						var url = "/director/ClubMovistarV2/beneficiosAfiliado/getBeneficiosByIds/"+dbx.sesion.cod_pais;
						$.ajaxq("mod_sync",{
						    url: serverCm+url,
						    type: 'POST',
						    crossDomain: true,
						    dataType: 'json',
						    data: json_string,
						    cache: false,
						    success: function(data)
						    {
					        	var ins = indexedDB.open('movistardb');	
					        	ins.onerror = function(res){
					        		dbCm.log("Error");
					        	};
					        	ins.onsuccess = function(res)
					        	{
					        		try{
					        			var db = res.target.result;		
					        			var trans = db.transaction(nombre_catalogo,"readwrite");
					        			var objStore = trans.objectStore(nombre_catalogo);
					        			for(var i in data.retorno)
								    	{
								        	var obj = {"id_beneficio":parseInt(data.retorno[i].idBeneficio),
								        			   "descripcion":data.retorno[i].descripcion,
								        			   "estado":parseInt(data.retorno[i].estado),
								        			   "fecha":"",
								        			   "condicion":data.retorno[i].condicion,
								        			   "id_afiliado":parseInt(data.retorno[i].idAfiliado)};
								        	objStore.put(obj);
								    	}
					        			db.close();
					        			vaciarCola(nombre_catalogo);
					        			actualizarCategorias();
					        		}catch(e){
					        			dbCm.log("ERROR AL INSERTAR OBJETO");
					        			dbCm.log(e);
					        		}
					        	};
					    	}
						});
					}else{
						actualizarCategorias();
					}
					
				}
			};
		}catch(e){
			dbCm.log("ERROR COLA CM");
			dbCm.log(e);
		};
	};
	
}//actualizarBeneficios



function actualizarCategorias(){
	var nombre_catalogo = "tcn_club_categorias";
	var ids = [];
	dbCm.log("REVISANDO ACTUALIZACIONES PENDIENTES DE CATEGORIAS");
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(nombre_catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					var id = obj_cursor.value.catalogo_id;
					var del = indexedDB.open('movistardb');	
					del.onerror = function(res){
						dbCm.log("Error");
					};
					del.onsuccess = function(res){
						try{
							var delDb = res.target.result;		
							var delTrans = delDb.transaction(nombre_catalogo,"readwrite");
							var delObjStore = delTrans.objectStore(nombre_catalogo)
							.index("tcn_club_categorias_id_categoria")
							.openCursor(IDBKeyRange.only(parseInt(id)));
							delObjStore.onsuccess = function(res){
								var obj_cursor = res.target.result;
								if(obj_cursor)
									obj_cursor.delete();
								delDb.close();
							};
						}catch(e){
							dbCm.log("ERROR AL ELIMINAR REGISTRO");
							dbCm.log(e);
						}
					};
					
					if(obj_cursor.value.operacion=="INSERT" || obj_cursor.value.operacion=="UPDATE")
						ids.push(obj_cursor.value.catalogo_id);
					
					obj_cursor.continue();
				}else{
					db.close();
					if(ids.length > 0)
					{
						var json_string = "{\"ids\":[";
						for(var i in ids)
						{
							json_string += "{\"id\":"+ids[i]+"},";
						}
						
						json_string += "]}";
						
						var url = "/director/ClubMovistarV2/categorias/getCategoriasByIds/"+dbx.sesion.cod_pais;
						$.ajaxq("mod_sync",{
						    url: serverCm+url,
						    type: 'POST',
						    crossDomain: true,
						    dataType: 'json',
						    data: json_string,
						    cache: false,
						    success: function(data)
						    {
					        	var ins = indexedDB.open('movistardb');	
					        	ins.onerror = function(res){
					        		dbCm.log("Error");
					        	};
					        	ins.onsuccess = function(res)
					        	{
					        		try{
					        			var db = res.target.result;		
					        			var trans = db.transaction(nombre_catalogo,"readwrite");
					        			var objStore = trans.objectStore(nombre_catalogo);
					        			for(var i in data.retorno)
								    	{
								        	var obj = {"id_categoria":parseInt(data.retorno[i].idCategoria),
								        			   "nombre":data.retorno[i].nombre,
								        			   "estado":parseInt(data.retorno[i].estado),
								        			   "logo":data.retorno[i].logo,
								        			   };
								        	objStore.put(obj);
								    	}
					        			db.close();
					        			vaciarCola(nombre_catalogo);
					        			actualizarEventos();
					        		}catch(e){
					        			dbCm.log("ERROR AL INSERTAR OBJETO");
					        			dbCm.log(e);
					        		}
					        	};
					    	}
						});
					}else{
						actualizarEventos();
					}
					
				}
			};
		}catch(e){
			dbCm.log("ERROR COLA CM");
			dbCm.log(e);
		}
	};
	
}//actualizarCategorias

function actualizarEventos(){
	var nombre_catalogo = "tcn_club_eventos";
	var ids = [];
	dbCm.log("REVISANDO ACTUALIZACIONES PENDIENTES DE EVENTOS");
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(nombre_catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					var id = obj_cursor.value.catalogo_id;
					var del = indexedDB.open('movistardb');	
					del.onerror = function(res){
						dbCm.log("Error");
					};
					del.onsuccess = function(res){
						try{
							var delDb = res.target.result;		
							var delTrans = delDb.transaction(nombre_catalogo,"readwrite");
							var delObjStore = delTrans.objectStore(nombre_catalogo)
							.index("tcn_club_eventos_id_evento")
							.openCursor(IDBKeyRange.only(parseInt(id)));
							delObjStore.onsuccess = function(res){
								var obj_cursor = res.target.result;
								if(obj_cursor)
									obj_cursor.delete();
								delDb.close();
							};
						}catch(e){
							dbCm.log("ERROR AL ELIMINAR REGISTRO");
							dbCm.log(e);
						}
					};
					
					if(obj_cursor.value.operacion=="INSERT" || obj_cursor.value.operacion=="UPDATE")
						ids.push(obj_cursor.value.catalogo_id);
					
					obj_cursor.continue();
				}else{
					db.close();
					if(ids.length > 0)
					{
						var json_string = "{\"ids\":[";
						for(var i in ids)
						{
							json_string += "{\"id\":"+ids[i]+"},";
						}
						
						json_string += "]}";
						
						var url = "/director/ClubMovistarV2/eventos/getEventosByIds/"+dbx.sesion.cod_pais;
						$.ajaxq("mod_sync",{
						    url: serverCm+url,
						    type: 'POST',
						    crossDomain: true,
						    dataType: 'json',
						    data: json_string,
						    cache: false,
						    success: function(data)
						    {
					        	var ins = indexedDB.open('movistardb');	
					        	ins.onerror = function(res){
					        		dbCm.log("Error");
					        	};
					        	ins.onsuccess = function(res)
					        	{
					        		try{
					        			var db = res.target.result;		
					        			var trans = db.transaction(nombre_catalogo,"readwrite");
					        			var objStore = trans.objectStore(nombre_catalogo);
					        			for(var i in data.retorno)
								    	{
								        	var obj = {"id_evento":parseInt(data.retorno[i].idEvento),
								        			   "nombre":data.retorno[i].nombre,
								        			   "lugar":data.retorno[i].lugar,
								        			   "fecha":parseInt(data.retorno[i].fecha),
								        			   "hora":data.retorno[i].hora,
								        			   "descuento":data.retorno[i].descuento,
								        			   "costo":data.retorno[i].costo,
								        			   "ruta_imagen":data.retorno[i].imagen,
								        			   "artista":data.retorno[i].artista,
								        			   };
								        	objStore.put(obj);
								    	}
					        			db.close();
					        			vaciarCola(nombre_catalogo);
					        			actualizarImagenes();
					        		}catch(e){
					        			dbCm.log("ERROR AL INSERTAR OBJETO");
					        			dbCm.log(e);
					        		}
					        	};
					    	}
						});
					}else{
						actualizarImagenes();
					}
					
				}
			};
		}catch(e){
			dbCm.log("ERROR COLA CM");
			dbCm.log(e);
		}
	};
	
}//actualizarEventos


function actualizarImagenes(){
	var nombre_catalogo = "tcn_club_imagenes";
	var ids = [];
	dbCm.log("REVISANDO ACTUALIZACIONES PENDIENTES DE IMAGENES");
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(nombre_catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					var id = obj_cursor.value.catalogo_id;
					var del = indexedDB.open('movistardb');	
					del.onerror = function(res){
						dbCm.log("Error");
					};
					del.onsuccess = function(res){
						try{
							var delDb = res.target.result;		
							var delTrans = delDb.transaction(nombre_catalogo,"readwrite");
							var delObjStore = delTrans.objectStore(nombre_catalogo)
							.index("tcn_club_imagenes_id_imagen")
							.openCursor(IDBKeyRange.only(parseInt(id)));
							delObjStore.onsuccess = function(res){
								var obj_cursor = res.target.result;
								if(obj_cursor)
									obj_cursor.delete();
								delDb.close();
							};
						}catch(e){
							dbCm.log("ERROR AL ELIMINAR REGISTRO");
							dbCm.log(e);
						}
					};
					
					if(obj_cursor.value.operacion=="INSERT" || obj_cursor.value.operacion=="UPDATE")
						ids.push(obj_cursor.value.catalogo_id);
					
					obj_cursor.continue();
				}else{
					db.close();
					if(ids.length > 0)
					{
						var json_string = "{\"ids\":[";
						for(var i in ids)
						{
							json_string += "{\"id\":"+ids[i]+"},";
						}
						
						json_string += "]}";
						
						var url = "/director/ClubMovistarV2/imagenes/getImagenesByIds/"+dbx.sesion.cod_pais;
						$.ajaxq("mod_sync",{
						    url: serverCm+url,
						    type: 'POST',
						    crossDomain: true,
						    dataType: 'json',
						    data: json_string,
						    cache: false,
						    success: function(data)
						    {
					        	var ins = indexedDB.open('movistardb');	
					        	ins.onerror = function(res){
					        		dbCm.log("Error");
					        	};
					        	ins.onsuccess = function(res)
					        	{
					        		try{
					        			var db = res.target.result;		
					        			var trans = db.transaction(nombre_catalogo,"readwrite");
					        			var objStore = trans.objectStore(nombre_catalogo);
					        			for(var i in data.retorno)
								    	{
								        	var obj = {"id_imagen":parseInt(data.retorno[i].idImagen),
								        			   "ruta_imagen":data.retorno[i].rutaImagen,
								        			   "id_sucursal":parseInt(data.retorno[i].idSucursal),
								        			   };
								        	objStore.put(obj);
								    	}
					        			db.close();
					        			vaciarCola(nombre_catalogo);
					        			actualizarPromociones();
					        		}catch(e){
					        			dbCm.log("ERROR AL INSERTAR OBJETO");
					        			dbCm.log(e);
					        		}
					        	};
					    	}
						});
					}else{
						actualizarPromociones();
					}
					
				}
			};
		}catch(e){
			dbCm.log("ERROR COLA CM");
			dbCm.log(e);
		}
	};
	
}//actualizarImagenes


function actualizarPromociones(){
	var nombre_catalogo = "tcn_club_promociones";
	var ids = [];
	dbCm.log("REVISANDO ACTUALIZACIONES PENDIENTES DE PROMOCIONES");
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(nombre_catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					var id = obj_cursor.value.catalogo_id;
					var del = indexedDB.open('movistardb');	
					del.onerror = function(res){
						dbCm.log("Error");
					};
					del.onsuccess = function(res){
						try{
							var delDb = res.target.result;		
							var delTrans = delDb.transaction(nombre_catalogo,"readwrite");
							var delObjStore = delTrans.objectStore(nombre_catalogo)
							.index("tcn_club_promociones_id_promocion")
							.openCursor(IDBKeyRange.only(parseInt(id)));
							delObjStore.onsuccess = function(res){
								var obj_cursor = res.target.result;
								if(obj_cursor)
									obj_cursor.delete();
								delDb.close();
							};
						}catch(e){
							dbCm.log("ERROR AL ELIMINAR REGISTRO");
							dbCm.log(e);
						}
					};
					
					if(obj_cursor.value.operacion=="INSERT" || obj_cursor.value.operacion=="UPDATE")
						ids.push(obj_cursor.value.catalogo_id);
					
					obj_cursor.continue();
				}else{
					db.close();
					if(ids.length > 0)
					{
						var json_string = "{\"ids\":[";
						for(var i in ids)
						{
							json_string += "{\"id\":"+ids[i]+"},";
						}
						
						json_string += "]}";
						
						var url = "/director/ClubMovistarV2/promociones/getPromocionesByIds/"+dbx.sesion.cod_pais;
						$.ajaxq("mod_sync",{
						    url: serverCm+url,
						    type: 'POST',
						    crossDomain: true,
						    dataType: 'json',
						    data: json_string,
						    cache: false,
						    success: function(data)
						    {
					        	var ins = indexedDB.open('movistardb');	
					        	ins.onerror = function(res){
					        		dbCm.log("Error");
					        	};
					        	ins.onsuccess = function(res)
					        	{
					        		try{
					        			var db = res.target.result;		
					        			var trans = db.transaction(nombre_catalogo,"readwrite");
					        			var objStore = trans.objectStore(nombre_catalogo);
					        			for(var i in data.retorno)
								    	{
								        	var obj = {"id_promocion":parseInt(data.retorno[i].idPromocion),
								        			   "descripcion":data.retorno[i].descripcion,
								        			   "enlace":data.retorno[i].enlace,
								        			   "fecha_inicio":data.retorno[i].fechaInicio,
								        			   "fecha_fin":data.retorno[i].fechaFin,
								        			   "estado":parseInt(data.retorno[i].estado),
								        			   "ruta_imagen":data.retorno[i].imagen,
								        			   };
								        	objStore.put(obj);
								    	}
					        			db.close();
					        			vaciarCola(nombre_catalogo);
					        			actualizarQuejas();
					        		}catch(e){
					        			dbCm.log("ERROR AL INSERTAR OBJETO");
					        			dbCm.log(e);
					        		}
					        	};
					    	}
						});
					}else{
						actualizarQuejas();
					}
					
				}
			};
		}catch(e){
			dbCm.log("ERROR COLA CM");
			dbCm.log(e);
		}
	};
	
}//actualizarPromociones



function actualizarQuejas(){
	var nombre_catalogo = "tcn_club_quejas";
	var ids = [];
	dbCm.log("REVISANDO ACTUALIZACIONES PENDIENTES DE QUEJAS");
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(nombre_catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					var id = obj_cursor.value.catalogo_id;
					var del = indexedDB.open('movistardb');	
					del.onerror = function(res){
						dbCm.log("Error");
					};
					del.onsuccess = function(res){
						try{
							var delDb = res.target.result;		
							var delTrans = delDb.transaction(nombre_catalogo,"readwrite");
							var delObjStore = delTrans.objectStore(nombre_catalogo)
							.index("tcn_club_quejas_id_queja")
							.openCursor(IDBKeyRange.only(parseInt(id)));
							delObjStore.onsuccess = function(res){
								var obj_cursor = res.target.result;
								if(obj_cursor)
									obj_cursor.delete();
								delDb.close();
							};
						}catch(e){
							dbCm.log("ERROR AL ELIMINAR REGISTRO");
							dbCm.log(e);
						}
					};
					
					if(obj_cursor.value.operacion=="INSERT" || obj_cursor.value.operacion=="UPDATE")
						ids.push(obj_cursor.value.catalogo_id);
					
					obj_cursor.continue();
				}else{
					db.close();
					if(ids.length > 0)
					{
						var json_string = "{\"ids\":[";
						for(var i in ids)
						{
							json_string += "{\"id\":"+ids[i]+"},";
						}
						
						json_string += "]}";
						
						var url = "/director/ClubMovistarV2/tiposQuejas/getTiposQuejasByIds/"+dbx.sesion.cod_pais;
						$.ajaxq("mod_sync",{
						    url: serverCm+url,
						    type: 'POST',
						    crossDomain: true,
						    dataType: 'json',
						    data: json_string,
						    cache: false,
						    success: function(data)
						    {
					        	var ins = indexedDB.open('movistardb');	
					        	ins.onerror = function(res){
					        		dbCm.log("Error");
					        	};
					        	ins.onsuccess = function(res)
					        	{
					        		try{
					        			var db = res.target.result;		
					        			var trans = db.transaction(nombre_catalogo,"readwrite");
					        			var objStore = trans.objectStore(nombre_catalogo);
					        			for(var i in data.retorno)
								    	{
								        	var obj = {"id_queja":parseInt(data.retorno[i].idQueja),
								        			   "descripcion":data.retorno[i].descripcion,
								        			   };
								        	objStore.put(obj);
								    	}
					        			db.close();
					        			vaciarCola(nombre_catalogo);
					        			actualizarSucursales();
					        		}catch(e){
					        			dbCm.log("ERROR AL INSERTAR OBJETO");
					        			dbCm.log(e);
					        		}
					        	};
					    	}
						});
					}else{
						actualizarSucursales();
					}
					
				}
			};
		}catch(e){
			dbCm.log("ERROR COLA CM");
			dbCm.log(e);
		}
	};
	
}//actualizarQuejas


function actualizarSucursales(){
	var nombre_catalogo = "tcn_club_sucursales";
	var ids = [];
	dbCm.log("REVISANDO ACTUALIZACIONES PENDIENTES DE SUCURSALES");
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(nombre_catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					var id = obj_cursor.value.catalogo_id;
					var del = indexedDB.open('movistardb');	
					del.onerror = function(res){
						dbCm.log("Error");
					};
					del.onsuccess = function(res){
						try{
							var delDb = res.target.result;		
							var delTrans = delDb.transaction(nombre_catalogo,"readwrite");
							var delObjStore = delTrans.objectStore(nombre_catalogo)
							.index("tcn_club_sucursales_id_sucursal")
							.openCursor(IDBKeyRange.only(parseInt(id)));
							delObjStore.onsuccess = function(res){
								var obj_cursor = res.target.result;
								if(obj_cursor)
									obj_cursor.delete();
								delDb.close();
							};
						}catch(e){
							dbCm.log("ERROR AL ELIMINAR REGISTRO");
							dbCm.log(e);
						}
					};
					
					if(obj_cursor.value.operacion=="INSERT" || obj_cursor.value.operacion=="UPDATE")
						ids.push(obj_cursor.value.catalogo_id);
					
					obj_cursor.continue();
				}else{
					db.close();
					if(ids.length > 0)
					{
						var json_string = "{\"ids\":[";
						for(var i in ids)
						{
							json_string += "{\"id\":"+ids[i]+"},";
						}
						
						json_string += "]}";
						
						var url = "/director/ClubMovistarV2/sucursalesAfiliado/getSucursalesByIds/"+dbx.sesion.cod_pais;
						$.ajaxq("mod_sync",{
						    url: serverCm+url,
						    type: 'POST',
						    crossDomain: true,
						    dataType: 'json',
						    data: json_string,
						    cache: false,
						    success: function(data)
						    {
					        	var ins = indexedDB.open('movistardb');	
					        	ins.onerror = function(res){
					        		dbCm.log("Error");
					        	};
					        	ins.onsuccess = function(res)
					        	{
					        		try{
					        			var db = res.target.result;		
					        			var trans = db.transaction(nombre_catalogo,"readwrite");
					        			var objStore = trans.objectStore(nombre_catalogo);
					        			for(var i in data.retorno)
								    	{
								        	var obj = {"id_sucursal":parseInt(data.retorno[i].idSucursal),
								        			   "nombre":data.retorno[i].nombre,
								        			   "id_afiliado":parseInt(data.retorno[i].idAfiliado),
								        			   "horario":data.retorno[i].horario,
								        			   "numero":data.retorno[i].numero,
								        			   "direccion":data.retorno[i].direccion,
								        			   "id_zona":data.retorno[i].idZona,
								        			   "comando":data.retorno[i].comando,
								        			   "latitud":data.retorno[i].latitud,
								        			   "longitud":data.retorno[i].longitud,
								        			   "estado":data.retorno[i].estado,
								        			   };
								        	objStore.put(obj);
								    	}
					        			db.close();
					        			vaciarCola(nombre_catalogo);
					        			actualizarZonas();
					        		}catch(e){
					        			dbCm.log("ERROR AL INSERTAR OBJETO");
					        			dbCm.log(e);
					        		}
					        	};
					    	}
						});
					}else{
						actualizarZonas();
					}
					
				}
			};
		}catch(e){
			dbCm.log("ERROR COLA CM");
			dbCm.log(e);
		}
	};
	
}//actualizarSucursales


function actualizarZonas(){
	var nombre_catalogo = "tcn_club_zonas";
	var ids = [];
	dbCm.log("REVISANDO ACTUALIZACIONES PENDIENTES DE ZONAS");
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(nombre_catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					var id = obj_cursor.value.catalogo_id;
					var del = indexedDB.open('movistardb');	
					del.onerror = function(res){
						dbCm.log("Error");
					};
					del.onsuccess = function(res){
						try{
							var delDb = res.target.result;		
							var delTrans = delDb.transaction(nombre_catalogo,"readwrite");
							var delObjStore = delTrans.objectStore(nombre_catalogo)
							.index("tcn_club_zonas_id_zona")
							.openCursor(IDBKeyRange.only(parseInt(id)));
							delObjStore.onsuccess = function(res){
								var obj_cursor = res.target.result;
								if(obj_cursor)
									obj_cursor.delete();
								delDb.close();
							};
						}catch(e){
							dbCm.log("ERROR AL ELIMINAR REGISTRO");
							dbCm.log(e);
						}
					};
					
					if(obj_cursor.value.operacion=="INSERT" || obj_cursor.value.operacion=="UPDATE")
						ids.push(obj_cursor.value.catalogo_id);
					
					obj_cursor.continue();
				}else{
					db.close();
					if(ids.length > 0)
					{
						var json_string = "{\"ids\":[";
						for(var i in ids)
						{
							json_string += "{\"id\":"+ids[i]+"},";
						}
						
						json_string += "]}";
						
						var url = "/director/ClubMovistarV2/zonas/getZonasByIds/"+dbx.sesion.cod_pais;
						$.ajaxq("mod_sync",{
						    url: serverCm+url,
						    type: 'POST',
						    crossDomain: true,
						    dataType: 'json',
						    data: json_string,
						    cache: false,
						    success: function(data)
						    {
					        	var ins = indexedDB.open('movistardb');	
					        	ins.onerror = function(res){
					        		dbCm.log("Error");
					        	};
					        	ins.onsuccess = function(res)
					        	{
					        		try{
					        			var db = res.target.result;		
					        			var trans = db.transaction(nombre_catalogo,"readwrite");
					        			var objStore = trans.objectStore(nombre_catalogo);
					        			for(var i in data.retorno)
								    	{
								        	var obj = {"id_zona":parseInt(data.retorno[i].idZona),
								        			   "nombre":data.retorno[i].nombre,
								        			   };
								        	objStore.put(obj);
								    	}
					        			db.close();
					        			vaciarCola(nombre_catalogo);
					        		}catch(e){
					        			dbCm.log("ERROR AL INSERTAR OBJETO");
					        			dbCm.log(e);
					        		}
					        	};
					    	}
						});
					}
					
				}
			};
		}catch(e){
			dbCm.log("ERROR COLA CM");
			dbCm.log(e);
		}
	};
	
}//actualizarZonas


function vaciarCola(catalogo){
	var pedido = indexedDB.open('movistardb');	
	pedido.onerror = function(res){
		dbCm.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_cola","readwrite");
			var objStore = trans.objectStore("tcn_club_cola");
			var cursor = objStore.index("tcn_club_cola_catalogo").openCursor(IDBKeyRange.only(catalogo));
			cursor.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					obj_cursor.delete();
					obj_cursor.continue();
				}else{
					db.close();
				}
			};
		}catch(e){
			dbCm.log("ERROR AL ELIMINAR REGISTRO DE LA COLA");
		}
	};
}//vaciarCola

