var modDB = function(){
	var dbm = {};
	dbm.sesion = {cod_pais:"",cod_equipo:"",telefono:"",token:"",
			      cod_uso:"",cod_prestacion:"",cod_plan:"",
			      correo:"",logged:false,contrasena:"",
			      num_abonado:"",nombre_cliente:"",cod_situacion:"",
			      cod_cliente:"",notificaciones_sin_leer:0,empresa:false,descPlan:"",aplicaPortabilidadSaldos:false, esPostpagoPrepagado:false, aplicaBloqueoNavegacion:false};
	//HABRA QUE CAMBIAR ESTOS VALORES POR LOS REALES
	//dbm.modelo = encodeURIComponent(navigator.userAgent).replace(/'/g,"%27").replace(/"/g,"%22");
	dbm.modelo = "FirefoxOS";
	dbm.os = "FirefoxOS";
	dbm.version_app = " v1.2.0";
	dbm.version_string = 120;
	dbm.debug = false;
	dbm.tag_valor = "@valor";
	dbm.ajax_timeout = 60000;
	dbm.jsonp_callback = "jsoncallback";
	dbm.digit_regexp = /([0-9]+\.?[0-9]*)(.?)([0-9]*)/i;
	
	dbm.errorConexion = "";
	dbm.errorConexionDesc = "";
	dbm.errorConexionLenta = "";
	dbm.errorConexionLentaDesc = "";
	dbm.errorDef = "";
	dbm.errorResp = "";
	dbm.mensajeExistoso = "";
	dbm.headerAlerta = "Movistar\n";
	dbm.footerAlerta = "\nMSG: ";


    if(localStorage.cod_pais)
	{
		dbm.sesion.cod_pais = localStorage.cod_pais;
		dbm.sesion.cod_equipo = localStorage.cod_equipo;
		dbm.sesion.telefono = localStorage.telefono;
		dbm.sesion.token = localStorage.token;
		dbm.sesion.cod_uso = localStorage.cod_uso;
		dbm.sesion.cod_prestacion = localStorage.cod_prestacion;
		dbm.sesion.cod_plan = localStorage.cod_plan;
		dbm.sesion.correo = localStorage.correo;
		dbm.sesion.logged = (localStorage.logged=="true")?true:false;
		dbm.sesion.contrasena = localStorage.contrasena;
		dbm.sesion.num_abonado = localStorage.num_abonado;
		dbm.sesion.nombre_cliente = localStorage.nombre_cliente;
		dbm.sesion.cod_situacion = localStorage.cod_situacion;
		dbm.sesion.cod_cliente = localStorage.cod_cliente;
		dbm.sesion.notificaciones_sin_leer = parseInt(localStorage.notificaciones_sin_leer);
		dbm.sesion.empresa = (localStorage.empresa=="true")?true:false;
        dbm.sesion.recordar = localStorage.recordar;
        dbm.sesion.piloto = localStorage.piloto;
        dbm.sesion.validarCambiarUsuario = localStorage.validarCambiarUsuario;
        dbm.sesion.esPiloto = localStorage.esPiloto;
        dbm.sesion.porBono = localStorage.porBono;
        dbm.sesion.porRed = localStorage.porRed;
        dbm.sesion.aplicaBloqueoNavegacion = localStorage.aplicaBloqueoNavegacion;
/*Release 1*/
        dbm.sesion.descPlan = localStorage.descPlan;
        dbm.sesion.aplicaPortabilidadSaldos = localStorage.aplicaPortabilidadSaldos;
        dbm.sesion.esPostpagoPrepagado = localStorage.esPostpagoPrepagado;


    }
	
	var objetos = new Array(); 
	objetos[0] = new Array("catalogos","cod_pais" );
	objetos[1] = new Array("consultas","cod_pais", "codigo_padre", "orden","cod_consulta" );
	objetos[2] = new Array("equipos","cod_pais", "estado" );
	objetos[3] = new Array("fecha_actualizacion", "cod_pais" );
	objetos[4] = new Array("montos_recarga","cod_pais" );
	objetos[5] = new Array("novedades", "cod_pais", "activo" );
	objetos[6] = new Array("paises","cod_pais", "activo" );
	objetos[7] = new Array("pantallas","cod_pantalla" );
	objetos[8] = new Array("paquete_bolsa" );
	objetos[9] = new Array("paquetes" );
	objetos[10] = new Array("servicios","cod_pais", "estado", "activo" );
	objetos[11] = new Array("servidores","tipo" );
	objetos[12] = new Array("sqlite_sequence" );
	objetos[13] = new Array("tarjetas", "cod_pais", "estado" );
	objetos[14] = new Array("tipo_opciones","cod_tipo_opcion", "cod_pais", "nombre", "tipo" );
	objetos[15] = new Array("tipos_paquete","cod_tipo_paquete", "cod_pais", "nombre","descripcion", "imagen" );
	objetos[16] = new Array("version","version" );
	objetos[17] = new Array("opciones","cod_opcion", "tipo", "opcion_padre", "orden" );
	objetos[18] = new Array("fusion_etiqueta", "cod_pantalla", "nombre" );
	objetos[19] = new Array("tcn_club_afiliados","id_afiliado", "estado", "id_categoria" );
	objetos[20] = new Array("tcn_club_beneficios","id_beneficio", "estado", "id_afiliado" );
	objetos[21] = new Array("tcn_club_categorias","id_categoria", "estado" );
	objetos[22] = new Array("tcn_club_cola","catalogo" );
	objetos[23] = new Array("tcn_club_control_versiones" );
	objetos[24] = new Array("tcn_club_eventos","id_evento" );
	objetos[25] = new Array("tcn_club_imagenes","id_imagen", "id_sucursal" );
	objetos[26] = new Array("tcn_club_promociones","id_promocion", "estado" );
	objetos[27] = new Array("tcn_club_quejas","id_queja" );
	objetos[28] = new Array("tcn_club_sucursales","id_sucursal", "tipo","id_afiliado", "estado" );
	objetos[29] = new Array("tcn_club_zonas","id_zona" );
	objetos[30] = new Array("favoritos_club","id_afiliado", "estado", "id_categoria" );
	objetos[31] = new Array("telefonos","cod_pantalla");
	objetos[32] = new Array("fusion_paquetes", "cod_paquete", "cod_tipo_paquete", "cod_pais","sub_paquete","tcamtsubtipopaqueteid", "aplicaCompraRecurrente");
	objetos[33] = new Array("redes_sociales", "cod_pais", "id_redes" );
	objetos[34] = new Array("configuracion_notificaciones", "telefono" );
	objetos[35] = new Array("configuracion_notificaciones", "correo_electronico" );
    //contrasena




    dbm.crearDB = function (callback){
		var flag = false;
		var pedido = indexedDB.open('movistardb', 3);
		
		pedido.onupgradeneeded = function(res){
			dbm.log(res);
			flag = true;
			var db = res.target.result;
			for(var i = res.oldVersion; i < res.newVersion; i++){
				if(i==0)
					dbm.objetosIndices(db);
				else if(i==1)
					dbm.crearFase2(db);
				else if(i==2){
										
					var objectStore = res.currentTarget.transaction.objectStore("configuracion_notificaciones");
					objectStore.createIndex(objetos[35][0] + "_" +  objetos[35][1], objetos[35][1], { unique: false });
					
				}
				
				db.close();
			}
		};
		
		pedido.onsuccess= function(res){
			var db = res.target.result;
			if(flag){
				dbm.log("BASE CREADA");
				dbm.cargarDB(callback);	
			} else {
				db.close();	
				dbm.log("BASE EXISTENTE");
				window.location.replace("inicio.html");				
			}				
			db.close();	
		};
	};	

dbm.crearFase2 = function (db){
	for(var i =33; i < 35; i++){
		var objeto = objetos[i];
		var titulo = objeto[0];
		var obj = db.createObjectStore(titulo, {autoIncrement: true});
		for(var e = 1; e < objeto.length; e++){
			obj.createIndex(titulo + "_" +  objeto[e], objeto[e], { unique: false });
		}		
	}	
};

dbm.objetosIndices = function (db){	
		for(var i =0; i < 33; i++){
			var objeto = objetos[i];
			var titulo = objeto[0];
			var obj = db.createObjectStore(titulo, {autoIncrement: true});
			for(var e = 1; e < objeto.length; e++){
				obj.createIndex(titulo + "_" +  objeto[e], objeto[e], { unique: false });
			}		
		}		
	};
	
	var objTrans = ["catalogos","consultas","equipos","fecha_actualizacion","montos_recarga","novedades","paises","pantallas",
	"paquete_bolsa","paquetes","servicios","servidores","sqlite_sequence","tarjetas","tipo_opciones","tipos_paquete","version", "opciones", "fusion_etiqueta",
	"tcn_club_afiliados","tcn_club_beneficios","tcn_club_categorias","tcn_club_cola","tcn_club_control_versiones","tcn_club_eventos","tcn_club_imagenes",
	"tcn_club_promociones","tcn_club_quejas","tcn_club_sucursales","tcn_club_zonas"];
	
dbm.cargarDB = function (callback){	
		var pedido = indexedDB.open('movistardb');	
	
		pedido.onerror = function(res){
			dbm.log(res);
		};

		pedido.onsuccess = function(res){
			var db = res.target.result;
			var trans = db.transaction(objTrans, "readwrite");// aqui se genera el bloqueo
		
			for(var e in listado){
				var obj = listado[e];
				var nom = objetos[e][0];
				var tr_obj = trans.objectStore(nom);
				
				for(var i in obj){
					var entrada = obj[i];
					try{
						tr_obj.put(entrada);
					} catch (e){
						dbm.log(e.message + entrada);
					}
				}	
			}

			trans.oncomplete = function(res){			
				db.close();
				callback();
			};
		};
	};
	
	var	can_et = {},
	can_epe = {},
	fin_et = false,
	fin_epe = false;


	
dbm.cargarPantallas = function (pantalla, pais, equipo, callback){
	var pedido = indexedDB.open('movistardb');	
		
		pedido.onerror = function(res){
			dbm.log("Error");
		};
		var result = [];
		pedido.onsuccess = function(res){		
			
			try{			
				var db = res.target.result;		
			
				var trans = db.transaction("fusion_etiqueta");
				var pantallas = trans.objectStore("fusion_etiqueta").index("fusion_etiqueta_cod_pantalla").openCursor(IDBKeyRange.only(pantalla));
				
				pantallas.onsuccess = function (res){
					var obj_cursor = res.target.result;
					
					if(obj_cursor){
						
						if(obj_cursor.value.cod_pais == pais && (obj_cursor.value.cod_equipo == equipo || obj_cursor.value.cod_equipo == 1 || equipo==1)){
							result.push({nombre: obj_cursor.value.nombre, valor: obj_cursor.value.valor, orden: obj_cursor.value.orden}); 						
						}
						obj_cursor.continue();
					} else {
						db.close();
						callback(result);
					}
				};			
			}catch(e){
				dbm.log("ERROR EN CONSULTA: " + e.message);
			}		
		};
};

dbm.obtenerEtiqueta = function(cod_pantalla,nombre_etiqueta,pais,cod_equipo,callback)
{
	cod_equipo = parseInt(cod_equipo);
	var pedido = indexedDB.open('movistardb');	
	
	pedido.onerror = function(res){
		dbm.log("Error");
	};
	
	pedido.onsuccess = function(res){
		try{			
			var db = res.target.result;				
			var trans = db.transaction("fusion_etiqueta");
			var pantallas = trans.objectStore("fusion_etiqueta").index("fusion_etiqueta_nombre").openCursor(IDBKeyRange.only(nombre_etiqueta));
			pantallas.onsuccess = function (res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					if(cod_equipo==1)
					{
						if(obj_cursor.value.cod_pais == pais  &&
								obj_cursor.value.cod_pantalla == cod_pantalla){
							db.close();
							callback([{nombre: obj_cursor.value.nombre, valor: obj_cursor.value.valor, orden: obj_cursor.value.orden}]); 
							return;
						}
					}else{
						if(obj_cursor.value.cod_pais == pais && obj_cursor.value.cod_equipo == cod_equipo &&
								obj_cursor.value.cod_pantalla == cod_pantalla){
							db.close();
							callback([{nombre: obj_cursor.value.nombre, valor: obj_cursor.value.valor, orden: obj_cursor.value.orden}]); 
							return;
						}
					}
					obj_cursor.continue();
				} else {
					db.close();			
					callback();
				}
			};
		}catch(e){
			dbm.log("ERROR EN CONSULTA: " + e.message);
		}
	};
};

dbm.listarPaises = function(callback){
		var pedido = indexedDB.open('movistardb');	
		var resp = [];
		pedido.onsuccess = function(res){
			try{
				var db = res.target.result;		
				var trans = db.transaction(["paises"]);
				
				var paises = trans.objectStore("paises").index("paises_cod_pais").openCursor();
				
				paises.onsuccess = function (res){
					var obj_cursor = res.target.result;	
					
					if(obj_cursor) {
						if(obj_cursor.value.activo==1)
							resp.push(obj_cursor.value); 
						obj_cursor.continue();
					} else {
                        db.close();
						callback(resp);
					}
				};
				
			} catch (e){
				dbm.log(e.message);
			}
		};
	};

    dbm.jsonp_call_param = function(url_receive_param,labelPopup, recibirNotificaciones, callback) {
        popup_show(labelPopup);
        $.jsonp({
            url: url_receive_param,
            callbackParameter:dbx.jsonp_callback,
            timeout: dbx.ajax_timeout,
            data:(recibirNotificaciones && localStorage.endpoint)?"notificationToken="+localStorage.endpoint:"",

            error: function(xOptions,data){
                popup_close();
                alert(dbx.headerAlerta + dbm.errorDef);
            },
            success: function (data, textStatus, xOptions) {
                popup_close();
                try{
                    callback(data);
                }catch(e){
                    alert(dbx.headerAlerta + dbm.errorDef);
                }
            }
        });
    };
        dbm.jsonp_call = function(url_receive_param,labelPopup, callback){
            //console.log("POPUUUUUUUUUUUUUUUUUUUUUUUUUUP<<<<<<<" + labelPopup );

            popup_show(labelPopup);
            $.jsonp({
                    url: url_receive_param,
                    callbackParameter:dbx.jsonp_callback,
                    timeout: dbx.ajax_timeout,
                    error: function(xOptions,data){
                        popup_close();
                        alert(dbx.headerAlerta + dbm.errorDef);
                    },
                    success: function (data, textStatus, xOptions) {

                        if(!$("#overlay").is(":visible"))
                            return;
                        popup_close();
                        try{
                            //console.log("DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD" );
                            callback(data);
                        }catch(e){
                            alert(dbx.headerAlerta + dbm.errorDef);
                        }
                    }
                });
    };

    dbm.jsonp_call_token = function(url_receive_param,labelPopup, callback){
        popup_show_token(labelPopup);
        $.jsonp({
            url: url_receive_param,
            callbackParameter:dbx.jsonp_callback,
            timeout: dbx.ajax_timeout,
            error: function(xOptions,data){
                popup_close_token();
                alert(dbx.headerAlerta + dbm.errorDef);
            },
            success: function (data, textStatus, xOptions) {

                if(!$("#overlaytoken").is(":visible"))
                    return;
                popup_close_token();
                try{
                    callback(data);
                }catch(e){
                    alert(dbx.headerAlerta + dbm.errorDef);
                }
            }
        });
    };
    dbm.jsonp_call_ret = function(url_receive_param,labelPopup, callback){
        popup_show(labelPopup);
        $.jsonp({
            url: url_receive_param,
            callbackParameter:dbx.jsonp_callback,
            timeout: dbx.ajax_timeout,
            error: function(xOptions,data){
                popup_close();
                alert(dbx.headerAlerta + dbm.errorDef);
                $('#itemRegresar a').trigger('click');

            },
            success: function (data, textStatus, xOptions) {

                if(!$("#overlay").is(":visible"))
                    return;
                popup_close();

                try{
                    callback(data);
                }catch(e){
                    alert(dbx.headerAlerta + dbm.errorDef);
                }
            }
        });
    };
    dbm.jsonp_call_sin_popup = function(url_receive_param, callback){
        $.jsonp({
            url: url_receive_param,
            callbackParameter:dbx.jsonp_callback,
            timeout: dbx.ajax_timeout,
            error: function(xOptions,data){
                popup_close();
                alert(dbx.headerAlerta + dbm.errorDef);
                $('#itemRegresar a').trigger('click');

            },
            success: function (data, textStatus, xOptions) {
                if(!$("#overlay").is(":visible"))
                    return;
                popup_close();
                try{
                    callback(data);
                }catch(e){
                    alert(dbx.headerAlerta + dbm.errorDef);
                }
            }
        });
    };

dbm.obtenerSesion = function()
{
	if(!localStorage.cod_pais)
	{
		window.location = "logPais.html";
		dbm.sesion = localStorage;				
	}else{
		dbm.sesion.cod_pais = localStorage.cod_pais;
		dbm.sesion.cod_equipo = localStorage.cod_equipo;
		dbm.sesion.telefono = localStorage.telefono;
		dbm.sesion.token = localStorage.token;
		dbm.sesion.cod_uso = localStorage.cod_uso;
		dbm.sesion.cod_prestacion = localStorage.cod_prestacion;
		dbm.sesion.cod_plan = localStorage.cod_plan;
		dbm.sesion.correo = localStorage.correo;
		dbm.sesion.logged = (localStorage.logged=="true")?true:false;
		dbm.sesion.contrasena = localStorage.contrasena;
		dbm.sesion.num_abonado = localStorage.num_abonado;
		dbm.sesion.nombre_cliente = localStorage.nombre_cliente;
		dbm.sesion.cod_situacion = localStorage.cod_situacion;
		dbm.sesion.cod_cliente = localStorage.cod_cliente;
		dbm.notificaciones_sin_leer = parseInt(localStorage.notificaciones_sin_leer);
	}
	return dbm.sesion;
};


dbm.traerOpciones = function(opcion_padre,callback){
	var opciones = [];
	var pedido = indexedDB.open('movistardb');	
	pedido.onsuccess = function(res)
	{
		try{
			var db = res.target.result;		
			var trans = db.transaction(["opciones"]);
			var servidores = trans.objectStore("opciones").index("opciones_opcion_padre").openCursor(IDBKeyRange.only(opcion_padre));
			servidores.onsuccess = function (res){
				var obj_cursor = res.target.result;	
				
				if(obj_cursor) {
					opciones.push(obj_cursor.value);
					obj_cursor.continue();
					
				}else {
					callback(opciones);
					db.close();
					
				}
				
			};
		}catch(e)
		{
			dbm.log(e.message);
		}//catch
	};//onsuccess pedido
};

dbm.traerOpcionesPadre = function(padre,opcion_padre,callback,latitud,longitud){
	//dbm.log("traerOpcionesPadre" + opcion_padre);
	var opciones = [];
	var pedido = indexedDB.open('movistardb');	
	pedido.onsuccess = function(res)
	{
		try{
			var db = res.target.result;		
			var trans = db.transaction(["opciones"]);
			var servidores = trans.objectStore("opciones").index("opciones_opcion_padre").openCursor(IDBKeyRange.only(opcion_padre));
			servidores.onsuccess = function (res){
				var obj_cursor = res.target.result;	
				
				if(obj_cursor) {
					var opcion = {cod_opcion: obj_cursor.value.cod_opcion, cod_pais: obj_cursor.value.cod_pais, etiqueta: obj_cursor.value.etiqueta, descripcion: obj_cursor.value.descripcion, tipo: obj_cursor.value.tipo, opcion_padre: obj_cursor.value.opcion_padre, padre: padre,latitud: latitud,longitud: longitud};
					
					opciones.push(opcion);
					obj_cursor.continue();
					
				}else {
					callback(opciones);
					db.close();
					
				}
				
			};
		}catch(e)
		{
			dbm.log(e.message);
		}//catch
	};//onsuccess pedido
};

    dbm.setNotificaciones = function(codigoPais,telefono,correo,contrasena,recordar, recibirNotificaciones,callback){
        var pedido = indexedDB.open('movistardb');
       // console.log("TELEFONO2: " + telefono);

        pedido.onsuccess = function(res){
            try{
                var db = res.target.result;
                var trans = db.transaction("configuracion_notificaciones", "readwrite");
                var objectStore = trans.objectStore("configuracion_notificaciones").openCursor();
                objectStore.onsuccess = function(res){
                    var obj_cursor = res.target.result;
                    if(obj_cursor){
                        if(obj_cursor.value.telefono == telefono){
                            obj_cursor.delete();
                        }
                        obj_cursor.continue();
                    }else{
                        objectStore = trans.objectStore("configuracion_notificaciones");
                        objectStore.add({"telefono":telefono,
                            "codigo_pais":codigoPais,
                            "registrado":recibirNotificaciones});
                        db.close();
                    }
                };

                if(callback)
                    callback(codigoPais,telefono,correo,contrasena,recordar, recibirNotificaciones);
            } catch (e){
                db.close();
                dbm.log("Error al agregar " + e.message);
            }
        };

        pedido.onerror = function(res){
            dbm.log(res);
        };
    };


dbm.setCatalogos = function(nombre, url, cod_pais, cod_uso, callback){
	var pedido = indexedDB.open('movistardb');	
	pedido.onsuccess = function(res){
		try{
			var existe = false;
			var db = res.target.result;
			var transCat = db.transaction("catalogos");
			var objCat = transCat.objectStore("catalogos").index("catalogos_cod_pais").openCursor(IDBKeyRange.only(parseInt(cod_pais)));
			objCat.onsuccess = function(res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					if(obj_cursor.value.url == url){
						existe = true;
					}
					obj_cursor.continue();
				} 
			};	
			
			transCat.oncomplete = function(res){
				if(!existe){
					var trans = db.transaction("catalogos", "readwrite");
					var objectStore = trans.objectStore("catalogos", "readwrite");
					var commit = objectStore.put({"nombre":nombre,
						"url":url,
						"cod_pais":parseInt(cod_pais),
						"cod_uso": parseInt(cod_uso)});
					commit.onerror = function(res){
						dbm.log("ERROR AL INGRESAR EN NOTIFICACIONES");
						dbm.log(res);
					};						
					db.close();
					if(callback != null){					
						callback();
					}
				} else {
					db.close();
					if(callback != null){					
						callback();
					}
				}
			};
		
		} catch (e){
			db.close();
			dbm.log("Error al agregar " + e.message);
		}
	};
	
	pedido.onerror = function(res){
		dbm.log(res);
	};
};

dbm.getCatalogos = function(cod_pais, callback){
	var pedido = indexedDB.open('movistardb');
	
	pedido.onsuccess = function(res){
		try{
			var catalogos = [];
			//catalogos.push({tama: 0});
			var db = res.target.result;
			
			var trans = db.transaction("catalogos", "readwrite");
			var kill_catalogos = trans.objectStore("catalogos").index("catalogos_cod_pais").openCursor(IDBKeyRange.only(parseInt(cod_pais)));
			
			kill_catalogos.onsuccess = function(res){
				var catalogo_cursor = res.target.result;
				if(catalogo_cursor){
					//catalogos[0]['tama']++;
					dbm.log({nombre: catalogo_cursor.value.nombre, url: catalogo_cursor.value.url, cod_pais: catalogo_cursor.value.cod_pais, cod_uso: catalogo_cursor.value.cod_uso});
					catalogos.push({nombre: catalogo_cursor.value.nombre, url: catalogo_cursor.value.url, cod_pais: catalogo_cursor.value.cod_pais, cod_uso: catalogo_cursor.value.cod_uso});
					catalogo_cursor.delete();
					catalogo_cursor.continue();
				} else {
					callback(catalogos);
					db.close();
				}
			};	
		} catch(e){
			db.close();
			dbm.log("Error al agregar " + e.message);
		}
	};
};

dbm.obtenerServidor = function(tipo,callback){
	var s;
	if(dbm.debug)
	{
		if(tipo==0)
		{
			callback({0:"http://www.corporativo.telefonica.com.gt/AppMovilesServiciosOperacionesDirector"});

		}else if(tipo ==1){
			callback({0:"http://10.231.193.146:9081/AMTUpdates"});
		}else{
			callback({0:""});
		}
	}else{
       /* if(tipo==0)
        {
            callback({0:"http://10.231.193.146:9080/AppMovilesServiciosOperacionesDirector"});

        }else if(tipo ==1){
            callback({0:"http://10.231.193.146:9081/AMTUpdates"});
        }else{
            callback({0:""});
        }*/
       // console.log("ENTROOOO SERVIDORES" + tipo);
		var servidor = {};
		var pedido = indexedDB.open('movistardb');	
		pedido.onsuccess = function(res)
		{
			try{
				var db = res.target.result;		
				var trans = db.transaction(["servidores"]);
				var servidores = trans.objectStore("servidores").index("servidores_tipo").openCursor(IDBKeyRange.only(tipo));

                var i = 0;
				servidores.onsuccess = function (res){
					var obj_cursor = res.target.result;	
					
					if(obj_cursor) {
						servidor[i] = obj_cursor.value.server;

                        i++;
						obj_cursor.continue();
						
					} else {

                        callback(servidor);
						db.close();
						
					}
					
				};
			}catch(e)
			{
				dbm.log(e.message);
			}//catch
		};//onsuccess pedido

	}
};


    dbm.obtenerPorcentaje = function(cod_pais, callback){
        var pedido = indexedDB.open('movistardb');
        pedido.onsuccess = function(res)
        {
            try{
                var db = res.target.result;
                var trans = db.transaction(["paises"]);
                var pais = trans.objectStore("paises").index("paises_cod_pais").openCursor(IDBKeyRange.only(cod_pais));
                pais.onsuccess = function (res){
                    var obj_cursor = res.target.result;
                    var porcentaje = 0;
                    if(obj_cursor){
                       // console.log(obj_cursor.value.porcentaje_transacciones + "sss");
                        porcentaje = obj_cursor.value.porcentaje_transacciones;
                        callback(porcentaje);
                        db.close();
                        return;
                    }
                };
            } catch(e){
                dbm.log(e);
            }
        };
    };




dbm.setParametros = function(parametros, objeto){
		var pedido = indexedDB.open('movistardb');	
		
		pedido.onsuccess = function(res){
			try{
				var db = res.target.result;		
				var trans = db.transaction(objeto, "readwrite");
				var objectStore = trans.objectStore(objeto);
				
				for(var i in parametros){
					//parametros[i] = {"cod_pais":502, "cod_equipo":"", "telefono":"", "token":"", "cod_uso":"", "cod_presentacion":"", "cod_plan":"", "correo":""}
					var par = parametros[i];
					objectStore.add(par);
				}				
				db.close();
			} catch (e){
				db.close();
				dbm.log("Error al agregar " + e.message);
			}
		};
		
		pedido.onerror = function(res){
			dbm.log(res);
		};
};
	
dbm.updateParametros = function(parametros, objeto, indice, constraint, callback){
		var pedido = indexedDB.open('movistardb');	
		
		pedido.onsuccess = function(res){
			var db = res.target.result;
			var trans = db.transaction(objeto, "readwrite");
			var obj = trans.objectStore(objeto).index(indice).get(constraint);
			
			obj.onerror = function(res){			
			};
			
			obj.onsuccess = function(res){
				var data ;
			};
			
		};
		
		pedido.onerror = function(){
		};
	};
	
dbm.kill = function (){
		var pedido = indexedDB.deleteDatabase("movistardb");
		
		pedido.onsuccess = function () {
			dbm.log("Base de datos elmininada");
		};
		
		pedido.onerror = function () {
			dbm.log("No se pudo eliminar la base de datos");
		};
};

dbm.log = function (msg){
	if(dbm.debug)
		console.log(msg);
	
};


dbm.errores = function(codPais)
{
	
	var cod_pantalla = 27;
	var dbx = new modDB();
	dbx.obtenerEtiqueta(cod_pantalla,"errorDef",parseInt(codPais), 1, setValores);
	dbx.obtenerEtiqueta(cod_pantalla,"errorResp",parseInt(codPais), 1, setValores);
	dbx.obtenerEtiqueta(cod_pantalla,"errorConexion",parseInt(codPais), 1, setValores);
	dbx.obtenerEtiqueta(cod_pantalla,"errorConexionDesc",parseInt(codPais), 1, setValores);
	dbx.obtenerEtiqueta(cod_pantalla,"mensajeExitoso",parseInt(codPais), 1, setValores);
	dbx.obtenerEtiqueta(cod_pantalla,"errorConexionLenta",parseInt(codPais), 1, setValores);
	dbx.obtenerEtiqueta(cod_pantalla,"errorConexionLentaDesc",parseInt(codPais), 1, setValores);
	function setValores(arreglo){
		for(var i in arreglo)
		{
			if(arreglo[i].nombre == "errorDef")
				dbm.errorDef = arreglo[i].valor;
			else if(arreglo[i].nombre == "errorResp")
				dbm.errorResp = arreglo[i].valor;
			else if(arreglo[i].nombre == "errorConexion")
				dbm.errorConexion = arreglo[i].valor;
			else if(arreglo[i].nombre == "errorConexionDesc")
				dbm.errorConexionDesc = arreglo[i].valor;
			else if(arreglo[i].nombre == "mensajeExitoso")
				dbm.mensajeExitoso = arreglo[i].valor;
			else if(arreglo[i].nombre == "errorConexionLenta")
				dbm.errorConexionLenta = arreglo[i].valor;
			else if(arreglo[i].nombre == "errorConexionLentaDesc")
				dbm.errorConexionLentaDesc = arreglo[i].valor;
		}
	};
};

    /*********************************************************************************
     * ***************************** URLS *******************************************
     *******************************************************************************/

        dbm.getUrlRecordarClave = function(serverpath,correoElectronico, pais){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=recordarClave";
            }else{
                return  serverpath+"/admon/moduloseguridad/recordarClave/"+encodeReplaceDiagonal(correoElectronico)+"/"+ encodeReplaceDiagonal(pais);
            }
        };
        dbm.getUrlLoginUsuario = function(serverpath,correoElectronico,contrasena, pais){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=loginUsuario";
            }else{
                return  serverpath+"/admon/moduloseguridad/loginUsuario/"+encodeReplaceDiagonal(correoElectronico)+"/"+ encodeReplaceDiagonal(contrasena)+"/"+encodeReplaceDiagonal(pais) + "/AMT/" + "127.0.0.1";
            }
        };
        dbm.getUrlLoginUsuarioV2 = function(serverpath,codigoPais,telefono){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=loginUsuarioV2";
            }else{
                return  serverpath+"/director/loginv2/autenticarinfocliente/"+encodeReplaceDiagonal(codigoPais)+"/"+encodeReplaceDiagonal(telefono)+"/"+ "123"+"/AMT/"+encodeReplaceDiagonal(dbm.modelo)+"/"+encodeReplaceDiagonal(dbm.modelo)+"/FIREFOXOS/"+encodeReplaceDiagonal(dbm.version_string)+"?id=111"+(dbm.debug?"editor":window.location.host);
            }
        };
        dbm.getUrlObtenerNumeros = function(serverpath,correoElectronicoParam,codigoPaisParam){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=obtenerNumeros";
            }else{
                return  serverpath+"/admon/moduloseguridad/obtenerNumeros/"+encodeReplaceDiagonal(correoElectronicoParam)+"/"+encodeReplaceDiagonal(codigoPaisParam);
            }
        };
        dbm.getUrlRecordarPin = function(serverpath,telefono,correoElectronicoParam,pais){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=recordarPin";
            }else{
                return  serverpath+"/admon/moduloseguridad/recordarPin/"+encodeReplaceDiagonal(telefono)+ "/" + encodeReplaceDiagonal(correoElectronicoParam) + "/"+encodeReplaceDiagonal(pais)+"/AMT";
            }
        };
        dbm.getUrlValidarPin = function(serverpath,correoParam,telefonoParam,codigo,codPaisParam){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=validarPin";
            }else{
                return  serverpath+"/admon/moduloseguridad/validarPin/"+encodeReplaceDiagonal(correoParam)+"/"+ encodeReplaceDiagonal(telefonoParam)+"/"+ encodeReplaceDiagonal(codigo) + "/" + encodeReplaceDiagonal(codPaisParam) +"/"  +"AMT";
            }
        };
        dbm.getUrlAsignarNumeroRegistro = function(serverpath,mail,telefono,pais){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=asignarNumeroRegistro";
            }else{
                return  serverpath+"/admon/moduloseguridad/asignarNumero/"+encodeReplaceDiagonal(mail)+"/"+encodeReplaceDiagonal(telefono) + "/"+ " " + "/" + "AMT"+ "/"+ encodeReplaceDiagonal(pais);
            }
        };

        dbm.getUrlAsignarNumero = function(serverpath,mail,telefono,piloto,pais){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=asignarNumero";
            }else{
                return  serverpath+"/admon/moduloseguridad/asignarNumero/"+encodeReplaceDiagonal(mail)+"/"+encodeReplaceDiagonal(telefono) + "/"+ encodeReplaceDiagonal(piloto)  + "/"+ "AMT"+ "/"+ encodeReplaceDiagonal(pais);
            }
        };
        dbm.getUrlCrearUsuario = function(serverpath,email,nombreCliente,apellidoCliente,nueva,tel,pais){

            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=crearUsuario";
            }else{
                return  serverpath+"/admon/moduloseguridad/crearUsuario/"+ encodeReplaceDiagonal(email)+"/"+ encodeReplaceDiagonal(nombreCliente)+"/"+
                encodeReplaceDiagonal(apellidoCliente)+"/"+ encodeReplaceDiagonal(nueva) + "/" + encodeReplaceDiagonal(tel) +"/" + encodeReplaceDiagonal(pais)+"/AMT";
            }
        };
        dbm.getUrlEliminar = function(serverpath,tel,correo,pais){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=eliminarNumero";
            }else{
                return  serverpath+"/admon/moduloseguridad/eliminarNumero/"+ "%20"+"/"+encodeReplaceDiagonal(tel)+"/"+
                encodeReplaceDiagonal(correo)+"/"+ "false" +"/"+encodeReplaceDiagonal(pais) +"/AMT";
            }
        };
        dbm.getUrlCambioClave = function(serverpath,correo,contrasena,nueva){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=cambioClave";
            }else{
                return  serverpath+"/admon/moduloseguridad/cambioClave/" + encodeReplaceDiagonal(correo) + "/" +encodeReplaceDiagonal(contrasena)+ "/" + encodeReplaceDiagonal(nueva) ;
            }
        };
        dbm.getUrlConsumoPaqueteMTH = function(serverpath,pais,tel){
            if(dbm.debug){
                return "http://127.0.0.1/FFOS/json_generico.php?servicio=consumopaquetemth";
            }else{
                return  serverpath+"/director/miconsumo/consumopaquetemth/"+
                encodeReplaceDiagonal(pais)+"/"+encodeReplaceDiagonal(tel)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)+"/"+dbm.sesion.token;
            }
        };

    dbm.getUrlValidarTokenSesion = function(serverpath,pais,tel){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=validartokensesion";
        }else{
            return  serverpath+"/director/login/validatokensesion/"+
            encodeReplaceDiagonal(pais)+"/"+encodeReplaceDiagonal(tel)+"/AMT/"+dbm.sesion.token;
        }
    };
    /////////////////////////////////// ACTUALIZACION  ///////////////////////////////
    dbm.getUrlPaquetes = function(serverpath){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=paquetes";
        }else{
            return  serverpath+"/admon/serviciosadmon/paquetes/"+
            encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/AMT/FIREFOXOS/-999/"+encodeReplaceDiagonal(dbx.sesion.cod_equipo)+"/"+encodeReplaceDiagonal(dbx.sesion.cod_prestacion)+"/"+encodeReplaceDiagonal(dbx.sesion.cod_plan);
        }
    };
    dbm.getUrlMiCuentaConsumo = function(serverpath){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=micuenta";
        }else{
            return  serverpath+"/director/micuenta/cuentaconsumo/"+
                encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/AMT/"+encodeReplaceDiagonal(dbx.version_string)+"/"+encodeReplaceDiagonal(dbx.sesion.token);
        }
    };

    /*********************************************************************************
     * ***************************** URLS *******************************************
     *******************************************************************************/
/******* RELEASE 2 *******/

//http://www.corporativo.telefonica.com.gt/AMTUpdates/admon/serviciosadmon/suscripcionPaquetes/502/52197043


	dbm.getUrlHistorialCompras = function(serverpath){
		if(dbm.debug){
			return "http://127.0.0.1/FFOS/json_generico.php?servicio=suscripcionPaquete";
		}
		else{
			return serverpath + "/admon/serviciosadmon/historialCompras/" + 
					encodeReplaceDiagonal(dbx.sesion.cod_pais) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.telefono);
		}
	}

	dbm.getUrlSuscripcionPaquetes = function(serverpath){
		if(dbm.debug){
			return "http://127.0.0.1/FFOS/json_generico.php?servicio=suscripcionPaquete";
		}
		else{
			return serverpath + "/admon/serviciosadmon/suscripcionPaquetes/" + 
					encodeReplaceDiagonal(dbx.sesion.cod_pais) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.telefono);
		}
	}

	dbm.getUrlgetUrlGuardarSuscripcion = function(serverpath, suscripcionId, codPaquete, estado, tipoRecurrencia, diaInicio, hora, obviar){
		if(dbm.debug){
			return "http://127.0.0.1/FFOS/json_generico.php?servicio=comprarPaquete";
		}
		else{
			return serverpath + "/director/paquetes/configurarPaquete/" + 
					encodeReplaceDiagonal(suscripcionId) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.cod_pais) + "/" + 
					encodeReplaceDiagonal(codPaquete) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.cod_cliente) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.num_abonado) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.telefono) + "/" +
					encodeReplaceDiagonal(dbx.sesion.cod_uso) + "/" + 
					encodeReplaceDiagonal(estado) + "/" + 
					encodeReplaceDiagonal(tipoRecurrencia) + "/" +
					encodeReplaceDiagonal(diaInicio) + "/" + 
					encodeReplaceDiagonal(hora) + "/" + 
					encodeReplaceDiagonal(obviar) + "/AMT/"+ 
					encodeReplaceDiagonal(dbm.version_app)+"/"+
					encodeReplaceDiagonal(dbm.sesion.token);
					
		}
	}

	dbm.getUrlgetUrlGuardarSuscripcion = function(serverpath, suscripcionId, codPaquete, estado, tipoRecurrencia, diaInicio, hora, obviar){
		if(dbm.debug){
			return "http://127.0.0.1/FFOS/json_generico.php?servicio=comprarPaquete";
		}
		else{
			return serverpath + "/director/paquetes/configurarPaquete/" + 
					encodeReplaceDiagonal(suscripcionId) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.cod_pais) + "/" + 
					encodeReplaceDiagonal(codPaquete) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.cod_cliente) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.num_abonado) + "/" + 
					encodeReplaceDiagonal(dbx.sesion.telefono) + "/" +
					encodeReplaceDiagonal(dbx.sesion.cod_uso) + "/" + 
					encodeReplaceDiagonal(estado) + "/" + 
					encodeReplaceDiagonal(tipoRecurrencia) + "/" +
					encodeReplaceDiagonal(diaInicio) + "/" + 
					encodeReplaceDiagonal(hora) + "/" + 
					encodeReplaceDiagonal(obviar) + "/AMT/"+ 
					encodeReplaceDiagonal(dbm.version_app)+"/"+
					encodeReplaceDiagonal(dbm.sesion.token);
					
		}
	}


	dbm.getUrlComprarPaquete = function(serverpath, idPaquete){
		
		if(dbm.debug){
			return "http://127.0.0.1/FFOS/json_generico.php?servicio=comprarPaquete";
		}
		else{
			return serverpath +"/director/paquetes/comprapaquete/"
			+ encodeReplaceDiagonal(dbx.sesion.cod_pais) + "/"
			+ encodeReplaceDiagonal(dbm.sesion.telefono) + "/" 
			+ encodeReplaceDiagonal(idPaquete) + "/AMT/"
			+ encodeReplaceDiagonal(dbm.version_app)  + "/"
			+ encodeReplaceDiagonal(dbm.sesion.token);
		}
		
	}

	dbm.getUrlPaquetesV2 = function(serverpath){
		if(dbm.debug){
			return "http://127.0.0.1/FFOS/json_generico.php?servicio=paquetesV2";
		}else{
			return  serverAct + "/admon/serviciosadmon/paquetesV2/"
							+ encodeReplaceDiagonal(dbx.sesion.cod_pais) + "/AMT/FIREFOXOS/-999/" + 
							encodeReplaceDiagonal(dbx.sesion.cod_equipo) + "/" + 
							encodeReplaceDiagonal(dbx.sesion.cod_prestacion) +"/"+
							encodeReplaceDiagonal(dbx.sesion.cod_plan);
		}
	};


dbm.getUrlMisConsumos = function(serverpath){
    if(dbm.debug){
        return "http://127.0.0.1/FFOS/json_generico.php?servicio=misConsumos";
    }else{
        return  serverpath+"/director/miconsumo/consumogeneral/"+
            encodeReplaceDiagonal(dbm.sesion.cod_pais)+ "/"+ encodeReplaceDiagonal(dbm.sesion.telefono)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)+"/"+encodeReplaceDiagonal(dbm.sesion.token);
    }
};
    dbm.getUrlSaldoDatosPortar = function(serverpath){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=getsaldodatoportar";
        }else{
            return  serverpath+"/director/recargas/getsaldodatoportar/"+
                encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)+"/"+encodeReplaceDiagonal(dbm.sesion.token);
        }
    };
    dbm.getUrlCalcularSaldoDatosPortar = function(serverpath, tipo, cantidad){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=calcularDatosPortar";
        }else{
            return  serverpath+"/director/recargas/calcularaprovisionamientoport/"+
                encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)+"/"+ tipo +"/"+ parseFloat(cantidad).toFixed(2) +"/"+ encodeReplaceDiagonal(dbm.sesion.token);
        }
    };
    dbm.getUrlRealizarAjustePortabilidad = function(serverpath, tipo, cantidad){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=realizarajusteport";
        }else{
            return  serverpath+"/director/recargas/realizarajusteport/"+
                encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)+"/"+ tipo +"/"+ parseFloat(cantidad).toFixed(2) +"/"+ encodeReplaceDiagonal(dbm.sesion.token);
        }
    };
    dbm.getUrlSaldoPostpagoPrepagado = function(serverpath){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=saldopospagoprepagado";
        }else{
            return  serverpath+"/director/miconsumo/saldopospagoprepagado/"+
                encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)  +"/"+ encodeReplaceDiagonal(dbm.sesion.token);
        }
    };
    dbm.getUrlSaldoPostpago = function(serverpath){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=consultafacturas";
        }else{
            return  serverpath+"/director/consultasaldos/consultafacturas/"+
                encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)  +"/"+ encodeReplaceDiagonal(dbm.sesion.token);
        }
    };
    dbm.getUrlCompraRecarga = function(serverpath, telefono, importe, numeroTarjeta, mes, anio, cvv, opciontarjeta,conValidacion, nombreTitular){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=comprarecarga";
        }else{
            if(dbx.sesion.cod_pais != "507")
                nombreTitular = "TITULAR";

            if(conValidacion)
                return  serverpath+"/director/recargas/comprarecarga/"+
                encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/"+encodeReplaceDiagonal(telefono)+"/"+encodeReplaceDiagonal(importe)
                +"/"+encodeReplaceDiagonal(numeroTarjeta) +"/"+encodeReplaceDiagonal(nombreTitular)+"/"+encodeReplaceDiagonal(mes)+"/"+encodeReplaceDiagonal(anio)+"/"+encodeReplaceDiagonal(cvv)+"/"+encodeReplaceDiagonal(opciontarjeta)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)  +"/"+ encodeReplaceDiagonal(dbm.sesion.token);
            else
                return  serverpath+"/director/recargas/comprarecargasinverificar/"+
                    encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/"+encodeReplaceDiagonal(telefono)+"/"+encodeReplaceDiagonal(importe)
                    +"/"+encodeReplaceDiagonal(numeroTarjeta) +"/"+encodeReplaceDiagonal(nombreTitular)+"/"+encodeReplaceDiagonal(mes)+"/"+encodeReplaceDiagonal(anio)+"/"+encodeReplaceDiagonal(cvv)+"/"+encodeReplaceDiagonal(opciontarjeta)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)  +"/"+ encodeReplaceDiagonal(dbm.sesion.token);

        }
    };

    dbm.getUrlPagarCuenta = function(serverpath, telefono, importe, numeroTarjeta, mes, anio, cvv, opciontarjeta,conValidacion, nombreTitular){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=pagarcuenta";
        }else{
            if(dbx.sesion.cod_pais != "507")
                nombreTitular = "TITULAR";

            if(conValidacion)
                return  serverpath+"/director/consultasaldos/pagarcuenta/"+
                    encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/"+encodeReplaceDiagonal(telefono)+"/"+encodeReplaceDiagonal(importe)
                    +"/"+encodeReplaceDiagonal(numeroTarjeta) +"/"+encodeReplaceDiagonal(nombreTitular)+"/"+encodeReplaceDiagonal(mes)+"/"+encodeReplaceDiagonal(anio)+"/"+encodeReplaceDiagonal(cvv)+"/"+encodeReplaceDiagonal(opciontarjeta)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)  +"/"+ encodeReplaceDiagonal(dbm.sesion.token);
            else
                return  serverpath+"/director/consultasaldos/pagarcuentasinverificar/"+
                    encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/"+encodeReplaceDiagonal(telefono)+"/"+encodeReplaceDiagonal(importe)
                    +"/"+encodeReplaceDiagonal(numeroTarjeta) +"/"+encodeReplaceDiagonal(nombreTitular)+"/"+encodeReplaceDiagonal(mes)+"/"+encodeReplaceDiagonal(anio)+"/"+encodeReplaceDiagonal(cvv)+"/"+encodeReplaceDiagonal(opciontarjeta)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)  +"/"+ encodeReplaceDiagonal(dbm.sesion.token);

        }
    };
    dbm.getUrlConsultarServicios = function(serverpath){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=consultarservicios";
        }else{
            return  serverpath+"/director/micuenta/consultarservicios/"+
                encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)  +"/"+ encodeReplaceDiagonal(dbm.sesion.token);
        }
    };

    dbm.getUrlBloqueoNavegacion = function(serverpath){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=bloqueonavegacion";
        }else{
            return  serverpath+"/director/misservicios/bloqueonavegacion/"+
                encodeReplaceDiagonal(dbx.sesion.cod_pais)+"/"+encodeReplaceDiagonal(dbx.sesion.telefono)+"/AMT/"+encodeReplaceDiagonal(dbm.version_string)  +"/"+ encodeReplaceDiagonal(dbm.sesion.token);
        }
    };
    dbm.getUrlVersionApp = function(serverpath){
        if(dbm.debug){
            return "http://127.0.0.1/FFOS/json_generico.php?servicio=versionapp";
        }else{
            return  serverpath+"/admon/serviciosadmon/versionapp";
        }
    };

    return dbm;
	
};

var obtenerTarjetas = function(codPais)
{
	var objTarjetas = {};
	var pedido = indexedDB.open('movistardb');	
	pedido.onsuccess = function(res)
	{
		try{
			var db = res.target.result;		
			var trans = db.transaction(["tarjetas"]);
			var objStore = trans.objectStore("tarjetas").openCursor();
			objStore.onsuccess = function (res){
				var obj_cursor = res.target.result;	
				
				if(obj_cursor) {
					if(obj_cursor.value.estado==1 && obj_cursor.value.cod_pais == codPais)
					{
						objTarjetas[obj_cursor.value.cod_tarjeta] = obj_cursor.value;
					}
					obj_cursor.continue();
					
				}else {
					db.close();
					
				}
				
			};
		}catch(e)
		{
			dbm.log(e.message);
		}//catch
	};//onsuccess pedido
	
	return objTarjetas;
};
var obtenerRequisitosContrasena = function(codPais)
{
    var resultado = new Object();
    var pedido = indexedDB.open('movistardb');
    pedido.onsuccess = function(res)
    {
        try{
            var db = res.target.result;
            var trans = db.transaction(["paises"]);
            //console.log("PAIS " + codPais);
            var objStore = trans.objectStore("paises").index("paises_cod_pais").openCursor();

           // console.log("ETROOOOOO111");
            objStore.onsuccess = function (res){
                var obj_cursor = res.target.result;
                if(obj_cursor) {
                   // console.log("ETROOOOOO111222"+ obj_cursor.value.cod_pais + " / " +  codPais);

                    if(obj_cursor.value.cod_pais == codPais)
                    {
                        //console.log("ETROOOOOO1113333");
                        if(obj_cursor.value.clave_requiere_numero){
                            resultado["clave_requiere_numero"]=  obj_cursor.value.clave_requiere_numero;
                        }
                        if(obj_cursor.value.clave_requiere_letra) {
                            resultado["clave_requiere_letra"]=  obj_cursor.value.clave_requiere_letra;
                        }
                        if(obj_cursor.value.clave_requiere_mayuscula) {
                            resultado["clave_requiere_mayuscula"]=  obj_cursor.value.clave_requiere_mayuscula;
                        }
                        if(obj_cursor.value.clave_requiere_minuscula) {
                            resultado["clave_requiere_minuscula"]=  obj_cursor.value.clave_requiere_minuscula;
                        }
                        if(obj_cursor.value.clave_requiere_especial) {
                            resultado["clave_requiere_especial"]=  obj_cursor.value.clave_requiere_especial;
                        }
                        if(obj_cursor.value.clave_longitud_min) {
                            resultado["clave_longitud_min"]=  obj_cursor.value.clave_longitud_min;
                        }
                        if(obj_cursor.value.clave_longitud_max) {
                            resultado["clave_longitud_max"]=  obj_cursor.value.clave_longitud_max;
                        }

                    }
                    obj_cursor.continue();
                }else {
                   // console.log("ETROOOOOO111444");

                    db.close();
                }
            };
        }catch(e)
        {
            dbm.log(e.message);
        }//catch
    };//onsuccess pedido

    return resultado;
};
var montos_recargas = function(codPais)
{
	var objMontoRecargas = {};
	var pedido = indexedDB.open('movistardb');	
	pedido.onsuccess = function(res)
	{
		try{
			var db = res.target.result;		
			var trans = db.transaction(["montos_recarga"]);
			var objStore = trans.objectStore("montos_recarga").openCursor();
			var i = 0;
			objStore.onsuccess = function (res){
				var obj_cursor = res.target.result;	
				
				if(obj_cursor) {
					if(obj_cursor.value.cod_pais == codPais)
					{
						objMontoRecargas[i] = obj_cursor.value;
						i++;
					}
					obj_cursor.continue();
					
				}else {
					db.close();
					
				}
				
			};
		}catch(e)
		{
			dbm.log(e.message);
		}//catch
	};//onsuccess pedido
	
	return objMontoRecargas;
};

var ultimaFecha = function(codPais, callback){
	var fecha = "";
	var pedido = indexedDB.open('movistardb');
	pedido.onsuccess = function(res){
		var db = res.target.result;
		var trans = db.transaction("fecha_actualizacion");
		var objeto = trans.objectStore("fecha_actualizacion").index("fecha_actualizacion_cod_pais").openCursor(IDBKeyRange.only(codPais));
		
		objeto.onsuccess = function(res){
			var fila = res.target.result;
			if(fila){
				fecha = fila.value.fecha;
				//fecha = "20120000000000";
				fila.continue();
			} else {
				db.close();
				callback(fecha);
			}
		};
	};
};





