var dbx = null;
var params = getUrlVars($('.pantalla').attr('data-url'));
var id_afiliado = parseInt(params["id_afiliado"]);
var logo = URLDecode(params["logo"]);
var nombre_afiliado = URLDecode(params["nombre_afiliado"]);
var titulo = "";
var noCoincidencias = "";
var codigoPantalla = 35;
var codigoPantallaAfiliado = 33;

function sucursales(arreglo){
	for(var i in arreglo){
		if(arreglo[i].nombre=="sucursales")
			titulo = arreglo[i].valor;
		else if(arreglo[i].nombre=="noCoincidencias")
			noCoincidencias = arreglo[i].valor;
	}
	$("#titulo").html(titulo);
}



$(document).ready(function(){
	dbx = new modDB();
	dbx.errores(parseInt(dbx.sesion.cod_pais));
	if(dbx.sesion.logged)
	{	
		dbx.cargarPantallas(codigoPantalla, parseInt(dbx.sesion.cod_pais), dbx.sesion.cod_uso, sucursales);
		dbx.obtenerEtiqueta(codigoPantallaAfiliado,"sucursales",parseInt(dbx.sesion.cod_pais), dbx.sesion.cod_equipo, sucursales);
	}else
	{
		dbx.cargarPantallas(codigoPantalla, parseInt(dbx.sesion.cod_pais), 1, sucursales);
		dbx.obtenerEtiqueta(codigoPantallaAfiliado,"sucursales",parseInt(dbx.sesion.cod_pais), 1, sucursales);
	}
	
	traerSucursales();
	popup_close();
});


function traerSucursales(){
	var pedido = indexedDB.open('movistardb');
	var contador = 0;
	var html = "";
	html += "<div>";
	html += "<ul>";
	pedido.onerror = function(res){
		dbx.log("Error");
	};
	pedido.onsuccess = function(res){
		try{
			var db = res.target.result;		
			var trans = db.transaction("tcn_club_sucursales");
			var objStore = trans.objectStore("tcn_club_sucursales").index("tcn_club_sucursales_id_afiliado").openCursor(IDBKeyRange.only(id_afiliado));
			
			objStore.onsuccess = function (res){
				var obj_cursor = res.target.result;
				if(obj_cursor){
					if(obj_cursor.value.estado == "A")
					{
						contador++;
						html += "<li class='item_menu negro' data-target='sucursal.html?id_sucursal="+obj_cursor.value.id_sucursal+
						"&nombre="+URLEncode(obj_cursor.value.nombre)+"&latitud="+URLEncode(obj_cursor.value.latitud)+"&longitud="+
						URLEncode(obj_cursor.value.longitud)+"&comando="+URLEncode(obj_cursor.value.comando)+"&numero="+
						URLEncode(obj_cursor.value.numero)+"&horario="+URLEncode(obj_cursor.value.horario)+"&direccion="+
						URLEncode(obj_cursor.value.direccion)+"&logo="+URLEncode(logo)+"&id_afiliado="+
						obj_cursor.value.id_afiliado+"&nombre_afiliado="+URLEncode(nombre_afiliado)+"' data-loading=''><a href='#' class='padding_left'>"+
						obj_cursor.value.nombre+"<span class='right'>&nbsp;</span></a></li>";
					}
					obj_cursor.continue();
				}else{
					db.close();
					if(contador>0)
					{
						html += "</ul></div>";
					}else{
						html = "<div class='padding_left negro'>"+noCoincidencias+"</div>";
					}
					$("#content").html(html);
					$('#content').jScrollPane({
						verticalGutter: 0
					}).data('jsp');
					$('#content').delegate("li.item_menu, li.item_menu a","click",function(event){
						event.preventDefault();
						if($(this).is("li"))
						{
							
							var tar = $(this).attr('data-target');
							if(!$("#overlay").is(":visible"))
							{
								pushStack(stackNavegacionClubMovistar,$('.pantalla').attr('data-url'),titulo);
								$('.pantalla').attr('data-url',tar);
								$('.pantalla').load(tar);
								popup_show("");
							}
						}
					});
					
				}
			};
		}catch(e){
			dbx.log(e);
		}
	};
}