
function getElementWithArguments(tag, keys, values, content) {
	var newElement = document.createElement(tag);
	keys.forEach(function(element, index, array) {
		newElement.setAttribute(element, values[index]);
	});
	if( content == null )
		return newElement;
	newElement.innerHTML = content;
	return newElement;
}

/**
Download news feed from the server
**/

var teamLocal = document.getElementById('teamLocal');
var teamVisitor = document.getElementById('teamVisitor');
var scoreLocal = document.getElementById('scoreLocal');
var scoreVisitor = document.getElementById('scoreVisitor');
var currentMinute = document.getElementById('currentMinute');
var minutes = document.getElementById('minutes');

function _downloadTeams() {
	var oReq = new XMLHttpRequest({mozSystem: true});
	oReq.open("GET", "https://api.storageroomapp.com/accounts/5127b2ad0f660245fa00106c/collections/5130fdd90f660265ed0005f7/entries.json?auth_token=iazyariHhoxQnisc4UyX", true);
	oReq.timeout = 20000;
	oReq.ontimeout = function (e) {
		_showError('Verifica tu conexión a Internet');
	}
	oReq.onerror = function (e) {
		_showError("Algo anda mal :'(\nIntentalo más tarde.");
	}
	oReq.onload = function(e) {
		var teams = JSON.parse(this.responseText);

		teamLocal.innerHTML = '<img src="' + teams.array.resources[0].url_local + '" ' + 
		'onerror="this.onerror=null; this.src=\'img/minamin/' + teams.array.resources[0].url_local + '.png\'" ' +
		'width=\'50px\' /><br>' + teams.array.resources[0].local + '</br>';

		teamVisitor.innerHTML = '<img src="' + teams.array.resources[0].url_visitante + '" ' + 
		'onerror="this.onerror=null; this.src=\'img/minamin/' + teams.array.resources[0].url_visitante + '.png\'" ' +
		'width=\'50px\' /><br>' + teams.array.resources[0].visitante + '</br>';
	}
	oReq.send();
}

function _setUrlImage(source, url) {
	console.log('setting image[' + url + ']');
	source.setAttribute('src', url);
}

function _downloadActions() {
	var oReq = new XMLHttpRequest({mozSystem: true});
	//oReq.open("GET", "https://api.storageroomapp.com/accounts/5127b2ad0f660245fa00106c/collections/5130f5e70f6602422d001dc1/entries.json?auth_token=iazyariHhoxQnisc4UyX&order=desc&sort=@created_at&per_page=200", true);
	oReq.open("GET", "https://api.storageroomapp.com/accounts/5127b2ad0f660245fa00106c/collections/5130f5e70f6602422d001dc1/entries.json?auth_token=iazyariHhoxQnisc4UyX&order=desc&per_page=200&sort=minuto", true);
	oReq.timeout = 20000;
	oReq.ontimeout = function (e) {
		_showError('Verifica tu conexión a Internet');
	}
	oReq.onerror = function (e) {
		_showError("Algo anda mal :'(\nIntentalo más tarde.");
	}
	oReq.onload = function(e) {
		var actions = JSON.parse(this.responseText).array.resources;
		while (minutes.firstChild) {
			minutes.removeChild(minutes.firstChild);
		}
		actions.forEach(function(element, index, array) {
			minutes.appendChild(getElementWithArguments('tr', [], [], 
				'<td class="minuto-icono"> <img src="img/minamin/' +  element.imagen + '.png" width="30px"/></td>' +
				'<td class="minuto-accion"> ' + element.accion + '</td>' +
				'<td class="minuto-minuto"> ' + element.minuto + '\'</td>')
			);
		});
		scoreLocal.innerHTML = actions[0].local;
		scoreVisitor.innerHTML = actions[0].visitante;
		currentMinute.innerHTML = actions[0].minuto + '<br>Minuto';
	}
	oReq.send();
}

function _openBannerInBrowser(URL) {
	var activity = new MozActivity({
		name: "view",
		data: {
			type: "url",
			url: URL
		}
	});
	activity.onsuccess = function() {
		console.log("url opened succesfully :P");
	};
	activity.onerror = function() {
		console.log(this.error);
	};
}
