var listView, detailView, currentMemo, deleteMemoDialog;

function showMemoDetail(inMemo){
	currentMemo = inMemo;
	displayMemo();
	listView.classList.add("hidden");
	detailView.classList.remove("hidden");
}

function displayMemo() {
	document.getElementById("memo-title").value = currentMemo.title;
	document.getElementById("memo-content").value = currentMemo.content;
}

function shareMemo() {
	var shareActivity = new MozActivity({
		name: "new",
		data: {
			type: "mail",
			body: currentMemo.content,
			url: "mailto:?body"+encodeURIComponent(currentMemo.content) + "&subject=" + encodeURIComponent(currentMemo.title)
		}
	});
	shareActivity.onerror = function(e) {
		console.log("Não é possível enviar nota", e);
	};
}

function textChanged(e) {
	currentMemo.title = document.getElementById("memo-title").value;
	currentMemo.content = document.getElementById("memo-content").value;
	saveMemo(currentMemo, function(err, succ){
		console.log("Salvando nota", err, succ);
		if(!err) {
			currentMemo.id = succ;

		}
	});
}

function newMemo() {
	var theMemo = new Memo();
	showMemoDetail(theMemo);
}

function requestDeletConfirmation() {
	deleteMemoDialog.classList.remove("hidden");
}

function closeDeletMemoDialog() {
	deleteMemoDialog.classList.add("hidden");
}

function deleteCurrentMemo(){
	closeDeletMemoDialog();
	console.log("Sheldon" + currentMemo.id);
	deleteMemo(currentMemo.id, function(){
		showMemolist();
	});
}

function showMemolist(){
	currentMemo = null;
    setTimeout(refreshMemoList, 500);
	listView.classList.remove("hidden");
	detailView.classList.add("hidden");
}


function refreshMemoList() {
    if (!db) {
        // HACK:
        // this condition may happen upon first time use when the
        // indexDB storage is under creation and refreshMemoList()
        // is called. Simply waiting for a bit longer before trying again
        // will make it work.
        console.warn("Database is not ready yet");
        setTimeout(refreshMemoList, 1000);
        return;
    }
    console.log("Refreshing memo list");

    var memoListContainer = document.getElementById("memoList");


    while (memoListContainer.hasChildNodes()) {
        memoListContainer.removeChild(memoListContainer.lastChild);
    }

    var memoList = document.createElement("ul");
    memoListContainer.appendChild(memoList);

    listAllMemoTitles(function (err, value) {
        var memoItem = document.createElement("li");
        var memoP = document.createElement("p");
        var memoTitle = document.createTextNode(value.title);

        memoItem.addEventListener("click", function (e) {
            console.log("clicked memo #" + value.id);
            showMemoDetail(value);

        });

        memoP.appendChild(memoTitle);
        memoItem.appendChild(memoP);
        memoList.appendChild(memoItem);


    });
}

window.onload = function (){
	//elements that we're going to reuse in the code
	listView = document.getElementById("memo-list");
	detailView = document.getElementById("memo-detail");
	deleteMemoDialog = document.getElementById("delete-memo-dialog");

	//All the listeners for the interface buttons and for the input changes
	document.getElementById("back-to-list").addEventListener("click", showMemolist);
	document.getElementById("new-memo").addEventListener("click", newMemo);
	document.getElementById("share-memo").addEventListener("click", shareMemo);
	document.getElementById("delete-memo").addEventListener("click", requestDeletConfirmation);
	document.getElementById("confirm-delete-action").addEventListener("click", deleteCurrentMemo);
	document.getElementById("cancel-delete-action").addEventListener("click", closeDeletMemoDialog);
	document.getElementById("memo-content").addEventListener("input", textChanged);
	document.getElementById("memo-title").addEventListener("input", textChanged);
	refreshMemoList();
}