// Constants
var MINE_MARKER = 10;
var LONG_TAP_TIME = 300;


// Ads config
var adOptions = {
	APP_ID: "MiroslavMilic_Minefield_other",
	TYPE: "Rectangle",
	//IS_INTERSTITIAL_AD: true,
	REFRESH_RATE: -1
};
var ad;


// Game config
var boxWidth = 40;
var boxHeight = 40;
var cellPadding = 15;
var cols = 14;
var rows = 14;
var fieldMap, ground;
var putFlag = false;
var savedGame;
var timer, t2, markMineTimeout;
var config = {
	easy:{
		id: 0,
		label: "Easy",
		mines: 20,
		store: "ScoreEasyStore",
		resultRoot: "easy"
	},
	normal:{
		id: 1,
		label: "Normal",
		mines: 30,
		store: "ScoreNormalStore",
		resultRoot: "normal"
	},
	hard:{
		id: 2,
		label: "Hard",
		mines: 40,
		store: "ScoreHardStore",
		resultRoot: "hard"
	},
	custom:{
		id: 3,
		label: "Custom",
		mines: 30,
	}
};
var mode = "normal";
var numOfMines = config[mode].mines;

/**
* Initialize game
**/
function initGame() {

	// If game was saved continue
	if ((fieldMap != null) && (typeOf(fieldMap) == 'array') && (fieldMap.length == rows)) {
		createFieldMapTiles(fieldMap);

		ground = createGround();
	} else {
		newGame();
	}
}

function saveGame() {
	//window.localStorage.setItem('fieldMap', fieldMap);
}

/**
 * Initializes new game
 **/
function newGame() {
	//window.localStorage.removeItem('fieldMap');

	$('#ground').empty();
	$('#fieldMap').empty();
	$('#game-screen > div.scrollable').scrollLeft(0).scrollTop(0);
	

	// Create field map
	fieldMap = createFieldMap();

	// Create map tiles
	createFieldMapTiles(fieldMap);

	ground = createGround();
        
	if((timer == null))
		timer = new Stopwatch(updateTimer, 100); 

	timer.restart();
	displayMinesLeft();
	
	$('#ground, #fieldMap')
		.width((cols * (boxWidth + cellPadding)) + (cellPadding * 2))
		.height((rows * (boxHeight + cellPadding)));
}

function updateTimer(watch){
    $("#time").text(watch.toString() + "." + parseInt(watch.getElapsed().milliseconds/100))
}

function setDifficulty(m){
	mode = m;
    numOfMines = config[mode].mines;
}

function changeNumLabel(num){
    $("#numMines span").html(num);
}

/**
 * Create ground.
 **/
function createGround() {
	var mtx = [];
	for (var i=0; i<rows; i++) {
		var mtxRow = [];
		mtx[i] = mtxRow;

		for (var j=0; j<cols; j++) {
			var groundCell = $('<div class="orangeBox"/>');
			mtxRow[j] = groundCell;

			groundCell.html('');
			groundCell.css({
				top: (i * (boxHeight + cellPadding)) + 10,
				left: (j * (boxWidth + cellPadding)) + 20,
				width: boxWidth,
				height: boxHeight
			});

			$('#ground').append(groundCell);

			groundCell.data('row', i);
			groundCell.data('col', j);

			// Ground click event
			groundCell.addSwipeEvents()
				.bind('longtap', onFieldLongTap)
				.bind('tap', onFieldTap)
				.bind('touchstart', onFieldTouchStart)
				.bind('touchend', onFieldCancelTouch)
				.bind('touchcancel', onFieldCancelTouch)
				.bind('longtapCanceled', onFieldCancelTouch);
		}
	}
	return mtx;
}

function onFieldCancelTouch(e){
	clearTimeout(markMineTimeout);
	$('#game-screen > header').removeClass('mine-marked');
}

function onFieldTouchStart(e){
	markMineTimeout = setTimeout(function(){
		$('#game-screen > header').addClass('mine-marked');
	}, LONG_TAP_TIME);
}

function onFieldTap(e){
	var rowInd = $(this).data('row');
	var colInd = $(this).data('col');

	if ($(this).hasClass('flag')) return;

	if (hasMine(fieldMap, rowInd, colInd)) {
		//secondChance();
		gameOver();
		return;
	}

	openField(rowInd, colInd);

	chekIsGameFinished();
}
function onFieldLongTap(e){
	var rowInd = $(this).data('row');
	var colInd = $(this).data('col');

	if ($(this).hasClass('flag')) {
		$(this).removeClass('flag');
		$(this).empty();
		updateMines(true);
	} else {
		$(this).addClass('flag');
		$(this).append('<img src="flag.png"/>');
		updateMines(false);
	}
}


/**
 * Open field at coordinates i, j.
 **/
function openField(i, j) {
	var mapCell = fieldMap[i][j];

	if (mapCell != 0) {
		$(ground[i][j]).remove();
		ground[i][j] = null;
	} else {
		flodRemove(i, j);
	}
}

function flodRemove(i, j) {
	if (i < 0 || i >= rows) return;
	if (j < 0 || j >= cols) return;

	var groundCell = ground[i][j];
	if (groundCell == null) return;

	groundCell.remove();
	ground[i][j] = null;

	if (fieldMap[i][j] != 0) return;

	flodRemove(i-1, j-1);
	flodRemove(i-1, j);
	flodRemove(i-1, j+1);
	flodRemove(i, j-1);
	flodRemove(i, j+1);
	flodRemove(i+1, j-1);
	flodRemove(i+1, j);
	flodRemove(i+1, j+1);
}

function chekIsGameFinished() {
	for (var i=0; i<rows; i++) {
		for (var j=0; j<cols; j++) {
			if ((fieldMap[i][j] != 10) && (ground[i][j] != null)) {
				return;
			}
		}
	}
	timer.stop();
	
	updateScores();
	
}

/**
 * Call when user finds the mine.
 **/
function gameOver() {
	timer.stop();

    //t2.stop();
	//updateScores();
	
    $('#ground').empty();
	$('#confirm-game-over').addClass('fade-in');

	ad = Inneractive.createAd(adOptions);
	ad.addTo(document.getElementById('game-over-section'));
	
	return;
	
	result = confirm('Do you want to play again?');
	if (result) {
		setDifficulty(mode);
		newGame();
	}
}

var tStart = 5000, t3 = 0;
var t1, msgC4, t2Active = false;
var popup;

function updateBombTimer(){
	if(t2Active == true){
		var elapsed = new Date().getTime() - t2.startTime;
		elapsed += t2.totalElapsed;
		t1.totalElapsed = tStart - elapsed;
		$("#c4timer").html(t1.toStringMiliseconds());

		var e = t1.getElapsed();
		if(e.seconds <= 0 && parseInt(e.milliseconds/100) == 0){
			t2.stop();
			popup.hide();
			gameOver();
		}
	}
	else{
		t2.stop();
	}
	
}

function secondChance(){
	t2 = new Stopwatch(updateBombTimer, 100);
	t1 = new Stopwatch();
	t1.totalElapsed = tStart;
	$("#c4timer").html(t1.toStringMiliseconds());
	t2Active = true;
	
	if(!popup){
		popup = new Ext.Panel({
			floating: true,
			modal: true,
			hideOnMaskTap: false,
			centered: true,
			width: 1024,
			height: 515,
			styleHtmlContent: true,
			cls: 'wire',
			html: '<div id="red" class="circle" data-id="0"></div><div id="blue" class="circle" data-id="1"></div><p id="c4timer"></p><div id="overlay"><p>You hit the mine! Try to cut the correct wire!</p></div>'
		});
	}
	popup.show('pop');
	$("#c4timer").html(t1.toStringMiliseconds());
	$("#overlay").show();
	var task = new Ext.util.DelayedTask( function() {
		$("#overlay").hide();
		t2.start();
	}, this);
	task.delay(3000);
	
	return false;
}


$(document).on('click', '.circle', function(){
	var v = parseInt($(this).data("id"));
	console.log(v);
	var bomb = getRandomInt(0,1);
	console.log(v != bomb);
	if(v != bomb){
		gameOver();
	}
	else{
		t2Active = false;
	}
	popup.hide();
});

function getRandomInt (min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

function updateMines(hasFlag){
    if(hasFlag)
        numOfMines++;
    else
        numOfMines--;
    displayMinesLeft();
}

function displayMinesLeft(){
    $("#mines-left").text(numOfMines);
}
function createFieldMap() {
	var mtx = [];
	var i, j;

	// create empty field map
	for (i=0; i<rows; i++) {
		var row = [];
		for (j=0; j<cols; j++) {
			row[j] = 0;
		}
		mtx.push(row);
	}

	// create random mines on field map
	var minesLeft = numOfMines;
	while (minesLeft) {
		var rndRow = randRange(0, rows);
		var rndCol = randRange(0, cols);

		if (mtx[rndRow][rndCol] == 0) {
			mtx[rndRow][rndCol] = MINE_MARKER;
			minesLeft--;
		}
	}

	// map field
	for (i=0; i<rows; i++) {
		for (j=0; j<cols; j++) {
			// Skip if we ran into a mine
			if (mtx[i][j] == MINE_MARKER) continue;

			var minesAroundField = 0;

			// Chesk surrounding fields for mines
			if (hasMine(mtx, i-1, j-1)) minesAroundField++;
			if (hasMine(mtx, i-1, j)) minesAroundField++;
			if (hasMine(mtx, i-1, j+1)) minesAroundField++;
			if (hasMine(mtx, i, j-1)) minesAroundField++;
			if (hasMine(mtx, i, j+1)) minesAroundField++;
			if (hasMine(mtx, i+1, j-1)) minesAroundField++;
			if (hasMine(mtx, i+1, j)) minesAroundField++;
			if (hasMine(mtx, i+1, j+1)) minesAroundField++;
			mtx[i][j] = minesAroundField;
		}
	}

	return mtx;
}

/**
 * Create divs for field map
 **/
function createFieldMapTiles(mtx) {
	var fieldClasses = ['mapCell', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'mine'];
	for (i=0; i<rows; i++) {
		for (j=0; j<cols; j++) {
			var mapCell = $('<div/>');
			mapCell.addClass(fieldClasses[mtx[i][j]]);
			//mapCell.html((mtx[i][j] == 0) ? '' : ((mtx[i][j] == 10) ? 'M' : mtx[i][j]));
			mapCell.css({
				top: (i * (boxHeight + cellPadding)) + 10,
				left: (j * (boxWidth + cellPadding)) + 20,
				width: boxWidth,
				height: boxHeight
			});
			$('#fieldMap').append(mapCell);
		}
	}
}

/**
 * Check if field has mine.
 **/
function hasMine(mtx, i, j) {
	if (i < 0 || i >= rows) return false;
	if (j < 0 || j >= cols) return false;

	return (mtx[i][j] == MINE_MARKER);
}


function clamp(min, max, value) {
	return Math.max(min, Math.min(max, value));
}

/**
 * Generate random nuber in range.
 */
function randRange(min, max) {
	return Math.floor((Math.random() * max) + min);
}

function typeOf(obj) {
  if ( typeof(obj) == 'object' ){
    if (obj.length) {
      return 'array';
	} else {
      return 'object';
    }
  }
  return typeof(obj);
}

function setCustomMode(mines){
	config.custom.mines = mines;
}

function getCustomMode(){
	return config.custom.mines;
}

function updateScores(){
	var time = timer.totalElapsed;
	//var store = Ext.getStore(config[mode].store);
	var last = 0;
	
    $('#game-time').html(timer.toStringMiliseconds()); 
    $('#ground').empty();
	$('#confirm-won').addClass('fade-in');

	ad = Inneractive.createAd(adOptions);
	ad.addTo(document.getElementById('won-section'));
    
	return;
	
	var count = store.getCount();
	if(count > 0){
		last = store.last();
	}
	
	if(count < 10 || time < last.data.time){
		Ext.Msg.prompt('You Won!', 'Your time is: '+timer.toStringMiliseconds+'. Enter your name:', function(btn, text){
			if(btn == "ok"){
				store.add({name: text, time: time, timeString: timer.toStringMiliseconds()});
				store.sync();
			}
		},
		this, false, 'Name', {maxlength: 20});
		
		if(count >= 10){
			store.remove(last);
		}
	}
	else{
		alert('You Won!', 'Your time is: '+timer.toStringMiliseconds()+'. Do you want to play again?', function(bt){
			if (bt == 'yes') {
				setDifficulty(mode);
				newGame();
			}
		});
	}
}

function showScores(m){
    
}

function hidePopUp(id) {
    $(id).removeClass('fade-in');
    if (ad) {
        ad.remove();
        ad = null;
    }
}

$(function(){
	initGame();
	
	$('#start-game-easy').on('click', function(e){
		mode = 'easy';
		setDifficulty(mode);
		newGame();
	});
	$('#start-game-normal').on('click', function(e){
		mode = 'normal';
		setDifficulty(mode);
		newGame();
	});
	$('#start-game-hard').on('click', function(e){
		mode = 'hard';
		setDifficulty(mode);
		newGame();
	});
    $('#show-help').on('click', function(e){
        $('#confirm-help').addClass('fade-in');
    });
    
    $('#game-over-cancel').on('click', function(e){
        hidePopUp('#confirm-game-over');
        
    });
    $('#game-over-ok').on('click', function(e){
        hidePopUp('#confirm-game-over');
        setDifficulty(mode);
		newGame();
    });
    $('#game-won-cancel').on('click', function(e){
        hidePopUp('#confirm-won');
        
    });
    $('#game-won-ok').on('click', function(e){
        hidePopUp('#confirm-won');
        setDifficulty(mode);
		newGame();
    });
    
    $('#help-ok').on('click', function(e){
        hidePopUp('#confirm-help');
    });
});