storage = {};

storage.local = {};

storage.local._get = function (id)
{
	if(localStorage[id] == undefined) {
		var list = {};
	} else {
		try {
			var list = JSON.parse(localStorage[id]);
		} catch (e) {
			var list = {};
		}
	}

	return list;
};

storage.local._set = function (id, obj)
{
	localStorage[id] = JSON.stringify(obj);
};


			var app = {
				currentSong : {}
			};
			
/*
			$.getJSON('demo.consulta.js',
				function(data) {
					if(data.success) {
						app.updateList(data.results, 'resultados_gasolineras', '@NOMBRE@ - Distancia: @DISTANCIA_KM@ km - Robo: @PORCENTAJE_ROBO_POR_LITRO@  %');
					}
				});
			*/
			app.baseUrl = "http://m.lacuerda.net/iapp.php?v=4.1a&";
			
			app.apiUrl = function (method) {
				method = method.replace(" ", "_");
				return app.baseUrl + method;
			};
			
			app.search = function (search) {
				$.ajax({
				  url: app.apiUrl("b="+search),
				  dataType: 'jsonp',
				}).always(function() {
					document.getElementById("title").innerHTML = res.title;
					app.updateList(res.items, 'resultados_acordes', '<a onclick="app.loadSong(\'@URL@\')">@TXT@ (@FD@)</a>');
			    });
			};
			
			app.loadSong = function (url) {
				$.ajax({
				  url: app.apiUrl(url),
				  dataType: 'jsonp',
				}).always(function() {
					document.getElementById("song_content").innerHTML = res.body;
					document.getElementById("song_band").innerHTML = res.banda;
					document.getElementById("song_title").innerHTML = res.cancion;
					
					app.currentSong = res;
					
					$.mobile.changePage("#page_song");
			    });
			};
			
			app.loadFav = function (rolacode) {
				var list = storage.local._get("favs");
				var res = list[rolacode];
				
				document.getElementById("song_content").innerHTML = res.body;
				document.getElementById("song_band").innerHTML = res.banda;
				document.getElementById("song_title").innerHTML = res.cancion;
					
				app.currentSong = res;
					
				$.mobile.changePage("#page_song");
			};
			
			
			app.loadFavs = function ()
			{
				var res = storage.local._get("favs");
				var tmp = [];
				for(var key in res) {
					tmp.push(res[key]);
				}
				app.updateList(tmp, 'acordes_favoritos', '<a onclick="app.loadFav(\'@ROLACODE@\')">@BANDA@ - @CANCION@ (@FDESC@)</a>');
			};
			
			app.favCurrentSong = function ()
			{
				var list = storage.local._get("favs");
				list[app.currentSong.rolacode] = app.currentSong;
				storage.local._set("favs", list);
				alert("Cancion guardada con xito para ser consultada offline");
			};
			
			app.apiKey = function () {
				return document.getElementById('api_key').value;
			};
			
			app.userId = function () {
				return document.getElementById('userid').value;
			};
			
			app.generateApiKey = function ()
			{
				var today = new Date();
				
				var hash = $.md5('2014' + app.userId() + 'autoii' + today.getFullYear() + today.getDate());
				return hash;
			};
			
			app.random = function (min, max) {
				return (Math.random()*(max-1))+min;
			};
			
			app.reporte = function () {
				var formData = $('#form_reporte').serialize();
				alert("Reportando a: "+app.apiUrl('customerReport') + '&' + formData);
				
				$.getJSON(app.apiUrl('customerReport') + '&' + formData, 
					function(data) {
						alert(JSON.stringify(data));
					});
			};
			
			function init ()
			{
				
			}

			function onDeviceReady () { init(); }

			document.addEventListener("deviceready", onDeviceReady, false);
			
			app.updateList = function (list, listId, listItemHtml) {
				var domList = $('#'+listId);
				var domItem = domList[0]; domItem.innerHTML = null;
				
				var limit = 999999; //More than that can cause a performance issue

				for(var i = 0; i < list.length; i++) {
					var item = document.createElement ('li');

					if(i > limit) { item.innerHTML = "... demasiados resultados, refine su b&uacute;squeda"; domItem.appendChild(item); break; }

					var entity = list[i];
					
					var itemHtml = listItemHtml;
			
					for(var field in entity) {
						if(typeof(entity[field]) == 'string'|| typeof(entity[field]) == 'number' ) { 
							itemHtml = 
							itemHtml.replace(new RegExp("@"+field.toUpperCase()+"@", "gi"), entity[field]); 
						}
					}

					item.innerHTML = itemHtml;
					
					domItem.appendChild (item);
				}

				$('#'+listId).listview('refresh');
			};