//En el futuro localizac
//http://stackoverflow.com/questions/1215920/localization-with-jquery

// ISCPA added search filter, home icon, updated CDN-Hosted links
// forked from sumukh1's "forked: RSS Reader with jQuery Mobile" http://jsdo.it/sumukh1/4Ton
/* configuration */
var rss = "http://www.notepases.com.mx/rss_cache/misal13_ff/misal.xml";

var maxLength = 32;
/* writing HTML */
document.write(
  '<div data-role="page" id="list">' +
  '  <div data-role="header" data-position="fixed">' +
  '    <h1><span id="widgetTitle">Cargando...</span> ' +
  '        <a id="refresh" href="#" data-icon="refresh" class="ui-btn-right" data-theme="b">Actualizar</a>' +
  '      <!--<span style="font-size: x-small">(HTML)</span>--></h1>' +
  '  </div>' +
  '  <div data-role="content">' +
  '    <ul data-role="listview" data-filter="false" id="articleList" data-theme="e">'
);
for(var i=1; i<=maxLength; i++){
  document.write(
    '<li id="list' + i + '"><a href="#article' + i + '" id="link' + i + '">&nbsp;</a></li>'
  );
}
document.write(
  '    </ul>' +
  '  </div>' +
  '</div>'
);
for(i=1; i<=maxLength; i++){
  document.write(
    '<div data-role="page" id="article' + i + '">' +
    '  <div data-role="header" data-position="inline">' +
    '    <a href="#list" data-role="button" data-icon="back" data-back="true" data-theme="b">Inicio</a>' +
    '    <h1 id="articleHeader' + i + '">&nbsp;</h1>' +
    '    <!--<a href="#" id="openButton' + i + '" data-role="button" data-icon="plus"' +
    '      class="ui-btn-right" rel="external">Open</a>-->' +
    '  </div>' +
    '  <div data-role="content">' +
    '    <div id="articleContent' + i + '" class="articleContent"></div>' +
    '    <div data-role="controlgroup" data-type="horizontal">' +
    '      <a href="#article' + String(i-1) + '" data-role="button" data-icon="arrow-l"' +
    '        data-inline="true" data-theme="b" class="prevButton">Siguiente</a>' +
    '      <a href="#article' + String(i+1) + '" data-role="button" data-icon="arrow-r"' +
    '        data-inline="true" data-theme="b" class="nextButton" data-iconpos="right">Anterior</a>' +
    '    </div>' +
    '  </div>' +
    '</div>' 
  );
}
/* JSONP */

$('#refresh').click(function() {
	if (navigator.onLine){
		$('#widgetTitle').text("Cargando...");
		//Clear list
		$('#articleList').empty();
		for(var i=1; i<=maxLength; i++){
			$('#articleList').append( '<li id="list' + i + '"><a href="#article' + i + '" id="link' + i + '">&nbsp;</a></li>');
		}
		//Parse
		$('#articleList').listview('refresh');
		getOnlineFeed(rss);
	}else{
		alert("Se necesita estar conectado a Internet para actualizar, intenta de nuevo.");
	}
});

$(function(){
	 
	if (navigator.onLine){
		getOnlineFeed(rss);
	}else{
		listEntries(rss);
	}

});
/* functions */

var listEntries = function(json) {
	
  if (typeof json == "string"){
  	//Use cached version
	//alert("using cache");
	if ( json in localStorage) {
		// We have some data cached, return that to the callback.
		json = JSON.parse(localStorage[json]);
		//alert("using cache " + typeof json);
	}else{
		alert("Para descargar el contenido se requiere una conexión a Internet");
	}
  }else{
  	//Cache
	localStorage[json.responseData.feed.feedUrl] = JSON.stringify(json);
	//alert("stored.. " + localStorage[json.responseData.feed.feedUrl]);
  }	
	
  if (!json.responseData.feed.entries) {return false;}
  $('#widgetTitle').text(json.responseData.feed.title);
  var articleLength =json.responseData.feed.entries.length;
  articleLength = (articleLength > maxLength) ? maxLength : articleLength;
  for (var i = 1; i <= articleLength ; i++) {
    var entry = json.responseData.feed.entries[i-1];
    $('#link' + i).text(entry.title);
    $('#articleHeader' + i).text(entry.title);
    $('#openButton' + i).attr('href', entry.link);
    $('#articleContent' + i).append(entry.content);
  }
  $('#article1 .prevButton').remove();
  $('#article' + articleLength + ' .nextButton').remove();
  if (articleLength < maxLength) {
    for (i = articleLength + 1; i <= maxLength; i++) {
      $('#list' + i).remove();
      $('#article' + i).remove();
    }
  }
};

var getOnlineFeed = function(url) {
  var script = document.createElement('script');
  script.setAttribute('src', 'http://ajax.googleapis.com/ajax/services/feed/load?callback=listEntries&hl=ja&output=json-in-script&q='
                      + encodeURIComponent(url)
                      + '&v=1.0&num=' + maxLength);
  script.setAttribute('type', 'text/javascript');
  document.documentElement.firstChild.appendChild(script);
};

var getOfflineFeed = function(url) {
  var script = document.createElement('script');
  script.setAttribute('src', url);
  script.setAttribute('type', 'text/javascript');
  document.documentElement.firstChild.appendChild(script);
};