function ScoreBoard(){
    
    this._challengers =  [];
    this._totalGamePlayed = 0;
    this._leader = new BrainChallenge("no one",0);
    
    if( typeof ScoreBoard.initialized == "undefined" ) {
        ScoreBoard.prototype.getChallengers = function(){
            return this._challengers;
        }
        ScoreBoard.prototype.getTotalGamePlayed = function(){
            return this._totalGamePlayed;
        }
        ScoreBoard.prototype.getLeader = function(){
            return this._leader;
        }
        ScoreBoard.prototype.setChallengers = function(challengers){
            this._challengers = challengers;
        }
        ScoreBoard.prototype.setTotalGamePlayed = function(totalGamePlayed){
            this._totalGamePlayed = totalGamePlayed;
        }
        ScoreBoard.prototype.setLeader = function(leader){
            this._leader = leader;
        }
        ScoreBoard.prototype.reset = function(){
            this.setChallengers([]);
            this.setLeader(new BrainChallenge("no one",0));
            this.setTotalGamePlayed(0);
        }
        ScoreBoard.prototype.refreshLeader = function(){
            var leader = new BrainChallenge("",0);
            var highscore = 0;
            for(var i=0 ; i < this.getChallengers().length ; i++){
                if(this.getChallengers()[i].getHighScore()>highscore)
                    hightscore = this.getChallengers()[i].getHighScore();
                    leader = this.getChallengers()[i];
            }
            localforage.setItem("leader", leader, function(err, value){
                if(!err){
                    console.log(value);
                }
            });
        }
    }
    ScoreBoard.initialized = true;
}



/*var c = [];
var bc = new BrainChallenge();
bc.init("no one",1000);
c.push(bc);
var s = new ScoreBoard();
s.setChallengers(c);
s.refreshLeader();
s.setTotalGamePlayed(0);*/