function Project(){
  this.name = "";
  this.time = 0;//in minutes
  this.description = "";
  this.percent = 0;
  this.tasks = [];
  
  if( typeof Project.initialized == "undefined" ) {
      
    Project.prototype.generateStick = function(){
        var task = [];
        var t = new Task();
        var t1 = new Task();
        var t2 = new Task();
        var t3 = new Task();
        t.init("Stage 1",2,"Boil water and add a tablespoon of vinegar. Meanwhile, break an egg into a small bowl so that they are willing to put in the water when it reaches the right temperature. Poached eggs take little time to cook, so we must act quickly .");
        task.push(t);
        t1.init("stage 2",3,"When boiling , reduce heat ; water should barely shudder. Dip the bowl with the egg in the water and cook it for a moment before sliding into the water . This step helps prevent the formation of white filaments . Then slide the second egg in the water the same way , trying to remember the order in which they entered the water. The first egg should be removed from the water first .");
        task.push(t1);
        t2.init("Stage 3",5,"Gently agitate the water with a spoon while cooking. Remove eggs after three minutes for soft-boiled eggs poached , or after 5 minutes to get a cooked yolk. Use a slotted spoon and let the water flow - the egg should hardly move if you move the spoon. Place the egg cooked on a paper towel and season with salt and pepper.");
        task.push(t2);
        t3.init("Fac. stage",1,"This step is optional - if you prepare eggs for a group of people , do not worry . We can keep the poached eggs in an ice bath for one hour. When serving , put the eggs in hot water to warm them and remove them after about 45 seconds.");
        task.push(t3);
        this.setTasks(task);
        this.setName("Egg 101");
        this.time = 15;
        this.description = "How to poach an egg like a true professional";
        this.push();
        var p = new Project();
        p.default();
        p.push();
    }
    
    Project.prototype.init = function(n,t,d,p){
      this.name=n;
      if(typeof t == "number"){
        this.time=t;
      }
      else{
        throw new Error("Le temps n'accept que des chiffres");
      }
      this.description=d;
      if(typeof p == "number"){
        this.percent=p;
      }
      else{
        throw new Error("Le pourcentage n'accept que des chiffres");
      }
      var t_default = new Task();
      t_default.init('t_d',0,'t_desc');
      this.tasks.push(t_default);
    }
    
    Project.prototype.default = function(){
      this.name="new Project";
      this.time=24;//default time
      this.description="This is a new Standard Project";
      this.percentage=0;
      var t_default = new Task();
      t_default.init('t_d',0,'t_desc');
      this.tasks.push(t_default);
    }
    
    Project.prototype.push = function(){
      localforage.setItem("00MTN00"+this.name, this, function(err, result) {
        if (err) {
          throw new Error('Error ocurred when adding <'+this.name+'> in DataBase!');
        }
        console.log('push successfull: '+JSON.stringify(result));
      });
    }
    
    Project.prototype.addTask = function(title,time,desc){
      var task = new Task();
      task.init(title,time,desc);
      this.tasks.push(task);
    }
    
    Project.prototype.setTasks = function(tasks){
      this.tasks = tasks;
    }
    
    Project.prototype.setName = function(name){
      this.name = name;
    }
  }
  Project.initialized = true;
}

function addProject(name,time,desc,percent){
  var p = new Project();
	p.init(name,time,desc,percent);
  localforage.setItem("00MTN00"+p.name, p, function(err, result) {
    if (err) {
      throw new Error('Error ocurred when adding <'+this.name+'> in DataBase!');
    }
    console.log('push successfull: '+JSON.stringify(result));
  });
}

function removeProject(name){
  localforage.removeItem(name);
}

function cleanDB(){
  localforage.clear(function(){
    console.log("All items are removed from DataBase!");
  });
}

function getProject(name){
  localforage.getItem(name, function(err,value){
    console.log(JSON.stringify(value));
  });
}

