//Class camera : save camera configuration in an object,
//each camera is saved in an object.
function Camera(name, video_address, refresh, login, password){
	//Attributes
	this.id=0;
	this.name=name;
	this.video_address=video_address;
	this.refresh=refresh;
	this.login=login;
	this.password=password;

	//Methods

	//save_camera : add the current object to the camera array in localStorage.
	this.save = function(){
		var cameras=localStorage.getItem('cameras');
		if(cameras==null){
			//No cameras are currently saved, we initiate the array with the first camera
			var array=[this];
			localStorage.setItem('cameras',JSON.stringify(array));
			return(false);
		}
		else{
			//Adding the current camera to the array
			var array=JSON.parse(cameras);
			this.id=array.length;
			array.push(this);
			localStorage.setItem('cameras', JSON.stringify(array));
			return(true);
		}
	}
	this.update = function(){
		var cameras=localStorage.getItem('cameras');
		var array=JSON.parse(cameras);
		var i = 0;
		while(array[i].id != this.id && i<array.length){
			i++;
		}
		if(i < array.length){
			array[i].name = this.name;
			array[i].video_address = this.video_address;
			array[i].refresh = this.refresh;
			array[i].login = this.login;
			array[i].password = this.password;
			localStorage.setItem('cameras', JSON.stringify(array));
		}
	}
	this.remove = function(){
		if(window.confirm(document.webL10n.get("confirmDeletion"))){
			var cameras=localStorage.getItem('cameras');
			var array=JSON.parse(cameras);
			var i = 0;
			while(array[i].id != this.id && i<array.length){
				i++;
			}
			array.splice(i,1);
			localStorage.setItem('cameras', JSON.stringify(array));
			alert(document.webL10n.get("cameraDeleted"));
			document.location.href = 'manage_cameras.html';
		}
	}
}

function getCamera(id){
	var cameras = JSON.parse(localStorage.getItem('cameras'));
	for (var i = 0; i < cameras.length; i++) {
		if(cameras[i].id==id){
			camera = new Camera(cameras[i].name, cameras[i].video_address, cameras[i].refresh, cameras[i].login, cameras[i].password);
			camera.id=id;
		}
	}
	return camera;
}