// image = new Image();
var camera = new Object();
var timerID = 0;

function getOrientation(){
	//This function returns 0 if the display is in landscape or 90 in portrait
	if(screen.height>screen.width){
		return 90;
	}
	else{
		return 0;
	}
}

function draw(picture){
	var binary = "";
	var length = picture.length;
	for (var i = 0 ; i < length ; i++) {
		binary += String.fromCharCode(picture.charCodeAt(i) & 255);
	};
	var image = new Image();
	image.onload = function(){
		var canvas = document.querySelector('#stream');
		if(getOrientation() == 90){
			var new_height = parseInt((parseInt(image.height) * parseInt(window.innerWidth))/parseInt(image.width));
			image.height = new_height;
			image.width = window.innerWidth;
			canvas.height = image.height;
			canvas.width = image.width;
			var top = parseInt((parseInt(window.innerHeight)/2)-(parseInt(new_height/2)));
			canvas.style='';
			canvas.style.top=top+'px';
		}
		else if(getOrientation() == 0){
			var new_width = parseInt((parseInt(image.width) * parseInt(window.innerHeight))/parseInt(image.height));
			image.height = window.innerHeight;
			image.width = new_width;
			canvas.height = image.height;
			canvas.width = image.width;
			var right = parseInt((parseInt(window.innerWidth)/2)-(parseInt(new_width/2)));
			canvas.style='';
			canvas.style.right=right+'px';
		}
		canvas.getContext('2d').drawImage(image, 0, 0, image.width, image.height);
		timerID=setTimeout(getImg,camera.refresh*1000);
	}
	image.src = 'data:image/jpeg;base64,' + btoa(binary);
}

function getImg(){
	request = new XMLHttpRequest({ mozSystem: true });
	if(camera.login != "" || camera.password != ""){
		request.open('GET', camera.video_address, true, camera.login, camera.password);
	}
	else{
		request.open('GET', camera.video_address, true);
	}
	request.overrideMimeType('text/plain; charset=x-user-defined');
	request.onreadystatechange = function(){
		if(request.readyState == 3 && request.status == 200){
			if(request.getResponseHeader('Content-type').indexOf('multipart/x-mixed-replace') != -1){
				var boundaryIndex = request.getResponseHeader('Content-type').indexOf("boundary=");
				var boundary = request.getResponseHeader('Content-type').substr(boundaryIndex+9);
				var count = request.responseText.split(boundary).length-1;
				if(count==2){
					var data = request.responseText;
					request.abort();
					data = data.substr(boundary.length+2);
					var frame = data.substring(0,data.lastIndexOf(boundary)-2);
					var nb = 0;
					var index = 0;
					while(nb!=3){
						if(frame.substr(index,1)=="\n"){
							nb=nb+1;
						}
						index=index+1;
					}
					var picture = frame.substr(index);
					draw(picture);
				}
			}
			else if(request.getResponseHeader('Content-type').indexOf('image/jpeg') != -1){
				var frame = request.responseText;
				draw(frame);
			}
			else{
				request.onerror();
			}
		}
	};
	request.onerror = function(){
		clearTimeout(timerID);
		var mire = new Image();
		var canvas = document.querySelector('#stream');
		mire.src = 'Images/mire.png';
		mire.height = canvas.height;
		mire.width = canvas.width;
		canvas.getContext('2d').drawImage(mire, 0, 0, canvas.width, canvas.height);
	}
	request.send(null);
}

window.addEventListener('load', function(){
	document.querySelector('body').height=window.screen.height;
	document.querySelector('body').width=window.screen.width;
	var id = parseInt((window.location.hash).replace('#',''));
	document.querySelector('form').setAttribute('action','show_camera.html#'+id);
	var cameras = JSON.parse(localStorage.getItem('cameras'));
	for (var i = 0; i < cameras.length; i++) {
		if(cameras[i].id==id){
			camera = new Camera(cameras[i].name, cameras[i].video_address, cameras[i].refresh, cameras[i].login, cameras[i].password);
			camera.id=id;
		}
	}
	try{
		if(camera!=undefined){
			//timerID=setInterval(getImg,camera.refresh*1000);
			getImg();
		}
		else{
			throw new Error('Unknown camera !');
		}
	}
	catch(e){
		alert(e);
		return false;
	}
}, false);

window.addEventListener('resize', function(){
	document.querySelector('body').height=window.screen.height;
	document.querySelector('body').width=window.screen.width;
	clearTimeout(timerID);
	getImg();
});