document.querySelector("#bt_ok").addEventListener('touchend',function(){
	var name = document.querySelector("#camera_name").value;
	var video_address = document.querySelector("#stream_address").value;
	var refresh = parseInt(document.querySelector("#refresh_frequency").value);
	var login = document.querySelector("#login").value;
	var password = document.querySelector("#password").value;
	var camera = new Camera(name, video_address, refresh, login, password);
	if(isNaN(window.id)){
		if(camera.save()==true){
			alert(document.webL10n.get("cameraAdded"));
		}
		else{
			alert(document.webL10n.get("firstCameraAdded"));
		}
		document.location.href = 'manage_cameras.html';
	}
	else{
		camera.id = window.id;
		camera.update();
		alert(document.webL10n.get("cameraUpdated"));
	}
},false);

window.addEventListener('load', function(){
	window.id = parseInt((window.location.hash).replace('#',''));
	document.querySelector('#remove_camera').addEventListener('touchend', function(){
		camera.remove();
	});
	document.querySelector('#refresh_frequency').addEventListener('change',function(e){
		document.querySelector('#refresh_value').value=e.target.value;
	},false);
	document.querySelector('#refresh_value').addEventListener('change',function(e){
		document.querySelector('#refresh_frequency').value=e.target.value;
	},false);
	document.querySelector('#refresh_value').value=document.querySelector('#refresh_frequency').value;
	if(isNaN(window.id)){
		//Adding a camera
		document.querySelector('#remove_camera').setAttribute('style', 'display: none');
		document.querySelector("#bt_ok>img").src = "Images/UI/add.png";
	}
	else{
		//Updating a camera
		document.querySelector("#bt_ok>img").src = "Images/UI/edit.png";
		var camera = getCamera(window.id);
		try{
			if(camera!=undefined){
				document.querySelector('#camera_name').value=camera.name;
				document.querySelector('#stream_address').value=camera.video_address;
				document.querySelector('#refresh_value').value=camera.refresh;
				document.querySelector('#refresh_frequency').value=camera.refresh;
				document.querySelector('#login').value=camera.login;
				document.querySelector('#password').value=camera.password;
			}
			else{
				throw new Error('Unknown camera !');
			}
		}
		catch(e){
			alert(e);
			return false;
		}
	}
});