            var state = {}

            var update_password = function(state) {
                var pw = mm2.generate_password(state)

                pw.forEach(function(elt, row) {
                    elt.forEach(function(elt, col) {
                        var target_id = "img#pw" + String(row) + String(col)
                        var img_src = "img/password/empty.png"

                        if(1 == pw[row][col]) {
                            img_src = "img/password/filled.png"
                        }

                        $(target_id).attr("src", img_src)
                    })
                })
            }

            var set_etank_state = function(which, on) {
                id = "img#etank" + String(which)

                if(on) {
                    $(id).attr("src", "img/etank_yes.png")
                }
                else {
                    $(id).attr("src", "img/etank_no.png")
                }
            }

            var update_etank_display = function(state) {
                var etanks = state.etanks || 0

                for(i = 1; i <= etanks; i++) {
                    set_etank_state(i, true)
                }

                for(i = etanks + 1; i <= mm2.max_etanks; i++) {
                    set_etank_state(i, false)
                }
            }

            $(document).ready(function() {
                update_etank_display(state)
                update_password(state)

                $(".boss_cell").click(function(event) {
                    var which = $(this).attr("id")

                    state[which] = !state[which]

                    var img = $(this).find("img")[0];

                    if (state[which]) {
                        img.src = img.src.replace('not_beaten', 'beaten');
                    } else {
                        img.src = img.src.replace('beaten', 'not_beaten');
                    }

                    update_password(state)
                })

                $(".etank_cell").click(function(event) {
                    if(state.etanks) {
                        state.etanks = (state.etanks + 1) % (mm2.max_etanks + 1)
                    }
                    else {
                        state.etanks = 1
                    }

                    update_etank_display(state)
                    update_password(state)
                })
            })
