var mm2 = {
	etanks: ['A1', 'A2', 'A3', 'A4', 'A5'],

	bosses: {
		bubble: [
			['C3', 'D1'],
			['C4', 'D2'],
			['C5', 'D3'],
			['D1', 'D4'],
			['D2', 'D5'], ],
		air: [
			['D2', 'E3'],
			['D3', 'E4'],
			['D4', 'E5'],
			['D5', 'B1'],
			['E1', 'B2'], ],
		quick: [
			['C4', 'B4'],
			['C5', 'B5'],
			['D1', 'C1'],
			['D2', 'C2'],
			['D3', 'C3'], ],
		wood: [
			['B5', 'D3'],
			['C1', 'D4'],
			['C2', 'D5'],
			['C3', 'E1'],
			['C4', 'E2'], ],
		crash: [
			['E2', 'C5'],
			['E3', 'D1'],
			['E4', 'D2'],
			['E5', 'D3'],
			['B1', 'D4'], ],
		flash: [
			['E4', 'C1'],
			['E5', 'C2'],
			['B1', 'C3'],
			['B2', 'C4'],
			['B3', 'C5'], ],
		metal: [
			['E1', 'E5'],
			['E2', 'B1'],
			['E3', 'B2'],
			['E4', 'B3'],
			['E5', 'B4'], ],
		heat: [
			['D5', 'B2'],
			['E1', 'B3'],
			['E2', 'B4'],
			['E3', 'B5'],
			['E4', 'C1'], ],
	},

	_elt_to_indices: function(elt) {
		return [elt.toLowerCase().charCodeAt(0) - 'a'.charCodeAt(0), parseInt(elt[1]) - 1]
	},

	_mark: function(grid, elt) {
		var indices = this._elt_to_indices(elt)
		grid[indices[0]][indices[1]] = 1
	},

	generate_password: function(state) {
		state = state || {}

		var self = this
		var etanks = Math.min(self.etanks.length - 1, state.etanks || 0)
		var grid = new Array(5);

		for (var i = 0; i < 5; i++) {
			grid[i] = new Array(5);

			for (var j = 0; j < 5; j++) {
				grid[i][j] = 0
			}
		}

		Object.keys(self.bosses).forEach(function(boss) {
			var beaten = !! state[boss]
			var beaten_index = beaten ? 1 : 0
			var elt = self.bosses[boss][etanks][beaten_index]
			self._mark(grid, elt)
		})

		self._mark(grid, self.etanks[etanks])

		return grid
	},

	max_etanks: 4
}
