﻿define([], function () {

    var searchController = ['$scope', '$routeParams', '$location', '$anchorScroll', 'SettingsService', 'ModelsService', 'Utils', 'ModelsCatalogService', function ($scope, $routeParams, $location, $anchorScroll, SettingsService, ModelsService, Utils, ModelsCatalogService) {
        debug.info('SearchController entered');

        $scope.query = $routeParams.query;
        $scope.error = null;
        $scope.Utils = Utils;

        var shouldLoadNext = false;
        if (!ModelsService.state["Search"] || ModelsService.state["Search"].Query != $scope.query) {
            ModelsService.state["Search"] = {
                CurrentPageIndex: 1,
                Items: [],
                TotalPageCount: 1,
                Query: $scope.query
            };
            shouldLoadNext = true;
        }
        $scope.state = ModelsService.state["Search"];

        var page = $routeParams.page ? parseInt($routeParams.page) : 1;
        if ($scope.state.CurrentPageIndex > page) $scope.state.Items = [];
        if ($scope.state.CurrentPageIndex != page) shouldLoadNext = true;
        $scope.state.CurrentPageIndex = page;

        $scope.Catalog = ModelsCatalogService;

        $scope.more = function () {
            $scope.loading = true;
            $scope.error = null;
            ModelsService.search($scope.query, $scope.state.CurrentPageIndex, SettingsService.get('modelsPerPage'), function (data, state) {
                if (data) {
                    if (angular.isArray(data)) {
                        for (var i = 0; i < data.length; i++) {
                            $scope.state.Items.push(data[i]);
                        }
                    } else {
                        $scope.state.Items.push(data);
                    }
                } else {
                    debug.log("Finished loading data");
                    $scope.state.CurrentPageIndex = state.CurrentPageIndex;
                    $scope.state.TotalPageCount = state.TotalPageCount;
                    $scope.loading = false;
                    Utils.apply($scope);
                    $anchorScroll();
                }
            }, function (result) {
                debug.error(result);
                $scope.loading = false;
                $scope.error = true;
            });
        };

        $scope.lastItemId = function () {
            return $scope.state.Items.length ? $scope.state.Items[$scope.state.Items.length - 1].Id : '';
        }

        $scope.url = function () {
            return btoa($location.url());
        };

        //trigger data loader
        if (shouldLoadNext) $scope.more();
        else $anchorScroll();
    }]

    return searchController;
});