﻿define([], function () {

    var modelsPhotoGalleriesController = ['$scope', '$routeParams', '$location', '$anchorScroll', 'SettingsService', 'ModelsService', 'Utils', 'ModelsCatalogService', function ($scope, $routeParams, $location, $anchorScroll, SettingsService, ModelsService, Utils, ModelsCatalogService) {
        debug.info('ModelsPhotoGalleriesController entered');

        $scope.error = null;
        $scope.Utils = Utils;

        var shouldLoadNext = false;
        if (!ModelsService.state["ModelsPhotoGalleries"]) {
            ModelsService.state["ModelsPhotoGalleries"] = {
                CurrentPageIndex: 1,
                Items: [],
                TotalPageCount: 1
            };
            shouldLoadNext = true;
        }
        $scope.state = ModelsService.state["ModelsPhotoGalleries"];

        var page = $routeParams.page ? parseInt($routeParams.page) : 1;
        if ($scope.state.CurrentPageIndex > page) $scope.state.Items = [];
        if ($scope.state.CurrentPageIndex != page) shouldLoadNext = true;
        $scope.state.CurrentPageIndex = page;

        $scope.Catalog = ModelsCatalogService;

        $scope.more = function () {
            $scope.loading = true;
            $scope.error = null;
            ModelsService.modelsGalleries(function (data) {
                $scope.state.Items = data;
                $scope.loading = false;
            }, function (result) {
                debug.error(result);
                $scope.loading = false;
                $scope.error = true;
            });
        };

        $scope.lastItemId = function () {
            return $scope.state.Items.length ? $scope.state.Items[$scope.state.Items.length - 1].Id : '';
        }
                
        //trigger data loader
        if (shouldLoadNext) $scope.more();
        else $anchorScroll();
    }]

    return modelsPhotoGalleriesController;
});