﻿define([], function () {

    var modelsPhotoGalleryController = ['$scope', '$routeParams', '$location', '$anchorScroll', 'SettingsService', 'ModelsService', 'Utils', 'ModelsCatalogService', function ($scope, $routeParams, $location, $anchorScroll, SettingsService, ModelsService, Utils, ModelsCatalogService) {
        debug.info('ModelsPhotoGalleryController entered');
        
        $scope.error = null;
        $scope.Utils = Utils;
        
        $scope.section = ModelsCatalogService.imageSectionFromUrl($routeParams.gallery);
        debug.info('Gallery id:', $scope.id);
        
        var shouldLoadNext = false;
        var galleryKey = "ModelsGallery-" + $routeParams.gallery;
        if (!ModelsService.state[galleryKey]) {
            ModelsService.state[galleryKey] = {
                CurrentPageIndex: 1,
                Items: [],
                TotalPageCount: 1
            };
            shouldLoadNext = true;
        }
        $scope.state = ModelsService.state[galleryKey];
        
        var page = $routeParams.page ? parseInt($routeParams.page) : 1;
        if ($scope.state.CurrentPageIndex > page) $scope.state.Items = [];
        if ($scope.state.CurrentPageIndex != page) shouldLoadNext = true;
        $scope.state.CurrentPageIndex = page;
        
        $scope.Catalog = ModelsCatalogService;
                                
        $scope.more = function () {
            $scope.loading = true;
            $scope.error = null;
            ModelsService.modelsGallery($scope.section.Id, $scope.state.CurrentPageIndex, SettingsService.get('modelsPerPage'), function (data) {

                $scope.state.CurrentPageIndex = data.CurrentPageIndex;
                $scope.state.TotalPageCount = data.TotalPageCount;

                for (var i = 0; i < data.Items.length; i++) {
                    $scope.state.Items.push(data.Items[i]);
                }

                $scope.loading = false;
                Utils.apply($scope);
                $anchorScroll();
                
            }, function (result) {
                debug.error(result);
                $scope.loading = false;
                $scope.error = true;
            });
        };

        $scope.lastItemId = function () {
            return $scope.state.Items.length ? $scope.state.Items[$scope.state.Items.length - 1] : '';
        }
        
        $scope.url = function () {
            return btoa($location.url());
        };

        //trigger data loader
        if (shouldLoadNext) $scope.more();
        else $anchorScroll();
    }]
        
    return modelsPhotoGalleryController;
});