﻿define([
    'text!../../templates/Install.html',
    'text!../../templates/models/Models.html',
    'text!../../templates/models/ModelPortfolio.html',
    'text!../../templates/models/ModelPortfolioGallery.html',
    'text!../../templates/models/ModelPortfolioProperties.html',
    'text!../../templates/models/ModelsPhotoGalleries.html',
    'text!../../templates/models/ModelsPhotoGallery.html',
    'text!../../templates/Search.html',
    'text!../../templates/Settings.html',
    'text!../../templates/account/Login.html'
], function (installTemplate, modelsTemplate, modelPortfolioTemplate, modelPortfolioGalleryTemplate, modelPortfolioPropertiesTemplate, modelsPhotoGalleriesTemplate, modelsPhotoGalleryTemplate, searchTemplate, settingsTemplate, loginTemplate) {
    debug.info('Defining routes...');
    return {
        Install: {
            title: 'TTL_INSTALL'
            , route: '/install'
            , controller: 'InstallController'
            , template: installTemplate
            , requireLogin: false
        },
        Models: {
            title: 'TTL_MODELS'
            , route: '/models'
            , controller: 'ModelsController'
            , template: modelsTemplate
            , requireLogin: false
        },
        ModelsPhotoGalleries: {
            title: 'TTL_MODELS_PHOTO_GALLERIES'
            , route: '/models/galleries'
            , controller: 'ModelsPhotoGalleriesController'
            , template: modelsPhotoGalleriesTemplate
            , requireLogin: false
        },
        ModelsPhotoGallery: {
            title: 'TTL_MODELS_PHOTO_GALLERY'
            , route: '/models/galleries/:gallery'
            , controller: 'ModelsPhotoGalleryController'
            , template: modelsPhotoGalleryTemplate
            , requireLogin: false
        },
        ModelPortfolio: {
            title: 'TTL_MODEL_PORTFOLIO'
            , route: '/models/:modelUrl'
            , controller: 'ModelPortfolioController'
            , template: modelPortfolioTemplate
            , requireLogin: false
        },
        ModelPortfolioGallery: {
            title: 'TTL_MODEL_PORTFOLIO_GALLERY'
            , route: '/models/:modelUrl/gallery'
            , controller: 'ModelPortfolioGalleryController'
            , template: modelPortfolioGalleryTemplate
            , requireLogin: false
        },
        ModelPortfolioProperties: {
            title: 'TTL_MODEL_PORTFOLIO_PROPERTIES'
            , route: '/models/:modelUrl/:sectionName'
            , controller: 'ModelPortfolioPropertiesController'
            , template: modelPortfolioPropertiesTemplate
            , requireLogin: false
        },
        Search: {
            title: 'TTL_SEARCH'
            , route: '/search'
            , controller: 'SearchController'
            , template: searchTemplate
            , requireLogin: false
        },
        Settings: {
            title: 'TTL_SETTINGS'
            , route: '/settings'
            , controller: 'SettingsController'
            , template: settingsTemplate
            , requireLogin: false
        },
        Login: {
            title: 'TTL_LOGIN'
            , route: '/login'
            , controller: 'LoginController'
            , template: loginTemplate
            , requireLogin: false
        }
    };
})
