﻿define([], function () {

    debug.info("Entering AccountService module.");

    var service = ['$http', 'SettingsService', 'DataService', function ($http, SettingsService, DataService) {

        var self = this;

        self.serverUrl = SettingsService.get('serverUrl');

        self.state = {};

        self.login = function (email, password, onsuccess, onerror) {
            debug.info('Logging in: ' + email);
            $http({ method: 'POST', url: self.serverUrl + '/Token', data: { userName: email, password: password, key: SettingsService.get('key'), culture: SettingsService.get('culture') } }).success(function (result) {
                debug.info(result);
                if (onsuccess) onsuccess(result);
            }).error(function (data, status, headers, config) {
                if (onerror) onerror(data);
            });
        };

        return self;
    }];

    return service;
});
